--
-- PostgreSQL database dump
--

-- Dumped from database version 16.4 (Ubuntu 16.4-0ubuntu0.24.04.2)
-- Dumped by pg_dump version 16.4 (Ubuntu 16.4-0ubuntu0.24.04.2)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: unaccent; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS unaccent WITH SCHEMA public;


--
-- Name: EXTENSION unaccent; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON EXTENSION unaccent IS 'text search dictionary that removes accents';


--
-- Name: knowledge_dictionary; Type: TEXT SEARCH DICTIONARY; Schema: public; Owner: -
--

CREATE TEXT SEARCH DICTIONARY public.knowledge_dictionary (
    TEMPLATE = pg_catalog.simple );


--
-- Name: knowledge_config; Type: TEXT SEARCH CONFIGURATION; Schema: public; Owner: -
--

CREATE TEXT SEARCH CONFIGURATION public.knowledge_config (
    PARSER = pg_catalog."default" );

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR asciiword WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR word WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR numword WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR email WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR url WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR host WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR sfloat WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR version WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR hword_numpart WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR hword_part WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR hword_asciipart WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR protocol WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR numhword WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR asciihword WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR hword WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR url_path WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR file WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR "float" WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR "int" WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR uint WITH public.knowledge_dictionary;


SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: account_account; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account (
    id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    account_type character varying NOT NULL,
    name jsonb NOT NULL,
    code_store jsonb,
    note text,
    deprecated boolean,
    reconcile boolean,
    non_trade boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    create_asset character varying NOT NULL,
    multiple_assets_per_line boolean,
    disallowed_expenses_category_id integer
);


--
-- Name: TABLE account_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account IS 'Account';


--
-- Name: COLUMN account_account.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.currency_id IS 'Account Currency';


--
-- Name: COLUMN account_account.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_account.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account.account_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.account_type IS 'Type';


--
-- Name: COLUMN account_account.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.name IS 'Account Name';


--
-- Name: COLUMN account_account.code_store; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.code_store IS 'Code Store';


--
-- Name: COLUMN account_account.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.note IS 'Internal Notes';


--
-- Name: COLUMN account_account.deprecated; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.deprecated IS 'Deprecated';


--
-- Name: COLUMN account_account.reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.reconcile IS 'Allow Reconciliation';


--
-- Name: COLUMN account_account.non_trade; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.non_trade IS 'Non Trade';


--
-- Name: COLUMN account_account.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.create_date IS 'Created on';


--
-- Name: COLUMN account_account.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_account.create_asset; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.create_asset IS 'Create Asset';


--
-- Name: COLUMN account_account.multiple_assets_per_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.multiple_assets_per_line IS 'Multiple Assets per Line';


--
-- Name: COLUMN account_account.disallowed_expenses_category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account.disallowed_expenses_category_id IS 'Disallowed Expenses Category';


--
-- Name: account_account_account_asset_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_account_asset_rel (
    account_account_id integer NOT NULL,
    account_asset_id integer NOT NULL
);


--
-- Name: TABLE account_account_account_asset_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_account_asset_rel IS 'RELATION BETWEEN account_account AND account_asset';


--
-- Name: account_account_account_auto_reconcile_wizard_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_account_auto_reconcile_wizard_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


--
-- Name: TABLE account_account_account_auto_reconcile_wizard_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_account_auto_reconcile_wizard_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND account_account';


--
-- Name: account_account_account_import_summary_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_account_import_summary_rel (
    account_import_summary_id integer NOT NULL,
    account_account_id integer NOT NULL
);


--
-- Name: TABLE account_account_account_import_summary_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_account_import_summary_rel IS 'RELATION BETWEEN account_import_summary AND account_account';


--
-- Name: account_account_account_journal_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_account_journal_rel (
    account_account_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_account_account_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_account_journal_rel IS 'RELATION BETWEEN account_account AND account_journal';


--
-- Name: account_account_account_merge_wizard_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_account_merge_wizard_rel (
    account_merge_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


--
-- Name: TABLE account_account_account_merge_wizard_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_account_merge_wizard_rel IS 'RELATION BETWEEN account_merge_wizard AND account_account';


--
-- Name: account_account_account_tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_account_tag (
    account_account_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


--
-- Name: TABLE account_account_account_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_account_tag IS 'RELATION BETWEEN account_account AND account_account_tag';


--
-- Name: account_account_exclude_res_currency_provision; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_exclude_res_currency_provision (
    account_account_id integer NOT NULL,
    res_currency_id integer NOT NULL
);


--
-- Name: TABLE account_account_exclude_res_currency_provision; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_exclude_res_currency_provision IS 'RELATION BETWEEN account_account AND res_currency';


--
-- Name: account_account_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_account_id_seq OWNED BY public.account_account.id;


--
-- Name: account_account_res_company_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_res_company_rel (
    account_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


--
-- Name: TABLE account_account_res_company_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_res_company_rel IS 'RELATION BETWEEN account_account AND res_company';


--
-- Name: account_account_tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_tag (
    id integer NOT NULL,
    color integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    applicability character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    tax_negate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_account_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_tag IS 'Account Tag';


--
-- Name: COLUMN account_account_tag.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.color IS 'Color Index';


--
-- Name: COLUMN account_account_tag.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.country_id IS 'Country';


--
-- Name: COLUMN account_account_tag.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_tag.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_tag.applicability; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.applicability IS 'Applicability';


--
-- Name: COLUMN account_account_tag.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.name IS 'Tag Name';


--
-- Name: COLUMN account_account_tag.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.active IS 'Active';


--
-- Name: COLUMN account_account_tag.tax_negate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.tax_negate IS 'Negate Tax Balance';


--
-- Name: COLUMN account_account_tag.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.create_date IS 'Created on';


--
-- Name: COLUMN account_account_tag.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_account_tag.write_date IS 'Last Updated on';


--
-- Name: account_account_tag_account_move_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_tag_account_move_line_rel (
    account_move_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


--
-- Name: TABLE account_account_tag_account_move_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_tag_account_move_line_rel IS 'RELATION BETWEEN account_move_line AND account_account_tag';


--
-- Name: account_account_tag_account_tax_repartition_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_tag_account_tax_repartition_line_rel (
    account_tax_repartition_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


--
-- Name: TABLE account_account_tag_account_tax_repartition_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_tag_account_tax_repartition_line_rel IS 'RELATION BETWEEN account_tax_repartition_line AND account_account_tag';


--
-- Name: account_account_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_account_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_account_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_account_tag_id_seq OWNED BY public.account_account_tag.id;


--
-- Name: account_account_tag_product_template_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_tag_product_template_rel (
    product_template_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


--
-- Name: TABLE account_account_tag_product_template_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_tag_product_template_rel IS 'RELATION BETWEEN product_template AND account_account_tag';


--
-- Name: account_account_tax_default_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_account_tax_default_rel (
    account_id integer NOT NULL,
    tax_id integer NOT NULL
);


--
-- Name: TABLE account_account_tax_default_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_account_tax_default_rel IS 'RELATION BETWEEN account_account AND account_tax';


--
-- Name: account_accrued_orders_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_accrued_orders_wizard (
    id integer NOT NULL,
    company_id integer,
    journal_id integer NOT NULL,
    currency_id integer,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    reversal_date date NOT NULL,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_accrued_orders_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_accrued_orders_wizard IS 'Accrued Orders Wizard';


--
-- Name: COLUMN account_accrued_orders_wizard.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_accrued_orders_wizard.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_accrued_orders_wizard.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.currency_id IS 'Company Currency';


--
-- Name: COLUMN account_accrued_orders_wizard.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.account_id IS 'Accrual Account';


--
-- Name: COLUMN account_accrued_orders_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_accrued_orders_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_accrued_orders_wizard.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.date IS 'Date';


--
-- Name: COLUMN account_accrued_orders_wizard.reversal_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.reversal_date IS 'Reversal Date';


--
-- Name: COLUMN account_accrued_orders_wizard.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.amount IS 'Amount';


--
-- Name: COLUMN account_accrued_orders_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_accrued_orders_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_date IS 'Last Updated on';


--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_accrued_orders_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNED BY public.account_accrued_orders_wizard.id;


--
-- Name: account_analytic_account; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_account (
    id integer NOT NULL,
    plan_id integer NOT NULL,
    root_plan_id integer,
    company_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_analytic_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_account IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.plan_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.plan_id IS 'Plan';


--
-- Name: COLUMN account_analytic_account.root_plan_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.root_plan_id IS 'Root Plan';


--
-- Name: COLUMN account_analytic_account.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_account.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.partner_id IS 'Customer';


--
-- Name: COLUMN account_analytic_account.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_account.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_account.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.code IS 'Reference';


--
-- Name: COLUMN account_analytic_account.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.name IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.active IS 'Active';


--
-- Name: COLUMN account_analytic_account.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_account.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_account.write_date IS 'Last Updated on';


--
-- Name: account_analytic_account_account_transfer_model_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_account_account_transfer_model_line_rel (
    account_transfer_model_line_id integer NOT NULL,
    account_analytic_account_id integer NOT NULL
);


--
-- Name: TABLE account_analytic_account_account_transfer_model_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_account_account_transfer_model_line_rel IS 'RELATION BETWEEN account_transfer_model_line AND account_analytic_account';


--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_analytic_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_analytic_account_id_seq OWNED BY public.account_analytic_account.id;


--
-- Name: account_analytic_account_mrp_bom_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_account_mrp_bom_rel (
    account_analytic_account_id integer NOT NULL,
    mrp_bom_id integer NOT NULL
);


--
-- Name: TABLE account_analytic_account_mrp_bom_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_account_mrp_bom_rel IS 'RELATION BETWEEN account_analytic_account AND mrp_bom';


--
-- Name: account_analytic_account_mrp_production_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_account_mrp_production_rel (
    account_analytic_account_id integer NOT NULL,
    mrp_production_id integer NOT NULL
);


--
-- Name: TABLE account_analytic_account_mrp_production_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_account_mrp_production_rel IS 'RELATION BETWEEN account_analytic_account AND mrp_production';


--
-- Name: account_analytic_account_mrp_workcenter_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_account_mrp_workcenter_rel (
    account_analytic_account_id integer NOT NULL,
    mrp_workcenter_id integer NOT NULL
);


--
-- Name: TABLE account_analytic_account_mrp_workcenter_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_account_mrp_workcenter_rel IS 'RELATION BETWEEN account_analytic_account AND mrp_workcenter';


--
-- Name: account_analytic_applicability; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_applicability (
    id integer NOT NULL,
    analytic_plan_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    business_domain character varying NOT NULL,
    applicability character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_categ_id integer,
    account_prefix character varying
);


--
-- Name: TABLE account_analytic_applicability; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_applicability IS 'Analytic Plan''s Applicabilities';


--
-- Name: COLUMN account_analytic_applicability.analytic_plan_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_applicability.analytic_plan_id IS 'Analytic Plan';


--
-- Name: COLUMN account_analytic_applicability.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_applicability.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_applicability.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_applicability.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_applicability.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_applicability.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_applicability.business_domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_applicability.business_domain IS 'Domain';


--
-- Name: COLUMN account_analytic_applicability.applicability; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_applicability.applicability IS 'Applicability';


--
-- Name: COLUMN account_analytic_applicability.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_applicability.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_applicability.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_applicability.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_applicability.product_categ_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_applicability.product_categ_id IS 'Product Category';


--
-- Name: COLUMN account_analytic_applicability.account_prefix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_applicability.account_prefix IS 'Financial Accounts Prefix';


--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_analytic_applicability_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNED BY public.account_analytic_applicability.id;


--
-- Name: account_analytic_distribution_model; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_distribution_model (
    id integer NOT NULL,
    sequence integer,
    partner_id integer,
    partner_category_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    analytic_distribution jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_id integer,
    product_categ_id integer,
    account_prefix character varying
);


--
-- Name: TABLE account_analytic_distribution_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_distribution_model IS 'Analytic Distribution Model';


--
-- Name: COLUMN account_analytic_distribution_model.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_distribution_model.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_distribution_model.partner_category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_category_id IS 'Partner Category';


--
-- Name: COLUMN account_analytic_distribution_model.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution_model.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_distribution_model.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_distribution_model.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_distribution_model.analytic_distribution; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution_model.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_analytic_distribution_model.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_distribution_model.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_distribution_model.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution_model.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_distribution_model.product_categ_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution_model.product_categ_id IS 'Product Category';


--
-- Name: COLUMN account_analytic_distribution_model.account_prefix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_distribution_model.account_prefix IS 'Accounts Prefix';


--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_analytic_distribution_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNED BY public.account_analytic_distribution_model.id;


--
-- Name: account_analytic_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_line (
    id integer NOT NULL,
    account_id integer,
    product_uom_id integer,
    partner_id integer,
    user_id integer,
    company_id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    category character varying,
    date date NOT NULL,
    amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    unit_amount double precision,
    product_id integer,
    general_account_id integer,
    journal_id integer,
    move_line_id integer,
    code character varying(8),
    ref character varying,
    so_line integer,
    task_id integer,
    parent_task_id integer,
    project_id integer,
    employee_id integer,
    department_id integer,
    manager_id integer,
    validated boolean,
    timesheet_invoice_id integer,
    order_id integer,
    timesheet_invoice_type character varying,
    is_so_line_edited boolean,
    slot_id integer
);


--
-- Name: TABLE account_analytic_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_line IS 'Analytic Line';


--
-- Name: COLUMN account_analytic_line.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.account_id IS 'Project Account';


--
-- Name: COLUMN account_analytic_line.product_uom_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_analytic_line.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_line.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.user_id IS 'User';


--
-- Name: COLUMN account_analytic_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_line.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_analytic_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.name IS 'Description';


--
-- Name: COLUMN account_analytic_line.category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.category IS 'Category';


--
-- Name: COLUMN account_analytic_line.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.date IS 'Date';


--
-- Name: COLUMN account_analytic_line.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.amount IS 'Amount';


--
-- Name: COLUMN account_analytic_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_line.unit_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.unit_amount IS 'Quantity';


--
-- Name: COLUMN account_analytic_line.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_line.general_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.general_account_id IS 'Financial Account';


--
-- Name: COLUMN account_analytic_line.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.journal_id IS 'Financial Journal';


--
-- Name: COLUMN account_analytic_line.move_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.move_line_id IS 'Journal Item';


--
-- Name: COLUMN account_analytic_line.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.code IS 'Code';


--
-- Name: COLUMN account_analytic_line.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.ref IS 'Ref.';


--
-- Name: COLUMN account_analytic_line.so_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.so_line IS 'Sales Order Item';


--
-- Name: COLUMN account_analytic_line.task_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.task_id IS 'Task';


--
-- Name: COLUMN account_analytic_line.parent_task_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.parent_task_id IS 'Parent Task';


--
-- Name: COLUMN account_analytic_line.project_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.project_id IS 'Project';


--
-- Name: COLUMN account_analytic_line.employee_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.employee_id IS 'Employee';


--
-- Name: COLUMN account_analytic_line.department_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.department_id IS 'Department';


--
-- Name: COLUMN account_analytic_line.manager_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.manager_id IS 'Manager';


--
-- Name: COLUMN account_analytic_line.validated; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.validated IS 'Validated line';


--
-- Name: COLUMN account_analytic_line.timesheet_invoice_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.timesheet_invoice_id IS 'Invoice';


--
-- Name: COLUMN account_analytic_line.order_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.order_id IS 'Order Reference';


--
-- Name: COLUMN account_analytic_line.timesheet_invoice_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.timesheet_invoice_type IS 'Billable Type';


--
-- Name: COLUMN account_analytic_line.is_so_line_edited; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.is_so_line_edited IS 'Is Sales Order Item Manually Edited';


--
-- Name: COLUMN account_analytic_line.slot_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_line.slot_id IS 'Planning Shift';


--
-- Name: account_analytic_line_hr_timesheet_merge_wizard_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel (
    hr_timesheet_merge_wizard_id integer NOT NULL,
    account_analytic_line_id integer NOT NULL
);


--
-- Name: TABLE account_analytic_line_hr_timesheet_merge_wizard_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel IS 'RELATION BETWEEN hr_timesheet_merge_wizard AND account_analytic_line';


--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_analytic_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_analytic_line_id_seq OWNED BY public.account_analytic_line.id;


--
-- Name: account_analytic_line_mrp_workorder_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_line_mrp_workorder_rel (
    mrp_workorder_id integer NOT NULL,
    account_analytic_line_id integer NOT NULL
);


--
-- Name: TABLE account_analytic_line_mrp_workorder_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_line_mrp_workorder_rel IS 'RELATION BETWEEN mrp_workorder AND account_analytic_line';


--
-- Name: account_analytic_line_stock_move_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_line_stock_move_rel (
    stock_move_id integer NOT NULL,
    account_analytic_line_id integer NOT NULL
);


--
-- Name: TABLE account_analytic_line_stock_move_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_line_stock_move_rel IS 'RELATION BETWEEN stock_move AND account_analytic_line';


--
-- Name: account_analytic_plan; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_analytic_plan (
    id integer NOT NULL,
    parent_id integer,
    color integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    complete_name character varying,
    name jsonb NOT NULL,
    default_applicability jsonb,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_analytic_plan; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_analytic_plan IS 'Analytic Plans';


--
-- Name: COLUMN account_analytic_plan.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_plan.parent_id IS 'Parent';


--
-- Name: COLUMN account_analytic_plan.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_plan.color IS 'Color';


--
-- Name: COLUMN account_analytic_plan.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_plan.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_plan.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_plan.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_plan.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_plan.parent_path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_plan.parent_path IS 'Parent Path';


--
-- Name: COLUMN account_analytic_plan.complete_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_plan.complete_name IS 'Complete Name';


--
-- Name: COLUMN account_analytic_plan.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_plan.name IS 'Name';


--
-- Name: COLUMN account_analytic_plan.default_applicability; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_plan.default_applicability IS 'Default Applicability';


--
-- Name: COLUMN account_analytic_plan.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_plan.description IS 'Description';


--
-- Name: COLUMN account_analytic_plan.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_plan.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_plan.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_analytic_plan.write_date IS 'Last Updated on';


--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_analytic_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_analytic_plan_id_seq OWNED BY public.account_analytic_plan.id;


--
-- Name: account_asset; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_asset (
    id integer NOT NULL,
    company_id integer NOT NULL,
    currency_id integer,
    method_number integer,
    account_asset_id integer,
    asset_group_id integer,
    account_depreciation_id integer,
    account_depreciation_expense_id integer,
    journal_id integer,
    model_id integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    method character varying,
    method_period character varying,
    prorata_computation_type character varying NOT NULL,
    prorata_date date NOT NULL,
    acquisition_date date,
    disposal_date date,
    analytic_distribution jsonb,
    asset_properties_definition jsonb,
    asset_properties jsonb,
    original_value numeric,
    book_value numeric,
    salvage_value numeric,
    non_deductible_tax_value numeric,
    already_depreciated_amount_import numeric,
    net_gain_on_sale numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    method_progress_factor double precision,
    salvage_value_pct double precision,
    asset_paused_days double precision
);


--
-- Name: TABLE account_asset; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_asset IS 'Asset/Revenue Recognition';


--
-- Name: COLUMN account_asset.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.company_id IS 'Company';


--
-- Name: COLUMN account_asset.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.currency_id IS 'Currency';


--
-- Name: COLUMN account_asset.method_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.method_number IS 'Duration';


--
-- Name: COLUMN account_asset.account_asset_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.account_asset_id IS 'Fixed Asset Account';


--
-- Name: COLUMN account_asset.asset_group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.asset_group_id IS 'Asset Group';


--
-- Name: COLUMN account_asset.account_depreciation_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.account_depreciation_id IS 'Depreciation Account';


--
-- Name: COLUMN account_asset.account_depreciation_expense_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.account_depreciation_expense_id IS 'Expense Account';


--
-- Name: COLUMN account_asset.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.journal_id IS 'Journal';


--
-- Name: COLUMN account_asset.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.model_id IS 'Model';


--
-- Name: COLUMN account_asset.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.parent_id IS 'Parent';


--
-- Name: COLUMN account_asset.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.create_uid IS 'Created by';


--
-- Name: COLUMN account_asset.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_asset.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.name IS 'Asset Name';


--
-- Name: COLUMN account_asset.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.state IS 'Status';


--
-- Name: COLUMN account_asset.method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.method IS 'Method';


--
-- Name: COLUMN account_asset.method_period; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.method_period IS 'Number of Months in a Period';


--
-- Name: COLUMN account_asset.prorata_computation_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.prorata_computation_type IS 'Computation';


--
-- Name: COLUMN account_asset.prorata_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.prorata_date IS 'Prorata Date';


--
-- Name: COLUMN account_asset.acquisition_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.acquisition_date IS 'Acquisition Date';


--
-- Name: COLUMN account_asset.disposal_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.disposal_date IS 'Disposal Date';


--
-- Name: COLUMN account_asset.analytic_distribution; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_asset.asset_properties_definition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.asset_properties_definition IS 'Model Properties';


--
-- Name: COLUMN account_asset.asset_properties; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.asset_properties IS 'Properties';


--
-- Name: COLUMN account_asset.original_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.original_value IS 'Original Value';


--
-- Name: COLUMN account_asset.book_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.book_value IS 'Book Value';


--
-- Name: COLUMN account_asset.salvage_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.salvage_value IS 'Not Depreciable Value';


--
-- Name: COLUMN account_asset.non_deductible_tax_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.non_deductible_tax_value IS 'Non Deductible Tax Value';


--
-- Name: COLUMN account_asset.already_depreciated_amount_import; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.already_depreciated_amount_import IS 'Already Depreciated Amount Import';


--
-- Name: COLUMN account_asset.net_gain_on_sale; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.net_gain_on_sale IS 'Net gain on sale';


--
-- Name: COLUMN account_asset.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.active IS 'Active';


--
-- Name: COLUMN account_asset.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.create_date IS 'Created on';


--
-- Name: COLUMN account_asset.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_asset.method_progress_factor; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.method_progress_factor IS 'Declining Factor';


--
-- Name: COLUMN account_asset.salvage_value_pct; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.salvage_value_pct IS 'Not Depreciable Value Percent';


--
-- Name: COLUMN account_asset.asset_paused_days; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset.asset_paused_days IS 'Asset Paused Days';


--
-- Name: account_asset_group; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_asset_group (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_asset_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_asset_group IS 'Asset Group';


--
-- Name: COLUMN account_asset_group.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset_group.company_id IS 'Company';


--
-- Name: COLUMN account_asset_group.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_asset_group.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_asset_group.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset_group.name IS 'Name';


--
-- Name: COLUMN account_asset_group.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset_group.create_date IS 'Created on';


--
-- Name: COLUMN account_asset_group.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_asset_group.write_date IS 'Last Updated on';


--
-- Name: account_asset_group_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_asset_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_asset_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_asset_group_id_seq OWNED BY public.account_asset_group.id;


--
-- Name: account_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_asset_id_seq OWNED BY public.account_asset.id;


--
-- Name: account_auto_reconcile_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_auto_reconcile_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    search_mode character varying NOT NULL,
    from_date date,
    to_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_auto_reconcile_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_auto_reconcile_wizard IS 'Account automatic reconciliation wizard';


--
-- Name: COLUMN account_auto_reconcile_wizard.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_auto_reconcile_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_auto_reconcile_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_auto_reconcile_wizard.search_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.search_mode IS 'Reconcile';


--
-- Name: COLUMN account_auto_reconcile_wizard.from_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.from_date IS 'From';


--
-- Name: COLUMN account_auto_reconcile_wizard.to_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.to_date IS 'To';


--
-- Name: COLUMN account_auto_reconcile_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_auto_reconcile_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.write_date IS 'Last Updated on';


--
-- Name: account_auto_reconcile_wizard_account_move_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_auto_reconcile_wizard_account_move_line_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


--
-- Name: TABLE account_auto_reconcile_wizard_account_move_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_auto_reconcile_wizard_account_move_line_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND account_move_line';


--
-- Name: account_auto_reconcile_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_auto_reconcile_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_auto_reconcile_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_auto_reconcile_wizard_id_seq OWNED BY public.account_auto_reconcile_wizard.id;


--
-- Name: account_auto_reconcile_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_auto_reconcile_wizard_res_partner_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE account_auto_reconcile_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_auto_reconcile_wizard_res_partner_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND res_partner';


--
-- Name: account_automatic_entry_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_automatic_entry_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    destination_account_id integer,
    create_uid integer,
    write_uid integer,
    action character varying NOT NULL,
    account_type character varying,
    date date NOT NULL,
    total_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percentage double precision
);


--
-- Name: TABLE account_automatic_entry_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_automatic_entry_wizard IS 'Create Automatic Entries';


--
-- Name: COLUMN account_automatic_entry_wizard.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_automatic_entry_wizard.destination_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.destination_account_id IS 'To';


--
-- Name: COLUMN account_automatic_entry_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_automatic_entry_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_automatic_entry_wizard.action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.action IS 'Action';


--
-- Name: COLUMN account_automatic_entry_wizard.account_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.account_type IS 'Account Type';


--
-- Name: COLUMN account_automatic_entry_wizard.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.date IS 'Date';


--
-- Name: COLUMN account_automatic_entry_wizard.total_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.total_amount IS 'Total Amount';


--
-- Name: COLUMN account_automatic_entry_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_automatic_entry_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_automatic_entry_wizard.percentage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.percentage IS 'Percentage';


--
-- Name: account_automatic_entry_wizard_account_move_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_automatic_entry_wizard_account_move_line_rel (
    account_automatic_entry_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


--
-- Name: TABLE account_automatic_entry_wizard_account_move_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_automatic_entry_wizard_account_move_line_rel IS 'RELATION BETWEEN account_automatic_entry_wizard AND account_move_line';


--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_automatic_entry_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNED BY public.account_automatic_entry_wizard.id;


--
-- Name: account_autopost_bills_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_autopost_bills_wizard (
    id integer NOT NULL,
    partner_id integer,
    nb_unmodified_bills integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_autopost_bills_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_autopost_bills_wizard IS 'Autopost Bills Wizard';


--
-- Name: COLUMN account_autopost_bills_wizard.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN account_autopost_bills_wizard.nb_unmodified_bills; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.nb_unmodified_bills IS 'Number of bills previously unmodified from this partner';


--
-- Name: COLUMN account_autopost_bills_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_autopost_bills_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_autopost_bills_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_autopost_bills_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.write_date IS 'Last Updated on';


--
-- Name: account_autopost_bills_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_autopost_bills_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_autopost_bills_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_autopost_bills_wizard_id_seq OWNED BY public.account_autopost_bills_wizard.id;


--
-- Name: account_bank_selection; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_bank_selection (
    id integer NOT NULL,
    account_online_link_id integer,
    selected_account integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_bank_selection; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_bank_selection IS 'Link a bank account to the selected journal';


--
-- Name: COLUMN account_bank_selection.account_online_link_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_selection.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_bank_selection.selected_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_selection.selected_account IS 'Selected Account';


--
-- Name: COLUMN account_bank_selection.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_selection.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_selection.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_selection.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_selection.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_selection.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_selection.write_date IS 'Last Updated on';


--
-- Name: account_bank_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_bank_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_bank_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_bank_selection_id_seq OWNED BY public.account_bank_selection.id;


--
-- Name: account_bank_statement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_bank_statement (
    id integer NOT NULL,
    company_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    reference character varying,
    first_line_index character varying,
    date date,
    balance_start numeric,
    balance_end numeric,
    balance_end_real numeric,
    is_complete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    message_main_attachment_id integer,
    extract_state character varying,
    extract_status character varying,
    extract_document_uuid character varying,
    is_in_extractable_state boolean,
    extract_state_processed boolean
);


--
-- Name: TABLE account_bank_statement; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_bank_statement IS 'Bank Statement';


--
-- Name: COLUMN account_bank_statement.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.name IS 'Reference';


--
-- Name: COLUMN account_bank_statement.reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.reference IS 'External Reference';


--
-- Name: COLUMN account_bank_statement.first_line_index; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.first_line_index IS 'First Line Index';


--
-- Name: COLUMN account_bank_statement.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.date IS 'Date';


--
-- Name: COLUMN account_bank_statement.balance_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.balance_start IS 'Starting Balance';


--
-- Name: COLUMN account_bank_statement.balance_end; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.balance_end IS 'Computed Balance';


--
-- Name: COLUMN account_bank_statement.balance_end_real; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.balance_end_real IS 'Ending Balance';


--
-- Name: COLUMN account_bank_statement.is_complete; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.is_complete IS 'Is Complete';


--
-- Name: COLUMN account_bank_statement.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_bank_statement.extract_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.extract_state IS 'Extract state';


--
-- Name: COLUMN account_bank_statement.extract_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.extract_status IS 'Extract status';


--
-- Name: COLUMN account_bank_statement.extract_document_uuid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.extract_document_uuid IS 'ID of the request to IAP-OCR';


--
-- Name: COLUMN account_bank_statement.is_in_extractable_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.is_in_extractable_state IS 'Is In Extractable State';


--
-- Name: COLUMN account_bank_statement.extract_state_processed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement.extract_state_processed IS 'Extract State Processed';


--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_bank_statement_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_bank_statement_id_seq OWNED BY public.account_bank_statement.id;


--
-- Name: account_bank_statement_ir_attachment_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_bank_statement_ir_attachment_rel (
    account_bank_statement_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


--
-- Name: TABLE account_bank_statement_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_bank_statement_ir_attachment_rel IS 'RELATION BETWEEN account_bank_statement AND ir_attachment';


--
-- Name: account_bank_statement_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_bank_statement_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    statement_id integer,
    sequence integer,
    partner_id integer,
    currency_id integer,
    foreign_currency_id integer,
    create_uid integer,
    write_uid integer,
    account_number character varying,
    partner_name character varying,
    transaction_type character varying,
    payment_ref character varying,
    internal_index character varying,
    transaction_details jsonb,
    amount numeric,
    amount_currency numeric,
    is_reconciled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount_residual double precision,
    cron_last_check timestamp without time zone,
    unique_import_id character varying,
    online_account_id integer,
    online_link_id integer,
    online_transaction_identifier character varying,
    online_partner_information character varying
);


--
-- Name: TABLE account_bank_statement_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_bank_statement_line IS 'Bank Statement Line';


--
-- Name: COLUMN account_bank_statement_line.move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_bank_statement_line.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement_line.statement_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_bank_statement_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_bank_statement_line.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.currency_id IS 'Journal Currency';


--
-- Name: COLUMN account_bank_statement_line.foreign_currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.foreign_currency_id IS 'Foreign Currency';


--
-- Name: COLUMN account_bank_statement_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line.account_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.account_number IS 'Bank Account Number';


--
-- Name: COLUMN account_bank_statement_line.partner_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line.transaction_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_bank_statement_line.payment_ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.payment_ref IS 'Label';


--
-- Name: COLUMN account_bank_statement_line.internal_index; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.internal_index IS 'Internal Reference';


--
-- Name: COLUMN account_bank_statement_line.transaction_details; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_details IS 'Transaction Details';


--
-- Name: COLUMN account_bank_statement_line.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_bank_statement_line.is_reconciled; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_bank_statement_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement_line.amount_residual; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_bank_statement_line.cron_last_check; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.cron_last_check IS 'Cron Last Check';


--
-- Name: COLUMN account_bank_statement_line.unique_import_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.unique_import_id IS 'Import ID';


--
-- Name: COLUMN account_bank_statement_line.online_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.online_account_id IS 'Online Account';


--
-- Name: COLUMN account_bank_statement_line.online_link_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_bank_statement_line.online_transaction_identifier; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.online_transaction_identifier IS 'Online Transaction Identifier';


--
-- Name: COLUMN account_bank_statement_line.online_partner_information; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line.online_partner_information IS 'Online Partner Information';


--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_bank_statement_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNED BY public.account_bank_statement_line.id;


--
-- Name: account_bank_statement_line_transient; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_bank_statement_line_transient (
    id integer NOT NULL,
    sequence integer,
    journal_id integer,
    online_account_id integer,
    company_id integer,
    foreign_currency_id integer,
    create_uid integer,
    write_uid integer,
    online_transaction_identifier character varying,
    payment_ref character varying,
    account_number character varying,
    partner_name character varying,
    state character varying,
    date date,
    transaction_details text,
    amount numeric,
    amount_currency numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_bank_statement_line_transient; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_bank_statement_line_transient IS 'Transient model for bank statement line';


--
-- Name: COLUMN account_bank_statement_line_transient.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line_transient.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement_line_transient.online_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.online_account_id IS 'Account Online Account';


--
-- Name: COLUMN account_bank_statement_line_transient.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement_line_transient.foreign_currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.foreign_currency_id IS 'Foreign Currency';


--
-- Name: COLUMN account_bank_statement_line_transient.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line_transient.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line_transient.online_transaction_identifier; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.online_transaction_identifier IS 'Online Transaction Identifier';


--
-- Name: COLUMN account_bank_statement_line_transient.payment_ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.payment_ref IS 'Payment Ref';


--
-- Name: COLUMN account_bank_statement_line_transient.account_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.account_number IS 'Account Number';


--
-- Name: COLUMN account_bank_statement_line_transient.partner_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line_transient.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.state IS 'State';


--
-- Name: COLUMN account_bank_statement_line_transient.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.date IS 'Date';


--
-- Name: COLUMN account_bank_statement_line_transient.transaction_details; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.transaction_details IS 'Transaction Details';


--
-- Name: COLUMN account_bank_statement_line_transient.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line_transient.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_bank_statement_line_transient.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line_transient.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.write_date IS 'Last Updated on';


--
-- Name: account_bank_statement_line_transient_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_bank_statement_line_transient_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_bank_statement_line_transient_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_bank_statement_line_transient_id_seq OWNED BY public.account_bank_statement_line_transient.id;


--
-- Name: account_cash_rounding; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_cash_rounding (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    strategy character varying NOT NULL,
    rounding_method character varying NOT NULL,
    name jsonb NOT NULL,
    profit_account_id jsonb,
    loss_account_id jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rounding double precision NOT NULL
);


--
-- Name: TABLE account_cash_rounding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_cash_rounding IS 'Account Cash Rounding';


--
-- Name: COLUMN account_cash_rounding.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.create_uid IS 'Created by';


--
-- Name: COLUMN account_cash_rounding.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cash_rounding.strategy; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.strategy IS 'Rounding Strategy';


--
-- Name: COLUMN account_cash_rounding.rounding_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.rounding_method IS 'Rounding Method';


--
-- Name: COLUMN account_cash_rounding.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.name IS 'Name';


--
-- Name: COLUMN account_cash_rounding.profit_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_cash_rounding.loss_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_cash_rounding.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.create_date IS 'Created on';


--
-- Name: COLUMN account_cash_rounding.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_cash_rounding.rounding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_cash_rounding.rounding IS 'Rounding Precision';


--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_cash_rounding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_cash_rounding_id_seq OWNED BY public.account_cash_rounding.id;


--
-- Name: account_change_lock_date; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_change_lock_date (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    exception_applies_to character varying NOT NULL,
    exception_duration character varying NOT NULL,
    exception_reason character varying,
    fiscalyear_lock_date date,
    tax_lock_date date,
    sale_lock_date date,
    purchase_lock_date date,
    hard_lock_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_change_lock_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_change_lock_date IS 'Change Lock Date';


--
-- Name: COLUMN account_change_lock_date.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_change_lock_date.company_id IS 'Company';


--
-- Name: COLUMN account_change_lock_date.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_change_lock_date.create_uid IS 'Created by';


--
-- Name: COLUMN account_change_lock_date.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_change_lock_date.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_change_lock_date.exception_applies_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_change_lock_date.exception_applies_to IS 'Exception applies';


--
-- Name: COLUMN account_change_lock_date.exception_duration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_change_lock_date.exception_duration IS 'Exception Duration';


--
-- Name: COLUMN account_change_lock_date.exception_reason; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_change_lock_date.exception_reason IS 'Exception Reason';


--
-- Name: COLUMN account_change_lock_date.fiscalyear_lock_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_change_lock_date.fiscalyear_lock_date IS 'Lock Everyone';


--
-- Name: COLUMN account_change_lock_date.tax_lock_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_change_lock_date.tax_lock_date IS 'Lock Tax Return';


--
-- Name: COLUMN account_change_lock_date.sale_lock_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_change_lock_date.sale_lock_date IS 'Lock Sales';


--
-- Name: COLUMN account_change_lock_date.purchase_lock_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_change_lock_date.purchase_lock_date IS 'Lock Purchases';


--
-- Name: COLUMN account_change_lock_date.hard_lock_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_change_lock_date.hard_lock_date IS 'Hard Lock';


--
-- Name: COLUMN account_change_lock_date.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_change_lock_date.create_date IS 'Created on';


--
-- Name: COLUMN account_change_lock_date.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_change_lock_date.write_date IS 'Last Updated on';


--
-- Name: account_change_lock_date_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_change_lock_date_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_change_lock_date_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_change_lock_date_id_seq OWNED BY public.account_change_lock_date.id;


--
-- Name: account_disallowed_expenses_category; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_disallowed_expenses_category (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_disallowed_expenses_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_disallowed_expenses_category IS 'Disallowed Expenses Category';


--
-- Name: COLUMN account_disallowed_expenses_category.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.company_id IS 'Company';


--
-- Name: COLUMN account_disallowed_expenses_category.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.create_uid IS 'Created by';


--
-- Name: COLUMN account_disallowed_expenses_category.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_disallowed_expenses_category.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.code IS 'Code';


--
-- Name: COLUMN account_disallowed_expenses_category.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.name IS 'Name';


--
-- Name: COLUMN account_disallowed_expenses_category.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.active IS 'Active';


--
-- Name: COLUMN account_disallowed_expenses_category.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.create_date IS 'Created on';


--
-- Name: COLUMN account_disallowed_expenses_category.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.write_date IS 'Last Updated on';


--
-- Name: account_disallowed_expenses_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_disallowed_expenses_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_disallowed_expenses_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_disallowed_expenses_category_id_seq OWNED BY public.account_disallowed_expenses_category.id;


--
-- Name: account_disallowed_expenses_rate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_disallowed_expenses_rate (
    id integer NOT NULL,
    category_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rate double precision NOT NULL
);


--
-- Name: TABLE account_disallowed_expenses_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_disallowed_expenses_rate IS 'Disallowed Expenses Rate';


--
-- Name: COLUMN account_disallowed_expenses_rate.category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.category_id IS 'Category';


--
-- Name: COLUMN account_disallowed_expenses_rate.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.company_id IS 'Company';


--
-- Name: COLUMN account_disallowed_expenses_rate.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.create_uid IS 'Created by';


--
-- Name: COLUMN account_disallowed_expenses_rate.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_disallowed_expenses_rate.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.date_from IS 'Start Date';


--
-- Name: COLUMN account_disallowed_expenses_rate.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.create_date IS 'Created on';


--
-- Name: COLUMN account_disallowed_expenses_rate.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_disallowed_expenses_rate.rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.rate IS 'Disallowed %';


--
-- Name: account_disallowed_expenses_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_disallowed_expenses_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_disallowed_expenses_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_disallowed_expenses_rate_id_seq OWNED BY public.account_disallowed_expenses_rate.id;


--
-- Name: account_duplicate_transaction_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_duplicate_transaction_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_duplicate_transaction_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_duplicate_transaction_wizard IS 'Wizard for duplicate transactions';


--
-- Name: COLUMN account_duplicate_transaction_wizard.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_duplicate_transaction_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_duplicate_transaction_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_duplicate_transaction_wizard.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.date IS 'Starting Date';


--
-- Name: COLUMN account_duplicate_transaction_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_duplicate_transaction_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.write_date IS 'Last Updated on';


--
-- Name: account_duplicate_transaction_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_duplicate_transaction_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_duplicate_transaction_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_duplicate_transaction_wizard_id_seq OWNED BY public.account_duplicate_transaction_wizard.id;


--
-- Name: account_financial_year_op; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_financial_year_op (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_financial_year_op; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_financial_year_op IS 'Opening Balance of Financial Year';


--
-- Name: COLUMN account_financial_year_op.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_financial_year_op.company_id IS 'Company';


--
-- Name: COLUMN account_financial_year_op.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_financial_year_op.create_uid IS 'Created by';


--
-- Name: COLUMN account_financial_year_op.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_financial_year_op.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_financial_year_op.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_financial_year_op.create_date IS 'Created on';


--
-- Name: COLUMN account_financial_year_op.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_financial_year_op.write_date IS 'Last Updated on';


--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_financial_year_op_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_financial_year_op_id_seq OWNED BY public.account_financial_year_op.id;


--
-- Name: account_fiscal_position; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_fiscal_position (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    country_id integer,
    country_group_id integer,
    create_uid integer,
    write_uid integer,
    zip_from character varying,
    zip_to character varying,
    foreign_vat character varying,
    name jsonb NOT NULL,
    note jsonb,
    active boolean,
    auto_apply boolean,
    vat_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_fiscal_position; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_fiscal_position IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.sequence IS 'Sequence';


--
-- Name: COLUMN account_fiscal_position.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.country_id IS 'Country';


--
-- Name: COLUMN account_fiscal_position.country_group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.country_group_id IS 'Country Group';


--
-- Name: COLUMN account_fiscal_position.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position.zip_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.zip_from IS 'Zip Range From';


--
-- Name: COLUMN account_fiscal_position.zip_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.zip_to IS 'Zip Range To';


--
-- Name: COLUMN account_fiscal_position.foreign_vat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.foreign_vat IS 'Foreign Tax ID';


--
-- Name: COLUMN account_fiscal_position.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.name IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.note IS 'Notes';


--
-- Name: COLUMN account_fiscal_position.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.active IS 'Active';


--
-- Name: COLUMN account_fiscal_position.auto_apply; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.auto_apply IS 'Detect Automatically';


--
-- Name: COLUMN account_fiscal_position.vat_required; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.vat_required IS 'VAT required';


--
-- Name: COLUMN account_fiscal_position.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_account; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_fiscal_position_account (
    id integer NOT NULL,
    position_id integer NOT NULL,
    company_id integer,
    account_src_id integer NOT NULL,
    account_dest_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_fiscal_position_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_fiscal_position_account IS 'Accounts Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position_account.account_src_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_src_id IS 'Account on Product';


--
-- Name: COLUMN account_fiscal_position_account.account_dest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_dest_id IS 'Account to Use Instead';


--
-- Name: COLUMN account_fiscal_position_account.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_account.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_account.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_account.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_fiscal_position_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNED BY public.account_fiscal_position_account.id;


--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_fiscal_position_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_fiscal_position_id_seq OWNED BY public.account_fiscal_position.id;


--
-- Name: account_fiscal_position_res_country_state_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_fiscal_position_res_country_state_rel (
    account_fiscal_position_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


--
-- Name: TABLE account_fiscal_position_res_country_state_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_fiscal_position_res_country_state_rel IS 'RELATION BETWEEN account_fiscal_position AND res_country_state';


--
-- Name: account_fiscal_position_tax; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_fiscal_position_tax (
    id integer NOT NULL,
    position_id integer NOT NULL,
    company_id integer,
    tax_src_id integer NOT NULL,
    tax_dest_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_fiscal_position_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_fiscal_position_tax IS 'Tax Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position_tax.tax_src_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax.tax_src_id IS 'Tax on Product';


--
-- Name: COLUMN account_fiscal_position_tax.tax_dest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax.tax_dest_id IS 'Tax to Apply';


--
-- Name: COLUMN account_fiscal_position_tax.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_tax.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_tax.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_tax.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_position_tax.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_fiscal_position_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_fiscal_position_tax_id_seq OWNED BY public.account_fiscal_position_tax.id;


--
-- Name: account_fiscal_year; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_fiscal_year (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_fiscal_year; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_fiscal_year IS 'Fiscal Year';


--
-- Name: COLUMN account_fiscal_year.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_year.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_year.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_year.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_year.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_year.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_year.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_year.name IS 'Name';


--
-- Name: COLUMN account_fiscal_year.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_year.date_from IS 'Start Date';


--
-- Name: COLUMN account_fiscal_year.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_year.date_to IS 'End Date';


--
-- Name: COLUMN account_fiscal_year.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_year.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_year.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_fiscal_year.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_year_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_fiscal_year_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_fiscal_year_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_fiscal_year_id_seq OWNED BY public.account_fiscal_year.id;


--
-- Name: account_followup_followup_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_followup_followup_line (
    id integer NOT NULL,
    delay integer NOT NULL,
    company_id integer NOT NULL,
    mail_template_id integer,
    sms_template_id integer,
    activity_type_id integer,
    create_uid integer,
    write_uid integer,
    activity_summary character varying,
    activity_default_responsible_type character varying NOT NULL,
    name jsonb NOT NULL,
    activity_note text,
    send_email boolean,
    join_invoices boolean,
    send_sms boolean,
    create_activity boolean,
    auto_execute boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    send_letter boolean
);


--
-- Name: TABLE account_followup_followup_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_followup_followup_line IS 'Follow-up Criteria';


--
-- Name: COLUMN account_followup_followup_line.delay; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.delay IS 'Due Days';


--
-- Name: COLUMN account_followup_followup_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.company_id IS 'Company';


--
-- Name: COLUMN account_followup_followup_line.mail_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.mail_template_id IS 'Mail Template';


--
-- Name: COLUMN account_followup_followup_line.sms_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN account_followup_followup_line.activity_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN account_followup_followup_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_followup_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_followup_line.activity_summary; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_summary IS 'Summary';


--
-- Name: COLUMN account_followup_followup_line.activity_default_responsible_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_default_responsible_type IS 'Responsible';


--
-- Name: COLUMN account_followup_followup_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.name IS 'Description';


--
-- Name: COLUMN account_followup_followup_line.activity_note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_note IS 'Note';


--
-- Name: COLUMN account_followup_followup_line.send_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.send_email IS 'Send Email';


--
-- Name: COLUMN account_followup_followup_line.join_invoices; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.join_invoices IS 'Attach Invoices';


--
-- Name: COLUMN account_followup_followup_line.send_sms; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.send_sms IS 'Send SMS Message';


--
-- Name: COLUMN account_followup_followup_line.create_activity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.create_activity IS 'Schedule Activity';


--
-- Name: COLUMN account_followup_followup_line.auto_execute; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.auto_execute IS 'Automatic';


--
-- Name: COLUMN account_followup_followup_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_followup_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_followup_followup_line.send_letter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_followup_line.send_letter IS 'Send a Letter';


--
-- Name: account_followup_followup_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_followup_followup_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_followup_followup_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_followup_followup_line_id_seq OWNED BY public.account_followup_followup_line.id;


--
-- Name: account_followup_followup_line_res_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_followup_followup_line_res_users_rel (
    account_followup_followup_line_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE account_followup_followup_line_res_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_followup_followup_line_res_users_rel IS 'RELATION BETWEEN account_followup_followup_line AND res_users';


--
-- Name: account_followup_manual_reminder; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_followup_manual_reminder (
    id integer NOT NULL,
    template_id integer,
    partner_id integer,
    sms_template_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    sms_body character varying,
    body text,
    email boolean,
    sms boolean,
    print boolean,
    join_invoices boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    snailmail boolean
);


--
-- Name: TABLE account_followup_manual_reminder; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_followup_manual_reminder IS 'Wizard for sending manual reminders to clients';


--
-- Name: COLUMN account_followup_manual_reminder.template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_manual_reminder.template_id IS 'Mail Template';


--
-- Name: COLUMN account_followup_manual_reminder.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_manual_reminder.partner_id IS 'Partner';


--
-- Name: COLUMN account_followup_manual_reminder.sms_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN account_followup_manual_reminder.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_manual_reminder.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_manual_reminder.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_manual_reminder.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_manual_reminder.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_manual_reminder.lang IS 'Language';


--
-- Name: COLUMN account_followup_manual_reminder.subject; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_manual_reminder.subject IS 'Subject';


--
-- Name: COLUMN account_followup_manual_reminder.sms_body; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms_body IS 'Sms Body';


--
-- Name: COLUMN account_followup_manual_reminder.body; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_manual_reminder.body IS 'Contents';


--
-- Name: COLUMN account_followup_manual_reminder.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_manual_reminder.email IS 'Email';


--
-- Name: COLUMN account_followup_manual_reminder.sms; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms IS 'Sms';


--
-- Name: COLUMN account_followup_manual_reminder.print; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_manual_reminder.print IS 'Print';


--
-- Name: COLUMN account_followup_manual_reminder.join_invoices; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_manual_reminder.join_invoices IS 'Attach Invoices';


--
-- Name: COLUMN account_followup_manual_reminder.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_manual_reminder.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_manual_reminder.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_manual_reminder.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_followup_manual_reminder.snailmail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_manual_reminder.snailmail IS 'Snailmail';


--
-- Name: account_followup_manual_reminder_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_followup_manual_reminder_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_followup_manual_reminder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_followup_manual_reminder_id_seq OWNED BY public.account_followup_manual_reminder.id;


--
-- Name: account_followup_manual_reminder_ir_attachment_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_followup_manual_reminder_ir_attachment_rel (
    account_followup_manual_reminder_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


--
-- Name: TABLE account_followup_manual_reminder_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_followup_manual_reminder_ir_attachment_rel IS 'RELATION BETWEEN account_followup_manual_reminder AND ir_attachment';


--
-- Name: account_followup_missing_information_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_followup_missing_information_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_followup_missing_information_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_followup_missing_information_wizard IS 'Followup missing information wizard';


--
-- Name: COLUMN account_followup_missing_information_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_missing_information_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_missing_information_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_missing_information_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.write_date IS 'Last Updated on';


--
-- Name: account_followup_missing_information_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_followup_missing_information_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_followup_missing_information_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_followup_missing_information_wizard_id_seq OWNED BY public.account_followup_missing_information_wizard.id;


--
-- Name: account_full_reconcile; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_full_reconcile (
    id integer NOT NULL,
    exchange_move_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_full_reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_full_reconcile IS 'Full Reconcile';


--
-- Name: COLUMN account_full_reconcile.exchange_move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_full_reconcile.exchange_move_id IS 'Exchange Move';


--
-- Name: COLUMN account_full_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_full_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_full_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_full_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_full_reconcile.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_full_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_full_reconcile.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_full_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_full_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_full_reconcile_id_seq OWNED BY public.account_full_reconcile.id;


--
-- Name: account_group; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_group (
    id integer NOT NULL,
    parent_id integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code_prefix_start character varying,
    code_prefix_end character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT account_group_check_length_prefix CHECK ((char_length((COALESCE(code_prefix_start, ''::character varying))::text) = char_length((COALESCE(code_prefix_end, ''::character varying))::text)))
);


--
-- Name: TABLE account_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_group IS 'Account Group';


--
-- Name: COLUMN account_group.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_group.parent_id IS 'Parent';


--
-- Name: COLUMN account_group.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_group.company_id IS 'Company';


--
-- Name: COLUMN account_group.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_group.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_group.code_prefix_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_group.code_prefix_start IS 'Code Prefix Start';


--
-- Name: COLUMN account_group.code_prefix_end; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_group.code_prefix_end IS 'Code Prefix End';


--
-- Name: COLUMN account_group.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_group.name IS 'Name';


--
-- Name: COLUMN account_group.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_group.create_date IS 'Created on';


--
-- Name: COLUMN account_group.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_group.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_group_check_length_prefix ON account_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT account_group_check_length_prefix ON public.account_group IS 'CHECK(char_length(COALESCE(code_prefix_start, '''')) = char_length(COALESCE(code_prefix_end, '''')))';


--
-- Name: account_group_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_group_id_seq OWNED BY public.account_group.id;


--
-- Name: account_import_summary; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_import_summary (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    import_summary_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_import_summary; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_import_summary IS 'Account import summary view';


--
-- Name: COLUMN account_import_summary.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_import_summary.create_uid IS 'Created by';


--
-- Name: COLUMN account_import_summary.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_import_summary.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_import_summary.import_summary_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_import_summary.import_summary_name IS 'Import Summary Name';


--
-- Name: COLUMN account_import_summary.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_import_summary.create_date IS 'Created on';


--
-- Name: COLUMN account_import_summary.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_import_summary.write_date IS 'Last Updated on';


--
-- Name: account_import_summary_account_journal_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_import_summary_account_journal_rel (
    account_import_summary_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_import_summary_account_journal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_import_summary_account_journal_rel IS 'RELATION BETWEEN account_import_summary AND account_journal';


--
-- Name: account_import_summary_account_move_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_import_summary_account_move_rel (
    account_import_summary_id integer NOT NULL,
    account_move_id integer NOT NULL
);


--
-- Name: TABLE account_import_summary_account_move_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_import_summary_account_move_rel IS 'RELATION BETWEEN account_import_summary AND account_move';


--
-- Name: account_import_summary_account_tax_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_import_summary_account_tax_rel (
    account_import_summary_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


--
-- Name: TABLE account_import_summary_account_tax_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_import_summary_account_tax_rel IS 'RELATION BETWEEN account_import_summary AND account_tax';


--
-- Name: account_import_summary_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_import_summary_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_import_summary_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_import_summary_id_seq OWNED BY public.account_import_summary.id;


--
-- Name: account_import_summary_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_import_summary_res_partner_rel (
    account_import_summary_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE account_import_summary_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_import_summary_res_partner_rel IS 'RELATION BETWEEN account_import_summary AND res_partner';


--
-- Name: account_incoterms; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_incoterms (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying(3) NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_incoterms; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_incoterms IS 'Incoterms';


--
-- Name: COLUMN account_incoterms.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_incoterms.create_uid IS 'Created by';


--
-- Name: COLUMN account_incoterms.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_incoterms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_incoterms.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_incoterms.code IS 'Code';


--
-- Name: COLUMN account_incoterms.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_incoterms.name IS 'Name';


--
-- Name: COLUMN account_incoterms.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_incoterms.active IS 'Active';


--
-- Name: COLUMN account_incoterms.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_incoterms.create_date IS 'Created on';


--
-- Name: COLUMN account_incoterms.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_incoterms.write_date IS 'Last Updated on';


--
-- Name: account_incoterms_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_incoterms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_incoterms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_incoterms_id_seq OWNED BY public.account_incoterms.id;


--
-- Name: account_invoice_extract_words; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_invoice_extract_words (
    id integer NOT NULL,
    invoice_id integer NOT NULL,
    word_page integer,
    create_uid integer,
    write_uid integer,
    field character varying,
    word_text character varying,
    ocr_selected boolean,
    user_selected boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "word_box_midX" double precision,
    "word_box_midY" double precision,
    word_box_width double precision,
    word_box_height double precision,
    word_box_angle double precision
);


--
-- Name: TABLE account_invoice_extract_words; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_invoice_extract_words IS 'Extracted words from invoice scan';


--
-- Name: COLUMN account_invoice_extract_words.invoice_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_extract_words.invoice_id IS 'Invoice';


--
-- Name: COLUMN account_invoice_extract_words.word_page; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_page IS 'Word Page';


--
-- Name: COLUMN account_invoice_extract_words.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_extract_words.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_extract_words.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_extract_words.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_extract_words.field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_extract_words.field IS 'Field';


--
-- Name: COLUMN account_invoice_extract_words.word_text; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_text IS 'Word Text';


--
-- Name: COLUMN account_invoice_extract_words.ocr_selected; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_extract_words.ocr_selected IS 'Ocr Selected';


--
-- Name: COLUMN account_invoice_extract_words.user_selected; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_extract_words.user_selected IS 'User Selected';


--
-- Name: COLUMN account_invoice_extract_words.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_extract_words.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_extract_words.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_extract_words.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice_extract_words."word_box_midX"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_extract_words."word_box_midX" IS 'Word Box Midx';


--
-- Name: COLUMN account_invoice_extract_words."word_box_midY"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_extract_words."word_box_midY" IS 'Word Box Midy';


--
-- Name: COLUMN account_invoice_extract_words.word_box_width; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_box_width IS 'Word Box Width';


--
-- Name: COLUMN account_invoice_extract_words.word_box_height; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_box_height IS 'Word Box Height';


--
-- Name: COLUMN account_invoice_extract_words.word_box_angle; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_box_angle IS 'Word Box Angle';


--
-- Name: account_invoice_extract_words_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_invoice_extract_words_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_invoice_extract_words_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_invoice_extract_words_id_seq OWNED BY public.account_invoice_extract_words.id;


--
-- Name: account_invoice_transaction_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_invoice_transaction_rel (
    invoice_id integer NOT NULL,
    transaction_id integer NOT NULL
);


--
-- Name: TABLE account_invoice_transaction_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_invoice_transaction_rel IS 'RELATION BETWEEN account_move AND payment_transaction';


--
-- Name: account_journal; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_journal (
    id integer NOT NULL,
    alias_id integer,
    default_account_id integer,
    suspense_account_id integer,
    sequence integer,
    currency_id integer,
    company_id integer NOT NULL,
    profit_account_id integer,
    loss_account_id integer,
    bank_account_id integer,
    create_uid integer,
    write_uid integer,
    color integer,
    access_token character varying,
    code character varying(5) NOT NULL,
    type character varying NOT NULL,
    invoice_reference_type character varying NOT NULL,
    invoice_reference_model character varying NOT NULL,
    bank_statements_source character varying,
    name jsonb NOT NULL,
    sequence_override_regex text,
    active boolean,
    autocheck_on_post boolean,
    restrict_mode_hash_table boolean,
    refund_sequence boolean,
    payment_sequence boolean,
    show_on_dashboard boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    account_online_account_id integer,
    account_online_link_id integer,
    renewal_contact_email character varying,
    loan_properties_definition jsonb
);


--
-- Name: TABLE account_journal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_journal IS 'Journal';


--
-- Name: COLUMN account_journal.alias_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.alias_id IS 'Alias';


--
-- Name: COLUMN account_journal.default_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.default_account_id IS 'Default Account';


--
-- Name: COLUMN account_journal.suspense_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.suspense_account_id IS 'Suspense Account';


--
-- Name: COLUMN account_journal.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.currency_id IS 'Currency';


--
-- Name: COLUMN account_journal.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.company_id IS 'Company';


--
-- Name: COLUMN account_journal.profit_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_journal.loss_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_journal.bank_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN account_journal.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.color IS 'Color Index';


--
-- Name: COLUMN account_journal.access_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.access_token IS 'Security Token';


--
-- Name: COLUMN account_journal.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.code IS 'Short Code';


--
-- Name: COLUMN account_journal.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.type IS 'Type';


--
-- Name: COLUMN account_journal.invoice_reference_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.invoice_reference_type IS 'Communication Type';


--
-- Name: COLUMN account_journal.invoice_reference_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.invoice_reference_model IS 'Communication Standard';


--
-- Name: COLUMN account_journal.bank_statements_source; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.bank_statements_source IS 'Bank Feeds';


--
-- Name: COLUMN account_journal.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.name IS 'Journal Name';


--
-- Name: COLUMN account_journal.sequence_override_regex; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.sequence_override_regex IS 'Sequence Override Regex';


--
-- Name: COLUMN account_journal.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.active IS 'Active';


--
-- Name: COLUMN account_journal.autocheck_on_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.autocheck_on_post IS 'Auto-Check on Post';


--
-- Name: COLUMN account_journal.restrict_mode_hash_table; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.restrict_mode_hash_table IS 'Secure Posted Entries with Hash';


--
-- Name: COLUMN account_journal.refund_sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.refund_sequence IS 'Dedicated Credit Note Sequence';


--
-- Name: COLUMN account_journal.payment_sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.payment_sequence IS 'Dedicated Payment Sequence';


--
-- Name: COLUMN account_journal.show_on_dashboard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.show_on_dashboard IS 'Show journal on dashboard';


--
-- Name: COLUMN account_journal.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_journal.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_journal.account_online_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.account_online_account_id IS 'Account Online Account';


--
-- Name: COLUMN account_journal.account_online_link_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_journal.renewal_contact_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.renewal_contact_email IS 'Connection Requests';


--
-- Name: COLUMN account_journal.loan_properties_definition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal.loan_properties_definition IS 'Model Properties';


--
-- Name: account_journal_account_journal_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_journal_account_journal_group_rel (
    account_journal_group_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_journal_account_journal_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_journal_account_journal_group_rel IS 'RELATION BETWEEN account_journal_group AND account_journal';


--
-- Name: account_journal_account_reconcile_model_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_journal_account_reconcile_model_rel (
    account_reconcile_model_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_journal_account_reconcile_model_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_journal_account_reconcile_model_rel IS 'RELATION BETWEEN account_reconcile_model AND account_journal';


--
-- Name: account_journal_group; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_journal_group (
    id integer NOT NULL,
    company_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_journal_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_journal_group IS 'Account Journal Group';


--
-- Name: COLUMN account_journal_group.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal_group.company_id IS 'Company';


--
-- Name: COLUMN account_journal_group.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal_group.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_group.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal_group.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal_group.name IS 'Ledger group';


--
-- Name: COLUMN account_journal_group.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_group.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_journal_group.write_date IS 'Last Updated on';


--
-- Name: account_journal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_journal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_journal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_journal_group_id_seq OWNED BY public.account_journal_group.id;


--
-- Name: account_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_journal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_journal_id_seq OWNED BY public.account_journal.id;


--
-- Name: account_journal_l10n_fr_fec_export_wizard_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_journal_l10n_fr_fec_export_wizard_rel (
    l10n_fr_fec_export_wizard_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


--
-- Name: TABLE account_journal_l10n_fr_fec_export_wizard_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_journal_l10n_fr_fec_export_wizard_rel IS 'RELATION BETWEEN l10n_fr_fec_export_wizard AND account_journal';


--
-- Name: account_loan; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_loan (
    id integer NOT NULL,
    company_id integer NOT NULL,
    duration integer,
    long_term_account_id integer,
    short_term_account_id integer,
    expense_account_id integer,
    journal_id integer,
    asset_group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying NOT NULL,
    display_name character varying,
    date date,
    skip_until_date date,
    loan_properties jsonb,
    amount_borrowed numeric,
    interest numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_loan; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_loan IS 'Loan';


--
-- Name: COLUMN account_loan.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.company_id IS 'Company';


--
-- Name: COLUMN account_loan.duration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.duration IS 'Duration';


--
-- Name: COLUMN account_loan.long_term_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.long_term_account_id IS 'Long Term Account';


--
-- Name: COLUMN account_loan.short_term_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.short_term_account_id IS 'Short Term Account';


--
-- Name: COLUMN account_loan.expense_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.expense_account_id IS 'Expense Account';


--
-- Name: COLUMN account_loan.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.journal_id IS 'Journal';


--
-- Name: COLUMN account_loan.asset_group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.asset_group_id IS 'Asset Group';


--
-- Name: COLUMN account_loan.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.name IS 'Name';


--
-- Name: COLUMN account_loan.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.state IS 'Status';


--
-- Name: COLUMN account_loan.display_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.display_name IS 'Loan name';


--
-- Name: COLUMN account_loan.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.date IS 'Loan Date';


--
-- Name: COLUMN account_loan.skip_until_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.skip_until_date IS 'Skip until';


--
-- Name: COLUMN account_loan.loan_properties; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.loan_properties IS 'Properties';


--
-- Name: COLUMN account_loan.amount_borrowed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.amount_borrowed IS 'Amount Borrowed';


--
-- Name: COLUMN account_loan.interest; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.interest IS 'Interest';


--
-- Name: COLUMN account_loan.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.active IS 'Active';


--
-- Name: COLUMN account_loan.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.create_date IS 'Created on';


--
-- Name: COLUMN account_loan.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan.write_date IS 'Last Updated on';


--
-- Name: account_loan_close_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_loan_close_wizard (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_loan_close_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_loan_close_wizard IS 'Close Loan Wizard';


--
-- Name: COLUMN account_loan_close_wizard.loan_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_close_wizard.loan_id IS 'Loan';


--
-- Name: COLUMN account_loan_close_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_close_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_close_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_close_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_close_wizard.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_close_wizard.date IS 'Close Date';


--
-- Name: COLUMN account_loan_close_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_close_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_close_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_close_wizard.write_date IS 'Last Updated on';


--
-- Name: account_loan_close_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_loan_close_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_loan_close_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_loan_close_wizard_id_seq OWNED BY public.account_loan_close_wizard.id;


--
-- Name: account_loan_compute_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_loan_compute_wizard (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    loan_term integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payment_end_of_month character varying NOT NULL,
    compounding_method character varying NOT NULL,
    start_date date NOT NULL,
    first_payment_date date NOT NULL,
    loan_amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    interest_rate double precision NOT NULL
);


--
-- Name: TABLE account_loan_compute_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_loan_compute_wizard IS 'Loan Compute Wizard';


--
-- Name: COLUMN account_loan_compute_wizard.loan_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_compute_wizard.loan_id IS 'Loan';


--
-- Name: COLUMN account_loan_compute_wizard.loan_term; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_compute_wizard.loan_term IS 'Loan Term';


--
-- Name: COLUMN account_loan_compute_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_compute_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_compute_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_compute_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_compute_wizard.payment_end_of_month; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_compute_wizard.payment_end_of_month IS 'Payment';


--
-- Name: COLUMN account_loan_compute_wizard.compounding_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_compute_wizard.compounding_method IS 'Compounding Method';


--
-- Name: COLUMN account_loan_compute_wizard.start_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_compute_wizard.start_date IS 'Start Date';


--
-- Name: COLUMN account_loan_compute_wizard.first_payment_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_compute_wizard.first_payment_date IS 'First Payment';


--
-- Name: COLUMN account_loan_compute_wizard.loan_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_compute_wizard.loan_amount IS 'Loan Amount';


--
-- Name: COLUMN account_loan_compute_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_compute_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_compute_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_compute_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_loan_compute_wizard.interest_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_compute_wizard.interest_rate IS 'Interest Rate';


--
-- Name: account_loan_compute_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_loan_compute_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_loan_compute_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_loan_compute_wizard_id_seq OWNED BY public.account_loan_compute_wizard.id;


--
-- Name: account_loan_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_loan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_loan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_loan_id_seq OWNED BY public.account_loan.id;


--
-- Name: account_loan_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_loan_line (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    principal numeric,
    interest numeric,
    payment numeric,
    long_term_theoretical_balance numeric,
    short_term_theoretical_balance numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_loan_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_loan_line IS 'Loan Line';


--
-- Name: COLUMN account_loan_line.loan_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_line.loan_id IS 'Loan';


--
-- Name: COLUMN account_loan_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_line.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_line.date IS 'Date';


--
-- Name: COLUMN account_loan_line.principal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_line.principal IS 'Principal';


--
-- Name: COLUMN account_loan_line.interest; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_line.interest IS 'Interest';


--
-- Name: COLUMN account_loan_line.payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_line.payment IS 'Payment';


--
-- Name: COLUMN account_loan_line.long_term_theoretical_balance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_line.long_term_theoretical_balance IS 'Long-Term';


--
-- Name: COLUMN account_loan_line.short_term_theoretical_balance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_line.short_term_theoretical_balance IS 'Short-Term';


--
-- Name: COLUMN account_loan_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_line.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_loan_line.write_date IS 'Last Updated on';


--
-- Name: account_loan_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_loan_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_loan_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_loan_line_id_seq OWNED BY public.account_loan_line.id;


--
-- Name: account_lock_exception; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_lock_exception (
    id integer NOT NULL,
    company_id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    reason character varying,
    lock_date_field character varying NOT NULL,
    lock_date date,
    company_lock_date date,
    active boolean,
    end_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_lock_exception; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_lock_exception IS 'Account Lock Exception';


--
-- Name: COLUMN account_lock_exception.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_lock_exception.company_id IS 'Company';


--
-- Name: COLUMN account_lock_exception.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_lock_exception.user_id IS 'User';


--
-- Name: COLUMN account_lock_exception.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_lock_exception.create_uid IS 'Created by';


--
-- Name: COLUMN account_lock_exception.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_lock_exception.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_lock_exception.reason; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_lock_exception.reason IS 'Reason';


--
-- Name: COLUMN account_lock_exception.lock_date_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_lock_exception.lock_date_field IS 'Lock Date Field';


--
-- Name: COLUMN account_lock_exception.lock_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_lock_exception.lock_date IS 'Changed Lock Date';


--
-- Name: COLUMN account_lock_exception.company_lock_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_lock_exception.company_lock_date IS 'Original Lock Date';


--
-- Name: COLUMN account_lock_exception.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_lock_exception.active IS 'Active';


--
-- Name: COLUMN account_lock_exception.end_datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_lock_exception.end_datetime IS 'End Date';


--
-- Name: COLUMN account_lock_exception.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_lock_exception.create_date IS 'Created on';


--
-- Name: COLUMN account_lock_exception.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_lock_exception.write_date IS 'Last Updated on';


--
-- Name: account_lock_exception_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_lock_exception_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_lock_exception_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_lock_exception_id_seq OWNED BY public.account_lock_exception.id;


--
-- Name: account_merge_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_merge_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    is_group_by_name boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_merge_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_merge_wizard IS 'Account merge wizard';


--
-- Name: COLUMN account_merge_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_merge_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_merge_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_merge_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_merge_wizard.is_group_by_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_merge_wizard.is_group_by_name IS 'Group by name?';


--
-- Name: COLUMN account_merge_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_merge_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_merge_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_merge_wizard.write_date IS 'Last Updated on';


--
-- Name: account_merge_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_merge_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_merge_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_merge_wizard_id_seq OWNED BY public.account_merge_wizard.id;


--
-- Name: account_merge_wizard_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_merge_wizard_line (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    sequence integer,
    account_id integer,
    create_uid integer,
    write_uid integer,
    grouping_key character varying,
    display_type character varying NOT NULL,
    is_selected boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_merge_wizard_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_merge_wizard_line IS 'Account merge wizard line';


--
-- Name: COLUMN account_merge_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_merge_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN account_merge_wizard_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_merge_wizard_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_merge_wizard_line.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_merge_wizard_line.account_id IS 'Account';


--
-- Name: COLUMN account_merge_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_merge_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_merge_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_merge_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_merge_wizard_line.grouping_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_merge_wizard_line.grouping_key IS 'Grouping Key';


--
-- Name: COLUMN account_merge_wizard_line.display_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_merge_wizard_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_merge_wizard_line.is_selected; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_merge_wizard_line.is_selected IS 'Is Selected';


--
-- Name: COLUMN account_merge_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_merge_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN account_merge_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_merge_wizard_line.write_date IS 'Last Updated on';


--
-- Name: account_merge_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_merge_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_merge_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_merge_wizard_line_id_seq OWNED BY public.account_merge_wizard_line.id;


--
-- Name: account_missing_transaction_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_missing_transaction_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_missing_transaction_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_missing_transaction_wizard IS 'Wizard for missing transactions';


--
-- Name: COLUMN account_missing_transaction_wizard.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_missing_transaction_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_missing_transaction_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_missing_transaction_wizard.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.date IS 'Starting Date';


--
-- Name: COLUMN account_missing_transaction_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_missing_transaction_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.write_date IS 'Last Updated on';


--
-- Name: account_missing_transaction_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_missing_transaction_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_missing_transaction_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_missing_transaction_wizard_id_seq OWNED BY public.account_missing_transaction_wizard.id;


--
-- Name: account_model_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_model_rel (
    account_transfer_model_id integer NOT NULL,
    account_account_id integer NOT NULL
);


--
-- Name: TABLE account_model_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_model_rel IS 'RELATION BETWEEN account_transfer_model AND account_account';


--
-- Name: account_move; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move (
    id integer NOT NULL,
    sequence_number integer,
    message_main_attachment_id integer,
    journal_id integer NOT NULL,
    company_id integer,
    origin_payment_id integer,
    statement_line_id integer,
    tax_cash_basis_rec_id integer,
    tax_cash_basis_origin_move_id integer,
    auto_post_origin_id integer,
    secure_sequence_number integer,
    invoice_payment_term_id integer,
    partner_id integer,
    commercial_partner_id integer,
    partner_shipping_id integer,
    partner_bank_id integer,
    fiscal_position_id integer,
    preferred_payment_method_line_id integer,
    currency_id integer NOT NULL,
    reversed_entry_id integer,
    invoice_user_id integer,
    invoice_incoterm_id integer,
    invoice_cash_rounding_id integer,
    create_uid integer,
    write_uid integer,
    sequence_prefix character varying,
    access_token character varying,
    name character varying,
    ref character varying,
    state character varying NOT NULL,
    move_type character varying NOT NULL,
    auto_post character varying NOT NULL,
    inalterable_hash character varying,
    payment_reference character varying,
    qr_code_method character varying,
    payment_state character varying,
    invoice_source_email character varying,
    invoice_partner_display_name character varying,
    invoice_origin character varying,
    incoterm_location character varying,
    date date NOT NULL,
    auto_post_until date,
    invoice_date date,
    invoice_date_due date,
    delivery_date date,
    sending_data jsonb,
    narration text,
    invoice_currency_rate numeric,
    amount_untaxed numeric,
    amount_tax numeric,
    amount_total numeric,
    amount_residual numeric,
    amount_untaxed_signed numeric,
    amount_untaxed_in_currency_signed numeric,
    amount_tax_signed numeric,
    amount_total_signed numeric,
    amount_total_in_currency_signed numeric,
    amount_residual_signed numeric,
    quick_edit_total_amount numeric,
    is_storno boolean,
    always_tax_exigible boolean,
    checked boolean,
    posted_before boolean,
    made_sequence_gap boolean,
    is_manually_modified boolean,
    is_move_sent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    signing_user integer,
    payment_state_before_switch character varying,
    transfer_model_id integer,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    team_id integer,
    tax_closing_report_id integer,
    asset_id integer,
    asset_number_days integer,
    asset_move_type character varying,
    asset_depreciation_beginning_date date,
    depreciation_value numeric,
    asset_value_change boolean,
    extract_attachment_id integer,
    extract_detected_layout integer,
    extract_state character varying,
    extract_status character varying,
    extract_document_uuid character varying,
    extract_partner_name character varying,
    extract_prefill_data jsonb,
    is_in_extractable_state boolean,
    extract_state_processed boolean,
    generating_loan_line_id integer,
    is_loan_payment_move boolean,
    expense_sheet_id integer,
    stock_move_id integer,
    website_id integer,
    suspense_statement_line_id integer
);


--
-- Name: TABLE account_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move IS 'Journal Entry';


--
-- Name: COLUMN account_move.sequence_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.sequence_number IS 'Sequence Number';


--
-- Name: COLUMN account_move.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_move.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.journal_id IS 'Journal';


--
-- Name: COLUMN account_move.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.company_id IS 'Company';


--
-- Name: COLUMN account_move.origin_payment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.origin_payment_id IS 'Payment';


--
-- Name: COLUMN account_move.statement_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.statement_line_id IS 'Statement Line';


--
-- Name: COLUMN account_move.tax_cash_basis_rec_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_rec_id IS 'Tax Cash Basis Entry of';


--
-- Name: COLUMN account_move.tax_cash_basis_origin_move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_origin_move_id IS 'Cash Basis Origin';


--
-- Name: COLUMN account_move.auto_post_origin_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.auto_post_origin_id IS 'First recurring entry';


--
-- Name: COLUMN account_move.secure_sequence_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.secure_sequence_number IS 'Inalterability No Gap Sequence #';


--
-- Name: COLUMN account_move.invoice_payment_term_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_payment_term_id IS 'Payment Terms';


--
-- Name: COLUMN account_move.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.partner_id IS 'Partner';


--
-- Name: COLUMN account_move.commercial_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN account_move.partner_shipping_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.partner_shipping_id IS 'Delivery Address';


--
-- Name: COLUMN account_move.partner_bank_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.partner_bank_id IS 'Recipient Bank';


--
-- Name: COLUMN account_move.fiscal_position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_move.preferred_payment_method_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.preferred_payment_method_line_id IS 'Preferred Payment Method Line';


--
-- Name: COLUMN account_move.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.currency_id IS 'Currency';


--
-- Name: COLUMN account_move.reversed_entry_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.reversed_entry_id IS 'Reversal of';


--
-- Name: COLUMN account_move.invoice_user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_user_id IS 'Salesperson';


--
-- Name: COLUMN account_move.invoice_incoterm_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_incoterm_id IS 'Incoterm';


--
-- Name: COLUMN account_move.invoice_cash_rounding_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_cash_rounding_id IS 'Cash Rounding Method';


--
-- Name: COLUMN account_move.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.create_uid IS 'Created by';


--
-- Name: COLUMN account_move.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move.sequence_prefix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.sequence_prefix IS 'Sequence Prefix';


--
-- Name: COLUMN account_move.access_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.access_token IS 'Security Token';


--
-- Name: COLUMN account_move.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.name IS 'Number';


--
-- Name: COLUMN account_move.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.ref IS 'Reference';


--
-- Name: COLUMN account_move.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.state IS 'Status';


--
-- Name: COLUMN account_move.move_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.move_type IS 'Type';


--
-- Name: COLUMN account_move.auto_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.auto_post IS 'Auto-post';


--
-- Name: COLUMN account_move.inalterable_hash; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.inalterable_hash IS 'Inalterability Hash';


--
-- Name: COLUMN account_move.payment_reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_move.qr_code_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.qr_code_method IS 'Payment QR-code';


--
-- Name: COLUMN account_move.payment_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.payment_state IS 'Payment Status';


--
-- Name: COLUMN account_move.invoice_source_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_source_email IS 'Source Email';


--
-- Name: COLUMN account_move.invoice_partner_display_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_partner_display_name IS 'Invoice Partner Display Name';


--
-- Name: COLUMN account_move.invoice_origin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_origin IS 'Origin';


--
-- Name: COLUMN account_move.incoterm_location; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.incoterm_location IS 'Incoterm Location';


--
-- Name: COLUMN account_move.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.date IS 'Date';


--
-- Name: COLUMN account_move.auto_post_until; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.auto_post_until IS 'Auto-post until';


--
-- Name: COLUMN account_move.invoice_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move.invoice_date_due; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_date_due IS 'Due Date';


--
-- Name: COLUMN account_move.delivery_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.delivery_date IS 'Delivery Date';


--
-- Name: COLUMN account_move.sending_data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.sending_data IS 'Sending Data';


--
-- Name: COLUMN account_move.narration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.narration IS 'Terms and Conditions';


--
-- Name: COLUMN account_move.invoice_currency_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.invoice_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN account_move.amount_untaxed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_untaxed IS 'Untaxed Amount';


--
-- Name: COLUMN account_move.amount_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_tax IS 'Tax';


--
-- Name: COLUMN account_move.amount_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_total IS 'Total';


--
-- Name: COLUMN account_move.amount_residual; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_residual IS 'Amount Due';


--
-- Name: COLUMN account_move.amount_untaxed_signed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_untaxed_signed IS 'Untaxed Amount Signed';


--
-- Name: COLUMN account_move.amount_untaxed_in_currency_signed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_untaxed_in_currency_signed IS 'Untaxed Amount Signed Currency';


--
-- Name: COLUMN account_move.amount_tax_signed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_tax_signed IS 'Tax Signed';


--
-- Name: COLUMN account_move.amount_total_signed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_total_signed IS 'Total Signed';


--
-- Name: COLUMN account_move.amount_total_in_currency_signed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_total_in_currency_signed IS 'Total in Currency Signed';


--
-- Name: COLUMN account_move.amount_residual_signed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.amount_residual_signed IS 'Amount Due Signed';


--
-- Name: COLUMN account_move.quick_edit_total_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.quick_edit_total_amount IS 'Total (Tax inc.)';


--
-- Name: COLUMN account_move.is_storno; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.is_storno IS 'Is Storno';


--
-- Name: COLUMN account_move.always_tax_exigible; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.always_tax_exigible IS 'Always Tax Exigible';


--
-- Name: COLUMN account_move.checked; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.checked IS 'Checked';


--
-- Name: COLUMN account_move.posted_before; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.posted_before IS 'Posted Before';


--
-- Name: COLUMN account_move.made_sequence_gap; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.made_sequence_gap IS 'Made Sequence Gap';


--
-- Name: COLUMN account_move.is_manually_modified; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.is_manually_modified IS 'Is Manually Modified';


--
-- Name: COLUMN account_move.is_move_sent; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.is_move_sent IS 'Is Move Sent';


--
-- Name: COLUMN account_move.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.create_date IS 'Created on';


--
-- Name: COLUMN account_move.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move.signing_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.signing_user IS 'Signer';


--
-- Name: COLUMN account_move.payment_state_before_switch; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.payment_state_before_switch IS 'Payment State Before Switch';


--
-- Name: COLUMN account_move.transfer_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.transfer_model_id IS 'Originating Model';


--
-- Name: COLUMN account_move.campaign_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.campaign_id IS 'Campaign';


--
-- Name: COLUMN account_move.source_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.source_id IS 'Source';


--
-- Name: COLUMN account_move.medium_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.medium_id IS 'Medium';


--
-- Name: COLUMN account_move.team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.team_id IS 'Sales Team';


--
-- Name: COLUMN account_move.tax_closing_report_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.tax_closing_report_id IS 'Tax Closing Report';


--
-- Name: COLUMN account_move.asset_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.asset_id IS 'Asset';


--
-- Name: COLUMN account_move.asset_number_days; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.asset_number_days IS 'Number of days';


--
-- Name: COLUMN account_move.asset_move_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.asset_move_type IS 'Asset Move Type';


--
-- Name: COLUMN account_move.asset_depreciation_beginning_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.asset_depreciation_beginning_date IS 'Date of the beginning of the depreciation';


--
-- Name: COLUMN account_move.depreciation_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.depreciation_value IS 'Depreciation';


--
-- Name: COLUMN account_move.asset_value_change; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.asset_value_change IS 'Asset Value Change';


--
-- Name: COLUMN account_move.extract_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.extract_attachment_id IS 'Extract Attachment';


--
-- Name: COLUMN account_move.extract_detected_layout; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.extract_detected_layout IS 'Extract Detected Layout Id';


--
-- Name: COLUMN account_move.extract_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.extract_state IS 'Extract state';


--
-- Name: COLUMN account_move.extract_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.extract_status IS 'Extract status';


--
-- Name: COLUMN account_move.extract_document_uuid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.extract_document_uuid IS 'ID of the request to IAP-OCR';


--
-- Name: COLUMN account_move.extract_partner_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.extract_partner_name IS 'Extract Detected Partner Name';


--
-- Name: COLUMN account_move.extract_prefill_data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.extract_prefill_data IS 'Extract Prefill Data';


--
-- Name: COLUMN account_move.is_in_extractable_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.is_in_extractable_state IS 'Is In Extractable State';


--
-- Name: COLUMN account_move.extract_state_processed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.extract_state_processed IS 'Extract State Processed';


--
-- Name: COLUMN account_move.generating_loan_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.generating_loan_line_id IS 'Generating Loan Line';


--
-- Name: COLUMN account_move.is_loan_payment_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.is_loan_payment_move IS 'Is Loan Payment Move';


--
-- Name: COLUMN account_move.expense_sheet_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.expense_sheet_id IS 'Expense Sheet';


--
-- Name: COLUMN account_move.stock_move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.stock_move_id IS 'Stock Move';


--
-- Name: COLUMN account_move.suspense_statement_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move.suspense_statement_line_id IS 'Request document from a bank statement line';


--
-- Name: account_move__account_payment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move__account_payment (
    invoice_id integer NOT NULL,
    payment_id integer NOT NULL
);


--
-- Name: TABLE account_move__account_payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move__account_payment IS 'RELATION BETWEEN account_move AND account_payment';


--
-- Name: account_move_account_move_send_batch_wizard_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_account_move_send_batch_wizard_rel (
    account_move_send_batch_wizard_id integer NOT NULL,
    account_move_id integer NOT NULL
);


--
-- Name: TABLE account_move_account_move_send_batch_wizard_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_account_move_send_batch_wizard_rel IS 'RELATION BETWEEN account_move_send_batch_wizard AND account_move';


--
-- Name: account_move_account_resequence_wizard_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_account_resequence_wizard_rel (
    account_resequence_wizard_id integer NOT NULL,
    account_move_id integer NOT NULL
);


--
-- Name: TABLE account_move_account_resequence_wizard_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_account_resequence_wizard_rel IS 'RELATION BETWEEN account_resequence_wizard AND account_move';


--
-- Name: account_move_asset_modify_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_asset_modify_rel (
    asset_modify_id integer NOT NULL,
    account_move_id integer NOT NULL
);


--
-- Name: TABLE account_move_asset_modify_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_asset_modify_rel IS 'RELATION BETWEEN asset_modify AND account_move';


--
-- Name: account_move_deferred_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_deferred_rel (
    original_move_id integer NOT NULL,
    deferred_move_id integer NOT NULL
);


--
-- Name: TABLE account_move_deferred_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_deferred_rel IS 'RELATION BETWEEN account_move AND account_move';


--
-- Name: account_move_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_move_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_move_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_move_id_seq OWNED BY public.account_move.id;


--
-- Name: account_move_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    journal_id integer,
    company_id integer,
    company_currency_id integer,
    sequence integer,
    account_id integer,
    currency_id integer NOT NULL,
    partner_id integer,
    reconcile_model_id integer,
    payment_id integer,
    statement_line_id integer,
    statement_id integer,
    group_tax_id integer,
    tax_line_id integer,
    tax_group_id integer,
    tax_repartition_line_id integer,
    full_reconcile_id integer,
    product_id integer,
    product_uom_id integer,
    create_uid integer,
    write_uid integer,
    move_name character varying,
    parent_state character varying,
    ref character varying,
    name character varying,
    matching_number character varying,
    display_type character varying NOT NULL,
    date date,
    invoice_date date,
    date_maturity date,
    discount_date date,
    analytic_distribution jsonb,
    debit numeric,
    credit numeric,
    balance numeric,
    amount_currency numeric,
    tax_base_amount numeric,
    amount_residual numeric,
    amount_residual_currency numeric,
    quantity numeric,
    price_unit numeric,
    price_subtotal numeric,
    price_total numeric,
    discount numeric,
    discount_amount_currency numeric,
    discount_balance numeric,
    is_imported boolean,
    tax_tag_invert boolean,
    reconciled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    deferred_start_date date,
    deferred_end_date date,
    is_downpayment boolean,
    exclude_bank_lines boolean,
    followup_line_id integer,
    expense_id integer,
    cogs_origin_id integer,
    purchase_line_id integer,
    CONSTRAINT account_move_line_check_accountable_required_fields CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR (account_id IS NOT NULL))),
    CONSTRAINT account_move_line_check_amount_currency_balance_sign CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR (((balance <= (0)::numeric) AND (amount_currency <= (0)::numeric)) OR ((balance >= (0)::numeric) AND (amount_currency >= (0)::numeric))))),
    CONSTRAINT account_move_line_check_credit_debit CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR ((credit * debit) = (0)::numeric))),
    CONSTRAINT account_move_line_check_non_accountable_fields_null CHECK ((((display_type)::text <> ALL ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR ((amount_currency = (0)::numeric) AND (debit = (0)::numeric) AND (credit = (0)::numeric) AND (account_id IS NULL))))
);


--
-- Name: TABLE account_move_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_line IS 'Journal Item';


--
-- Name: COLUMN account_move_line.move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_move_line.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.company_id IS 'Company';


--
-- Name: COLUMN account_move_line.company_currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN account_move_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_move_line.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.account_id IS 'Account';


--
-- Name: COLUMN account_move_line.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_move_line.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_move_line.reconcile_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.reconcile_model_id IS 'Reconciliation Model';


--
-- Name: COLUMN account_move_line.payment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.payment_id IS 'Originator Payment';


--
-- Name: COLUMN account_move_line.statement_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.statement_line_id IS 'Originator Statement Line';


--
-- Name: COLUMN account_move_line.statement_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_move_line.group_tax_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.group_tax_id IS 'Originator Group of Taxes';


--
-- Name: COLUMN account_move_line.tax_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.tax_line_id IS 'Originator Tax';


--
-- Name: COLUMN account_move_line.tax_group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.tax_group_id IS 'Originator tax group';


--
-- Name: COLUMN account_move_line.tax_repartition_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.tax_repartition_line_id IS 'Originator Tax Distribution Line';


--
-- Name: COLUMN account_move_line.full_reconcile_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.full_reconcile_id IS 'Matching';


--
-- Name: COLUMN account_move_line.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.product_id IS 'Product';


--
-- Name: COLUMN account_move_line.product_uom_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_move_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_line.move_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.move_name IS 'Number';


--
-- Name: COLUMN account_move_line.parent_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.parent_state IS 'Status';


--
-- Name: COLUMN account_move_line.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.ref IS 'Reference';


--
-- Name: COLUMN account_move_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.name IS 'Label';


--
-- Name: COLUMN account_move_line.matching_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.matching_number IS 'Matching #';


--
-- Name: COLUMN account_move_line.display_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_move_line.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.date IS 'Date';


--
-- Name: COLUMN account_move_line.invoice_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move_line.date_maturity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.date_maturity IS 'Due Date';


--
-- Name: COLUMN account_move_line.discount_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.discount_date IS 'Discount Date';


--
-- Name: COLUMN account_move_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_move_line.debit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.debit IS 'Debit';


--
-- Name: COLUMN account_move_line.credit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.credit IS 'Credit';


--
-- Name: COLUMN account_move_line.balance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.balance IS 'Balance';


--
-- Name: COLUMN account_move_line.amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_move_line.tax_base_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.tax_base_amount IS 'Base Amount';


--
-- Name: COLUMN account_move_line.amount_residual; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_move_line.amount_residual_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.amount_residual_currency IS 'Residual Amount in Currency';


--
-- Name: COLUMN account_move_line.quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.quantity IS 'Quantity';


--
-- Name: COLUMN account_move_line.price_unit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.price_unit IS 'Unit Price';


--
-- Name: COLUMN account_move_line.price_subtotal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.price_subtotal IS 'Subtotal';


--
-- Name: COLUMN account_move_line.price_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.price_total IS 'Total';


--
-- Name: COLUMN account_move_line.discount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.discount IS 'Discount (%)';


--
-- Name: COLUMN account_move_line.discount_amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.discount_amount_currency IS 'Discount amount in Currency';


--
-- Name: COLUMN account_move_line.discount_balance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.discount_balance IS 'Discount Balance';


--
-- Name: COLUMN account_move_line.is_imported; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.is_imported IS 'Is Imported';


--
-- Name: COLUMN account_move_line.tax_tag_invert; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.tax_tag_invert IS 'Invert Tags';


--
-- Name: COLUMN account_move_line.reconciled; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.reconciled IS 'Reconciled';


--
-- Name: COLUMN account_move_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.create_date IS 'Created on';


--
-- Name: COLUMN account_move_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_line.deferred_start_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.deferred_start_date IS 'Start Date';


--
-- Name: COLUMN account_move_line.deferred_end_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.deferred_end_date IS 'End Date';


--
-- Name: COLUMN account_move_line.is_downpayment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.is_downpayment IS 'Is Downpayment';


--
-- Name: COLUMN account_move_line.exclude_bank_lines; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.exclude_bank_lines IS 'Exclude Bank Lines';


--
-- Name: COLUMN account_move_line.followup_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.followup_line_id IS 'Follow-up Level';


--
-- Name: COLUMN account_move_line.expense_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.expense_id IS 'Expense';


--
-- Name: COLUMN account_move_line.cogs_origin_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.cogs_origin_id IS 'Cogs Origin';


--
-- Name: COLUMN account_move_line.purchase_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_line.purchase_line_id IS 'Purchase Order Line';


--
-- Name: CONSTRAINT account_move_line_check_accountable_required_fields ON account_move_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT account_move_line_check_accountable_required_fields ON public.account_move_line IS 'CHECK(display_type IN (''line_section'', ''line_note'') OR account_id IS NOT NULL)';


--
-- Name: CONSTRAINT account_move_line_check_amount_currency_balance_sign ON account_move_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT account_move_line_check_amount_currency_balance_sign ON public.account_move_line IS 'CHECK(
                display_type IN (''line_section'', ''line_note'')
                OR (
                    (balance <= 0 AND amount_currency <= 0)
                    OR
                    (balance >= 0 AND amount_currency >= 0)
                )
            )';


--
-- Name: CONSTRAINT account_move_line_check_credit_debit ON account_move_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT account_move_line_check_credit_debit ON public.account_move_line IS 'CHECK(display_type IN (''line_section'', ''line_note'') OR credit * debit=0)';


--
-- Name: CONSTRAINT account_move_line_check_non_accountable_fields_null ON account_move_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT account_move_line_check_non_accountable_fields_null ON public.account_move_line IS 'CHECK(display_type NOT IN (''line_section'', ''line_note'') OR (amount_currency = 0 AND debit = 0 AND credit = 0 AND account_id IS NULL))';


--
-- Name: account_move_line_account_reconcile_wizard_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_line_account_reconcile_wizard_rel (
    account_reconcile_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


--
-- Name: TABLE account_move_line_account_reconcile_wizard_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_line_account_reconcile_wizard_rel IS 'RELATION BETWEEN account_reconcile_wizard AND account_move_line';


--
-- Name: account_move_line_account_tax_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_line_account_tax_rel (
    account_move_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


--
-- Name: TABLE account_move_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_line_account_tax_rel IS 'RELATION BETWEEN account_move_line AND account_tax';


--
-- Name: account_move_line_asset_modify_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_line_asset_modify_rel (
    asset_modify_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


--
-- Name: TABLE account_move_line_asset_modify_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_line_asset_modify_rel IS 'RELATION BETWEEN asset_modify AND account_move_line';


--
-- Name: account_move_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_move_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_move_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_move_line_id_seq OWNED BY public.account_move_line.id;


--
-- Name: account_move_mrp_production_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_mrp_production_rel (
    account_move_id integer NOT NULL,
    mrp_production_id integer NOT NULL
);


--
-- Name: TABLE account_move_mrp_production_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_mrp_production_rel IS 'RELATION BETWEEN account_move AND mrp_production';


--
-- Name: account_move_purchase_order_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_purchase_order_rel (
    purchase_order_id integer NOT NULL,
    account_move_id integer NOT NULL
);


--
-- Name: TABLE account_move_purchase_order_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_purchase_order_rel IS 'RELATION BETWEEN purchase_order AND account_move';


--
-- Name: account_move_reversal; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_reversal (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reason character varying,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_move_reversal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_reversal IS 'Account Move Reversal';


--
-- Name: COLUMN account_move_reversal.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_reversal.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.company_id IS 'Company';


--
-- Name: COLUMN account_move_reversal.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_reversal.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_reversal.reason; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.reason IS 'Reason displayed on Credit Note';


--
-- Name: COLUMN account_move_reversal.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.date IS 'Reversal date';


--
-- Name: COLUMN account_move_reversal.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.create_date IS 'Created on';


--
-- Name: COLUMN account_move_reversal.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_reversal.write_date IS 'Last Updated on';


--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_move_reversal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_move_reversal_id_seq OWNED BY public.account_move_reversal.id;


--
-- Name: account_move_reversal_move; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_reversal_move (
    reversal_id integer NOT NULL,
    move_id integer NOT NULL
);


--
-- Name: TABLE account_move_reversal_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_reversal_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_reversal_new_move; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_reversal_new_move (
    reversal_id integer NOT NULL,
    new_move_id integer NOT NULL
);


--
-- Name: TABLE account_move_reversal_new_move; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_reversal_new_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_send_batch_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_send_batch_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_move_send_batch_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_send_batch_wizard IS 'Account Move Send Batch Wizard';


--
-- Name: COLUMN account_move_send_batch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_send_batch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_send_batch_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_move_send_batch_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.write_date IS 'Last Updated on';


--
-- Name: account_move_send_batch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_move_send_batch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_move_send_batch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_move_send_batch_wizard_id_seq OWNED BY public.account_move_send_batch_wizard.id;


--
-- Name: account_move_send_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_send_wizard (
    id integer NOT NULL,
    move_id integer NOT NULL,
    pdf_report_id integer,
    mail_template_id integer,
    create_uid integer,
    write_uid integer,
    mail_subject character varying,
    sending_method_checkboxes jsonb,
    extra_edi_checkboxes jsonb,
    mail_attachments_widget jsonb,
    mail_body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_move_send_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_send_wizard IS 'Account Move Send Wizard';


--
-- Name: COLUMN account_move_send_wizard.move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_send_wizard.move_id IS 'Move';


--
-- Name: COLUMN account_move_send_wizard.pdf_report_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_send_wizard.pdf_report_id IS 'Invoice template';


--
-- Name: COLUMN account_move_send_wizard.mail_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_template_id IS 'Email template';


--
-- Name: COLUMN account_move_send_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_send_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_send_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_send_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_send_wizard.mail_subject; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_subject IS 'Subject';


--
-- Name: COLUMN account_move_send_wizard.sending_method_checkboxes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_send_wizard.sending_method_checkboxes IS 'Sending Method Checkboxes';


--
-- Name: COLUMN account_move_send_wizard.extra_edi_checkboxes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_send_wizard.extra_edi_checkboxes IS 'Extra Edi Checkboxes';


--
-- Name: COLUMN account_move_send_wizard.mail_attachments_widget; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_attachments_widget IS 'Mail Attachments Widget';


--
-- Name: COLUMN account_move_send_wizard.mail_body; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_body IS 'Contents';


--
-- Name: COLUMN account_move_send_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_send_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_move_send_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_move_send_wizard.write_date IS 'Last Updated on';


--
-- Name: account_move_send_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_move_send_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_move_send_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_move_send_wizard_id_seq OWNED BY public.account_move_send_wizard.id;


--
-- Name: account_move_send_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_send_wizard_res_partner_rel (
    account_move_send_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE account_move_send_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_send_wizard_res_partner_rel IS 'RELATION BETWEEN account_move_send_wizard AND res_partner';


--
-- Name: account_move_validate_account_move_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_move_validate_account_move_rel (
    validate_account_move_id integer NOT NULL,
    account_move_id integer NOT NULL
);


--
-- Name: TABLE account_move_validate_account_move_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_move_validate_account_move_rel IS 'RELATION BETWEEN validate_account_move AND account_move';


--
-- Name: account_multicurrency_revaluation_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_multicurrency_revaluation_wizard (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    reversal_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_multicurrency_revaluation_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_multicurrency_revaluation_wizard IS 'Multicurrency Revaluation Wizard';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.date IS 'Date';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.reversal_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.reversal_date IS 'Reversal Date';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.write_date IS 'Last Updated on';


--
-- Name: account_multicurrency_revaluation_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_multicurrency_revaluation_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq OWNED BY public.account_multicurrency_revaluation_wizard.id;


--
-- Name: account_online_account; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_online_account (
    id integer NOT NULL,
    account_online_link_id integer,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    online_identifier character varying,
    account_number character varying,
    account_data character varying,
    fetching_status character varying,
    last_sync date,
    inverse_balance_sign boolean,
    inverse_transaction_sign boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    balance double precision
);


--
-- Name: TABLE account_online_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_online_account IS 'representation of an online bank account';


--
-- Name: COLUMN account_online_account.account_online_link_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_account.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_online_account.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_account.currency_id IS 'Currency';


--
-- Name: COLUMN account_online_account.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_online_account.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_online_account.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_account.name IS 'Account Name';


--
-- Name: COLUMN account_online_account.online_identifier; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_account.online_identifier IS 'Online Identifier';


--
-- Name: COLUMN account_online_account.account_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_account.account_number IS 'Account Number';


--
-- Name: COLUMN account_online_account.account_data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_account.account_data IS 'Account Data';


--
-- Name: COLUMN account_online_account.fetching_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_account.fetching_status IS 'Fetching Status';


--
-- Name: COLUMN account_online_account.last_sync; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_account.last_sync IS 'Last synchronization';


--
-- Name: COLUMN account_online_account.inverse_balance_sign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_account.inverse_balance_sign IS 'Inverse Balance Sign';


--
-- Name: COLUMN account_online_account.inverse_transaction_sign; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_account.inverse_transaction_sign IS 'Inverse Transaction Sign';


--
-- Name: COLUMN account_online_account.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_account.create_date IS 'Created on';


--
-- Name: COLUMN account_online_account.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_online_account.balance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_account.balance IS 'Balance';


--
-- Name: account_online_account_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_online_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_online_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_online_account_id_seq OWNED BY public.account_online_account.id;


--
-- Name: account_online_link; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_online_link (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    client_id character varying,
    refresh_token character varying,
    access_token character varying,
    provider_data character varying,
    provider_type character varying,
    expiring_synchronization_date date,
    connection_state_details jsonb,
    auto_sync boolean,
    has_unlinked_accounts boolean,
    last_refresh timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_online_link; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_online_link IS 'Bank Connection';


--
-- Name: COLUMN account_online_link.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.company_id IS 'Company';


--
-- Name: COLUMN account_online_link.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.create_uid IS 'Created by';


--
-- Name: COLUMN account_online_link.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_online_link.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.state IS 'State';


--
-- Name: COLUMN account_online_link.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.name IS 'Name';


--
-- Name: COLUMN account_online_link.client_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.client_id IS 'Client';


--
-- Name: COLUMN account_online_link.refresh_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.refresh_token IS 'Refresh Token';


--
-- Name: COLUMN account_online_link.access_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.access_token IS 'Access Token';


--
-- Name: COLUMN account_online_link.provider_data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.provider_data IS 'Provider Data';


--
-- Name: COLUMN account_online_link.provider_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.provider_type IS 'Provider Type';


--
-- Name: COLUMN account_online_link.expiring_synchronization_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.expiring_synchronization_date IS 'Expiring Synchronization Date';


--
-- Name: COLUMN account_online_link.connection_state_details; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.connection_state_details IS 'Connection State Details';


--
-- Name: COLUMN account_online_link.auto_sync; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.auto_sync IS 'Automatic synchronization';


--
-- Name: COLUMN account_online_link.has_unlinked_accounts; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.has_unlinked_accounts IS 'Has Unlinked Accounts';


--
-- Name: COLUMN account_online_link.last_refresh; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.last_refresh IS 'Last Refresh';


--
-- Name: COLUMN account_online_link.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.create_date IS 'Created on';


--
-- Name: COLUMN account_online_link.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_online_link.write_date IS 'Last Updated on';


--
-- Name: account_online_link_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_online_link_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_online_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_online_link_id_seq OWNED BY public.account_online_link.id;


--
-- Name: account_partial_reconcile; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_partial_reconcile (
    id integer NOT NULL,
    debit_move_id integer NOT NULL,
    credit_move_id integer NOT NULL,
    full_reconcile_id integer,
    exchange_move_id integer,
    debit_currency_id integer,
    credit_currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    max_date date,
    amount numeric,
    debit_amount_currency numeric,
    credit_amount_currency numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_partial_reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_partial_reconcile IS 'Partial Reconcile';


--
-- Name: COLUMN account_partial_reconcile.debit_move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_move_id IS 'Debit Move';


--
-- Name: COLUMN account_partial_reconcile.credit_move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_move_id IS 'Credit Move';


--
-- Name: COLUMN account_partial_reconcile.full_reconcile_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.full_reconcile_id IS 'Full Reconcile';


--
-- Name: COLUMN account_partial_reconcile.exchange_move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.exchange_move_id IS 'Exchange Move';


--
-- Name: COLUMN account_partial_reconcile.debit_currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_currency_id IS 'Currency of the debit journal item.';


--
-- Name: COLUMN account_partial_reconcile.credit_currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_currency_id IS 'Currency of the credit journal item.';


--
-- Name: COLUMN account_partial_reconcile.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.company_id IS 'Company';


--
-- Name: COLUMN account_partial_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_partial_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_partial_reconcile.max_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.max_date IS 'Max Date of Matched Lines';


--
-- Name: COLUMN account_partial_reconcile.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.amount IS 'Amount';


--
-- Name: COLUMN account_partial_reconcile.debit_amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_amount_currency IS 'Debit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.credit_amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_amount_currency IS 'Credit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_partial_reconcile.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_partial_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_partial_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNED BY public.account_partial_reconcile.id;


--
-- Name: account_payment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_payment (
    id integer NOT NULL,
    message_main_attachment_id integer,
    move_id integer,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    partner_bank_id integer,
    paired_internal_transfer_payment_id integer,
    payment_method_line_id integer,
    payment_method_id integer,
    currency_id integer,
    partner_id integer,
    outstanding_account_id integer,
    destination_account_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    state character varying NOT NULL,
    payment_type character varying NOT NULL,
    partner_type character varying NOT NULL,
    memo character varying,
    payment_reference character varying,
    date date NOT NULL,
    amount numeric,
    amount_company_currency_signed numeric,
    is_reconciled boolean,
    is_matched boolean,
    is_sent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_transaction_id integer,
    payment_token_id integer,
    source_payment_id integer,
    CONSTRAINT account_payment_check_amount_not_negative CHECK ((amount >= 0.0))
);


--
-- Name: TABLE account_payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_payment IS 'Payments';


--
-- Name: COLUMN account_payment.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_payment.move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_payment.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.company_id IS 'Company';


--
-- Name: COLUMN account_payment.partner_bank_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment.paired_internal_transfer_payment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.paired_internal_transfer_payment_id IS 'Paired Internal Transfer Payment';


--
-- Name: COLUMN account_payment.payment_method_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment.payment_method_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.payment_method_id IS 'Method';


--
-- Name: COLUMN account_payment.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment.outstanding_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.outstanding_account_id IS 'Outstanding Account';


--
-- Name: COLUMN account_payment.destination_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.destination_account_id IS 'Destination Account';


--
-- Name: COLUMN account_payment.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.name IS 'Number';


--
-- Name: COLUMN account_payment.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.state IS 'State';


--
-- Name: COLUMN account_payment.payment_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment.partner_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment.memo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.memo IS 'Memo';


--
-- Name: COLUMN account_payment.payment_reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_payment.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.date IS 'Date';


--
-- Name: COLUMN account_payment.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.amount IS 'Amount';


--
-- Name: COLUMN account_payment.amount_company_currency_signed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.amount_company_currency_signed IS 'Amount Company Currency Signed';


--
-- Name: COLUMN account_payment.is_reconciled; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_payment.is_matched; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.is_matched IS 'Is Matched With a Bank Statement';


--
-- Name: COLUMN account_payment.is_sent; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.is_sent IS 'Is Sent';


--
-- Name: COLUMN account_payment.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.create_date IS 'Created on';


--
-- Name: COLUMN account_payment.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment.payment_transaction_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.payment_transaction_id IS 'Payment Transaction';


--
-- Name: COLUMN account_payment.payment_token_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.payment_token_id IS 'Saved Payment Token';


--
-- Name: COLUMN account_payment.source_payment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment.source_payment_id IS 'Source Payment';


--
-- Name: CONSTRAINT account_payment_check_amount_not_negative ON account_payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT account_payment_check_amount_not_negative ON public.account_payment IS 'CHECK(amount >= 0.0)';


--
-- Name: account_payment_account_bank_statement_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_payment_account_bank_statement_line_rel (
    account_bank_statement_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


--
-- Name: TABLE account_payment_account_bank_statement_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_payment_account_bank_statement_line_rel IS 'RELATION BETWEEN account_bank_statement_line AND account_payment';


--
-- Name: account_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_payment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_payment_id_seq OWNED BY public.account_payment.id;


--
-- Name: account_payment_method; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_payment_method (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    payment_type character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_payment_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_payment_method IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method.code IS 'Code';


--
-- Name: COLUMN account_payment_method.payment_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_method.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method.name IS 'Name';


--
-- Name: COLUMN account_payment_method.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method.write_date IS 'Last Updated on';


--
-- Name: account_payment_method_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_payment_method_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_payment_method_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_payment_method_id_seq OWNED BY public.account_payment_method.id;


--
-- Name: account_payment_method_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_payment_method_line (
    id integer NOT NULL,
    sequence integer,
    payment_method_id integer NOT NULL,
    payment_account_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_provider_id integer
);


--
-- Name: TABLE account_payment_method_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_payment_method_line IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_method_line.payment_method_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method_line.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_method_line.payment_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method_line.payment_account_id IS 'Payment Account';


--
-- Name: COLUMN account_payment_method_line.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_method_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method_line.name IS 'Name';


--
-- Name: COLUMN account_payment_method_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_method_line.payment_provider_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_method_line.payment_provider_id IS 'Payment Provider';


--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_payment_method_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_payment_method_line_id_seq OWNED BY public.account_payment_method_line.id;


--
-- Name: account_payment_method_line_res_company_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_payment_method_line_res_company_rel (
    res_company_id integer NOT NULL,
    account_payment_method_line_id integer NOT NULL
);


--
-- Name: TABLE account_payment_method_line_res_company_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_payment_method_line_res_company_rel IS 'RELATION BETWEEN res_company AND account_payment_method_line';


--
-- Name: account_payment_register; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_payment_register (
    id integer NOT NULL,
    currency_id integer,
    journal_id integer,
    partner_bank_id integer,
    custom_user_currency_id integer,
    source_currency_id integer,
    company_id integer,
    partner_id integer,
    payment_method_line_id integer,
    writeoff_account_id integer,
    create_uid integer,
    write_uid integer,
    communication character varying,
    installments_mode character varying,
    payment_type character varying,
    partner_type character varying,
    payment_difference_handling character varying,
    writeoff_label character varying,
    payment_date date NOT NULL,
    amount numeric,
    custom_user_amount numeric,
    source_amount numeric,
    source_amount_currency numeric,
    group_payment boolean,
    can_edit_wizard boolean,
    can_group_payments boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_token_id integer
);


--
-- Name: TABLE account_payment_register; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_payment_register IS 'Pay';


--
-- Name: COLUMN account_payment_register.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment_register.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_register.partner_bank_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment_register.custom_user_currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.custom_user_currency_id IS 'Custom User Currency';


--
-- Name: COLUMN account_payment_register.source_currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.source_currency_id IS 'Source Currency';


--
-- Name: COLUMN account_payment_register.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.company_id IS 'Company';


--
-- Name: COLUMN account_payment_register.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment_register.payment_method_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_register.writeoff_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.writeoff_account_id IS 'Difference Account';


--
-- Name: COLUMN account_payment_register.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_register.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_register.communication; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.communication IS 'Memo';


--
-- Name: COLUMN account_payment_register.installments_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.installments_mode IS 'Installments Mode';


--
-- Name: COLUMN account_payment_register.payment_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_register.partner_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment_register.payment_difference_handling; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.payment_difference_handling IS 'Payment Difference Handling';


--
-- Name: COLUMN account_payment_register.writeoff_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.writeoff_label IS 'Journal Item Label';


--
-- Name: COLUMN account_payment_register.payment_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.payment_date IS 'Payment Date';


--
-- Name: COLUMN account_payment_register.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.amount IS 'Amount';


--
-- Name: COLUMN account_payment_register.custom_user_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.custom_user_amount IS 'Custom User Amount';


--
-- Name: COLUMN account_payment_register.source_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.source_amount IS 'Amount to Pay (company currency)';


--
-- Name: COLUMN account_payment_register.source_amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.source_amount_currency IS 'Amount to Pay (foreign currency)';


--
-- Name: COLUMN account_payment_register.group_payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.group_payment IS 'Group Payments';


--
-- Name: COLUMN account_payment_register.can_edit_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.can_edit_wizard IS 'Can Edit Wizard';


--
-- Name: COLUMN account_payment_register.can_group_payments; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.can_group_payments IS 'Can Group Payments';


--
-- Name: COLUMN account_payment_register.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_register.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_register.payment_token_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_register.payment_token_id IS 'Saved payment token';


--
-- Name: account_payment_register_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_payment_register_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_payment_register_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_payment_register_id_seq OWNED BY public.account_payment_register.id;


--
-- Name: account_payment_register_move_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_payment_register_move_line_rel (
    wizard_id integer NOT NULL,
    line_id integer NOT NULL
);


--
-- Name: TABLE account_payment_register_move_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_payment_register_move_line_rel IS 'RELATION BETWEEN account_payment_register AND account_move_line';


--
-- Name: account_payment_term; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_payment_term (
    id integer NOT NULL,
    company_id integer,
    sequence integer NOT NULL,
    discount_days integer,
    create_uid integer,
    write_uid integer,
    early_pay_discount_computation character varying,
    name jsonb NOT NULL,
    note jsonb,
    active boolean,
    display_on_invoice boolean,
    early_discount boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    discount_percentage double precision
);


--
-- Name: TABLE account_payment_term; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_payment_term IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.company_id IS 'Company';


--
-- Name: COLUMN account_payment_term.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_term.discount_days; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.discount_days IS 'Discount Days';


--
-- Name: COLUMN account_payment_term.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term.early_pay_discount_computation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.early_pay_discount_computation IS 'Cash Discount Tax Reduction';


--
-- Name: COLUMN account_payment_term.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.name IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.note IS 'Description on the Invoice';


--
-- Name: COLUMN account_payment_term.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.active IS 'Active';


--
-- Name: COLUMN account_payment_term.display_on_invoice; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.display_on_invoice IS 'Show installment dates';


--
-- Name: COLUMN account_payment_term.early_discount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.early_discount IS 'Early Discount';


--
-- Name: COLUMN account_payment_term.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_term.discount_percentage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term.discount_percentage IS 'Discount %';


--
-- Name: account_payment_term_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_payment_term_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_payment_term_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_payment_term_id_seq OWNED BY public.account_payment_term.id;


--
-- Name: account_payment_term_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_payment_term_line (
    id integer NOT NULL,
    nb_days integer,
    payment_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    delay_type character varying NOT NULL,
    days_next_month character varying(2),
    value_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_payment_term_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_payment_term_line IS 'Payment Terms Line';


--
-- Name: COLUMN account_payment_term_line.nb_days; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.nb_days IS 'Days';


--
-- Name: COLUMN account_payment_term_line.payment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.payment_id IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term_line.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.value IS 'Value';


--
-- Name: COLUMN account_payment_term_line.delay_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.delay_type IS 'Delay Type';


--
-- Name: COLUMN account_payment_term_line.days_next_month; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.days_next_month IS 'Days on the next month';


--
-- Name: COLUMN account_payment_term_line.value_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.value_amount IS 'Due';


--
-- Name: COLUMN account_payment_term_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_payment_term_line.write_date IS 'Last Updated on';


--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_payment_term_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_payment_term_line_id_seq OWNED BY public.account_payment_term_line.id;


--
-- Name: account_reconcile_model; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model (
    id integer NOT NULL,
    sequence integer NOT NULL,
    company_id integer NOT NULL,
    past_months_limit integer,
    create_uid integer,
    write_uid integer,
    rule_type character varying NOT NULL,
    matching_order character varying NOT NULL,
    counterpart_type character varying,
    match_nature character varying NOT NULL,
    match_amount character varying,
    match_label character varying,
    match_label_param character varying,
    match_note character varying,
    match_note_param character varying,
    match_transaction_type character varying,
    match_transaction_type_param character varying,
    payment_tolerance_type character varying NOT NULL,
    decimal_separator character varying,
    name jsonb NOT NULL,
    active boolean,
    auto_reconcile boolean,
    to_check boolean,
    match_text_location_label boolean,
    match_text_location_note boolean,
    match_text_location_reference boolean,
    match_same_currency boolean,
    allow_payment_tolerance boolean,
    match_partner boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    match_amount_min double precision,
    match_amount_max double precision,
    payment_tolerance_param double precision
);


--
-- Name: TABLE account_reconcile_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model IS 'Preset to create journal entries during a invoices and payments matching';


--
-- Name: COLUMN account_reconcile_model.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model.past_months_limit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.past_months_limit IS 'Search Months Limit';


--
-- Name: COLUMN account_reconcile_model.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model.rule_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.rule_type IS 'Type';


--
-- Name: COLUMN account_reconcile_model.matching_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.matching_order IS 'Matching Order';


--
-- Name: COLUMN account_reconcile_model.counterpart_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.counterpart_type IS 'Counterpart Type';


--
-- Name: COLUMN account_reconcile_model.match_nature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_nature IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model.match_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount IS 'Amount Condition';


--
-- Name: COLUMN account_reconcile_model.match_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_label IS 'Label';


--
-- Name: COLUMN account_reconcile_model.match_label_param; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_label_param IS 'Label Parameter';


--
-- Name: COLUMN account_reconcile_model.match_note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_note IS 'Note';


--
-- Name: COLUMN account_reconcile_model.match_note_param; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_note_param IS 'Note Parameter';


--
-- Name: COLUMN account_reconcile_model.match_transaction_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_reconcile_model.match_transaction_type_param; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_transaction_type_param IS 'Transaction Type Parameter';


--
-- Name: COLUMN account_reconcile_model.payment_tolerance_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.payment_tolerance_type IS 'Payment Tolerance Type';


--
-- Name: COLUMN account_reconcile_model.decimal_separator; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.decimal_separator IS 'Decimal Separator';


--
-- Name: COLUMN account_reconcile_model.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.name IS 'Name';


--
-- Name: COLUMN account_reconcile_model.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.active IS 'Active';


--
-- Name: COLUMN account_reconcile_model.auto_reconcile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.auto_reconcile IS 'Auto-validate';


--
-- Name: COLUMN account_reconcile_model.to_check; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_model.match_text_location_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_label IS 'Match Text Location Label';


--
-- Name: COLUMN account_reconcile_model.match_text_location_note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_note IS 'Match Text Location Note';


--
-- Name: COLUMN account_reconcile_model.match_text_location_reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_reference IS 'Match Text Location Reference';


--
-- Name: COLUMN account_reconcile_model.match_same_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_same_currency IS 'Same Currency';


--
-- Name: COLUMN account_reconcile_model.allow_payment_tolerance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.allow_payment_tolerance IS 'Payment Tolerance';


--
-- Name: COLUMN account_reconcile_model.match_partner; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_partner IS 'Partner is Set';


--
-- Name: COLUMN account_reconcile_model.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model.match_amount_min; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_min IS 'Amount Min Parameter';


--
-- Name: COLUMN account_reconcile_model.match_amount_max; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_max IS 'Amount Max Parameter';


--
-- Name: COLUMN account_reconcile_model.payment_tolerance_param; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model.payment_tolerance_param IS 'Gap';


--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_reconcile_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_reconcile_model_id_seq OWNED BY public.account_reconcile_model.id;


--
-- Name: account_reconcile_model_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model_line (
    id integer NOT NULL,
    model_id integer,
    company_id integer,
    sequence integer NOT NULL,
    account_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    amount_type character varying NOT NULL,
    amount_string character varying NOT NULL,
    analytic_distribution jsonb,
    label jsonb,
    force_tax_included boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount double precision
);


--
-- Name: TABLE account_reconcile_model_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model_line IS 'Rules for the reconciliation model';


--
-- Name: COLUMN account_reconcile_model_line.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_line.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_line.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model_line.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_line.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_model_line.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_reconcile_model_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_line.amount_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_type IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model_line.amount_string; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_string IS 'Amount';


--
-- Name: COLUMN account_reconcile_model_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_line.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_reconcile_model_line.label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_line.label IS 'Journal Item Label';


--
-- Name: COLUMN account_reconcile_model_line.force_tax_included; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_line.force_tax_included IS 'Tax Included in Price';


--
-- Name: COLUMN account_reconcile_model_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model_line.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount IS 'Float Amount';


--
-- Name: account_reconcile_model_line_account_tax_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model_line_account_tax_rel (
    account_reconcile_model_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


--
-- Name: TABLE account_reconcile_model_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model_line_account_tax_rel IS 'RELATION BETWEEN account_reconcile_model_line AND account_tax';


--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_reconcile_model_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNED BY public.account_reconcile_model_line.id;


--
-- Name: account_reconcile_model_partner_mapping; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model_partner_mapping (
    id integer NOT NULL,
    model_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payment_ref_regex character varying,
    narration_regex character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_reconcile_model_partner_mapping; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model_partner_mapping IS 'Partner mapping for reconciliation models';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.partner_id IS 'Partner';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.payment_ref_regex; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.payment_ref_regex IS 'Find Text in Label';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.narration_regex; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.narration_regex IS 'Find Text in Notes';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_model_partner_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_reconcile_model_partner_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_reconcile_model_partner_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_reconcile_model_partner_mapping_id_seq OWNED BY public.account_reconcile_model_partner_mapping.id;


--
-- Name: account_reconcile_model_res_partner_category_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model_res_partner_category_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_category_id integer NOT NULL
);


--
-- Name: TABLE account_reconcile_model_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_category_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner_category';


--
-- Name: account_reconcile_model_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_model_res_partner_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE account_reconcile_model_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner';


--
-- Name: account_reconcile_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reconcile_wizard (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    account_id integer,
    to_partner_id integer,
    tax_id integer,
    create_uid integer,
    write_uid integer,
    label character varying,
    date date,
    edit_mode_amount_currency numeric,
    allow_partials boolean,
    to_check boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_reconcile_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reconcile_wizard IS 'Account reconciliation wizard';


--
-- Name: COLUMN account_reconcile_wizard.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_reconcile_wizard.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_wizard.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_wizard.to_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_wizard.to_partner_id IS 'Partner';


--
-- Name: COLUMN account_reconcile_wizard.tax_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_wizard.tax_id IS 'Tax';


--
-- Name: COLUMN account_reconcile_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_wizard.label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_wizard.label IS 'Label';


--
-- Name: COLUMN account_reconcile_wizard.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_wizard.date IS 'Date';


--
-- Name: COLUMN account_reconcile_wizard.edit_mode_amount_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_wizard.edit_mode_amount_currency IS 'Edit mode amount';


--
-- Name: COLUMN account_reconcile_wizard.allow_partials; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_wizard.allow_partials IS 'Allow partials';


--
-- Name: COLUMN account_reconcile_wizard.to_check; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_wizard.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reconcile_wizard.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_reconcile_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_reconcile_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_reconcile_wizard_id_seq OWNED BY public.account_reconcile_wizard.id;


--
-- Name: account_report; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report (
    id integer NOT NULL,
    sequence integer,
    root_report_id integer,
    country_id integer,
    load_more_limit integer,
    prefix_groups_threshold integer,
    create_uid integer,
    write_uid integer,
    chart_template character varying,
    availability_condition character varying,
    integer_rounding character varying,
    default_opening_date_filter character varying,
    currency_translation character varying,
    filter_multi_company character varying,
    filter_hide_0_lines character varying,
    filter_hierarchy character varying,
    filter_account_type character varying,
    name jsonb NOT NULL,
    active boolean,
    use_sections boolean,
    only_tax_exigible boolean,
    search_bar boolean,
    filter_date_range boolean,
    filter_show_draft boolean,
    filter_unreconciled boolean,
    filter_unfold_all boolean,
    filter_period_comparison boolean,
    filter_growth_comparison boolean,
    filter_journals boolean,
    filter_analytic boolean,
    filter_partner boolean,
    filter_fiscal_position boolean,
    filter_aml_ir_filters boolean,
    filter_budgets boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    custom_handler_model_id integer,
    tax_closing_start_date jsonb,
    send_and_print_values jsonb,
    filter_analytic_groupby boolean
);


--
-- Name: TABLE account_report; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report IS 'Accounting Report';


--
-- Name: COLUMN account_report.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.sequence IS 'Sequence';


--
-- Name: COLUMN account_report.root_report_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.root_report_id IS 'Root Report';


--
-- Name: COLUMN account_report.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.country_id IS 'Country';


--
-- Name: COLUMN account_report.load_more_limit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.load_more_limit IS 'Load More Limit';


--
-- Name: COLUMN account_report.prefix_groups_threshold; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.prefix_groups_threshold IS 'Prefix Groups Threshold';


--
-- Name: COLUMN account_report.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_report.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report.chart_template; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.chart_template IS 'Chart of Accounts';


--
-- Name: COLUMN account_report.availability_condition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.availability_condition IS 'Availability';


--
-- Name: COLUMN account_report.integer_rounding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.integer_rounding IS 'Integer Rounding';


--
-- Name: COLUMN account_report.default_opening_date_filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.default_opening_date_filter IS 'Default Opening';


--
-- Name: COLUMN account_report.currency_translation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.currency_translation IS 'Currency Translation';


--
-- Name: COLUMN account_report.filter_multi_company; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_multi_company IS 'Multi-Company';


--
-- Name: COLUMN account_report.filter_hide_0_lines; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_hide_0_lines IS 'Hide lines at 0';


--
-- Name: COLUMN account_report.filter_hierarchy; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_hierarchy IS 'Account Groups';


--
-- Name: COLUMN account_report.filter_account_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_account_type IS 'Account Types';


--
-- Name: COLUMN account_report.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.name IS 'Name';


--
-- Name: COLUMN account_report.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.active IS 'Active';


--
-- Name: COLUMN account_report.use_sections; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.use_sections IS 'Composite Report';


--
-- Name: COLUMN account_report.only_tax_exigible; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.only_tax_exigible IS 'Only Tax Exigible Lines';


--
-- Name: COLUMN account_report.search_bar; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.search_bar IS 'Search Bar';


--
-- Name: COLUMN account_report.filter_date_range; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_date_range IS 'Date Range';


--
-- Name: COLUMN account_report.filter_show_draft; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_show_draft IS 'Draft Entries';


--
-- Name: COLUMN account_report.filter_unreconciled; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_unreconciled IS 'Unreconciled Entries';


--
-- Name: COLUMN account_report.filter_unfold_all; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_unfold_all IS 'Unfold All';


--
-- Name: COLUMN account_report.filter_period_comparison; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_period_comparison IS 'Period Comparison';


--
-- Name: COLUMN account_report.filter_growth_comparison; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_growth_comparison IS 'Growth Comparison';


--
-- Name: COLUMN account_report.filter_journals; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_journals IS 'Journals';


--
-- Name: COLUMN account_report.filter_analytic; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_analytic IS 'Analytic Filter';


--
-- Name: COLUMN account_report.filter_partner; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_partner IS 'Partners';


--
-- Name: COLUMN account_report.filter_fiscal_position; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_fiscal_position IS 'Filter Multivat';


--
-- Name: COLUMN account_report.filter_aml_ir_filters; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_aml_ir_filters IS 'Favorite Filters';


--
-- Name: COLUMN account_report.filter_budgets; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_budgets IS 'Budgets';


--
-- Name: COLUMN account_report.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.create_date IS 'Created on';


--
-- Name: COLUMN account_report.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report.custom_handler_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.custom_handler_model_id IS 'Custom Handler Model';


--
-- Name: COLUMN account_report.tax_closing_start_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.tax_closing_start_date IS 'Start Date';


--
-- Name: COLUMN account_report.send_and_print_values; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.send_and_print_values IS 'Send And Print Values';


--
-- Name: COLUMN account_report.filter_analytic_groupby; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report.filter_analytic_groupby IS 'Analytic Group By';


--
-- Name: account_report_account_report_horizontal_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report_account_report_horizontal_group_rel (
    account_report_id integer NOT NULL,
    account_report_horizontal_group_id integer NOT NULL
);


--
-- Name: TABLE account_report_account_report_horizontal_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report_account_report_horizontal_group_rel IS 'RELATION BETWEEN account_report AND account_report_horizontal_group';


--
-- Name: account_report_annotation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report_annotation (
    id integer NOT NULL,
    report_id integer,
    fiscal_position_id integer,
    create_uid integer,
    write_uid integer,
    line_id character varying,
    text character varying,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_report_annotation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report_annotation IS 'Account Report Annotation';


--
-- Name: COLUMN account_report_annotation.report_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_annotation.report_id IS 'Report';


--
-- Name: COLUMN account_report_annotation.fiscal_position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_annotation.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_report_annotation.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_annotation.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_annotation.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_annotation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_annotation.line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_annotation.line_id IS 'Line';


--
-- Name: COLUMN account_report_annotation.text; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_annotation.text IS 'The annotation''s content.';


--
-- Name: COLUMN account_report_annotation.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_annotation.date IS 'Date';


--
-- Name: COLUMN account_report_annotation.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_annotation.create_date IS 'Created on';


--
-- Name: COLUMN account_report_annotation.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_annotation.write_date IS 'Last Updated on';


--
-- Name: account_report_annotation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_report_annotation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_report_annotation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_report_annotation_id_seq OWNED BY public.account_report_annotation.id;


--
-- Name: account_report_async_export; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report_async_export (
    id integer NOT NULL,
    report_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    deposit_uid character varying,
    declaration_uid character varying,
    recipient character varying,
    state character varying,
    step_1_logs character varying,
    step_2_logs character varying,
    date_from date,
    date_to date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_report_async_export; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report_async_export IS 'Account Report Async Export';


--
-- Name: COLUMN account_report_async_export.report_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_async_export.report_id IS 'Report';


--
-- Name: COLUMN account_report_async_export.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_async_export.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_async_export.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_async_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_async_export.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_async_export.name IS 'Name';


--
-- Name: COLUMN account_report_async_export.deposit_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_async_export.deposit_uid IS 'Deposit Uid';


--
-- Name: COLUMN account_report_async_export.declaration_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_async_export.declaration_uid IS 'Declaration Uid';


--
-- Name: COLUMN account_report_async_export.recipient; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_async_export.recipient IS 'Recipient';


--
-- Name: COLUMN account_report_async_export.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_async_export.state IS 'State';


--
-- Name: COLUMN account_report_async_export.step_1_logs; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_async_export.step_1_logs IS 'Step 1 Logs';


--
-- Name: COLUMN account_report_async_export.step_2_logs; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_async_export.step_2_logs IS 'Step 2 Logs';


--
-- Name: COLUMN account_report_async_export.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_async_export.date_from IS 'Date From';


--
-- Name: COLUMN account_report_async_export.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_async_export.date_to IS 'Date To';


--
-- Name: COLUMN account_report_async_export.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_async_export.create_date IS 'Created on';


--
-- Name: COLUMN account_report_async_export.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_async_export.write_date IS 'Last Updated on';


--
-- Name: account_report_async_export_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_report_async_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_report_async_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_report_async_export_id_seq OWNED BY public.account_report_async_export.id;


--
-- Name: account_report_async_export_ir_attachment_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report_async_export_ir_attachment_rel (
    account_report_async_export_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


--
-- Name: TABLE account_report_async_export_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report_async_export_ir_attachment_rel IS 'RELATION BETWEEN account_report_async_export AND ir_attachment';


--
-- Name: account_report_budget; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report_budget (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_report_budget; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report_budget IS 'Accounting Report Budget';


--
-- Name: COLUMN account_report_budget.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_budget.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_budget.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_budget.company_id IS 'Company';


--
-- Name: COLUMN account_report_budget.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_budget.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_budget.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_budget.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_budget.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_budget.name IS 'Name';


--
-- Name: COLUMN account_report_budget.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_budget.create_date IS 'Created on';


--
-- Name: COLUMN account_report_budget.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_budget.write_date IS 'Last Updated on';


--
-- Name: account_report_budget_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_report_budget_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_report_budget_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_report_budget_id_seq OWNED BY public.account_report_budget.id;


--
-- Name: account_report_budget_item; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report_budget_item (
    id integer NOT NULL,
    budget_id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount double precision
);


--
-- Name: TABLE account_report_budget_item; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report_budget_item IS 'Accounting Report Budget Item';


--
-- Name: COLUMN account_report_budget_item.budget_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_budget_item.budget_id IS 'Budget';


--
-- Name: COLUMN account_report_budget_item.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_budget_item.account_id IS 'Account';


--
-- Name: COLUMN account_report_budget_item.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_budget_item.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_budget_item.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_budget_item.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_budget_item.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_budget_item.date IS 'Date';


--
-- Name: COLUMN account_report_budget_item.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_budget_item.create_date IS 'Created on';


--
-- Name: COLUMN account_report_budget_item.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_budget_item.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report_budget_item.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_budget_item.amount IS 'Amount';


--
-- Name: account_report_budget_item_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_report_budget_item_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_report_budget_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_report_budget_item_id_seq OWNED BY public.account_report_budget_item.id;


--
-- Name: account_report_column; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report_column (
    id integer NOT NULL,
    sequence integer,
    report_id integer,
    custom_audit_action_id integer,
    create_uid integer,
    write_uid integer,
    expression_label character varying NOT NULL,
    figure_type character varying NOT NULL,
    name jsonb NOT NULL,
    sortable boolean,
    blank_if_zero boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_report_column; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report_column IS 'Accounting Report Column';


--
-- Name: COLUMN account_report_column.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_column.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_column.report_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_column.report_id IS 'Report';


--
-- Name: COLUMN account_report_column.custom_audit_action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_column.custom_audit_action_id IS 'Custom Audit Action';


--
-- Name: COLUMN account_report_column.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_column.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_column.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_column.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_column.expression_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_column.expression_label IS 'Expression Label';


--
-- Name: COLUMN account_report_column.figure_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_column.figure_type IS 'Figure Type';


--
-- Name: COLUMN account_report_column.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_column.name IS 'Name';


--
-- Name: COLUMN account_report_column.sortable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_column.sortable IS 'Sortable';


--
-- Name: COLUMN account_report_column.blank_if_zero; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_column.blank_if_zero IS 'Blank if Zero';


--
-- Name: COLUMN account_report_column.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_column.create_date IS 'Created on';


--
-- Name: COLUMN account_report_column.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_column.write_date IS 'Last Updated on';


--
-- Name: account_report_column_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_report_column_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_report_column_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_report_column_id_seq OWNED BY public.account_report_column.id;


--
-- Name: account_report_expression; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report_expression (
    id integer NOT NULL,
    report_line_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    label character varying NOT NULL,
    engine character varying NOT NULL,
    formula character varying NOT NULL,
    subformula character varying,
    date_scope character varying NOT NULL,
    figure_type character varying,
    carryover_target character varying,
    green_on_positive boolean,
    blank_if_zero boolean,
    auditable boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT account_report_expression_domain_engine_subformula_required CHECK ((((engine)::text <> 'domain'::text) OR (subformula IS NOT NULL)))
);


--
-- Name: TABLE account_report_expression; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report_expression IS 'Accounting Report Expression';


--
-- Name: COLUMN account_report_expression.report_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_expression.report_line_id IS 'Report Line';


--
-- Name: COLUMN account_report_expression.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_expression.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_expression.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_expression.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_expression.label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_expression.label IS 'Label';


--
-- Name: COLUMN account_report_expression.engine; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_expression.engine IS 'Computation Engine';


--
-- Name: COLUMN account_report_expression.formula; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_expression.formula IS 'Formula';


--
-- Name: COLUMN account_report_expression.subformula; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_expression.subformula IS 'Subformula';


--
-- Name: COLUMN account_report_expression.date_scope; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_expression.date_scope IS 'Date Scope';


--
-- Name: COLUMN account_report_expression.figure_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_expression.figure_type IS 'Figure Type';


--
-- Name: COLUMN account_report_expression.carryover_target; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_expression.carryover_target IS 'Carry Over To';


--
-- Name: COLUMN account_report_expression.green_on_positive; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_expression.green_on_positive IS 'Is Growth Good when Positive';


--
-- Name: COLUMN account_report_expression.blank_if_zero; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_expression.blank_if_zero IS 'Blank if Zero';


--
-- Name: COLUMN account_report_expression.auditable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_expression.auditable IS 'Auditable';


--
-- Name: COLUMN account_report_expression.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_expression.create_date IS 'Created on';


--
-- Name: COLUMN account_report_expression.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_expression.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_report_expression_domain_engine_subformula_required ON account_report_expression; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT account_report_expression_domain_engine_subformula_required ON public.account_report_expression IS 'CHECK(engine != ''domain'' OR subformula IS NOT NULL)';


--
-- Name: account_report_expression_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_report_expression_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_report_expression_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_report_expression_id_seq OWNED BY public.account_report_expression.id;


--
-- Name: account_report_external_value; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report_external_value (
    id integer NOT NULL,
    target_report_expression_id integer NOT NULL,
    company_id integer NOT NULL,
    foreign_vat_fiscal_position_id integer,
    carryover_origin_report_line_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    text_value character varying,
    carryover_origin_expression_label character varying,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value double precision
);


--
-- Name: TABLE account_report_external_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report_external_value IS 'Accounting Report External Value';


--
-- Name: COLUMN account_report_external_value.target_report_expression_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_external_value.target_report_expression_id IS 'Target Expression';


--
-- Name: COLUMN account_report_external_value.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_external_value.company_id IS 'Company';


--
-- Name: COLUMN account_report_external_value.foreign_vat_fiscal_position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_external_value.foreign_vat_fiscal_position_id IS 'Fiscal position';


--
-- Name: COLUMN account_report_external_value.carryover_origin_report_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_external_value.carryover_origin_report_line_id IS 'Origin Line';


--
-- Name: COLUMN account_report_external_value.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_external_value.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_external_value.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_external_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_external_value.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_external_value.name IS 'Name';


--
-- Name: COLUMN account_report_external_value.text_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_external_value.text_value IS 'Text Value';


--
-- Name: COLUMN account_report_external_value.carryover_origin_expression_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_external_value.carryover_origin_expression_label IS 'Origin Expression Label';


--
-- Name: COLUMN account_report_external_value.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_external_value.date IS 'Date';


--
-- Name: COLUMN account_report_external_value.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_external_value.create_date IS 'Created on';


--
-- Name: COLUMN account_report_external_value.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_external_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report_external_value.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_external_value.value IS 'Numeric Value';


--
-- Name: account_report_external_value_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_report_external_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_report_external_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_report_external_value_id_seq OWNED BY public.account_report_external_value.id;


--
-- Name: account_report_file_download_error_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report_file_download_error_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    file_name character varying,
    actionable_errors jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_report_file_download_error_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report_file_download_error_wizard IS 'Manage the file generation errors from report exports.';


--
-- Name: COLUMN account_report_file_download_error_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_file_download_error_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_file_download_error_wizard.file_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.file_name IS 'File Name';


--
-- Name: COLUMN account_report_file_download_error_wizard.actionable_errors; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.actionable_errors IS 'Actionable Errors';


--
-- Name: COLUMN account_report_file_download_error_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_report_file_download_error_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.write_date IS 'Last Updated on';


--
-- Name: account_report_file_download_error_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_report_file_download_error_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_report_file_download_error_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_report_file_download_error_wizard_id_seq OWNED BY public.account_report_file_download_error_wizard.id;


--
-- Name: account_report_horizontal_group; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report_horizontal_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_report_horizontal_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report_horizontal_group IS 'Horizontal group for reports';


--
-- Name: COLUMN account_report_horizontal_group.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_horizontal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_horizontal_group.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_horizontal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_horizontal_group.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_horizontal_group.name IS 'Name';


--
-- Name: COLUMN account_report_horizontal_group.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_horizontal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_report_horizontal_group.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_horizontal_group.write_date IS 'Last Updated on';


--
-- Name: account_report_horizontal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_report_horizontal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_report_horizontal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_report_horizontal_group_id_seq OWNED BY public.account_report_horizontal_group.id;


--
-- Name: account_report_horizontal_group_rule; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report_horizontal_group_rule (
    id integer NOT NULL,
    horizontal_group_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    domain character varying NOT NULL,
    field_name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_report_horizontal_group_rule; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report_horizontal_group_rule IS 'Horizontal group rule for reports';


--
-- Name: COLUMN account_report_horizontal_group_rule.horizontal_group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.horizontal_group_id IS 'Horizontal Group';


--
-- Name: COLUMN account_report_horizontal_group_rule.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_horizontal_group_rule.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_horizontal_group_rule.domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.domain IS 'Domain';


--
-- Name: COLUMN account_report_horizontal_group_rule.field_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.field_name IS 'Field';


--
-- Name: COLUMN account_report_horizontal_group_rule.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.create_date IS 'Created on';


--
-- Name: COLUMN account_report_horizontal_group_rule.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.write_date IS 'Last Updated on';


--
-- Name: account_report_horizontal_group_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_report_horizontal_group_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_report_horizontal_group_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_report_horizontal_group_rule_id_seq OWNED BY public.account_report_horizontal_group_rule.id;


--
-- Name: account_report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_report_id_seq OWNED BY public.account_report.id;


--
-- Name: account_report_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report_line (
    id integer NOT NULL,
    report_id integer NOT NULL,
    hierarchy_level integer NOT NULL,
    parent_id integer,
    sequence integer,
    action_id integer,
    create_uid integer,
    write_uid integer,
    groupby character varying,
    user_groupby character varying,
    code character varying,
    horizontal_split_side character varying,
    name jsonb NOT NULL,
    foldable boolean,
    print_on_new_page boolean,
    hide_if_zero boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_report_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report_line IS 'Accounting Report Line';


--
-- Name: COLUMN account_report_line.report_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.report_id IS 'Parent Report';


--
-- Name: COLUMN account_report_line.hierarchy_level; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.hierarchy_level IS 'Level';


--
-- Name: COLUMN account_report_line.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.parent_id IS 'Parent Line';


--
-- Name: COLUMN account_report_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_line.action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.action_id IS 'Action';


--
-- Name: COLUMN account_report_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_line.groupby; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.groupby IS 'Group By';


--
-- Name: COLUMN account_report_line.user_groupby; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.user_groupby IS 'User Group By';


--
-- Name: COLUMN account_report_line.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.code IS 'Code';


--
-- Name: COLUMN account_report_line.horizontal_split_side; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.horizontal_split_side IS 'Horizontal Split Side';


--
-- Name: COLUMN account_report_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.name IS 'Name';


--
-- Name: COLUMN account_report_line.foldable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.foldable IS 'Foldable';


--
-- Name: COLUMN account_report_line.print_on_new_page; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.print_on_new_page IS 'Print On New Page';


--
-- Name: COLUMN account_report_line.hide_if_zero; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.hide_if_zero IS 'Hide if Zero';


--
-- Name: COLUMN account_report_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.create_date IS 'Created on';


--
-- Name: COLUMN account_report_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_line.write_date IS 'Last Updated on';


--
-- Name: account_report_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_report_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_report_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_report_line_id_seq OWNED BY public.account_report_line.id;


--
-- Name: account_report_section_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report_section_rel (
    main_report_id integer NOT NULL,
    sub_report_id integer NOT NULL
);


--
-- Name: TABLE account_report_section_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report_section_rel IS 'RELATION BETWEEN account_report AND account_report';


--
-- Name: account_report_send; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report_send (
    id integer NOT NULL,
    mail_template_id integer,
    account_report_id integer,
    create_uid integer,
    write_uid integer,
    mode character varying,
    mail_subject character varying,
    report_options jsonb,
    mail_attachments_widget jsonb,
    mail_body text,
    enable_download boolean,
    checkbox_download boolean,
    enable_send_mail boolean,
    checkbox_send_mail boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_report_send; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report_send IS 'Account Report Send';


--
-- Name: COLUMN account_report_send.mail_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_send.mail_template_id IS 'Email template';


--
-- Name: COLUMN account_report_send.account_report_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_send.account_report_id IS 'Report';


--
-- Name: COLUMN account_report_send.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_send.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_send.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_send.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_send.mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_send.mode IS 'Mode';


--
-- Name: COLUMN account_report_send.mail_subject; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_send.mail_subject IS 'Subject';


--
-- Name: COLUMN account_report_send.report_options; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_send.report_options IS 'Report Options';


--
-- Name: COLUMN account_report_send.mail_attachments_widget; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_send.mail_attachments_widget IS 'Mail Attachments Widget';


--
-- Name: COLUMN account_report_send.mail_body; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_send.mail_body IS 'Contents';


--
-- Name: COLUMN account_report_send.enable_download; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_send.enable_download IS 'Enable Download';


--
-- Name: COLUMN account_report_send.checkbox_download; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_send.checkbox_download IS 'Download';


--
-- Name: COLUMN account_report_send.enable_send_mail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_send.enable_send_mail IS 'Enable Send Mail';


--
-- Name: COLUMN account_report_send.checkbox_send_mail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_send.checkbox_send_mail IS 'Email';


--
-- Name: COLUMN account_report_send.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_send.create_date IS 'Created on';


--
-- Name: COLUMN account_report_send.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_report_send.write_date IS 'Last Updated on';


--
-- Name: account_report_send_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_report_send_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_report_send_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_report_send_id_seq OWNED BY public.account_report_send.id;


--
-- Name: account_report_send_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_report_send_res_partner_rel (
    account_report_send_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE account_report_send_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_report_send_res_partner_rel IS 'RELATION BETWEEN account_report_send AND res_partner';


--
-- Name: account_reports_export_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reports_export_wizard (
    id integer NOT NULL,
    report_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    doc_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    folder_id integer NOT NULL
);


--
-- Name: TABLE account_reports_export_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reports_export_wizard IS 'Export wizard for accounting''s reports';


--
-- Name: COLUMN account_reports_export_wizard.report_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reports_export_wizard.report_id IS 'Parent Report Id';


--
-- Name: COLUMN account_reports_export_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reports_export_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_reports_export_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reports_export_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reports_export_wizard.doc_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reports_export_wizard.doc_name IS 'Documents Name';


--
-- Name: COLUMN account_reports_export_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reports_export_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_reports_export_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reports_export_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reports_export_wizard.folder_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reports_export_wizard.folder_id IS 'Folder';


--
-- Name: account_reports_export_wizard_format; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_reports_export_wizard_format (
    id integer NOT NULL,
    export_wizard_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    fun_to_call character varying NOT NULL,
    fun_param character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_reports_export_wizard_format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_reports_export_wizard_format IS 'Export format for accounting''s reports';


--
-- Name: COLUMN account_reports_export_wizard_format.export_wizard_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.export_wizard_id IS 'Parent Wizard';


--
-- Name: COLUMN account_reports_export_wizard_format.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.create_uid IS 'Created by';


--
-- Name: COLUMN account_reports_export_wizard_format.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reports_export_wizard_format.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.name IS 'Name';


--
-- Name: COLUMN account_reports_export_wizard_format.fun_to_call; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.fun_to_call IS 'Function to Call';


--
-- Name: COLUMN account_reports_export_wizard_format.fun_param; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.fun_param IS 'Function Parameter';


--
-- Name: COLUMN account_reports_export_wizard_format.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.create_date IS 'Created on';


--
-- Name: COLUMN account_reports_export_wizard_format.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.write_date IS 'Last Updated on';


--
-- Name: account_reports_export_wizard_format_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_reports_export_wizard_format_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_reports_export_wizard_format_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_reports_export_wizard_format_id_seq OWNED BY public.account_reports_export_wizard_format.id;


--
-- Name: account_reports_export_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_reports_export_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_reports_export_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_reports_export_wizard_id_seq OWNED BY public.account_reports_export_wizard.id;


--
-- Name: account_resequence_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_resequence_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    first_name character varying NOT NULL,
    ordering character varying NOT NULL,
    first_date date,
    end_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_resequence_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_resequence_wizard IS 'Remake the sequence of Journal Entries.';


--
-- Name: COLUMN account_resequence_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_resequence_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_resequence_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_resequence_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_resequence_wizard.first_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_resequence_wizard.first_name IS 'First New Sequence';


--
-- Name: COLUMN account_resequence_wizard.ordering; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_resequence_wizard.ordering IS 'Ordering';


--
-- Name: COLUMN account_resequence_wizard.first_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_resequence_wizard.first_date IS 'First Date';


--
-- Name: COLUMN account_resequence_wizard.end_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_resequence_wizard.end_date IS 'End Date';


--
-- Name: COLUMN account_resequence_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_resequence_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_resequence_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_resequence_wizard.write_date IS 'Last Updated on';


--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_resequence_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNED BY public.account_resequence_wizard.id;


--
-- Name: account_secure_entries_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_secure_entries_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    hash_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_secure_entries_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_secure_entries_wizard IS 'Secure Journal Entries';


--
-- Name: COLUMN account_secure_entries_wizard.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_secure_entries_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_secure_entries_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_secure_entries_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_secure_entries_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_secure_entries_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_secure_entries_wizard.hash_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_secure_entries_wizard.hash_date IS 'Hash All Entries';


--
-- Name: COLUMN account_secure_entries_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_secure_entries_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_secure_entries_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_secure_entries_wizard.write_date IS 'Last Updated on';


--
-- Name: account_secure_entries_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_secure_entries_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_secure_entries_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_secure_entries_wizard_id_seq OWNED BY public.account_secure_entries_wizard.id;


--
-- Name: account_setup_bank_manual_config; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_setup_bank_manual_config (
    id integer NOT NULL,
    res_partner_bank_id integer NOT NULL,
    num_journals_without_account integer,
    create_uid integer,
    write_uid integer,
    new_journal_name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_setup_bank_manual_config; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_setup_bank_manual_config IS 'Bank setup manual config';


--
-- Name: COLUMN account_setup_bank_manual_config.res_partner_bank_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.res_partner_bank_id IS 'Res Partner Bank';


--
-- Name: COLUMN account_setup_bank_manual_config.num_journals_without_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.num_journals_without_account IS 'Num Journals Without Account';


--
-- Name: COLUMN account_setup_bank_manual_config.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_uid IS 'Created by';


--
-- Name: COLUMN account_setup_bank_manual_config.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_setup_bank_manual_config.new_journal_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.new_journal_name IS 'New Journal Name';


--
-- Name: COLUMN account_setup_bank_manual_config.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_date IS 'Created on';


--
-- Name: COLUMN account_setup_bank_manual_config.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_date IS 'Last Updated on';


--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_setup_bank_manual_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNED BY public.account_setup_bank_manual_config.id;


--
-- Name: account_tax; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax (
    id integer NOT NULL,
    company_id integer NOT NULL,
    sequence integer NOT NULL,
    tax_group_id integer NOT NULL,
    cash_basis_transition_account_id integer,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    type_tax_use character varying NOT NULL,
    tax_scope character varying,
    amount_type character varying NOT NULL,
    price_include_override character varying,
    tax_exigibility character varying,
    name jsonb NOT NULL,
    description jsonb,
    invoice_label jsonb,
    invoice_legal_notes text,
    amount numeric NOT NULL,
    active boolean,
    include_base_amount boolean,
    is_base_affected boolean,
    analytic boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax IS 'Tax';


--
-- Name: COLUMN account_tax.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.company_id IS 'Company';


--
-- Name: COLUMN account_tax.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax.tax_group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.tax_group_id IS 'Tax Group';


--
-- Name: COLUMN account_tax.cash_basis_transition_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.cash_basis_transition_account_id IS 'Cash Basis Transition Account';


--
-- Name: COLUMN account_tax.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.country_id IS 'Country';


--
-- Name: COLUMN account_tax.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax.type_tax_use; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.type_tax_use IS 'Tax Type';


--
-- Name: COLUMN account_tax.tax_scope; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.tax_scope IS 'Tax Scope';


--
-- Name: COLUMN account_tax.amount_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.amount_type IS 'Tax Computation';


--
-- Name: COLUMN account_tax.price_include_override; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.price_include_override IS 'Included in Price';


--
-- Name: COLUMN account_tax.tax_exigibility; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.tax_exigibility IS 'Tax Exigibility';


--
-- Name: COLUMN account_tax.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.name IS 'Tax Name';


--
-- Name: COLUMN account_tax.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.description IS 'Description';


--
-- Name: COLUMN account_tax.invoice_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.invoice_label IS 'Label on Invoices';


--
-- Name: COLUMN account_tax.invoice_legal_notes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.invoice_legal_notes IS 'Legal Notes';


--
-- Name: COLUMN account_tax.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.amount IS 'Amount';


--
-- Name: COLUMN account_tax.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.active IS 'Active';


--
-- Name: COLUMN account_tax.include_base_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.include_base_amount IS 'Affect Base of Subsequent Taxes';


--
-- Name: COLUMN account_tax.is_base_affected; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.is_base_affected IS 'Base Affected by Previous Taxes';


--
-- Name: COLUMN account_tax.analytic; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.analytic IS 'Include in Analytic Cost';


--
-- Name: COLUMN account_tax.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_tax.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax.write_date IS 'Last Updated on';


--
-- Name: account_tax_filiation_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_filiation_rel (
    parent_tax integer NOT NULL,
    child_tax integer NOT NULL
);


--
-- Name: TABLE account_tax_filiation_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_filiation_rel IS 'RELATION BETWEEN account_tax AND account_tax';


--
-- Name: account_tax_group; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_group (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    tax_payable_account_id integer,
    tax_receivable_account_id integer,
    advance_tax_payment_account_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    pos_receipt_label character varying,
    name jsonb NOT NULL,
    preceding_subtotal jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_tax_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_group IS 'Tax Group';


--
-- Name: COLUMN account_tax_group.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_group.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.company_id IS 'Company';


--
-- Name: COLUMN account_tax_group.tax_payable_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.tax_payable_account_id IS 'Tax Payable Account';


--
-- Name: COLUMN account_tax_group.tax_receivable_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.tax_receivable_account_id IS 'Tax Receivable Account';


--
-- Name: COLUMN account_tax_group.advance_tax_payment_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.advance_tax_payment_account_id IS 'Tax Advance Account';


--
-- Name: COLUMN account_tax_group.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.country_id IS 'Country';


--
-- Name: COLUMN account_tax_group.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_group.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_group.pos_receipt_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.pos_receipt_label IS 'PoS receipt label';


--
-- Name: COLUMN account_tax_group.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.name IS 'Name';


--
-- Name: COLUMN account_tax_group.preceding_subtotal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.preceding_subtotal IS 'Preceding Subtotal';


--
-- Name: COLUMN account_tax_group.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_group.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_group.write_date IS 'Last Updated on';


--
-- Name: account_tax_group_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_tax_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_tax_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_tax_group_id_seq OWNED BY public.account_tax_group.id;


--
-- Name: account_tax_hr_expense_split_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_hr_expense_split_rel (
    hr_expense_split_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


--
-- Name: TABLE account_tax_hr_expense_split_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_hr_expense_split_rel IS 'RELATION BETWEEN hr_expense_split AND account_tax';


--
-- Name: account_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_tax_id_seq OWNED BY public.account_tax.id;


--
-- Name: account_tax_purchase_order_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_purchase_order_line_rel (
    purchase_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


--
-- Name: TABLE account_tax_purchase_order_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_purchase_order_line_rel IS 'RELATION BETWEEN purchase_order_line AND account_tax';


--
-- Name: account_tax_repartition_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_repartition_line (
    id integer NOT NULL,
    account_id integer,
    tax_id integer,
    company_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    repartition_type character varying NOT NULL,
    document_type character varying NOT NULL,
    use_in_tax_closing boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    factor_percent double precision NOT NULL
);


--
-- Name: TABLE account_tax_repartition_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_repartition_line IS 'Tax Repartition Line';


--
-- Name: COLUMN account_tax_repartition_line.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.account_id IS 'Account';


--
-- Name: COLUMN account_tax_repartition_line.tax_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.tax_id IS 'Tax';


--
-- Name: COLUMN account_tax_repartition_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.company_id IS 'Company';


--
-- Name: COLUMN account_tax_repartition_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_repartition_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_repartition_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_repartition_line.repartition_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.repartition_type IS 'Based On';


--
-- Name: COLUMN account_tax_repartition_line.document_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.document_type IS 'Related to';


--
-- Name: COLUMN account_tax_repartition_line.use_in_tax_closing; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.use_in_tax_closing IS 'Tax Closing Entry';


--
-- Name: COLUMN account_tax_repartition_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_repartition_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax_repartition_line.factor_percent; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_repartition_line.factor_percent IS '%';


--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_tax_repartition_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNED BY public.account_tax_repartition_line.id;


--
-- Name: account_tax_sale_order_discount_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_sale_order_discount_rel (
    sale_order_discount_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


--
-- Name: TABLE account_tax_sale_order_discount_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_sale_order_discount_rel IS 'RELATION BETWEEN sale_order_discount AND account_tax';


--
-- Name: account_tax_sale_order_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_sale_order_line_rel (
    sale_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


--
-- Name: TABLE account_tax_sale_order_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_sale_order_line_rel IS 'RELATION BETWEEN sale_order_line AND account_tax';


--
-- Name: account_tax_unit; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_unit (
    id integer NOT NULL,
    country_id integer NOT NULL,
    main_company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    vat character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_tax_unit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_unit IS 'Tax Unit';


--
-- Name: COLUMN account_tax_unit.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_unit.country_id IS 'Country';


--
-- Name: COLUMN account_tax_unit.main_company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_unit.main_company_id IS 'Main Company';


--
-- Name: COLUMN account_tax_unit.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_unit.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_unit.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_unit.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_unit.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_unit.name IS 'Name';


--
-- Name: COLUMN account_tax_unit.vat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_unit.vat IS 'Tax ID';


--
-- Name: COLUMN account_tax_unit.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_unit.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_unit.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_tax_unit.write_date IS 'Last Updated on';


--
-- Name: account_tax_unit_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_tax_unit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_tax_unit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_tax_unit_id_seq OWNED BY public.account_tax_unit.id;


--
-- Name: account_tax_unit_res_company_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_tax_unit_res_company_rel (
    res_company_id integer NOT NULL,
    account_tax_unit_id integer NOT NULL
);


--
-- Name: TABLE account_tax_unit_res_company_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_tax_unit_res_company_rel IS 'RELATION BETWEEN res_company AND account_tax_unit';


--
-- Name: account_transfer_model; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_transfer_model (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    frequency character varying NOT NULL,
    state character varying NOT NULL,
    date_start date NOT NULL,
    date_stop date,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE account_transfer_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_transfer_model IS 'Account Transfer Model';


--
-- Name: COLUMN account_transfer_model.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model.journal_id IS 'Destination Journal';


--
-- Name: COLUMN account_transfer_model.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_transfer_model.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_transfer_model.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model.name IS 'Name';


--
-- Name: COLUMN account_transfer_model.frequency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model.frequency IS 'Frequency';


--
-- Name: COLUMN account_transfer_model.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model.state IS 'State';


--
-- Name: COLUMN account_transfer_model.date_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model.date_start IS 'Start Date';


--
-- Name: COLUMN account_transfer_model.date_stop; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model.date_stop IS 'Stop Date';


--
-- Name: COLUMN account_transfer_model.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model.active IS 'Active';


--
-- Name: COLUMN account_transfer_model.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model.create_date IS 'Created on';


--
-- Name: COLUMN account_transfer_model.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model.write_date IS 'Last Updated on';


--
-- Name: account_transfer_model_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_transfer_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_transfer_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_transfer_model_id_seq OWNED BY public.account_transfer_model.id;


--
-- Name: account_transfer_model_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_transfer_model_line (
    id integer NOT NULL,
    transfer_model_id integer NOT NULL,
    account_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percent double precision NOT NULL
);


--
-- Name: TABLE account_transfer_model_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_transfer_model_line IS 'Account Transfer Model Line';


--
-- Name: COLUMN account_transfer_model_line.transfer_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model_line.transfer_model_id IS 'Transfer Model';


--
-- Name: COLUMN account_transfer_model_line.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model_line.account_id IS 'Destination Account';


--
-- Name: COLUMN account_transfer_model_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_transfer_model_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_transfer_model_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_transfer_model_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model_line.create_date IS 'Created on';


--
-- Name: COLUMN account_transfer_model_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_transfer_model_line.percent; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.account_transfer_model_line.percent IS 'Percent';


--
-- Name: account_transfer_model_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.account_transfer_model_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: account_transfer_model_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.account_transfer_model_line_id_seq OWNED BY public.account_transfer_model_line.id;


--
-- Name: account_transfer_model_line_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.account_transfer_model_line_res_partner_rel (
    account_transfer_model_line_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE account_transfer_model_line_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.account_transfer_model_line_res_partner_rel IS 'RELATION BETWEEN account_transfer_model_line AND res_partner';


--
-- Name: activity_attachment_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.activity_attachment_rel (
    activity_id integer NOT NULL,
    attachment_id integer NOT NULL
);


--
-- Name: TABLE activity_attachment_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.activity_attachment_rel IS 'RELATION BETWEEN mail_activity AND ir_attachment';


--
-- Name: appointment_answer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_answer (
    id integer NOT NULL,
    question_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE appointment_answer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_answer IS 'Appointment Question Answers';


--
-- Name: COLUMN appointment_answer.question_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer.question_id IS 'Question';


--
-- Name: COLUMN appointment_answer.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer.sequence IS 'Sequence';


--
-- Name: COLUMN appointment_answer.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_answer.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_answer.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer.name IS 'Answer';


--
-- Name: COLUMN appointment_answer.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer.create_date IS 'Created on';


--
-- Name: COLUMN appointment_answer.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer.write_date IS 'Last Updated on';


--
-- Name: appointment_answer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.appointment_answer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: appointment_answer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.appointment_answer_id_seq OWNED BY public.appointment_answer.id;


--
-- Name: appointment_answer_input; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_answer_input (
    id integer NOT NULL,
    question_id integer NOT NULL,
    value_answer_id integer,
    appointment_type_id integer NOT NULL,
    calendar_event_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    value_text_box text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    calendar_booking_id integer,
    CONSTRAINT appointment_answer_input_check_event_or_booking CHECK (((calendar_booking_id IS NOT NULL) OR (calendar_event_id IS NOT NULL))),
    CONSTRAINT appointment_answer_input_value_check CHECK (((value_answer_id IS NOT NULL) OR (COALESCE(value_text_box, ''::text) <> ''::text)))
);


--
-- Name: TABLE appointment_answer_input; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_answer_input IS 'Appointment Answer Inputs';


--
-- Name: COLUMN appointment_answer_input.question_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer_input.question_id IS 'Question';


--
-- Name: COLUMN appointment_answer_input.value_answer_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer_input.value_answer_id IS 'Selected Answer';


--
-- Name: COLUMN appointment_answer_input.appointment_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer_input.appointment_type_id IS 'Appointment Type';


--
-- Name: COLUMN appointment_answer_input.calendar_event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer_input.calendar_event_id IS 'Calendar Event';


--
-- Name: COLUMN appointment_answer_input.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer_input.partner_id IS 'Customer';


--
-- Name: COLUMN appointment_answer_input.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer_input.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_answer_input.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer_input.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_answer_input.value_text_box; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer_input.value_text_box IS 'Text Answer';


--
-- Name: COLUMN appointment_answer_input.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer_input.create_date IS 'Created on';


--
-- Name: COLUMN appointment_answer_input.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer_input.write_date IS 'Last Updated on';


--
-- Name: COLUMN appointment_answer_input.calendar_booking_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_answer_input.calendar_booking_id IS 'Meeting Booking';


--
-- Name: CONSTRAINT appointment_answer_input_check_event_or_booking ON appointment_answer_input; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT appointment_answer_input_check_event_or_booking ON public.appointment_answer_input IS 'CHECK(calendar_booking_id IS NOT NULL OR calendar_event_id IS NOT NULL)';


--
-- Name: CONSTRAINT appointment_answer_input_value_check ON appointment_answer_input; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT appointment_answer_input_value_check ON public.appointment_answer_input IS 'CHECK(value_answer_id IS NOT NULL OR COALESCE(value_text_box, '''') <> '''')';


--
-- Name: appointment_answer_input_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.appointment_answer_input_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: appointment_answer_input_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.appointment_answer_input_id_seq OWNED BY public.appointment_answer_input.id;


--
-- Name: appointment_booking_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_booking_line (
    id integer NOT NULL,
    appointment_resource_id integer NOT NULL,
    appointment_type_id integer,
    capacity_reserved integer NOT NULL,
    capacity_used integer,
    calendar_event_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    event_start timestamp without time zone,
    event_stop timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT appointment_booking_line_check_capacity_reserved CHECK ((capacity_reserved >= 0)),
    CONSTRAINT appointment_booking_line_check_capacity_used CHECK ((capacity_used >= capacity_reserved))
);


--
-- Name: TABLE appointment_booking_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_booking_line IS 'Appointment Booking Line';


--
-- Name: COLUMN appointment_booking_line.appointment_resource_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_booking_line.appointment_resource_id IS 'Appointment Resource';


--
-- Name: COLUMN appointment_booking_line.appointment_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_booking_line.appointment_type_id IS 'Appointment';


--
-- Name: COLUMN appointment_booking_line.capacity_reserved; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_booking_line.capacity_reserved IS 'Capacity Reserved';


--
-- Name: COLUMN appointment_booking_line.capacity_used; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_booking_line.capacity_used IS 'Capacity Used';


--
-- Name: COLUMN appointment_booking_line.calendar_event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_booking_line.calendar_event_id IS 'Booking';


--
-- Name: COLUMN appointment_booking_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_booking_line.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_booking_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_booking_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_booking_line.event_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_booking_line.event_start IS 'Booking Start';


--
-- Name: COLUMN appointment_booking_line.event_stop; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_booking_line.event_stop IS 'Booking End';


--
-- Name: COLUMN appointment_booking_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_booking_line.create_date IS 'Created on';


--
-- Name: COLUMN appointment_booking_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_booking_line.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT appointment_booking_line_check_capacity_reserved ON appointment_booking_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT appointment_booking_line_check_capacity_reserved ON public.appointment_booking_line IS 'CHECK(capacity_reserved >= 0)';


--
-- Name: CONSTRAINT appointment_booking_line_check_capacity_used ON appointment_booking_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT appointment_booking_line_check_capacity_used ON public.appointment_booking_line IS 'CHECK(capacity_used >= capacity_reserved)';


--
-- Name: appointment_booking_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.appointment_booking_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: appointment_booking_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.appointment_booking_line_id_seq OWNED BY public.appointment_booking_line.id;


--
-- Name: appointment_invite; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_invite (
    id integer NOT NULL,
    appointment_type_count integer,
    create_uid integer,
    write_uid integer,
    access_token character varying NOT NULL,
    short_code character varying NOT NULL,
    resources_choice character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    opportunity_id integer,
    website_id integer,
    is_published boolean
);


--
-- Name: TABLE appointment_invite; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_invite IS 'Appointment Invite';


--
-- Name: COLUMN appointment_invite.appointment_type_count; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_invite.appointment_type_count IS 'Selected Appointments Count';


--
-- Name: COLUMN appointment_invite.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_invite.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_invite.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_invite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_invite.access_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_invite.access_token IS 'Token';


--
-- Name: COLUMN appointment_invite.short_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_invite.short_code IS 'Short Code';


--
-- Name: COLUMN appointment_invite.resources_choice; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_invite.resources_choice IS 'Assign to';


--
-- Name: COLUMN appointment_invite.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_invite.create_date IS 'Created on';


--
-- Name: COLUMN appointment_invite.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_invite.write_date IS 'Last Updated on';


--
-- Name: COLUMN appointment_invite.opportunity_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_invite.opportunity_id IS 'Opportunity/Lead';


--
-- Name: COLUMN appointment_invite.website_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_invite.website_id IS 'Website';


--
-- Name: COLUMN appointment_invite.is_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_invite.is_published IS 'Is Published';


--
-- Name: appointment_invite_appointment_resource_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_invite_appointment_resource_rel (
    appointment_invite_id integer NOT NULL,
    appointment_resource_id integer NOT NULL
);


--
-- Name: TABLE appointment_invite_appointment_resource_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_invite_appointment_resource_rel IS 'RELATION BETWEEN appointment_invite AND appointment_resource';


--
-- Name: appointment_invite_appointment_type_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_invite_appointment_type_rel (
    appointment_invite_id integer NOT NULL,
    appointment_type_id integer NOT NULL
);


--
-- Name: TABLE appointment_invite_appointment_type_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_invite_appointment_type_rel IS 'RELATION BETWEEN appointment_invite AND appointment_type';


--
-- Name: appointment_invite_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.appointment_invite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: appointment_invite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.appointment_invite_id_seq OWNED BY public.appointment_invite.id;


--
-- Name: appointment_invite_res_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_invite_res_users_rel (
    appointment_invite_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE appointment_invite_res_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_invite_res_users_rel IS 'RELATION BETWEEN appointment_invite AND res_users';


--
-- Name: appointment_manage_leaves; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_manage_leaves (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reason character varying,
    leave_start_dt timestamp without time zone NOT NULL,
    leave_end_dt timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE appointment_manage_leaves; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_manage_leaves IS 'Add or remove leaves from appointments';


--
-- Name: COLUMN appointment_manage_leaves.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_manage_leaves.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_manage_leaves.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_manage_leaves.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_manage_leaves.reason; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_manage_leaves.reason IS 'Reason';


--
-- Name: COLUMN appointment_manage_leaves.leave_start_dt; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_manage_leaves.leave_start_dt IS 'Start Date';


--
-- Name: COLUMN appointment_manage_leaves.leave_end_dt; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_manage_leaves.leave_end_dt IS 'End Date';


--
-- Name: COLUMN appointment_manage_leaves.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_manage_leaves.create_date IS 'Created on';


--
-- Name: COLUMN appointment_manage_leaves.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_manage_leaves.write_date IS 'Last Updated on';


--
-- Name: appointment_manage_leaves_appointment_resource_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_manage_leaves_appointment_resource_rel (
    appointment_manage_leaves_id integer NOT NULL,
    appointment_resource_id integer NOT NULL
);


--
-- Name: TABLE appointment_manage_leaves_appointment_resource_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_manage_leaves_appointment_resource_rel IS 'RELATION BETWEEN appointment_manage_leaves AND appointment_resource';


--
-- Name: appointment_manage_leaves_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.appointment_manage_leaves_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: appointment_manage_leaves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.appointment_manage_leaves_id_seq OWNED BY public.appointment_manage_leaves.id;


--
-- Name: appointment_question; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_question (
    id integer NOT NULL,
    sequence integer,
    appointment_type_id integer,
    create_uid integer,
    write_uid integer,
    question_type character varying,
    name jsonb NOT NULL,
    placeholder jsonb,
    question_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE appointment_question; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_question IS 'Appointment Questions';


--
-- Name: COLUMN appointment_question.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_question.sequence IS 'Sequence';


--
-- Name: COLUMN appointment_question.appointment_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_question.appointment_type_id IS 'Appointment Type';


--
-- Name: COLUMN appointment_question.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_question.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_question.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_question.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_question.question_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_question.question_type IS 'Answer Type';


--
-- Name: COLUMN appointment_question.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_question.name IS 'Question';


--
-- Name: COLUMN appointment_question.placeholder; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_question.placeholder IS 'Placeholder';


--
-- Name: COLUMN appointment_question.question_required; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_question.question_required IS 'Mandatory Answer';


--
-- Name: COLUMN appointment_question.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_question.create_date IS 'Created on';


--
-- Name: COLUMN appointment_question.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_question.write_date IS 'Last Updated on';


--
-- Name: appointment_question_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.appointment_question_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: appointment_question_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.appointment_question_id_seq OWNED BY public.appointment_question.id;


--
-- Name: appointment_resource; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_resource (
    id integer NOT NULL,
    resource_id integer NOT NULL,
    company_id integer,
    resource_calendar_id integer,
    sequence integer NOT NULL,
    capacity integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    description jsonb,
    active boolean,
    shareable boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT appointment_resource_check_capacity CHECK ((capacity >= 1))
);


--
-- Name: TABLE appointment_resource; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_resource IS 'Appointment Resource';


--
-- Name: COLUMN appointment_resource.resource_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_resource.resource_id IS 'Resource';


--
-- Name: COLUMN appointment_resource.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_resource.company_id IS 'Company';


--
-- Name: COLUMN appointment_resource.resource_calendar_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_resource.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN appointment_resource.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_resource.sequence IS 'Sequence';


--
-- Name: COLUMN appointment_resource.capacity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_resource.capacity IS 'Capacity';


--
-- Name: COLUMN appointment_resource.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_resource.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_resource.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_resource.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_resource.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_resource.name IS 'Name';


--
-- Name: COLUMN appointment_resource.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_resource.description IS 'Description';


--
-- Name: COLUMN appointment_resource.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_resource.active IS 'Active';


--
-- Name: COLUMN appointment_resource.shareable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_resource.shareable IS 'Shareable';


--
-- Name: COLUMN appointment_resource.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_resource.create_date IS 'Created on';


--
-- Name: COLUMN appointment_resource.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_resource.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT appointment_resource_check_capacity ON appointment_resource; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT appointment_resource_check_capacity ON public.appointment_resource IS 'check(capacity >= 1)';


--
-- Name: appointment_resource_appointment_slot_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_resource_appointment_slot_rel (
    appointment_slot_id integer NOT NULL,
    appointment_resource_id integer NOT NULL
);


--
-- Name: TABLE appointment_resource_appointment_slot_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_resource_appointment_slot_rel IS 'RELATION BETWEEN appointment_slot AND appointment_resource';


--
-- Name: appointment_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.appointment_resource_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: appointment_resource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.appointment_resource_id_seq OWNED BY public.appointment_resource.id;


--
-- Name: appointment_resource_linked_appointment_resource; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_resource_linked_appointment_resource (
    resource_id integer NOT NULL,
    linked_resource_id integer NOT NULL
);


--
-- Name: TABLE appointment_resource_linked_appointment_resource; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_resource_linked_appointment_resource IS 'RELATION BETWEEN appointment_resource AND appointment_resource';


--
-- Name: appointment_slot; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_slot (
    id integer NOT NULL,
    appointment_type_id integer,
    create_uid integer,
    write_uid integer,
    slot_type character varying NOT NULL,
    weekday character varying NOT NULL,
    allday boolean,
    start_datetime timestamp without time zone,
    end_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    start_hour double precision NOT NULL,
    end_hour double precision NOT NULL,
    CONSTRAINT appointment_slot_check_start_and_end_hour CHECK (((((end_hour = (0)::double precision) AND ((start_hour >= (0)::double precision) AND (start_hour <= (23.99)::double precision))) OR ((start_hour >= (0)::double precision) AND (start_hour <= end_hour))) AND ((end_hour = (0)::double precision) OR ((end_hour >= start_hour) AND (end_hour <= (23.99)::double precision)))))
);


--
-- Name: TABLE appointment_slot; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_slot IS 'Appointment: Time Slot';


--
-- Name: COLUMN appointment_slot.appointment_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_slot.appointment_type_id IS 'Appointment Type';


--
-- Name: COLUMN appointment_slot.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_slot.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_slot.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_slot.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_slot.slot_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_slot.slot_type IS 'Slot type';


--
-- Name: COLUMN appointment_slot.weekday; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_slot.weekday IS 'Week Day';


--
-- Name: COLUMN appointment_slot.allday; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_slot.allday IS 'All day';


--
-- Name: COLUMN appointment_slot.start_datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_slot.start_datetime IS 'From';


--
-- Name: COLUMN appointment_slot.end_datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_slot.end_datetime IS 'To';


--
-- Name: COLUMN appointment_slot.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_slot.create_date IS 'Created on';


--
-- Name: COLUMN appointment_slot.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_slot.write_date IS 'Last Updated on';


--
-- Name: COLUMN appointment_slot.start_hour; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_slot.start_hour IS 'Starting Hour';


--
-- Name: COLUMN appointment_slot.end_hour; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_slot.end_hour IS 'Ending Hour';


--
-- Name: CONSTRAINT appointment_slot_check_start_and_end_hour ON appointment_slot; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT appointment_slot_check_start_and_end_hour ON public.appointment_slot IS 'CHECK(
                ((end_hour=0 AND (start_hour BETWEEN 0 AND 23.99))
                    OR (start_hour BETWEEN 0 AND end_hour))
                AND (end_hour=0
                    OR (end_hour BETWEEN start_hour AND 23.99))
                )';


--
-- Name: appointment_slot_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.appointment_slot_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: appointment_slot_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.appointment_slot_id_seq OWNED BY public.appointment_slot.id;


--
-- Name: appointment_slot_res_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_slot_res_users_rel (
    appointment_slot_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE appointment_slot_res_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_slot_res_users_rel IS 'RELATION BETWEEN appointment_slot AND res_users';


--
-- Name: appointment_type; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_type (
    id integer NOT NULL,
    sequence integer,
    location_id integer,
    booked_mail_template_id integer,
    canceled_mail_template_id integer,
    max_schedule_days integer NOT NULL,
    create_uid integer,
    write_uid integer,
    appointment_tz character varying NOT NULL,
    event_videocall_source character varying,
    assign_method character varying NOT NULL,
    avatars_display character varying,
    category character varying,
    schedule_based_on character varying NOT NULL,
    name jsonb NOT NULL,
    message_confirmation jsonb,
    message_intro jsonb,
    active boolean,
    appointment_manual_confirmation boolean,
    allow_guests boolean,
    hide_duration boolean,
    hide_timezone boolean,
    resource_manage_capacity boolean,
    is_published boolean,
    start_datetime timestamp without time zone,
    end_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    appointment_duration double precision NOT NULL,
    min_cancellation_hours double precision NOT NULL,
    min_schedule_hours double precision NOT NULL,
    resource_manual_confirmation_percentage double precision,
    lead_create boolean,
    work_hours_activated boolean,
    product_id integer,
    has_payment_step boolean,
    website_id integer,
    website_meta_og_img character varying,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    CONSTRAINT appointment_type_check_product_and_payment_step CHECK (((has_payment_step IS NULL) OR (NOT has_payment_step) OR (product_id IS NOT NULL))),
    CONSTRAINT appointment_type_check_resource_manual_confirmation_percentage CHECK (((resource_manual_confirmation_percentage >= (0)::double precision) AND (resource_manual_confirmation_percentage <= (1)::double precision)))
);


--
-- Name: TABLE appointment_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_type IS 'Appointment Type';


--
-- Name: COLUMN appointment_type.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.sequence IS 'Sequence';


--
-- Name: COLUMN appointment_type.location_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.location_id IS 'Location';


--
-- Name: COLUMN appointment_type.booked_mail_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.booked_mail_template_id IS 'Confirmation Email';


--
-- Name: COLUMN appointment_type.canceled_mail_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.canceled_mail_template_id IS 'Cancellation Email';


--
-- Name: COLUMN appointment_type.max_schedule_days; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.max_schedule_days IS 'Schedule not after (days)';


--
-- Name: COLUMN appointment_type.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_type.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_type.appointment_tz; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.appointment_tz IS 'Timezone';


--
-- Name: COLUMN appointment_type.event_videocall_source; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.event_videocall_source IS 'Videoconference Link';


--
-- Name: COLUMN appointment_type.assign_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.assign_method IS 'Assignment Method';


--
-- Name: COLUMN appointment_type.avatars_display; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.avatars_display IS 'Front-End Display';


--
-- Name: COLUMN appointment_type.category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.category IS 'Category';


--
-- Name: COLUMN appointment_type.schedule_based_on; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.schedule_based_on IS 'Availability on';


--
-- Name: COLUMN appointment_type.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.name IS 'Appointment Title';


--
-- Name: COLUMN appointment_type.message_confirmation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.message_confirmation IS 'Confirmation Message';


--
-- Name: COLUMN appointment_type.message_intro; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.message_intro IS 'Introduction Message';


--
-- Name: COLUMN appointment_type.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.active IS 'Active';


--
-- Name: COLUMN appointment_type.appointment_manual_confirmation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.appointment_manual_confirmation IS 'Manual Confirmation';


--
-- Name: COLUMN appointment_type.allow_guests; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.allow_guests IS 'Allow Guests';


--
-- Name: COLUMN appointment_type.hide_duration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.hide_duration IS 'Hide Duration';


--
-- Name: COLUMN appointment_type.hide_timezone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.hide_timezone IS 'Hide Time Zone';


--
-- Name: COLUMN appointment_type.resource_manage_capacity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.resource_manage_capacity IS 'Manage Capacities';


--
-- Name: COLUMN appointment_type.is_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.is_published IS 'Is Published';


--
-- Name: COLUMN appointment_type.start_datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.start_datetime IS 'Start Datetime';


--
-- Name: COLUMN appointment_type.end_datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.end_datetime IS 'End Datetime';


--
-- Name: COLUMN appointment_type.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.create_date IS 'Created on';


--
-- Name: COLUMN appointment_type.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.write_date IS 'Last Updated on';


--
-- Name: COLUMN appointment_type.appointment_duration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.appointment_duration IS 'Duration';


--
-- Name: COLUMN appointment_type.min_cancellation_hours; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.min_cancellation_hours IS 'Cancel Before (hours)';


--
-- Name: COLUMN appointment_type.min_schedule_hours; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.min_schedule_hours IS 'Schedule before (hours)';


--
-- Name: COLUMN appointment_type.resource_manual_confirmation_percentage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.resource_manual_confirmation_percentage IS 'Capacity Percentage';


--
-- Name: COLUMN appointment_type.lead_create; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.lead_create IS 'Create Opportunities';


--
-- Name: COLUMN appointment_type.work_hours_activated; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.work_hours_activated IS 'Limit to Work Hours';


--
-- Name: COLUMN appointment_type.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.product_id IS 'Booking Product';


--
-- Name: COLUMN appointment_type.has_payment_step; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.has_payment_step IS 'Up-front Payment';


--
-- Name: COLUMN appointment_type.website_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.website_id IS 'Website';


--
-- Name: COLUMN appointment_type.website_meta_og_img; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN appointment_type.website_meta_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN appointment_type.website_meta_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN appointment_type.website_meta_keywords; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN appointment_type.seo_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appointment_type.seo_name IS 'Seo name';


--
-- Name: CONSTRAINT appointment_type_check_product_and_payment_step ON appointment_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT appointment_type_check_product_and_payment_step ON public.appointment_type IS 'CHECK(has_payment_step IS NULL OR NOT has_payment_step OR product_id IS NOT NULL)';


--
-- Name: CONSTRAINT appointment_type_check_resource_manual_confirmation_percentage ON appointment_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT appointment_type_check_resource_manual_confirmation_percentage ON public.appointment_type IS 'check(resource_manual_confirmation_percentage >= 0 and resource_manual_confirmation_percentage <= 1)';


--
-- Name: appointment_type_appointment_resource_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_type_appointment_resource_rel (
    appointment_resource_id integer NOT NULL,
    appointment_type_id integer NOT NULL
);


--
-- Name: TABLE appointment_type_appointment_resource_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_type_appointment_resource_rel IS 'RELATION BETWEEN appointment_resource AND appointment_type';


--
-- Name: appointment_type_calendar_alarm_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_type_calendar_alarm_rel (
    appointment_type_id integer NOT NULL,
    calendar_alarm_id integer NOT NULL
);


--
-- Name: TABLE appointment_type_calendar_alarm_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_type_calendar_alarm_rel IS 'RELATION BETWEEN appointment_type AND calendar_alarm';


--
-- Name: appointment_type_country_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_type_country_rel (
    appointment_type_id integer NOT NULL,
    res_country_id integer NOT NULL
);


--
-- Name: TABLE appointment_type_country_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_type_country_rel IS 'RELATION BETWEEN appointment_type AND res_country';


--
-- Name: appointment_type_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.appointment_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: appointment_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.appointment_type_id_seq OWNED BY public.appointment_type.id;


--
-- Name: appointment_type_res_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appointment_type_res_users_rel (
    appointment_type_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE appointment_type_res_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appointment_type_res_users_rel IS 'RELATION BETWEEN appointment_type AND res_users';


--
-- Name: appraisal_ask_feedback; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appraisal_ask_feedback (
    id integer NOT NULL,
    template_id integer,
    appraisal_id integer,
    author_id integer NOT NULL,
    survey_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    deadline date NOT NULL,
    body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE appraisal_ask_feedback; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appraisal_ask_feedback IS 'Ask Feedback for Appraisal';


--
-- Name: COLUMN appraisal_ask_feedback.template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appraisal_ask_feedback.template_id IS 'Mail Template';


--
-- Name: COLUMN appraisal_ask_feedback.appraisal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appraisal_ask_feedback.appraisal_id IS 'Appraisal';


--
-- Name: COLUMN appraisal_ask_feedback.author_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appraisal_ask_feedback.author_id IS 'Author';


--
-- Name: COLUMN appraisal_ask_feedback.survey_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appraisal_ask_feedback.survey_template_id IS 'Survey Template';


--
-- Name: COLUMN appraisal_ask_feedback.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appraisal_ask_feedback.create_uid IS 'Created by';


--
-- Name: COLUMN appraisal_ask_feedback.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appraisal_ask_feedback.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appraisal_ask_feedback.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appraisal_ask_feedback.lang IS 'Language';


--
-- Name: COLUMN appraisal_ask_feedback.subject; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appraisal_ask_feedback.subject IS 'Subject';


--
-- Name: COLUMN appraisal_ask_feedback.deadline; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appraisal_ask_feedback.deadline IS 'Answer Deadline';


--
-- Name: COLUMN appraisal_ask_feedback.body; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appraisal_ask_feedback.body IS 'Contents';


--
-- Name: COLUMN appraisal_ask_feedback.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appraisal_ask_feedback.create_date IS 'Created on';


--
-- Name: COLUMN appraisal_ask_feedback.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.appraisal_ask_feedback.write_date IS 'Last Updated on';


--
-- Name: appraisal_ask_feedback_hr_employee_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appraisal_ask_feedback_hr_employee_rel (
    appraisal_ask_feedback_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


--
-- Name: TABLE appraisal_ask_feedback_hr_employee_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appraisal_ask_feedback_hr_employee_rel IS 'RELATION BETWEEN appraisal_ask_feedback AND hr_employee';


--
-- Name: appraisal_ask_feedback_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.appraisal_ask_feedback_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: appraisal_ask_feedback_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.appraisal_ask_feedback_id_seq OWNED BY public.appraisal_ask_feedback.id;


--
-- Name: appraisal_manager_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.appraisal_manager_rel (
    hr_appraisal_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


--
-- Name: TABLE appraisal_manager_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.appraisal_manager_rel IS 'RELATION BETWEEN hr_appraisal AND hr_employee';


--
-- Name: approval_rule_users_to_notify_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.approval_rule_users_to_notify_rel (
    studio_approval_rule_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE approval_rule_users_to_notify_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.approval_rule_users_to_notify_rel IS 'RELATION BETWEEN studio_approval_rule AND res_users';


--
-- Name: asset_modify; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.asset_modify (
    id integer NOT NULL,
    asset_id integer NOT NULL,
    method_number integer NOT NULL,
    account_asset_id integer,
    account_asset_counterpart_id integer,
    account_depreciation_id integer,
    account_depreciation_expense_id integer,
    create_uid integer,
    write_uid integer,
    method_period character varying,
    modify_action character varying,
    date date,
    name text,
    value_residual numeric,
    salvage_value numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE asset_modify; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.asset_modify IS 'Modify Asset';


--
-- Name: COLUMN asset_modify.asset_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.asset_modify.asset_id IS 'Asset';


--
-- Name: COLUMN asset_modify.method_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.asset_modify.method_number IS 'Duration';


--
-- Name: COLUMN asset_modify.account_asset_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.asset_modify.account_asset_id IS 'Gross Increase Account';


--
-- Name: COLUMN asset_modify.account_asset_counterpart_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.asset_modify.account_asset_counterpart_id IS 'Asset Counterpart Account';


--
-- Name: COLUMN asset_modify.account_depreciation_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.asset_modify.account_depreciation_id IS 'Depreciation Account';


--
-- Name: COLUMN asset_modify.account_depreciation_expense_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.asset_modify.account_depreciation_expense_id IS 'Expense Account';


--
-- Name: COLUMN asset_modify.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.asset_modify.create_uid IS 'Created by';


--
-- Name: COLUMN asset_modify.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.asset_modify.write_uid IS 'Last Updated by';


--
-- Name: COLUMN asset_modify.method_period; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.asset_modify.method_period IS 'Number of Months in a Period';


--
-- Name: COLUMN asset_modify.modify_action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.asset_modify.modify_action IS 'Action';


--
-- Name: COLUMN asset_modify.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.asset_modify.date IS 'Date';


--
-- Name: COLUMN asset_modify.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.asset_modify.name IS 'Note';


--
-- Name: COLUMN asset_modify.value_residual; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.asset_modify.value_residual IS 'Depreciable Amount';


--
-- Name: COLUMN asset_modify.salvage_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.asset_modify.salvage_value IS 'Not Depreciable Amount';


--
-- Name: COLUMN asset_modify.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.asset_modify.create_date IS 'Created on';


--
-- Name: COLUMN asset_modify.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.asset_modify.write_date IS 'Last Updated on';


--
-- Name: asset_modify_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.asset_modify_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: asset_modify_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.asset_modify_id_seq OWNED BY public.asset_modify.id;


--
-- Name: asset_move_line_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.asset_move_line_rel (
    asset_id integer NOT NULL,
    line_id integer NOT NULL
);


--
-- Name: TABLE asset_move_line_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.asset_move_line_rel IS 'RELATION BETWEEN account_asset AND account_move_line';


--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    code character varying(7),
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.code IS 'Verification Code';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: badge_unlocked_definition_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.badge_unlocked_definition_rel (
    gamification_badge_id integer NOT NULL,
    gamification_goal_definition_id integer NOT NULL
);


--
-- Name: TABLE badge_unlocked_definition_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.badge_unlocked_definition_rel IS 'RELATION BETWEEN gamification_badge AND gamification_goal_definition';


--
-- Name: barcode_nomenclature; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.barcode_nomenclature (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    upc_ean_conv character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    gs1_separator_fnc1 character varying,
    is_gs1_nomenclature boolean
);


--
-- Name: TABLE barcode_nomenclature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.barcode_nomenclature IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_nomenclature.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_nomenclature.create_uid IS 'Created by';


--
-- Name: COLUMN barcode_nomenclature.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_nomenclature.write_uid IS 'Last Updated by';


--
-- Name: COLUMN barcode_nomenclature.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_nomenclature.name IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_nomenclature.upc_ean_conv; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_nomenclature.upc_ean_conv IS 'UPC/EAN Conversion';


--
-- Name: COLUMN barcode_nomenclature.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_nomenclature.create_date IS 'Created on';


--
-- Name: COLUMN barcode_nomenclature.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_nomenclature.write_date IS 'Last Updated on';


--
-- Name: COLUMN barcode_nomenclature.gs1_separator_fnc1; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_nomenclature.gs1_separator_fnc1 IS 'FNC1 Separator';


--
-- Name: COLUMN barcode_nomenclature.is_gs1_nomenclature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_nomenclature.is_gs1_nomenclature IS 'Is GS1 Nomenclature';


--
-- Name: barcode_nomenclature_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.barcode_nomenclature_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: barcode_nomenclature_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.barcode_nomenclature_id_seq OWNED BY public.barcode_nomenclature.id;


--
-- Name: barcode_rule; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.barcode_rule (
    id integer NOT NULL,
    barcode_nomenclature_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    encoding character varying NOT NULL,
    type character varying NOT NULL,
    pattern character varying NOT NULL,
    alias character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    associated_uom_id integer,
    gs1_content_type character varying,
    gs1_decimal_usage boolean
);


--
-- Name: TABLE barcode_rule; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.barcode_rule IS 'Barcode Rule';


--
-- Name: COLUMN barcode_rule.barcode_nomenclature_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_rule.barcode_nomenclature_id IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_rule.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_rule.sequence IS 'Sequence';


--
-- Name: COLUMN barcode_rule.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_rule.create_uid IS 'Created by';


--
-- Name: COLUMN barcode_rule.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN barcode_rule.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_rule.name IS 'Rule Name';


--
-- Name: COLUMN barcode_rule.encoding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_rule.encoding IS 'Encoding';


--
-- Name: COLUMN barcode_rule.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_rule.type IS 'Type';


--
-- Name: COLUMN barcode_rule.pattern; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_rule.pattern IS 'Barcode Pattern';


--
-- Name: COLUMN barcode_rule.alias; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_rule.alias IS 'Alias';


--
-- Name: COLUMN barcode_rule.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_rule.create_date IS 'Created on';


--
-- Name: COLUMN barcode_rule.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN barcode_rule.associated_uom_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_rule.associated_uom_id IS 'Associated Uom';


--
-- Name: COLUMN barcode_rule.gs1_content_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_rule.gs1_content_type IS 'GS1 Content Type';


--
-- Name: COLUMN barcode_rule.gs1_decimal_usage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.barcode_rule.gs1_decimal_usage IS 'Decimal';


--
-- Name: barcode_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.barcode_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: barcode_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.barcode_rule_id_seq OWNED BY public.barcode_rule.id;


--
-- Name: base_automation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_automation (
    id integer NOT NULL,
    model_id integer NOT NULL,
    trg_selection_field_id integer,
    trg_field_ref integer,
    trg_date_id integer,
    trg_date_range integer,
    trg_date_calendar_id integer,
    create_uid integer,
    write_uid integer,
    webhook_uuid character varying,
    record_getter character varying,
    trigger character varying NOT NULL,
    trg_date_range_type character varying,
    filter_pre_domain character varying,
    filter_domain character varying,
    name jsonb NOT NULL,
    description text,
    log_webhook_calls boolean,
    active boolean,
    last_run timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_automation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_automation IS 'Automation Rule';


--
-- Name: COLUMN base_automation.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.model_id IS 'Model';


--
-- Name: COLUMN base_automation.trg_selection_field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.trg_selection_field_id IS 'Trigger Field';


--
-- Name: COLUMN base_automation.trg_field_ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.trg_field_ref IS 'Trigger Reference';


--
-- Name: COLUMN base_automation.trg_date_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.trg_date_id IS 'Trigger Date';


--
-- Name: COLUMN base_automation.trg_date_range; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.trg_date_range IS 'Delay after trigger date';


--
-- Name: COLUMN base_automation.trg_date_calendar_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.trg_date_calendar_id IS 'Use Calendar';


--
-- Name: COLUMN base_automation.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.create_uid IS 'Created by';


--
-- Name: COLUMN base_automation.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_automation.webhook_uuid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.webhook_uuid IS 'Webhook UUID';


--
-- Name: COLUMN base_automation.record_getter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.record_getter IS 'Record Getter';


--
-- Name: COLUMN base_automation.trigger; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.trigger IS 'Trigger';


--
-- Name: COLUMN base_automation.trg_date_range_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.trg_date_range_type IS 'Delay type';


--
-- Name: COLUMN base_automation.filter_pre_domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.filter_pre_domain IS 'Before Update Domain';


--
-- Name: COLUMN base_automation.filter_domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.filter_domain IS 'Apply on';


--
-- Name: COLUMN base_automation.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.name IS 'Automation Rule Name';


--
-- Name: COLUMN base_automation.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.description IS 'Description';


--
-- Name: COLUMN base_automation.log_webhook_calls; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.log_webhook_calls IS 'Log Calls';


--
-- Name: COLUMN base_automation.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.active IS 'Active';


--
-- Name: COLUMN base_automation.last_run; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.last_run IS 'Last Run';


--
-- Name: COLUMN base_automation.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.create_date IS 'Created on';


--
-- Name: COLUMN base_automation.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_automation.write_date IS 'Last Updated on';


--
-- Name: base_automation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_automation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_automation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_automation_id_seq OWNED BY public.base_automation.id;


--
-- Name: base_automation_ir_model_fields_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_automation_ir_model_fields_rel (
    base_automation_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


--
-- Name: TABLE base_automation_ir_model_fields_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_automation_ir_model_fields_rel IS 'RELATION BETWEEN base_automation AND ir_model_fields';


--
-- Name: base_automation_onchange_fields_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_automation_onchange_fields_rel (
    base_automation_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


--
-- Name: TABLE base_automation_onchange_fields_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_automation_onchange_fields_rel IS 'RELATION BETWEEN base_automation AND ir_model_fields';


--
-- Name: base_cache_signaling_assets; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_cache_signaling_assets
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_cache_signaling_default; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_cache_signaling_default
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_cache_signaling_groups; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_cache_signaling_groups
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_cache_signaling_routing; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_cache_signaling_routing
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_cache_signaling_templates; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_cache_signaling_templates
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    from_invoice boolean
);


--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_document_layout.from_invoice; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.from_invoice IS 'From Invoice';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_module; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying,
    import_message text,
    modules_dependencies text,
    force boolean,
    with_demo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    module_file bytea NOT NULL
);


--
-- Name: TABLE base_import_module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_module IS 'Import Module';


--
-- Name: COLUMN base_import_module.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_module.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_module.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.state IS 'Status';


--
-- Name: COLUMN base_import_module.import_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.import_message IS 'Import Message';


--
-- Name: COLUMN base_import_module.modules_dependencies; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.modules_dependencies IS 'Modules Dependencies';


--
-- Name: COLUMN base_import_module.force; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.force IS 'Force init';


--
-- Name: COLUMN base_import_module.with_demo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.with_demo IS 'Import demo data of module';


--
-- Name: COLUMN base_import_module.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.create_date IS 'Created on';


--
-- Name: COLUMN base_import_module.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_module.module_file; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.module_file IS 'Module .ZIP file';


--
-- Name: base_import_module_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_module_id_seq OWNED BY public.base_import_module.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    export_type character varying NOT NULL,
    domain character varying,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.model_id IS 'Model to Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.export_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.export_type IS 'Export Type';


--
-- Name: COLUMN base_language_export.domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.domain IS 'Model Domain';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_language_install_website_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_language_install_website_rel (
    base_language_install_id integer NOT NULL,
    website_id integer NOT NULL
);


--
-- Name: TABLE base_language_install_website_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_language_install_website_rel IS 'RELATION BETWEEN base_language_install AND website';


--
-- Name: base_module_install_request; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_module_install_request (
    id integer NOT NULL,
    module_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    body_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_module_install_request; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_module_install_request IS 'Module Activation Request';


--
-- Name: COLUMN base_module_install_request.module_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_install_request.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_request.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_install_request.user_id IS 'User';


--
-- Name: COLUMN base_module_install_request.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_install_request.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_request.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_install_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_request.body_html; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_install_request.body_html IS 'Body';


--
-- Name: COLUMN base_module_install_request.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_install_request.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_request.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_install_request.write_date IS 'Last Updated on';


--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_module_install_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_module_install_request_id_seq OWNED BY public.base_module_install_request.id;


--
-- Name: base_module_install_review; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_module_install_review (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_module_install_review; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_module_install_review IS 'Module Activation Review';


--
-- Name: COLUMN base_module_install_review.module_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_install_review.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_review.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_install_review.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_review.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_install_review.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_review.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_install_review.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_review.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_install_review.write_date IS 'Last Updated on';


--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_module_install_review_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_module_install_review_id_seq OWNED BY public.base_module_install_review.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: base_registry_signaling; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_registry_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: bill_to_po_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.bill_to_po_wizard (
    id integer NOT NULL,
    purchase_order_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE bill_to_po_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.bill_to_po_wizard IS 'Bill to Purchase Order';


--
-- Name: COLUMN bill_to_po_wizard.purchase_order_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bill_to_po_wizard.purchase_order_id IS 'Purchase Order';


--
-- Name: COLUMN bill_to_po_wizard.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bill_to_po_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN bill_to_po_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bill_to_po_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN bill_to_po_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bill_to_po_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bill_to_po_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bill_to_po_wizard.create_date IS 'Created on';


--
-- Name: COLUMN bill_to_po_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bill_to_po_wizard.write_date IS 'Last Updated on';


--
-- Name: bill_to_po_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.bill_to_po_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: bill_to_po_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.bill_to_po_wizard_id_seq OWNED BY public.bill_to_po_wizard.id;


--
-- Name: blog_blog; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.blog_blog (
    id integer NOT NULL,
    website_id integer,
    create_uid integer,
    write_uid integer,
    website_meta_og_img character varying,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    name jsonb NOT NULL,
    subtitle jsonb,
    content jsonb,
    cover_properties text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE blog_blog; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.blog_blog IS 'Blog';


--
-- Name: COLUMN blog_blog.website_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_blog.website_id IS 'Website';


--
-- Name: COLUMN blog_blog.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_blog.create_uid IS 'Created by';


--
-- Name: COLUMN blog_blog.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_blog.write_uid IS 'Last Updated by';


--
-- Name: COLUMN blog_blog.website_meta_og_img; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_blog.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN blog_blog.website_meta_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_blog.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN blog_blog.website_meta_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_blog.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN blog_blog.website_meta_keywords; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_blog.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN blog_blog.seo_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_blog.seo_name IS 'Seo name';


--
-- Name: COLUMN blog_blog.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_blog.name IS 'Blog Name';


--
-- Name: COLUMN blog_blog.subtitle; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_blog.subtitle IS 'Blog Subtitle';


--
-- Name: COLUMN blog_blog.content; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_blog.content IS 'Content';


--
-- Name: COLUMN blog_blog.cover_properties; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_blog.cover_properties IS 'Cover Properties';


--
-- Name: COLUMN blog_blog.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_blog.active IS 'Active';


--
-- Name: COLUMN blog_blog.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_blog.create_date IS 'Created on';


--
-- Name: COLUMN blog_blog.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_blog.write_date IS 'Last Updated on';


--
-- Name: blog_blog_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.blog_blog_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: blog_blog_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.blog_blog_id_seq OWNED BY public.blog_blog.id;


--
-- Name: blog_post; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.blog_post (
    id integer NOT NULL,
    website_id integer,
    author_id integer,
    blog_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    visits integer,
    website_meta_og_img character varying,
    author_name character varying,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    name jsonb NOT NULL,
    subtitle jsonb,
    content jsonb,
    teaser_manual jsonb,
    cover_properties text,
    is_published boolean,
    active boolean,
    create_date timestamp without time zone,
    published_date timestamp without time zone,
    post_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE blog_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.blog_post IS 'Blog Post';


--
-- Name: COLUMN blog_post.website_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.website_id IS 'Website';


--
-- Name: COLUMN blog_post.author_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.author_id IS 'Author';


--
-- Name: COLUMN blog_post.blog_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.blog_id IS 'Blog';


--
-- Name: COLUMN blog_post.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.create_uid IS 'Created by';


--
-- Name: COLUMN blog_post.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.write_uid IS 'Last Contributor';


--
-- Name: COLUMN blog_post.visits; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.visits IS 'No of Views';


--
-- Name: COLUMN blog_post.website_meta_og_img; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN blog_post.author_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.author_name IS 'Author Name';


--
-- Name: COLUMN blog_post.website_meta_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN blog_post.website_meta_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN blog_post.website_meta_keywords; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN blog_post.seo_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.seo_name IS 'Seo name';


--
-- Name: COLUMN blog_post.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.name IS 'Title';


--
-- Name: COLUMN blog_post.subtitle; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.subtitle IS 'Sub Title';


--
-- Name: COLUMN blog_post.content; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.content IS 'Content';


--
-- Name: COLUMN blog_post.teaser_manual; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.teaser_manual IS 'Teaser Content';


--
-- Name: COLUMN blog_post.cover_properties; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.cover_properties IS 'Cover Properties';


--
-- Name: COLUMN blog_post.is_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.is_published IS 'Is Published';


--
-- Name: COLUMN blog_post.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.active IS 'Active';


--
-- Name: COLUMN blog_post.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.create_date IS 'Created on';


--
-- Name: COLUMN blog_post.published_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.published_date IS 'Published Date';


--
-- Name: COLUMN blog_post.post_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.post_date IS 'Publishing date';


--
-- Name: COLUMN blog_post.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_post.write_date IS 'Last Updated on';


--
-- Name: blog_post_blog_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.blog_post_blog_tag_rel (
    blog_tag_id integer NOT NULL,
    blog_post_id integer NOT NULL
);


--
-- Name: TABLE blog_post_blog_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.blog_post_blog_tag_rel IS 'RELATION BETWEEN blog_tag AND blog_post';


--
-- Name: blog_post_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.blog_post_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: blog_post_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.blog_post_id_seq OWNED BY public.blog_post.id;


--
-- Name: blog_tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.blog_tag (
    id integer NOT NULL,
    category_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    website_meta_og_img character varying,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE blog_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.blog_tag IS 'Blog Tag';


--
-- Name: COLUMN blog_tag.category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag.category_id IS 'Category';


--
-- Name: COLUMN blog_tag.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag.color IS 'Color';


--
-- Name: COLUMN blog_tag.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag.create_uid IS 'Created by';


--
-- Name: COLUMN blog_tag.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN blog_tag.website_meta_og_img; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN blog_tag.website_meta_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN blog_tag.website_meta_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN blog_tag.website_meta_keywords; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN blog_tag.seo_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag.seo_name IS 'Seo name';


--
-- Name: COLUMN blog_tag.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag.name IS 'Name';


--
-- Name: COLUMN blog_tag.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag.create_date IS 'Created on';


--
-- Name: COLUMN blog_tag.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag.write_date IS 'Last Updated on';


--
-- Name: blog_tag_category; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.blog_tag_category (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE blog_tag_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.blog_tag_category IS 'Blog Tag Category';


--
-- Name: COLUMN blog_tag_category.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag_category.create_uid IS 'Created by';


--
-- Name: COLUMN blog_tag_category.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN blog_tag_category.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag_category.name IS 'Name';


--
-- Name: COLUMN blog_tag_category.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag_category.create_date IS 'Created on';


--
-- Name: COLUMN blog_tag_category.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.blog_tag_category.write_date IS 'Last Updated on';


--
-- Name: blog_tag_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.blog_tag_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: blog_tag_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.blog_tag_category_id_seq OWNED BY public.blog_tag_category.id;


--
-- Name: blog_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.blog_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: blog_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.blog_tag_id_seq OWNED BY public.blog_tag.id;


--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: bus_presence; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.bus_presence (
    id integer NOT NULL,
    user_id integer,
    status character varying,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone,
    guest_id integer,
    CONSTRAINT bus_presence_partner_or_guest_exists CHECK ((((user_id IS NOT NULL) AND (guest_id IS NULL)) OR ((user_id IS NULL) AND (guest_id IS NOT NULL))))
);


--
-- Name: TABLE bus_presence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.bus_presence IS 'User Presence';


--
-- Name: COLUMN bus_presence.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_presence.user_id IS 'Users';


--
-- Name: COLUMN bus_presence.status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_presence.status IS 'IM Status';


--
-- Name: COLUMN bus_presence.last_poll; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN bus_presence.last_presence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_presence.last_presence IS 'Last Presence';


--
-- Name: COLUMN bus_presence.guest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_presence.guest_id IS 'Guest';


--
-- Name: CONSTRAINT bus_presence_partner_or_guest_exists ON bus_presence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT bus_presence_partner_or_guest_exists ON public.bus_presence IS 'CHECK((user_id IS NOT NULL AND guest_id IS NULL) OR (user_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: bus_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.bus_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: bus_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.bus_presence_id_seq OWNED BY public.bus_presence.id;


--
-- Name: calendar_alarm; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.calendar_alarm (
    id integer NOT NULL,
    duration integer NOT NULL,
    duration_minutes integer,
    mail_template_id integer,
    create_uid integer,
    write_uid integer,
    alarm_type character varying NOT NULL,
    "interval" character varying NOT NULL,
    name jsonb NOT NULL,
    body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    default_for_new_appointment_type boolean,
    sms_template_id integer,
    sms_notify_responsible boolean
);


--
-- Name: TABLE calendar_alarm; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.calendar_alarm IS 'Event Alarm';


--
-- Name: COLUMN calendar_alarm.duration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_alarm.duration IS 'Remind Before';


--
-- Name: COLUMN calendar_alarm.duration_minutes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_alarm.duration_minutes IS 'Duration in minutes';


--
-- Name: COLUMN calendar_alarm.mail_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_alarm.mail_template_id IS 'Email Template';


--
-- Name: COLUMN calendar_alarm.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_alarm.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_alarm.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_alarm.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_alarm.alarm_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_alarm.alarm_type IS 'Type';


--
-- Name: COLUMN calendar_alarm."interval"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_alarm."interval" IS 'Unit';


--
-- Name: COLUMN calendar_alarm.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_alarm.name IS 'Name';


--
-- Name: COLUMN calendar_alarm.body; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_alarm.body IS 'Additional Message';


--
-- Name: COLUMN calendar_alarm.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_alarm.create_date IS 'Created on';


--
-- Name: COLUMN calendar_alarm.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_alarm.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_alarm.default_for_new_appointment_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_alarm.default_for_new_appointment_type IS 'New Appointments Default';


--
-- Name: COLUMN calendar_alarm.sms_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_alarm.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN calendar_alarm.sms_notify_responsible; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_alarm.sms_notify_responsible IS 'Notify Responsible';


--
-- Name: calendar_alarm_calendar_event_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.calendar_alarm_calendar_event_rel (
    calendar_event_id integer NOT NULL,
    calendar_alarm_id integer NOT NULL
);


--
-- Name: TABLE calendar_alarm_calendar_event_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.calendar_alarm_calendar_event_rel IS 'RELATION BETWEEN calendar_event AND calendar_alarm';


--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.calendar_alarm_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.calendar_alarm_id_seq OWNED BY public.calendar_alarm.id;


--
-- Name: calendar_attendee; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.calendar_attendee (
    id integer NOT NULL,
    event_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    common_name character varying,
    access_token character varying,
    state character varying,
    availability character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE calendar_attendee; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.calendar_attendee IS 'Calendar Attendee Information';


--
-- Name: COLUMN calendar_attendee.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_attendee.event_id IS 'Meeting linked';


--
-- Name: COLUMN calendar_attendee.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_attendee.partner_id IS 'Attendee';


--
-- Name: COLUMN calendar_attendee.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_attendee.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_attendee.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_attendee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_attendee.common_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_attendee.common_name IS 'Common name';


--
-- Name: COLUMN calendar_attendee.access_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_attendee.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_attendee.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_attendee.state IS 'Status';


--
-- Name: COLUMN calendar_attendee.availability; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_attendee.availability IS 'Available/Busy';


--
-- Name: COLUMN calendar_attendee.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_attendee.create_date IS 'Created on';


--
-- Name: COLUMN calendar_attendee.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_attendee.write_date IS 'Last Updated on';


--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.calendar_attendee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.calendar_attendee_id_seq OWNED BY public.calendar_attendee.id;


--
-- Name: calendar_booking; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.calendar_booking (
    id integer NOT NULL,
    appointment_invite_id integer,
    appointment_type_id integer NOT NULL,
    partner_id integer,
    asked_capacity integer,
    staff_user_id integer,
    account_move_id integer,
    product_id integer NOT NULL,
    calendar_event_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    booking_token character varying,
    not_available boolean,
    start timestamp without time zone NOT NULL,
    stop timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    order_line_id integer
);


--
-- Name: TABLE calendar_booking; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.calendar_booking IS 'Meeting Booking';


--
-- Name: COLUMN calendar_booking.appointment_invite_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.appointment_invite_id IS 'Appointment Invite';


--
-- Name: COLUMN calendar_booking.appointment_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.appointment_type_id IS 'Appointment Type';


--
-- Name: COLUMN calendar_booking.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.partner_id IS 'Contact';


--
-- Name: COLUMN calendar_booking.asked_capacity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.asked_capacity IS 'Asked Capacity';


--
-- Name: COLUMN calendar_booking.staff_user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.staff_user_id IS 'Operator';


--
-- Name: COLUMN calendar_booking.account_move_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.account_move_id IS 'Appointment Invoice';


--
-- Name: COLUMN calendar_booking.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.product_id IS 'Product';


--
-- Name: COLUMN calendar_booking.calendar_event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.calendar_event_id IS 'Meeting';


--
-- Name: COLUMN calendar_booking.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_booking.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_booking.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.name IS 'Customer Name';


--
-- Name: COLUMN calendar_booking.booking_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.booking_token IS 'Access Token';


--
-- Name: COLUMN calendar_booking.not_available; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.not_available IS 'Is Not Available';


--
-- Name: COLUMN calendar_booking.start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.start IS 'Start';


--
-- Name: COLUMN calendar_booking.stop; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.stop IS 'Stop';


--
-- Name: COLUMN calendar_booking.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.create_date IS 'Created on';


--
-- Name: COLUMN calendar_booking.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_booking.order_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking.order_line_id IS 'Sale Order Line';


--
-- Name: calendar_booking_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.calendar_booking_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: calendar_booking_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.calendar_booking_id_seq OWNED BY public.calendar_booking.id;


--
-- Name: calendar_booking_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.calendar_booking_line (
    id integer NOT NULL,
    appointment_resource_id integer NOT NULL,
    calendar_booking_id integer NOT NULL,
    capacity_reserved integer,
    capacity_used integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE calendar_booking_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.calendar_booking_line IS 'Meeting Resource Booking';


--
-- Name: COLUMN calendar_booking_line.appointment_resource_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking_line.appointment_resource_id IS 'Resource';


--
-- Name: COLUMN calendar_booking_line.calendar_booking_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking_line.calendar_booking_id IS 'Meeting Booking';


--
-- Name: COLUMN calendar_booking_line.capacity_reserved; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking_line.capacity_reserved IS 'Capacity Reserved';


--
-- Name: COLUMN calendar_booking_line.capacity_used; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking_line.capacity_used IS 'Capacity Used';


--
-- Name: COLUMN calendar_booking_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking_line.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_booking_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_booking_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking_line.create_date IS 'Created on';


--
-- Name: COLUMN calendar_booking_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_booking_line.write_date IS 'Last Updated on';


--
-- Name: calendar_booking_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.calendar_booking_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: calendar_booking_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.calendar_booking_line_id_seq OWNED BY public.calendar_booking_line.id;


--
-- Name: calendar_booking_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.calendar_booking_res_partner_rel (
    calendar_booking_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE calendar_booking_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.calendar_booking_res_partner_rel IS 'RELATION BETWEEN calendar_booking AND res_partner';


--
-- Name: calendar_event; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.calendar_event (
    id integer NOT NULL,
    user_id integer,
    videocall_channel_id integer,
    res_id integer,
    res_model_id integer,
    recurrence_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    location character varying,
    videocall_location character varying,
    access_token character varying,
    privacy character varying,
    show_as character varying NOT NULL,
    res_model character varying,
    start_date date,
    stop_date date,
    description text,
    active boolean,
    allday boolean,
    recurrency boolean,
    follow_recurrence boolean,
    start timestamp without time zone NOT NULL,
    stop timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision,
    appointment_type_id integer,
    appointment_invite_id integer,
    appointment_booker_id integer,
    appointment_status character varying,
    opportunity_id integer,
    google_id character varying,
    need_sync boolean,
    guests_readonly boolean
);


--
-- Name: TABLE calendar_event; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.calendar_event IS 'Calendar Event';


--
-- Name: COLUMN calendar_event.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.user_id IS 'Organizer';


--
-- Name: COLUMN calendar_event.videocall_channel_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.videocall_channel_id IS 'Discuss Channel';


--
-- Name: COLUMN calendar_event.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.res_id IS 'Document ID';


--
-- Name: COLUMN calendar_event.res_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.res_model_id IS 'Document Model';


--
-- Name: COLUMN calendar_event.recurrence_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.recurrence_id IS 'Recurrence Rule';


--
-- Name: COLUMN calendar_event.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.name IS 'Meeting Subject';


--
-- Name: COLUMN calendar_event.location; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.location IS 'Location';


--
-- Name: COLUMN calendar_event.videocall_location; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.videocall_location IS 'Meeting URL';


--
-- Name: COLUMN calendar_event.access_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_event.privacy; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.privacy IS 'Privacy';


--
-- Name: COLUMN calendar_event.show_as; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.show_as IS 'Show as';


--
-- Name: COLUMN calendar_event.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.res_model IS 'Document Model Name';


--
-- Name: COLUMN calendar_event.start_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.start_date IS 'Start Date';


--
-- Name: COLUMN calendar_event.stop_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.stop_date IS 'End Date';


--
-- Name: COLUMN calendar_event.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.description IS 'Description';


--
-- Name: COLUMN calendar_event.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.active IS 'Active';


--
-- Name: COLUMN calendar_event.allday; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.allday IS 'All Day';


--
-- Name: COLUMN calendar_event.recurrency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.recurrency IS 'Recurrent';


--
-- Name: COLUMN calendar_event.follow_recurrence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.follow_recurrence IS 'Follow Recurrence';


--
-- Name: COLUMN calendar_event.start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.start IS 'Start';


--
-- Name: COLUMN calendar_event.stop; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.stop IS 'Stop';


--
-- Name: COLUMN calendar_event.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_event.duration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.duration IS 'Duration';


--
-- Name: COLUMN calendar_event.appointment_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.appointment_type_id IS 'Appointment';


--
-- Name: COLUMN calendar_event.appointment_invite_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.appointment_invite_id IS 'Appointment Invitation';


--
-- Name: COLUMN calendar_event.appointment_booker_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.appointment_booker_id IS 'Person who is booking the appointment';


--
-- Name: COLUMN calendar_event.appointment_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.appointment_status IS 'Appointment Status';


--
-- Name: COLUMN calendar_event.opportunity_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.opportunity_id IS 'Opportunity';


--
-- Name: COLUMN calendar_event.google_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.google_id IS 'Google Calendar Event Id';


--
-- Name: COLUMN calendar_event.need_sync; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.need_sync IS 'Need Sync';


--
-- Name: COLUMN calendar_event.guests_readonly; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event.guests_readonly IS 'Guests Event Modification Permission';


--
-- Name: calendar_event_hr_appraisal_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.calendar_event_hr_appraisal_rel (
    hr_appraisal_id integer NOT NULL,
    calendar_event_id integer NOT NULL
);


--
-- Name: TABLE calendar_event_hr_appraisal_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.calendar_event_hr_appraisal_rel IS 'RELATION BETWEEN hr_appraisal AND calendar_event';


--
-- Name: calendar_event_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.calendar_event_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: calendar_event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.calendar_event_id_seq OWNED BY public.calendar_event.id;


--
-- Name: calendar_event_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.calendar_event_res_partner_rel (
    res_partner_id integer NOT NULL,
    calendar_event_id integer NOT NULL
);


--
-- Name: TABLE calendar_event_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.calendar_event_res_partner_rel IS 'RELATION BETWEEN res_partner AND calendar_event';


--
-- Name: calendar_event_type; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.calendar_event_type (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE calendar_event_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.calendar_event_type IS 'Event Meeting Type';


--
-- Name: COLUMN calendar_event_type.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event_type.color IS 'Color';


--
-- Name: COLUMN calendar_event_type.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event_type.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event_type.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event_type.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event_type.name IS 'Name';


--
-- Name: COLUMN calendar_event_type.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event_type.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event_type.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_event_type.write_date IS 'Last Updated on';


--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.calendar_event_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.calendar_event_type_id_seq OWNED BY public.calendar_event_type.id;


--
-- Name: calendar_filters; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.calendar_filters (
    id integer NOT NULL,
    user_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    partner_checked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE calendar_filters; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.calendar_filters IS 'Calendar Filters';


--
-- Name: COLUMN calendar_filters.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_filters.user_id IS 'Me';


--
-- Name: COLUMN calendar_filters.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_filters.partner_id IS 'Employee';


--
-- Name: COLUMN calendar_filters.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_filters.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_filters.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_filters.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_filters.active IS 'Active';


--
-- Name: COLUMN calendar_filters.partner_checked; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_filters.partner_checked IS 'Checked';


--
-- Name: COLUMN calendar_filters.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_filters.create_date IS 'Created on';


--
-- Name: COLUMN calendar_filters.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_filters.write_date IS 'Last Updated on';


--
-- Name: calendar_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.calendar_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: calendar_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.calendar_filters_id_seq OWNED BY public.calendar_filters.id;


--
-- Name: calendar_popover_delete_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.calendar_popover_delete_wizard (
    id integer NOT NULL,
    record integer,
    create_uid integer,
    write_uid integer,
    delete character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE calendar_popover_delete_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.calendar_popover_delete_wizard IS 'Calendar Popover Delete Wizard';


--
-- Name: COLUMN calendar_popover_delete_wizard.record; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.record IS 'Calendar Event';


--
-- Name: COLUMN calendar_popover_delete_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_popover_delete_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_popover_delete_wizard.delete; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.delete IS 'Delete';


--
-- Name: COLUMN calendar_popover_delete_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.create_date IS 'Created on';


--
-- Name: COLUMN calendar_popover_delete_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.write_date IS 'Last Updated on';


--
-- Name: calendar_popover_delete_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.calendar_popover_delete_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: calendar_popover_delete_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.calendar_popover_delete_wizard_id_seq OWNED BY public.calendar_popover_delete_wizard.id;


--
-- Name: calendar_provider_config; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.calendar_provider_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    external_calendar_provider character varying,
    cal_client_id character varying,
    cal_client_secret character varying,
    microsoft_outlook_client_identifier character varying,
    microsoft_outlook_client_secret character varying,
    cal_sync_paused boolean,
    microsoft_outlook_sync_paused boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE calendar_provider_config; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.calendar_provider_config IS 'Calendar Provider Configuration Wizard';


--
-- Name: COLUMN calendar_provider_config.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_provider_config.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_provider_config.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_provider_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_provider_config.external_calendar_provider; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_provider_config.external_calendar_provider IS 'Choose an external calendar to configure';


--
-- Name: COLUMN calendar_provider_config.cal_client_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_provider_config.cal_client_id IS 'Google Client_id';


--
-- Name: COLUMN calendar_provider_config.cal_client_secret; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_provider_config.cal_client_secret IS 'Google Client_key';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_client_identifier; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_client_identifier IS 'Outlook Client Id';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_client_secret; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_client_secret IS 'Outlook Client Secret';


--
-- Name: COLUMN calendar_provider_config.cal_sync_paused; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_provider_config.cal_sync_paused IS 'Google Synchronization Paused';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_sync_paused; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_sync_paused IS 'Outlook Synchronization Paused';


--
-- Name: COLUMN calendar_provider_config.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_provider_config.create_date IS 'Created on';


--
-- Name: COLUMN calendar_provider_config.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_provider_config.write_date IS 'Last Updated on';


--
-- Name: calendar_provider_config_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.calendar_provider_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: calendar_provider_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.calendar_provider_config_id_seq OWNED BY public.calendar_provider_config.id;


--
-- Name: calendar_recurrence; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.calendar_recurrence (
    id integer NOT NULL,
    base_event_id integer,
    "interval" integer,
    count integer,
    day integer,
    trigger_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    event_tz character varying,
    rrule character varying,
    rrule_type character varying,
    end_type character varying,
    month_by character varying,
    weekday character varying,
    byday character varying,
    until date,
    mon boolean,
    tue boolean,
    wed boolean,
    thu boolean,
    fri boolean,
    sat boolean,
    sun boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    google_id character varying,
    need_sync boolean,
    active boolean,
    CONSTRAINT calendar_recurrence_month_day CHECK ((((rrule_type)::text <> 'monthly'::text) OR ((month_by)::text <> 'day'::text) OR ((day >= 1) AND (day <= 31)) OR (((weekday)::text = ANY ((ARRAY['MON'::character varying, 'TUE'::character varying, 'WED'::character varying, 'THU'::character varying, 'FRI'::character varying, 'SAT'::character varying, 'SUN'::character varying])::text[])) AND ((byday)::text = ANY ((ARRAY['1'::character varying, '2'::character varying, '3'::character varying, '4'::character varying, '-1'::character varying])::text[])))))
);


--
-- Name: TABLE calendar_recurrence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.calendar_recurrence IS 'Event Recurrence Rule';


--
-- Name: COLUMN calendar_recurrence.base_event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.base_event_id IS 'Base Event';


--
-- Name: COLUMN calendar_recurrence."interval"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence."interval" IS 'Interval';


--
-- Name: COLUMN calendar_recurrence.count; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.count IS 'Count';


--
-- Name: COLUMN calendar_recurrence.day; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.day IS 'Day';


--
-- Name: COLUMN calendar_recurrence.trigger_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.trigger_id IS 'Trigger';


--
-- Name: COLUMN calendar_recurrence.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_recurrence.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_recurrence.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.name IS 'Name';


--
-- Name: COLUMN calendar_recurrence.event_tz; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.event_tz IS 'Timezone';


--
-- Name: COLUMN calendar_recurrence.rrule; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.rrule IS 'Rrule';


--
-- Name: COLUMN calendar_recurrence.rrule_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.rrule_type IS 'Rrule Type';


--
-- Name: COLUMN calendar_recurrence.end_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.end_type IS 'End Type';


--
-- Name: COLUMN calendar_recurrence.month_by; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.month_by IS 'Month By';


--
-- Name: COLUMN calendar_recurrence.weekday; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.weekday IS 'Weekday';


--
-- Name: COLUMN calendar_recurrence.byday; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.byday IS 'By day';


--
-- Name: COLUMN calendar_recurrence.until; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.until IS 'Repeat Until';


--
-- Name: COLUMN calendar_recurrence.mon; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.mon IS 'Mon';


--
-- Name: COLUMN calendar_recurrence.tue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.tue IS 'Tue';


--
-- Name: COLUMN calendar_recurrence.wed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.wed IS 'Wed';


--
-- Name: COLUMN calendar_recurrence.thu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.thu IS 'Thu';


--
-- Name: COLUMN calendar_recurrence.fri; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.fri IS 'Fri';


--
-- Name: COLUMN calendar_recurrence.sat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.sat IS 'Sat';


--
-- Name: COLUMN calendar_recurrence.sun; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.sun IS 'Sun';


--
-- Name: COLUMN calendar_recurrence.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.create_date IS 'Created on';


--
-- Name: COLUMN calendar_recurrence.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_recurrence.google_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.google_id IS 'Google Calendar Id';


--
-- Name: COLUMN calendar_recurrence.need_sync; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.need_sync IS 'Need Sync';


--
-- Name: COLUMN calendar_recurrence.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.calendar_recurrence.active IS 'Active';


--
-- Name: CONSTRAINT calendar_recurrence_month_day ON calendar_recurrence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT calendar_recurrence_month_day ON public.calendar_recurrence IS 'CHECK (rrule_type != ''monthly'' OR month_by != ''day'' OR day >= 1 AND day <= 31 OR weekday in (''MON'', ''TUE'', ''WED'', ''THU'', ''FRI'', ''SAT'', ''SUN'') AND byday in (''1'', ''2'', ''3'', ''4'', ''-1''))';


--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.calendar_recurrence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.calendar_recurrence_id_seq OWNED BY public.calendar_recurrence.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: change_production_qty; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.change_production_qty (
    id integer NOT NULL,
    mo_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    product_qty numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE change_production_qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.change_production_qty IS 'Change Production Qty';


--
-- Name: COLUMN change_production_qty.mo_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_production_qty.mo_id IS 'Manufacturing Order';


--
-- Name: COLUMN change_production_qty.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_production_qty.create_uid IS 'Created by';


--
-- Name: COLUMN change_production_qty.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_production_qty.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_production_qty.product_qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_production_qty.product_qty IS 'Quantity To Produce';


--
-- Name: COLUMN change_production_qty.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_production_qty.create_date IS 'Created on';


--
-- Name: COLUMN change_production_qty.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_production_qty.write_date IS 'Last Updated on';


--
-- Name: change_production_qty_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.change_production_qty_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: change_production_qty_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.change_production_qty_id_seq OWNED BY public.change_production_qty.id;


--
-- Name: chat_room; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.chat_room (
    id integer NOT NULL,
    lang_id integer,
    participant_count integer,
    max_participant_reached integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    max_capacity character varying NOT NULL,
    last_activity timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE chat_room; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.chat_room IS 'Chat Room';


--
-- Name: COLUMN chat_room.lang_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chat_room.lang_id IS 'Language';


--
-- Name: COLUMN chat_room.participant_count; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chat_room.participant_count IS 'Participant count';


--
-- Name: COLUMN chat_room.max_participant_reached; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chat_room.max_participant_reached IS 'Max participant reached';


--
-- Name: COLUMN chat_room.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chat_room.create_uid IS 'Created by';


--
-- Name: COLUMN chat_room.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chat_room.write_uid IS 'Last Updated by';


--
-- Name: COLUMN chat_room.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chat_room.name IS 'Room Name';


--
-- Name: COLUMN chat_room.max_capacity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chat_room.max_capacity IS 'Max capacity';


--
-- Name: COLUMN chat_room.last_activity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chat_room.last_activity IS 'Last Activity';


--
-- Name: COLUMN chat_room.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chat_room.create_date IS 'Created on';


--
-- Name: COLUMN chat_room.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chat_room.write_date IS 'Last Updated on';


--
-- Name: chat_room_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.chat_room_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: chat_room_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.chat_room_id_seq OWNED BY public.chat_room.id;


--
-- Name: chatbot_message; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.chatbot_message (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    discuss_channel_id integer NOT NULL,
    script_step_id integer NOT NULL,
    user_script_answer_id integer,
    create_uid integer,
    write_uid integer,
    user_raw_answer text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE chatbot_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.chatbot_message IS 'Chatbot Message';


--
-- Name: COLUMN chatbot_message.mail_message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_message.mail_message_id IS 'Related Mail Message';


--
-- Name: COLUMN chatbot_message.discuss_channel_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_message.discuss_channel_id IS 'Discussion Channel';


--
-- Name: COLUMN chatbot_message.script_step_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_message.script_step_id IS 'Chatbot Step';


--
-- Name: COLUMN chatbot_message.user_script_answer_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_message.user_script_answer_id IS 'User''s answer';


--
-- Name: COLUMN chatbot_message.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_message.create_uid IS 'Created by';


--
-- Name: COLUMN chatbot_message.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN chatbot_message.user_raw_answer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_message.user_raw_answer IS 'User''s raw answer';


--
-- Name: COLUMN chatbot_message.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_message.create_date IS 'Created on';


--
-- Name: COLUMN chatbot_message.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_message.write_date IS 'Last Updated on';


--
-- Name: chatbot_message_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.chatbot_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: chatbot_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.chatbot_message_id_seq OWNED BY public.chatbot_message.id;


--
-- Name: chatbot_script; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.chatbot_script (
    id integer NOT NULL,
    source_id integer NOT NULL,
    operator_partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    title jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE chatbot_script; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.chatbot_script IS 'Chatbot Script';


--
-- Name: COLUMN chatbot_script.source_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script.source_id IS 'Source';


--
-- Name: COLUMN chatbot_script.operator_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script.operator_partner_id IS 'Bot Operator';


--
-- Name: COLUMN chatbot_script.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script.create_uid IS 'Created by';


--
-- Name: COLUMN chatbot_script.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script.write_uid IS 'Last Updated by';


--
-- Name: COLUMN chatbot_script.title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script.title IS 'Title';


--
-- Name: COLUMN chatbot_script.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script.active IS 'Active';


--
-- Name: COLUMN chatbot_script.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script.create_date IS 'Created on';


--
-- Name: COLUMN chatbot_script.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script.write_date IS 'Last Updated on';


--
-- Name: chatbot_script_answer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.chatbot_script_answer (
    id integer NOT NULL,
    sequence integer,
    script_step_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    redirect_link character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE chatbot_script_answer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.chatbot_script_answer IS 'Chatbot Script Answer';


--
-- Name: COLUMN chatbot_script_answer.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_answer.sequence IS 'Sequence';


--
-- Name: COLUMN chatbot_script_answer.script_step_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_answer.script_step_id IS 'Script Step';


--
-- Name: COLUMN chatbot_script_answer.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_answer.create_uid IS 'Created by';


--
-- Name: COLUMN chatbot_script_answer.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_answer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN chatbot_script_answer.redirect_link; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_answer.redirect_link IS 'Redirect Link';


--
-- Name: COLUMN chatbot_script_answer.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_answer.name IS 'Answer';


--
-- Name: COLUMN chatbot_script_answer.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_answer.create_date IS 'Created on';


--
-- Name: COLUMN chatbot_script_answer.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_answer.write_date IS 'Last Updated on';


--
-- Name: chatbot_script_answer_chatbot_script_step_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.chatbot_script_answer_chatbot_script_step_rel (
    chatbot_script_step_id integer NOT NULL,
    chatbot_script_answer_id integer NOT NULL
);


--
-- Name: TABLE chatbot_script_answer_chatbot_script_step_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.chatbot_script_answer_chatbot_script_step_rel IS 'RELATION BETWEEN chatbot_script_step AND chatbot_script_answer';


--
-- Name: chatbot_script_answer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.chatbot_script_answer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: chatbot_script_answer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.chatbot_script_answer_id_seq OWNED BY public.chatbot_script_answer.id;


--
-- Name: chatbot_script_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.chatbot_script_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: chatbot_script_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.chatbot_script_id_seq OWNED BY public.chatbot_script.id;


--
-- Name: chatbot_script_step; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.chatbot_script_step (
    id integer NOT NULL,
    sequence integer,
    chatbot_script_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    step_type character varying NOT NULL,
    message jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    crm_team_id integer,
    helpdesk_team_id integer
);


--
-- Name: TABLE chatbot_script_step; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.chatbot_script_step IS 'Chatbot Script Step';


--
-- Name: COLUMN chatbot_script_step.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_step.sequence IS 'Sequence';


--
-- Name: COLUMN chatbot_script_step.chatbot_script_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_step.chatbot_script_id IS 'Chatbot';


--
-- Name: COLUMN chatbot_script_step.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_step.create_uid IS 'Created by';


--
-- Name: COLUMN chatbot_script_step.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_step.write_uid IS 'Last Updated by';


--
-- Name: COLUMN chatbot_script_step.step_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_step.step_type IS 'Step Type';


--
-- Name: COLUMN chatbot_script_step.message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_step.message IS 'Message';


--
-- Name: COLUMN chatbot_script_step.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_step.create_date IS 'Created on';


--
-- Name: COLUMN chatbot_script_step.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_step.write_date IS 'Last Updated on';


--
-- Name: COLUMN chatbot_script_step.crm_team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_step.crm_team_id IS 'Sales Team';


--
-- Name: COLUMN chatbot_script_step.helpdesk_team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.chatbot_script_step.helpdesk_team_id IS 'Helpdesk Team';


--
-- Name: chatbot_script_step_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.chatbot_script_step_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: chatbot_script_step_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.chatbot_script_step_id_seq OWNED BY public.chatbot_script_step.id;


--
-- Name: choose_delivery_carrier; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.choose_delivery_carrier (
    id integer NOT NULL,
    order_id integer NOT NULL,
    carrier_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    weight_uom_name character varying,
    delivery_message text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    delivery_price double precision,
    display_price double precision
);


--
-- Name: TABLE choose_delivery_carrier; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.choose_delivery_carrier IS 'Delivery Carrier Selection Wizard';


--
-- Name: COLUMN choose_delivery_carrier.order_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_carrier.order_id IS 'Order';


--
-- Name: COLUMN choose_delivery_carrier.carrier_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_carrier.carrier_id IS 'Shipping Method';


--
-- Name: COLUMN choose_delivery_carrier.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_carrier.create_uid IS 'Created by';


--
-- Name: COLUMN choose_delivery_carrier.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_carrier.write_uid IS 'Last Updated by';


--
-- Name: COLUMN choose_delivery_carrier.weight_uom_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_carrier.weight_uom_name IS 'Weight Uom Name';


--
-- Name: COLUMN choose_delivery_carrier.delivery_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_carrier.delivery_message IS 'Delivery Message';


--
-- Name: COLUMN choose_delivery_carrier.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_carrier.create_date IS 'Created on';


--
-- Name: COLUMN choose_delivery_carrier.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_carrier.write_date IS 'Last Updated on';


--
-- Name: COLUMN choose_delivery_carrier.delivery_price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_carrier.delivery_price IS 'Delivery Price';


--
-- Name: COLUMN choose_delivery_carrier.display_price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_carrier.display_price IS 'Cost';


--
-- Name: choose_delivery_carrier_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.choose_delivery_carrier_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: choose_delivery_carrier_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.choose_delivery_carrier_id_seq OWNED BY public.choose_delivery_carrier.id;


--
-- Name: choose_delivery_package; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.choose_delivery_package (
    id integer NOT NULL,
    picking_id integer,
    delivery_package_type_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    shipping_weight double precision
);


--
-- Name: TABLE choose_delivery_package; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.choose_delivery_package IS 'Delivery Package Selection Wizard';


--
-- Name: COLUMN choose_delivery_package.picking_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_package.picking_id IS 'Picking';


--
-- Name: COLUMN choose_delivery_package.delivery_package_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_package.delivery_package_type_id IS 'Delivery Package Type';


--
-- Name: COLUMN choose_delivery_package.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_package.create_uid IS 'Created by';


--
-- Name: COLUMN choose_delivery_package.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_package.write_uid IS 'Last Updated by';


--
-- Name: COLUMN choose_delivery_package.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_package.create_date IS 'Created on';


--
-- Name: COLUMN choose_delivery_package.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_package.write_date IS 'Last Updated on';


--
-- Name: COLUMN choose_delivery_package.shipping_weight; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.choose_delivery_package.shipping_weight IS 'Shipping Weight';


--
-- Name: choose_delivery_package_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.choose_delivery_package_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: choose_delivery_package_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.choose_delivery_package_id_seq OWNED BY public.choose_delivery_package.id;


--
-- Name: confirm_stock_sms; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.confirm_stock_sms (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE confirm_stock_sms; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.confirm_stock_sms IS 'Confirm Stock SMS';


--
-- Name: COLUMN confirm_stock_sms.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.confirm_stock_sms.create_uid IS 'Created by';


--
-- Name: COLUMN confirm_stock_sms.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.confirm_stock_sms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN confirm_stock_sms.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.confirm_stock_sms.create_date IS 'Created on';


--
-- Name: COLUMN confirm_stock_sms.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.confirm_stock_sms.write_date IS 'Last Updated on';


--
-- Name: confirm_stock_sms_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.confirm_stock_sms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: confirm_stock_sms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.confirm_stock_sms_id_seq OWNED BY public.confirm_stock_sms.id;


--
-- Name: crm_lead; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_lead (
    id integer NOT NULL,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    message_bounce integer,
    user_id integer,
    team_id integer,
    company_id integer,
    stage_id integer,
    color integer,
    recurring_plan integer,
    partner_id integer,
    title integer,
    lang_id integer,
    state_id integer,
    country_id integer,
    lost_reason_id integer,
    create_uid integer,
    write_uid integer,
    phone_sanitized character varying,
    email_normalized character varying,
    email_cc character varying,
    name character varying NOT NULL,
    referred character varying,
    type character varying NOT NULL,
    priority character varying,
    contact_name character varying,
    partner_name character varying,
    function character varying,
    email_from character varying,
    email_domain_criterion character varying,
    phone character varying,
    mobile character varying,
    phone_state character varying,
    email_state character varying,
    website character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    date_deadline date,
    lead_properties jsonb,
    description text,
    expected_revenue numeric,
    prorated_revenue numeric,
    recurring_revenue numeric,
    recurring_revenue_monthly numeric,
    recurring_revenue_monthly_prorated numeric,
    recurring_revenue_prorated numeric,
    active boolean,
    date_closed timestamp without time zone,
    date_automation_last timestamp without time zone,
    date_open timestamp without time zone,
    date_last_stage_update timestamp without time zone,
    date_conversion timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    day_open double precision,
    day_close double precision,
    probability double precision,
    automated_probability double precision,
    won_status character varying,
    days_to_convert double precision,
    days_exceeding_closing double precision,
    reveal_id character varying,
    iap_enrich_done boolean,
    lead_mining_request_id integer,
    event_lead_rule_id integer,
    event_id integer,
    CONSTRAINT crm_lead_check_probability CHECK (((probability >= (0)::double precision) AND (probability <= (100)::double precision)))
);


--
-- Name: TABLE crm_lead; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_lead IS 'Lead/Opportunity';


--
-- Name: COLUMN crm_lead.campaign_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.campaign_id IS 'Campaign';


--
-- Name: COLUMN crm_lead.source_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.source_id IS 'Source';


--
-- Name: COLUMN crm_lead.medium_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.medium_id IS 'Medium';


--
-- Name: COLUMN crm_lead.message_bounce; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.message_bounce IS 'Bounce';


--
-- Name: COLUMN crm_lead.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_lead.team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.company_id IS 'Company';


--
-- Name: COLUMN crm_lead.stage_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.stage_id IS 'Stage';


--
-- Name: COLUMN crm_lead.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.color IS 'Color Index';


--
-- Name: COLUMN crm_lead.recurring_plan; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.recurring_plan IS 'Recurring Plan';


--
-- Name: COLUMN crm_lead.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead.title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.title IS 'Title';


--
-- Name: COLUMN crm_lead.lang_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.lang_id IS 'Language';


--
-- Name: COLUMN crm_lead.state_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.state_id IS 'State';


--
-- Name: COLUMN crm_lead.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.country_id IS 'Country';


--
-- Name: COLUMN crm_lead.lost_reason_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.lost_reason_id IS 'Lost Reason';


--
-- Name: COLUMN crm_lead.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead.phone_sanitized; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.phone_sanitized IS 'Sanitized Number';


--
-- Name: COLUMN crm_lead.email_normalized; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN crm_lead.email_cc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.email_cc IS 'Email cc';


--
-- Name: COLUMN crm_lead.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.name IS 'Opportunity';


--
-- Name: COLUMN crm_lead.referred; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.referred IS 'Referred By';


--
-- Name: COLUMN crm_lead.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.type IS 'Type';


--
-- Name: COLUMN crm_lead.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.priority IS 'Priority';


--
-- Name: COLUMN crm_lead.contact_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.contact_name IS 'Contact Name';


--
-- Name: COLUMN crm_lead.partner_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.partner_name IS 'Company Name';


--
-- Name: COLUMN crm_lead.function; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.function IS 'Job Position';


--
-- Name: COLUMN crm_lead.email_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.email_from IS 'Email';


--
-- Name: COLUMN crm_lead.email_domain_criterion; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.email_domain_criterion IS 'Email Domain Criterion';


--
-- Name: COLUMN crm_lead.phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.phone IS 'Phone';


--
-- Name: COLUMN crm_lead.mobile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.mobile IS 'Mobile';


--
-- Name: COLUMN crm_lead.phone_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.phone_state IS 'Phone Quality';


--
-- Name: COLUMN crm_lead.email_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.email_state IS 'Email Quality';


--
-- Name: COLUMN crm_lead.website; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.website IS 'Website';


--
-- Name: COLUMN crm_lead.street; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.street IS 'Street';


--
-- Name: COLUMN crm_lead.street2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.street2 IS 'Street2';


--
-- Name: COLUMN crm_lead.zip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.zip IS 'Zip';


--
-- Name: COLUMN crm_lead.city; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.city IS 'City';


--
-- Name: COLUMN crm_lead.date_deadline; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.date_deadline IS 'Expected Closing';


--
-- Name: COLUMN crm_lead.lead_properties; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.lead_properties IS 'Properties';


--
-- Name: COLUMN crm_lead.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.description IS 'Notes';


--
-- Name: COLUMN crm_lead.expected_revenue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.expected_revenue IS 'Expected Revenue';


--
-- Name: COLUMN crm_lead.prorated_revenue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.prorated_revenue IS 'Prorated Revenue';


--
-- Name: COLUMN crm_lead.recurring_revenue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue IS 'Recurring Revenues';


--
-- Name: COLUMN crm_lead.recurring_revenue_monthly; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue_monthly IS 'Expected MRR';


--
-- Name: COLUMN crm_lead.recurring_revenue_monthly_prorated; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue_monthly_prorated IS 'Prorated MRR';


--
-- Name: COLUMN crm_lead.recurring_revenue_prorated; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue_prorated IS 'Prorated Recurring Revenues';


--
-- Name: COLUMN crm_lead.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.active IS 'Active';


--
-- Name: COLUMN crm_lead.date_closed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.date_closed IS 'Closed Date';


--
-- Name: COLUMN crm_lead.date_automation_last; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.date_automation_last IS 'Last Action';


--
-- Name: COLUMN crm_lead.date_open; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.date_open IS 'Assignment Date';


--
-- Name: COLUMN crm_lead.date_last_stage_update; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.date_last_stage_update IS 'Last Stage Update';


--
-- Name: COLUMN crm_lead.date_conversion; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.date_conversion IS 'Conversion Date';


--
-- Name: COLUMN crm_lead.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_lead.day_open; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.day_open IS 'Days to Assign';


--
-- Name: COLUMN crm_lead.day_close; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.day_close IS 'Days to Close';


--
-- Name: COLUMN crm_lead.probability; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.probability IS 'Probability';


--
-- Name: COLUMN crm_lead.automated_probability; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.automated_probability IS 'Automated Probability';


--
-- Name: COLUMN crm_lead.won_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.won_status IS 'Is Won';


--
-- Name: COLUMN crm_lead.days_to_convert; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.days_to_convert IS 'Days To Convert';


--
-- Name: COLUMN crm_lead.days_exceeding_closing; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.days_exceeding_closing IS 'Exceeded Closing Days';


--
-- Name: COLUMN crm_lead.reveal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.reveal_id IS 'Reveal ID';


--
-- Name: COLUMN crm_lead.iap_enrich_done; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.iap_enrich_done IS 'Enrichment done';


--
-- Name: COLUMN crm_lead.lead_mining_request_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.lead_mining_request_id IS 'Lead Mining Request';


--
-- Name: COLUMN crm_lead.event_lead_rule_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.event_lead_rule_id IS 'Registration Rule';


--
-- Name: COLUMN crm_lead.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead.event_id IS 'Source Event';


--
-- Name: CONSTRAINT crm_lead_check_probability ON crm_lead; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT crm_lead_check_probability ON public.crm_lead IS 'check(probability >= 0 and probability <= 100)';


--
-- Name: mail_message; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mail_message (
    id integer NOT NULL,
    parent_id integer,
    res_id integer,
    record_alias_domain_id integer,
    record_company_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    author_id integer,
    author_guest_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    subject character varying,
    model character varying,
    record_name character varying,
    message_type character varying NOT NULL,
    email_from character varying,
    message_id character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    body text,
    is_internal boolean,
    reply_to_force_new boolean,
    email_add_signature boolean,
    date timestamp without time zone,
    pinned_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE mail_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.mail_message IS 'Message';


--
-- Name: COLUMN mail_message.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_message.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_message.record_alias_domain_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.record_alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_message.record_company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.record_company_id IS 'Company';


--
-- Name: COLUMN mail_message.subtype_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_message.author_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.author_id IS 'Author';


--
-- Name: COLUMN mail_message.author_guest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.author_guest_id IS 'Guest';


--
-- Name: COLUMN mail_message.mail_server_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_message.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message.subject; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.subject IS 'Subject';


--
-- Name: COLUMN mail_message.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_message.record_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.record_name IS 'Message Record Name';


--
-- Name: COLUMN mail_message.message_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.message_type IS 'Type';


--
-- Name: COLUMN mail_message.email_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.email_from IS 'From';


--
-- Name: COLUMN mail_message.message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.message_id IS 'Message-Id';


--
-- Name: COLUMN mail_message.reply_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.email_layout_xmlid IS 'Layout';


--
-- Name: COLUMN mail_message.body; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.body IS 'Contents';


--
-- Name: COLUMN mail_message.is_internal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.is_internal IS 'Employee Only';


--
-- Name: COLUMN mail_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.reply_to_force_new IS 'No threading for answers';


--
-- Name: COLUMN mail_message.email_add_signature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.email_add_signature IS 'Email Add Signature';


--
-- Name: COLUMN mail_message.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.date IS 'Date';


--
-- Name: COLUMN mail_message.pinned_at; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.pinned_at IS 'Pinned';


--
-- Name: COLUMN mail_message.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_message.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.mail_message.write_date IS 'Last Updated on';


--
-- Name: crm_activity_report; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.crm_activity_report AS
 SELECT m.id,
    l.create_date AS lead_create_date,
    l.date_conversion,
    l.date_deadline,
    l.date_closed,
    m.subtype_id,
    m.mail_activity_type_id,
    m.author_id,
    m.date,
    m.body,
    l.id AS lead_id,
    l.user_id,
    l.team_id,
    l.country_id,
    l.company_id,
    l.stage_id,
    l.partner_id,
    l.type AS lead_type,
    l.active,
    l.won_status
   FROM (public.mail_message m
     JOIN public.crm_lead l ON ((m.res_id = l.id)))
  WHERE (((m.model)::text = 'crm.lead'::text) AND (m.mail_activity_type_id IS NOT NULL));


--
-- Name: crm_convert_lead_mass_lead_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_convert_lead_mass_lead_rel (
    crm_lead2opportunity_partner_mass_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


--
-- Name: TABLE crm_convert_lead_mass_lead_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_convert_lead_mass_lead_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner_mass AND crm_lead';


--
-- Name: crm_iap_lead_helpers; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_iap_lead_helpers (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_iap_lead_helpers; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_iap_lead_helpers IS 'Helper methods for crm_iap_mine modules';


--
-- Name: COLUMN crm_iap_lead_helpers.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_helpers.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_helpers.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_helpers.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_helpers.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_helpers.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_helpers.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_helpers.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_helpers_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_iap_lead_helpers_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_iap_lead_helpers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_iap_lead_helpers_id_seq OWNED BY public.crm_iap_lead_helpers.id;


--
-- Name: crm_iap_lead_industry; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_iap_lead_industry (
    id integer NOT NULL,
    color integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    reveal_ids character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_iap_lead_industry; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_iap_lead_industry IS 'CRM IAP Lead Industry';


--
-- Name: COLUMN crm_iap_lead_industry.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_industry.color IS 'Color Index';


--
-- Name: COLUMN crm_iap_lead_industry.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_industry.sequence IS 'Sequence';


--
-- Name: COLUMN crm_iap_lead_industry.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_industry.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_industry.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_industry.reveal_ids; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_industry.reveal_ids IS 'Reveal';


--
-- Name: COLUMN crm_iap_lead_industry.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_industry.name IS 'Industry';


--
-- Name: COLUMN crm_iap_lead_industry.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_industry.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_industry.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_industry.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_industry_crm_iap_lead_mining_request_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_iap_lead_industry_crm_iap_lead_mining_request_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    crm_iap_lead_industry_id integer NOT NULL
);


--
-- Name: TABLE crm_iap_lead_industry_crm_iap_lead_mining_request_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_iap_lead_industry_crm_iap_lead_mining_request_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND crm_iap_lead_industry';


--
-- Name: crm_iap_lead_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_iap_lead_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_iap_lead_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_iap_lead_industry_id_seq OWNED BY public.crm_iap_lead_industry.id;


--
-- Name: crm_iap_lead_mining_request; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_iap_lead_mining_request (
    id integer NOT NULL,
    lead_number integer NOT NULL,
    team_id integer,
    user_id integer,
    company_size_min integer,
    company_size_max integer,
    contact_number integer,
    preferred_role_id integer,
    seniority_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying NOT NULL,
    search_type character varying NOT NULL,
    error_type character varying,
    lead_type character varying NOT NULL,
    contact_filter_type character varying,
    filter_on_size boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_iap_lead_mining_request; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_iap_lead_mining_request IS 'CRM Lead Mining Request';


--
-- Name: COLUMN crm_iap_lead_mining_request.lead_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.lead_number IS 'Number of Leads';


--
-- Name: COLUMN crm_iap_lead_mining_request.team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_iap_lead_mining_request.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_iap_lead_mining_request.company_size_min; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.company_size_min IS 'Size';


--
-- Name: COLUMN crm_iap_lead_mining_request.company_size_max; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.company_size_max IS 'Company Size Max';


--
-- Name: COLUMN crm_iap_lead_mining_request.contact_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.contact_number IS 'Number of Contacts';


--
-- Name: COLUMN crm_iap_lead_mining_request.preferred_role_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.preferred_role_id IS 'Preferred Role';


--
-- Name: COLUMN crm_iap_lead_mining_request.seniority_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.seniority_id IS 'Seniority';


--
-- Name: COLUMN crm_iap_lead_mining_request.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_mining_request.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_mining_request.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.name IS 'Request Number';


--
-- Name: COLUMN crm_iap_lead_mining_request.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.state IS 'Status';


--
-- Name: COLUMN crm_iap_lead_mining_request.search_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.search_type IS 'Target';


--
-- Name: COLUMN crm_iap_lead_mining_request.error_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.error_type IS 'Error Type';


--
-- Name: COLUMN crm_iap_lead_mining_request.lead_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.lead_type IS 'Type';


--
-- Name: COLUMN crm_iap_lead_mining_request.contact_filter_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.contact_filter_type IS 'Filter on';


--
-- Name: COLUMN crm_iap_lead_mining_request.filter_on_size; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.filter_on_size IS 'Filter on Size';


--
-- Name: COLUMN crm_iap_lead_mining_request.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_mining_request.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_mining_request_crm_iap_lead_role_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_iap_lead_mining_request_crm_iap_lead_role_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    crm_iap_lead_role_id integer NOT NULL
);


--
-- Name: TABLE crm_iap_lead_mining_request_crm_iap_lead_role_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_iap_lead_mining_request_crm_iap_lead_role_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND crm_iap_lead_role';


--
-- Name: crm_iap_lead_mining_request_crm_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_iap_lead_mining_request_crm_tag_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    crm_tag_id integer NOT NULL
);


--
-- Name: TABLE crm_iap_lead_mining_request_crm_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_iap_lead_mining_request_crm_tag_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND crm_tag';


--
-- Name: crm_iap_lead_mining_request_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_iap_lead_mining_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_iap_lead_mining_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_iap_lead_mining_request_id_seq OWNED BY public.crm_iap_lead_mining_request.id;


--
-- Name: crm_iap_lead_mining_request_res_country_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_iap_lead_mining_request_res_country_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    res_country_id integer NOT NULL
);


--
-- Name: TABLE crm_iap_lead_mining_request_res_country_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_iap_lead_mining_request_res_country_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND res_country';


--
-- Name: crm_iap_lead_mining_request_res_country_state_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_iap_lead_mining_request_res_country_state_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


--
-- Name: TABLE crm_iap_lead_mining_request_res_country_state_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_iap_lead_mining_request_res_country_state_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND res_country_state';


--
-- Name: crm_iap_lead_role; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_iap_lead_role (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    reveal_id character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_iap_lead_role; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_iap_lead_role IS 'People Role';


--
-- Name: COLUMN crm_iap_lead_role.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_role.color IS 'Color Index';


--
-- Name: COLUMN crm_iap_lead_role.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_role.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_role.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_role.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_role.reveal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_role.reveal_id IS 'Reveal';


--
-- Name: COLUMN crm_iap_lead_role.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_role.name IS 'Role Name';


--
-- Name: COLUMN crm_iap_lead_role.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_role.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_role.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_role.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_role_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_iap_lead_role_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_iap_lead_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_iap_lead_role_id_seq OWNED BY public.crm_iap_lead_role.id;


--
-- Name: crm_iap_lead_seniority; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_iap_lead_seniority (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reveal_id character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_iap_lead_seniority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_iap_lead_seniority IS 'People Seniority';


--
-- Name: COLUMN crm_iap_lead_seniority.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_seniority.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_seniority.reveal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.reveal_id IS 'Reveal';


--
-- Name: COLUMN crm_iap_lead_seniority.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.name IS 'Name';


--
-- Name: COLUMN crm_iap_lead_seniority.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_seniority.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_seniority_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_iap_lead_seniority_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_iap_lead_seniority_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_iap_lead_seniority_id_seq OWNED BY public.crm_iap_lead_seniority.id;


--
-- Name: crm_lead2opportunity_partner; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_lead2opportunity_partner (
    id integer NOT NULL,
    lead_id integer NOT NULL,
    partner_id integer,
    user_id integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    action character varying,
    force_assignment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_lead2opportunity_partner; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_lead2opportunity_partner IS 'Convert Lead to Opportunity (not in mass)';


--
-- Name: COLUMN crm_lead2opportunity_partner.lead_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.lead_id IS 'Associated Lead';


--
-- Name: COLUMN crm_lead2opportunity_partner.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_lead2opportunity_partner.team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead2opportunity_partner.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead2opportunity_partner.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead2opportunity_partner.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.name IS 'Conversion Action';


--
-- Name: COLUMN crm_lead2opportunity_partner.action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.action IS 'Related Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner.force_assignment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.force_assignment IS 'Force assignment';


--
-- Name: COLUMN crm_lead2opportunity_partner.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead2opportunity_partner.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.write_date IS 'Last Updated on';


--
-- Name: crm_lead2opportunity_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_lead2opportunity_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_lead2opportunity_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_lead2opportunity_partner_id_seq OWNED BY public.crm_lead2opportunity_partner.id;


--
-- Name: crm_lead2opportunity_partner_mass; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_lead2opportunity_partner_mass (
    id integer NOT NULL,
    lead_id integer,
    partner_id integer,
    user_id integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    action character varying,
    force_assignment boolean,
    deduplicate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_lead2opportunity_partner_mass; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_lead2opportunity_partner_mass IS 'Convert Lead to Opportunity (in mass)';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.lead_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.lead_id IS 'Associated Lead';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.name IS 'Conversion Action';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.action IS 'Related Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.force_assignment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.force_assignment IS 'Force assignment';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.deduplicate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.deduplicate IS 'Apply deduplication';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.write_date IS 'Last Updated on';


--
-- Name: crm_lead2opportunity_partner_mass_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_lead2opportunity_partner_mass_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_lead2opportunity_partner_mass_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_lead2opportunity_partner_mass_id_seq OWNED BY public.crm_lead2opportunity_partner_mass.id;


--
-- Name: crm_lead2opportunity_partner_mass_res_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_lead2opportunity_partner_mass_res_users_rel (
    crm_lead2opportunity_partner_mass_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE crm_lead2opportunity_partner_mass_res_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_lead2opportunity_partner_mass_res_users_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner_mass AND res_users';


--
-- Name: crm_lead_convert2ticket; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_lead_convert2ticket (
    id integer NOT NULL,
    lead_id integer,
    partner_id integer,
    team_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_lead_convert2ticket; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_lead_convert2ticket IS 'Lead convert to Ticket';


--
-- Name: COLUMN crm_lead_convert2ticket.lead_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.lead_id IS 'Lead';


--
-- Name: COLUMN crm_lead_convert2ticket.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead_convert2ticket.team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.team_id IS 'Team';


--
-- Name: COLUMN crm_lead_convert2ticket.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_convert2ticket.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_convert2ticket.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_convert2ticket.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.write_date IS 'Last Updated on';


--
-- Name: crm_lead_convert2ticket_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_lead_convert2ticket_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_lead_convert2ticket_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_lead_convert2ticket_id_seq OWNED BY public.crm_lead_convert2ticket.id;


--
-- Name: crm_lead_crm_lead2opportunity_partner_mass_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_lead_crm_lead2opportunity_partner_mass_rel (
    crm_lead2opportunity_partner_mass_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


--
-- Name: TABLE crm_lead_crm_lead2opportunity_partner_mass_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_lead_crm_lead2opportunity_partner_mass_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner_mass AND crm_lead';


--
-- Name: crm_lead_crm_lead2opportunity_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_lead_crm_lead2opportunity_partner_rel (
    crm_lead2opportunity_partner_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


--
-- Name: TABLE crm_lead_crm_lead2opportunity_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_lead_crm_lead2opportunity_partner_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner AND crm_lead';


--
-- Name: crm_lead_crm_lead_lost_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_lead_crm_lead_lost_rel (
    crm_lead_lost_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


--
-- Name: TABLE crm_lead_crm_lead_lost_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_lead_crm_lead_lost_rel IS 'RELATION BETWEEN crm_lead_lost AND crm_lead';


--
-- Name: crm_lead_event_registration_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_lead_event_registration_rel (
    crm_lead_id integer NOT NULL,
    event_registration_id integer NOT NULL
);


--
-- Name: TABLE crm_lead_event_registration_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_lead_event_registration_rel IS 'RELATION BETWEEN crm_lead AND event_registration';


--
-- Name: crm_lead_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_lead_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_lead_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_lead_id_seq OWNED BY public.crm_lead.id;


--
-- Name: crm_lead_lost; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_lead_lost (
    id integer NOT NULL,
    lost_reason_id integer,
    create_uid integer,
    write_uid integer,
    lost_feedback text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_lead_lost; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_lead_lost IS 'Get Lost Reason';


--
-- Name: COLUMN crm_lead_lost.lost_reason_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_lost.lost_reason_id IS 'Lost Reason';


--
-- Name: COLUMN crm_lead_lost.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_lost.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_lost.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_lost.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_lost.lost_feedback; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_lost.lost_feedback IS 'Closing Note';


--
-- Name: COLUMN crm_lead_lost.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_lost.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_lost.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_lost.write_date IS 'Last Updated on';


--
-- Name: crm_lead_lost_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_lead_lost_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_lead_lost_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_lead_lost_id_seq OWNED BY public.crm_lead_lost.id;


--
-- Name: crm_lead_pls_update; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_lead_pls_update (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    pls_start_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_lead_pls_update; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_lead_pls_update IS 'Update the probabilities';


--
-- Name: COLUMN crm_lead_pls_update.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_pls_update.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_pls_update.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_pls_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_pls_update.pls_start_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_pls_update.pls_start_date IS 'Pls Start Date';


--
-- Name: COLUMN crm_lead_pls_update.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_pls_update.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_pls_update.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_pls_update.write_date IS 'Last Updated on';


--
-- Name: crm_lead_pls_update_crm_lead_scoring_frequency_field_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_lead_pls_update_crm_lead_scoring_frequency_field_rel (
    crm_lead_pls_update_id integer NOT NULL,
    crm_lead_scoring_frequency_field_id integer NOT NULL
);


--
-- Name: TABLE crm_lead_pls_update_crm_lead_scoring_frequency_field_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_lead_pls_update_crm_lead_scoring_frequency_field_rel IS 'RELATION BETWEEN crm_lead_pls_update AND crm_lead_scoring_frequency_field';


--
-- Name: crm_lead_pls_update_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_lead_pls_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_lead_pls_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_lead_pls_update_id_seq OWNED BY public.crm_lead_pls_update.id;


--
-- Name: crm_lead_scoring_frequency; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_lead_scoring_frequency (
    id integer NOT NULL,
    team_id integer,
    create_uid integer,
    write_uid integer,
    variable character varying,
    value character varying,
    won_count numeric,
    lost_count numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_lead_scoring_frequency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_lead_scoring_frequency IS 'Lead Scoring Frequency';


--
-- Name: COLUMN crm_lead_scoring_frequency.team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead_scoring_frequency.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_scoring_frequency.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_scoring_frequency.variable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.variable IS 'Variable';


--
-- Name: COLUMN crm_lead_scoring_frequency.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.value IS 'Value';


--
-- Name: COLUMN crm_lead_scoring_frequency.won_count; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.won_count IS 'Won Count';


--
-- Name: COLUMN crm_lead_scoring_frequency.lost_count; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.lost_count IS 'Lost Count';


--
-- Name: COLUMN crm_lead_scoring_frequency.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_scoring_frequency.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.write_date IS 'Last Updated on';


--
-- Name: crm_lead_scoring_frequency_field; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_lead_scoring_frequency_field (
    id integer NOT NULL,
    field_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_lead_scoring_frequency_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_lead_scoring_frequency_field IS 'Fields that can be used for predictive lead scoring computation';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.field_id IS 'Field';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.write_date IS 'Last Updated on';


--
-- Name: crm_lead_scoring_frequency_field_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_lead_scoring_frequency_field_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_lead_scoring_frequency_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_lead_scoring_frequency_field_id_seq OWNED BY public.crm_lead_scoring_frequency_field.id;


--
-- Name: crm_lead_scoring_frequency_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_lead_scoring_frequency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_lead_scoring_frequency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_lead_scoring_frequency_id_seq OWNED BY public.crm_lead_scoring_frequency.id;


--
-- Name: crm_lead_website_visitor_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_lead_website_visitor_rel (
    crm_lead_id integer NOT NULL,
    website_visitor_id integer NOT NULL
);


--
-- Name: TABLE crm_lead_website_visitor_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_lead_website_visitor_rel IS 'RELATION BETWEEN crm_lead AND website_visitor';


--
-- Name: crm_lost_reason; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_lost_reason (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_lost_reason; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_lost_reason IS 'Opp. Lost Reason';


--
-- Name: COLUMN crm_lost_reason.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lost_reason.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lost_reason.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lost_reason.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lost_reason.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lost_reason.name IS 'Description';


--
-- Name: COLUMN crm_lost_reason.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lost_reason.active IS 'Active';


--
-- Name: COLUMN crm_lost_reason.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lost_reason.create_date IS 'Created on';


--
-- Name: COLUMN crm_lost_reason.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_lost_reason.write_date IS 'Last Updated on';


--
-- Name: crm_lost_reason_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_lost_reason_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_lost_reason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_lost_reason_id_seq OWNED BY public.crm_lost_reason.id;


--
-- Name: crm_merge_opportunity; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_merge_opportunity (
    id integer NOT NULL,
    user_id integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_merge_opportunity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_merge_opportunity IS 'Merge Opportunities';


--
-- Name: COLUMN crm_merge_opportunity.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_merge_opportunity.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_merge_opportunity.team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_merge_opportunity.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_merge_opportunity.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_merge_opportunity.create_uid IS 'Created by';


--
-- Name: COLUMN crm_merge_opportunity.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_merge_opportunity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_merge_opportunity.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_merge_opportunity.create_date IS 'Created on';


--
-- Name: COLUMN crm_merge_opportunity.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_merge_opportunity.write_date IS 'Last Updated on';


--
-- Name: crm_merge_opportunity_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_merge_opportunity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_merge_opportunity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_merge_opportunity_id_seq OWNED BY public.crm_merge_opportunity.id;


--
-- Name: crm_quotation_partner; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_quotation_partner (
    id integer NOT NULL,
    lead_id integer NOT NULL,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    action character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_quotation_partner; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_quotation_partner IS 'Create new or use existing Customer on new Quotation';


--
-- Name: COLUMN crm_quotation_partner.lead_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_quotation_partner.lead_id IS 'Associated Lead';


--
-- Name: COLUMN crm_quotation_partner.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_quotation_partner.partner_id IS 'Customer';


--
-- Name: COLUMN crm_quotation_partner.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_quotation_partner.create_uid IS 'Created by';


--
-- Name: COLUMN crm_quotation_partner.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_quotation_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_quotation_partner.action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_quotation_partner.action IS 'Quotation Customer';


--
-- Name: COLUMN crm_quotation_partner.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_quotation_partner.create_date IS 'Created on';


--
-- Name: COLUMN crm_quotation_partner.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_quotation_partner.write_date IS 'Last Updated on';


--
-- Name: crm_quotation_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_quotation_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_quotation_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_quotation_partner_id_seq OWNED BY public.crm_quotation_partner.id;


--
-- Name: crm_recurring_plan; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_recurring_plan (
    id integer NOT NULL,
    number_of_months integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT crm_recurring_plan_check_number_of_months CHECK ((number_of_months >= 0))
);


--
-- Name: TABLE crm_recurring_plan; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_recurring_plan IS 'CRM Recurring revenue plans';


--
-- Name: COLUMN crm_recurring_plan.number_of_months; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_recurring_plan.number_of_months IS '# Months';


--
-- Name: COLUMN crm_recurring_plan.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_recurring_plan.sequence IS 'Sequence';


--
-- Name: COLUMN crm_recurring_plan.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_recurring_plan.create_uid IS 'Created by';


--
-- Name: COLUMN crm_recurring_plan.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_recurring_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_recurring_plan.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_recurring_plan.name IS 'Plan Name';


--
-- Name: COLUMN crm_recurring_plan.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_recurring_plan.active IS 'Active';


--
-- Name: COLUMN crm_recurring_plan.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_recurring_plan.create_date IS 'Created on';


--
-- Name: COLUMN crm_recurring_plan.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_recurring_plan.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT crm_recurring_plan_check_number_of_months ON crm_recurring_plan; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT crm_recurring_plan_check_number_of_months ON public.crm_recurring_plan IS 'CHECK(number_of_months >= 0)';


--
-- Name: crm_recurring_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_recurring_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_recurring_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_recurring_plan_id_seq OWNED BY public.crm_recurring_plan.id;


--
-- Name: crm_stage; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_stage (
    id integer NOT NULL,
    sequence integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    requirements text,
    is_won boolean,
    fold boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_stage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_stage IS 'CRM Stages';


--
-- Name: COLUMN crm_stage.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_stage.sequence IS 'Sequence';


--
-- Name: COLUMN crm_stage.team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_stage.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_stage.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_stage.create_uid IS 'Created by';


--
-- Name: COLUMN crm_stage.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_stage.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_stage.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_stage.name IS 'Stage Name';


--
-- Name: COLUMN crm_stage.requirements; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_stage.requirements IS 'Requirements';


--
-- Name: COLUMN crm_stage.is_won; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_stage.is_won IS 'Is Won Stage?';


--
-- Name: COLUMN crm_stage.fold; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_stage.fold IS 'Folded in Pipeline';


--
-- Name: COLUMN crm_stage.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_stage.create_date IS 'Created on';


--
-- Name: COLUMN crm_stage.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_stage.write_date IS 'Last Updated on';


--
-- Name: crm_stage_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_stage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_stage_id_seq OWNED BY public.crm_stage.id;


--
-- Name: crm_tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE crm_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_tag IS 'CRM Tag';


--
-- Name: COLUMN crm_tag.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_tag.color IS 'Color';


--
-- Name: COLUMN crm_tag.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_tag.create_uid IS 'Created by';


--
-- Name: COLUMN crm_tag.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_tag.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_tag.name IS 'Tag Name';


--
-- Name: COLUMN crm_tag.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_tag.create_date IS 'Created on';


--
-- Name: COLUMN crm_tag.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_tag.write_date IS 'Last Updated on';


--
-- Name: crm_tag_event_lead_rule_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_tag_event_lead_rule_rel (
    event_lead_rule_id integer NOT NULL,
    crm_tag_id integer NOT NULL
);


--
-- Name: TABLE crm_tag_event_lead_rule_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_tag_event_lead_rule_rel IS 'RELATION BETWEEN event_lead_rule AND crm_tag';


--
-- Name: crm_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_tag_id_seq OWNED BY public.crm_tag.id;


--
-- Name: crm_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_tag_rel (
    lead_id integer NOT NULL,
    tag_id integer NOT NULL
);


--
-- Name: TABLE crm_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_tag_rel IS 'RELATION BETWEEN crm_lead AND crm_tag';


--
-- Name: crm_team; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_team (
    id integer NOT NULL,
    sequence integer,
    company_id integer,
    user_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    alias_id integer NOT NULL,
    assignment_domain character varying,
    lead_properties_definition jsonb,
    use_leads boolean,
    use_opportunities boolean,
    assignment_optout boolean,
    invoiced_target double precision
);


--
-- Name: TABLE crm_team; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_team IS 'Sales Team';


--
-- Name: COLUMN crm_team.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.sequence IS 'Sequence';


--
-- Name: COLUMN crm_team.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.company_id IS 'Company';


--
-- Name: COLUMN crm_team.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.user_id IS 'Team Leader';


--
-- Name: COLUMN crm_team.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.color IS 'Color Index';


--
-- Name: COLUMN crm_team.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.name IS 'Sales Team';


--
-- Name: COLUMN crm_team.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.active IS 'Active';


--
-- Name: COLUMN crm_team.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.create_date IS 'Created on';


--
-- Name: COLUMN crm_team.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_team.alias_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.alias_id IS 'Alias';


--
-- Name: COLUMN crm_team.assignment_domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.assignment_domain IS 'Assignment Domain';


--
-- Name: COLUMN crm_team.lead_properties_definition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.lead_properties_definition IS 'Lead Properties';


--
-- Name: COLUMN crm_team.use_leads; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.use_leads IS 'Leads';


--
-- Name: COLUMN crm_team.use_opportunities; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.use_opportunities IS 'Pipeline';


--
-- Name: COLUMN crm_team.assignment_optout; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.assignment_optout IS 'Skip auto assignment';


--
-- Name: COLUMN crm_team.invoiced_target; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team.invoiced_target IS 'Invoicing Target';


--
-- Name: crm_team_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_team_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_team_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_team_id_seq OWNED BY public.crm_team.id;


--
-- Name: crm_team_member; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.crm_team_member (
    id integer NOT NULL,
    crm_team_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    assignment_max integer,
    assignment_domain character varying,
    assignment_optout boolean
);


--
-- Name: TABLE crm_team_member; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.crm_team_member IS 'Sales Team Member';


--
-- Name: COLUMN crm_team_member.crm_team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team_member.crm_team_id IS 'Sales Team';


--
-- Name: COLUMN crm_team_member.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team_member.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_team_member.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team_member.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team_member.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team_member.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team_member.active IS 'Active';


--
-- Name: COLUMN crm_team_member.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team_member.create_date IS 'Created on';


--
-- Name: COLUMN crm_team_member.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team_member.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_team_member.assignment_max; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team_member.assignment_max IS 'Average Leads Capacity (on 30 days)';


--
-- Name: COLUMN crm_team_member.assignment_domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team_member.assignment_domain IS 'Assignment Domain';


--
-- Name: COLUMN crm_team_member.assignment_optout; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.crm_team_member.assignment_optout IS 'Skip auto assignment';


--
-- Name: crm_team_member_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.crm_team_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: crm_team_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.crm_team_member_id_seq OWNED BY public.crm_team_member.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: delivery_carrier; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.delivery_carrier (
    id integer NOT NULL,
    sequence integer,
    company_id integer,
    product_id integer NOT NULL,
    shipping_insurance integer,
    create_uid integer,
    write_uid integer,
    delivery_type character varying NOT NULL,
    integration_level character varying,
    tracking_url character varying,
    invoice_policy character varying NOT NULL,
    name jsonb NOT NULL,
    carrier_description jsonb,
    active boolean,
    prod_environment boolean,
    debug_logging boolean,
    free_over boolean,
    return_label_on_delivery boolean,
    get_return_label_from_portal boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_weight double precision,
    max_volume double precision,
    margin double precision,
    fixed_margin double precision,
    amount double precision,
    fixed_price double precision,
    website_id integer,
    is_published boolean,
    CONSTRAINT delivery_carrier_margin_not_under_100_percent CHECK ((margin >= ('-1'::integer)::double precision)),
    CONSTRAINT delivery_carrier_shipping_insurance_is_percentage CHECK (((shipping_insurance >= 0) AND (shipping_insurance <= 100)))
);


--
-- Name: TABLE delivery_carrier; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.delivery_carrier IS 'Shipping Methods';


--
-- Name: COLUMN delivery_carrier.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.sequence IS 'Sequence';


--
-- Name: COLUMN delivery_carrier.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.company_id IS 'Company';


--
-- Name: COLUMN delivery_carrier.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.product_id IS 'Delivery Product';


--
-- Name: COLUMN delivery_carrier.shipping_insurance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.shipping_insurance IS 'Insurance Percentage';


--
-- Name: COLUMN delivery_carrier.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.create_uid IS 'Created by';


--
-- Name: COLUMN delivery_carrier.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.write_uid IS 'Last Updated by';


--
-- Name: COLUMN delivery_carrier.delivery_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.delivery_type IS 'Provider';


--
-- Name: COLUMN delivery_carrier.integration_level; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.integration_level IS 'Integration Level';


--
-- Name: COLUMN delivery_carrier.tracking_url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.tracking_url IS 'Tracking Link';


--
-- Name: COLUMN delivery_carrier.invoice_policy; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.invoice_policy IS 'Invoicing Policy';


--
-- Name: COLUMN delivery_carrier.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.name IS 'Delivery Method';


--
-- Name: COLUMN delivery_carrier.carrier_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.carrier_description IS 'Carrier Description';


--
-- Name: COLUMN delivery_carrier.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.active IS 'Active';


--
-- Name: COLUMN delivery_carrier.prod_environment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.prod_environment IS 'Environment';


--
-- Name: COLUMN delivery_carrier.debug_logging; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.debug_logging IS 'Debug logging';


--
-- Name: COLUMN delivery_carrier.free_over; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.free_over IS 'Free if order amount is above';


--
-- Name: COLUMN delivery_carrier.return_label_on_delivery; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.return_label_on_delivery IS 'Generate Return Label';


--
-- Name: COLUMN delivery_carrier.get_return_label_from_portal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.get_return_label_from_portal IS 'Return Label Accessible from Customer Portal';


--
-- Name: COLUMN delivery_carrier.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.create_date IS 'Created on';


--
-- Name: COLUMN delivery_carrier.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.write_date IS 'Last Updated on';


--
-- Name: COLUMN delivery_carrier.max_weight; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.max_weight IS 'Max Weight';


--
-- Name: COLUMN delivery_carrier.max_volume; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.max_volume IS 'Max Volume';


--
-- Name: COLUMN delivery_carrier.margin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.margin IS 'Margin';


--
-- Name: COLUMN delivery_carrier.fixed_margin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.fixed_margin IS 'Fixed Margin';


--
-- Name: COLUMN delivery_carrier.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.amount IS 'Amount';


--
-- Name: COLUMN delivery_carrier.fixed_price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.fixed_price IS 'Fixed Price';


--
-- Name: COLUMN delivery_carrier.website_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.website_id IS 'Website';


--
-- Name: COLUMN delivery_carrier.is_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_carrier.is_published IS 'Is Published';


--
-- Name: CONSTRAINT delivery_carrier_margin_not_under_100_percent ON delivery_carrier; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT delivery_carrier_margin_not_under_100_percent ON public.delivery_carrier IS 'CHECK (margin >= -1)';


--
-- Name: CONSTRAINT delivery_carrier_shipping_insurance_is_percentage ON delivery_carrier; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT delivery_carrier_shipping_insurance_is_percentage ON public.delivery_carrier IS 'CHECK(shipping_insurance >= 0 AND shipping_insurance <= 100)';


--
-- Name: delivery_carrier_country_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.delivery_carrier_country_rel (
    carrier_id integer NOT NULL,
    country_id integer NOT NULL
);


--
-- Name: TABLE delivery_carrier_country_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.delivery_carrier_country_rel IS 'RELATION BETWEEN delivery_carrier AND res_country';


--
-- Name: delivery_carrier_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.delivery_carrier_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: delivery_carrier_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.delivery_carrier_id_seq OWNED BY public.delivery_carrier.id;


--
-- Name: delivery_carrier_state_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.delivery_carrier_state_rel (
    carrier_id integer NOT NULL,
    state_id integer NOT NULL
);


--
-- Name: TABLE delivery_carrier_state_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.delivery_carrier_state_rel IS 'RELATION BETWEEN delivery_carrier AND res_country_state';


--
-- Name: delivery_price_rule; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.delivery_price_rule (
    id integer NOT NULL,
    sequence integer NOT NULL,
    carrier_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    variable character varying NOT NULL,
    operator character varying NOT NULL,
    variable_factor character varying NOT NULL,
    list_base_price numeric NOT NULL,
    list_price numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_value double precision NOT NULL
);


--
-- Name: TABLE delivery_price_rule; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.delivery_price_rule IS 'Delivery Price Rules';


--
-- Name: COLUMN delivery_price_rule.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_price_rule.sequence IS 'Sequence';


--
-- Name: COLUMN delivery_price_rule.carrier_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_price_rule.carrier_id IS 'Carrier';


--
-- Name: COLUMN delivery_price_rule.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_price_rule.create_uid IS 'Created by';


--
-- Name: COLUMN delivery_price_rule.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_price_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN delivery_price_rule.variable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_price_rule.variable IS 'Variable';


--
-- Name: COLUMN delivery_price_rule.operator; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_price_rule.operator IS 'Operator';


--
-- Name: COLUMN delivery_price_rule.variable_factor; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_price_rule.variable_factor IS 'Variable Factor';


--
-- Name: COLUMN delivery_price_rule.list_base_price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_price_rule.list_base_price IS 'Sale Base Price';


--
-- Name: COLUMN delivery_price_rule.list_price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_price_rule.list_price IS 'Sale Price';


--
-- Name: COLUMN delivery_price_rule.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_price_rule.create_date IS 'Created on';


--
-- Name: COLUMN delivery_price_rule.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_price_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN delivery_price_rule.max_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_price_rule.max_value IS 'Maximum Value';


--
-- Name: delivery_price_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.delivery_price_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: delivery_price_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.delivery_price_rule_id_seq OWNED BY public.delivery_price_rule.id;


--
-- Name: delivery_zip_prefix; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.delivery_zip_prefix (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE delivery_zip_prefix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.delivery_zip_prefix IS 'Delivery Zip Prefix';


--
-- Name: COLUMN delivery_zip_prefix.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_zip_prefix.create_uid IS 'Created by';


--
-- Name: COLUMN delivery_zip_prefix.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_zip_prefix.write_uid IS 'Last Updated by';


--
-- Name: COLUMN delivery_zip_prefix.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_zip_prefix.name IS 'Prefix';


--
-- Name: COLUMN delivery_zip_prefix.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_zip_prefix.create_date IS 'Created on';


--
-- Name: COLUMN delivery_zip_prefix.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.delivery_zip_prefix.write_date IS 'Last Updated on';


--
-- Name: delivery_zip_prefix_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.delivery_zip_prefix_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: delivery_zip_prefix_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.delivery_zip_prefix_id_seq OWNED BY public.delivery_zip_prefix.id;


--
-- Name: delivery_zip_prefix_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.delivery_zip_prefix_rel (
    carrier_id integer NOT NULL,
    zip_prefix_id integer NOT NULL
);


--
-- Name: TABLE delivery_zip_prefix_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.delivery_zip_prefix_rel IS 'RELATION BETWEEN delivery_carrier AND delivery_zip_prefix';


--
-- Name: digest_digest; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.digest_digest (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    periodicity character varying NOT NULL,
    state character varying,
    next_run_date date,
    name jsonb NOT NULL,
    kpi_res_users_connected boolean,
    kpi_mail_message_total boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    kpi_account_total_revenue boolean,
    kpi_crm_lead_created boolean,
    kpi_crm_opportunities_won boolean,
    kpi_project_task_opened boolean,
    kpi_account_bank_cash boolean,
    kpi_all_sale_total boolean,
    kpi_website_sale_total boolean,
    kpi_helpdesk_tickets_closed boolean,
    kpi_livechat_rating boolean,
    kpi_livechat_conversations boolean,
    kpi_livechat_response boolean
);


--
-- Name: TABLE digest_digest; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.digest_digest IS 'Digest';


--
-- Name: COLUMN digest_digest.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.company_id IS 'Company';


--
-- Name: COLUMN digest_digest.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.create_uid IS 'Created by';


--
-- Name: COLUMN digest_digest.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_digest.periodicity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.periodicity IS 'Periodicity';


--
-- Name: COLUMN digest_digest.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.state IS 'Status';


--
-- Name: COLUMN digest_digest.next_run_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.next_run_date IS 'Next Mailing Date';


--
-- Name: COLUMN digest_digest.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.name IS 'Name';


--
-- Name: COLUMN digest_digest.kpi_res_users_connected; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_res_users_connected IS 'Connected Users';


--
-- Name: COLUMN digest_digest.kpi_mail_message_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_mail_message_total IS 'Messages Sent';


--
-- Name: COLUMN digest_digest.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.create_date IS 'Created on';


--
-- Name: COLUMN digest_digest.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.write_date IS 'Last Updated on';


--
-- Name: COLUMN digest_digest.kpi_account_total_revenue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_account_total_revenue IS 'Revenue';


--
-- Name: COLUMN digest_digest.kpi_crm_lead_created; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_crm_lead_created IS 'New Leads';


--
-- Name: COLUMN digest_digest.kpi_crm_opportunities_won; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_crm_opportunities_won IS 'Opportunities Won';


--
-- Name: COLUMN digest_digest.kpi_project_task_opened; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_project_task_opened IS 'Open Tasks';


--
-- Name: COLUMN digest_digest.kpi_account_bank_cash; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_account_bank_cash IS 'Bank & Cash Moves';


--
-- Name: COLUMN digest_digest.kpi_all_sale_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_all_sale_total IS 'All Sales';


--
-- Name: COLUMN digest_digest.kpi_website_sale_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_website_sale_total IS 'eCommerce Sales';


--
-- Name: COLUMN digest_digest.kpi_helpdesk_tickets_closed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_helpdesk_tickets_closed IS 'Tickets Closed';


--
-- Name: COLUMN digest_digest.kpi_livechat_rating; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_livechat_rating IS '% of Happiness';


--
-- Name: COLUMN digest_digest.kpi_livechat_conversations; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_livechat_conversations IS 'Conversations handled';


--
-- Name: COLUMN digest_digest.kpi_livechat_response; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_digest.kpi_livechat_response IS 'Time to answer (sec)';


--
-- Name: digest_digest_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.digest_digest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: digest_digest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.digest_digest_id_seq OWNED BY public.digest_digest.id;


--
-- Name: digest_digest_res_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.digest_digest_res_users_rel (
    digest_digest_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE digest_digest_res_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.digest_digest_res_users_rel IS 'RELATION BETWEEN digest_digest AND res_users';


--
-- Name: digest_tip; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.digest_tip (
    id integer NOT NULL,
    sequence integer,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb,
    tip_description jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE digest_tip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.digest_tip IS 'Digest Tips';


--
-- Name: COLUMN digest_tip.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_tip.sequence IS 'Sequence';


--
-- Name: COLUMN digest_tip.group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_tip.group_id IS 'Authorized Group';


--
-- Name: COLUMN digest_tip.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_tip.create_uid IS 'Created by';


--
-- Name: COLUMN digest_tip.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_tip.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_tip.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_tip.name IS 'Name';


--
-- Name: COLUMN digest_tip.tip_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_tip.tip_description IS 'Tip description';


--
-- Name: COLUMN digest_tip.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_tip.create_date IS 'Created on';


--
-- Name: COLUMN digest_tip.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.digest_tip.write_date IS 'Last Updated on';


--
-- Name: digest_tip_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.digest_tip_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: digest_tip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.digest_tip_id_seq OWNED BY public.digest_tip.id;


--
-- Name: digest_tip_res_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.digest_tip_res_users_rel (
    digest_tip_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE digest_tip_res_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.digest_tip_res_users_rel IS 'RELATION BETWEEN digest_tip AND res_users';


--
-- Name: discuss_channel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.discuss_channel (
    id integer NOT NULL,
    parent_channel_id integer,
    from_message_id integer,
    group_public_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    channel_type character varying NOT NULL,
    default_display_mode character varying,
    sfu_channel_uuid character varying,
    sfu_server_url character varying,
    uuid character varying(50),
    description text,
    active boolean,
    allow_public_upload boolean,
    last_interest_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    livechat_channel_id integer,
    livechat_operator_id integer,
    chatbot_current_step_id integer,
    country_id integer,
    anonymous_name character varying,
    livechat_active boolean,
    rating_last_value double precision,
    livechat_visitor_id integer,
    CONSTRAINT discuss_channel_channel_type_not_null CHECK ((channel_type IS NOT NULL)),
    CONSTRAINT discuss_channel_group_public_id_check CHECK ((((channel_type)::text = 'channel'::text) OR (group_public_id IS NULL))),
    CONSTRAINT discuss_channel_livechat_operator_id CHECK (((((channel_type)::text = 'livechat'::text) AND (livechat_operator_id IS NOT NULL)) OR ((channel_type)::text <> 'livechat'::text))),
    CONSTRAINT discuss_channel_sub_channel_no_group_public_id CHECK (((parent_channel_id IS NULL) OR (group_public_id IS NULL)))
);


--
-- Name: TABLE discuss_channel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.discuss_channel IS 'Discussion Channel';


--
-- Name: COLUMN discuss_channel.parent_channel_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.parent_channel_id IS 'Parent Channel';


--
-- Name: COLUMN discuss_channel.from_message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.from_message_id IS 'From Message';


--
-- Name: COLUMN discuss_channel.group_public_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.group_public_id IS 'Authorized Group';


--
-- Name: COLUMN discuss_channel.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.name IS 'Name';


--
-- Name: COLUMN discuss_channel.channel_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.channel_type IS 'Channel Type';


--
-- Name: COLUMN discuss_channel.default_display_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.default_display_mode IS 'Default Display Mode';


--
-- Name: COLUMN discuss_channel.sfu_channel_uuid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.sfu_channel_uuid IS 'Sfu Channel Uuid';


--
-- Name: COLUMN discuss_channel.sfu_server_url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.sfu_server_url IS 'Sfu Server Url';


--
-- Name: COLUMN discuss_channel.uuid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.uuid IS 'UUID';


--
-- Name: COLUMN discuss_channel.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.description IS 'Description';


--
-- Name: COLUMN discuss_channel.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.active IS 'Active';


--
-- Name: COLUMN discuss_channel.allow_public_upload; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.allow_public_upload IS 'Allow Public Upload';


--
-- Name: COLUMN discuss_channel.last_interest_dt; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.write_date IS 'Last Updated on';


--
-- Name: COLUMN discuss_channel.livechat_channel_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.livechat_channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel.livechat_operator_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.livechat_operator_id IS 'Operator';


--
-- Name: COLUMN discuss_channel.chatbot_current_step_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.chatbot_current_step_id IS 'Chatbot Current Step';


--
-- Name: COLUMN discuss_channel.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.country_id IS 'Country';


--
-- Name: COLUMN discuss_channel.anonymous_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.anonymous_name IS 'Anonymous Name';


--
-- Name: COLUMN discuss_channel.livechat_active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.livechat_active IS 'Is livechat ongoing?';


--
-- Name: COLUMN discuss_channel.rating_last_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.rating_last_value IS 'Rating Last Value';


--
-- Name: COLUMN discuss_channel.livechat_visitor_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel.livechat_visitor_id IS 'Visitor';


--
-- Name: CONSTRAINT discuss_channel_channel_type_not_null ON discuss_channel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT discuss_channel_channel_type_not_null ON public.discuss_channel IS 'CHECK(channel_type IS NOT NULL)';


--
-- Name: CONSTRAINT discuss_channel_group_public_id_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT discuss_channel_group_public_id_check ON public.discuss_channel IS 'CHECK (channel_type = ''channel'' OR group_public_id IS NULL)';


--
-- Name: CONSTRAINT discuss_channel_livechat_operator_id ON discuss_channel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT discuss_channel_livechat_operator_id ON public.discuss_channel IS 'CHECK((channel_type = ''livechat'' and livechat_operator_id is not null) or (channel_type != ''livechat''))';


--
-- Name: CONSTRAINT discuss_channel_sub_channel_no_group_public_id ON discuss_channel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT discuss_channel_sub_channel_no_group_public_id ON public.discuss_channel IS 'CHECK(parent_channel_id IS NULL OR group_public_id IS NULL)';


--
-- Name: discuss_channel_hr_department_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.discuss_channel_hr_department_rel (
    discuss_channel_id integer NOT NULL,
    hr_department_id integer NOT NULL
);


--
-- Name: TABLE discuss_channel_hr_department_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.discuss_channel_hr_department_rel IS 'RELATION BETWEEN discuss_channel AND hr_department';


--
-- Name: discuss_channel_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.discuss_channel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: discuss_channel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.discuss_channel_id_seq OWNED BY public.discuss_channel.id;


--
-- Name: discuss_channel_member; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.discuss_channel_member (
    id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    channel_id integer NOT NULL,
    fetched_message_id integer,
    seen_message_id integer,
    new_message_separator integer NOT NULL,
    rtc_inviting_session_id integer,
    create_uid integer,
    write_uid integer,
    custom_channel_name character varying,
    fold_state character varying,
    custom_notifications character varying,
    mute_until_dt timestamp without time zone,
    unpin_dt timestamp without time zone,
    last_interest_dt timestamp without time zone,
    last_seen_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_channel_member_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


--
-- Name: TABLE discuss_channel_member; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.discuss_channel_member IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_member.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_member.guest_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.guest_id IS 'Guest';


--
-- Name: COLUMN discuss_channel_member.channel_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_member.fetched_message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.fetched_message_id IS 'Last Fetched';


--
-- Name: COLUMN discuss_channel_member.seen_message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.seen_message_id IS 'Last Seen';


--
-- Name: COLUMN discuss_channel_member.new_message_separator; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.new_message_separator IS 'New Message Separator';


--
-- Name: COLUMN discuss_channel_member.rtc_inviting_session_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.rtc_inviting_session_id IS 'Ringing session';


--
-- Name: COLUMN discuss_channel_member.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_member.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_member.custom_channel_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.custom_channel_name IS 'Custom channel name';


--
-- Name: COLUMN discuss_channel_member.fold_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.fold_state IS 'Conversation Fold State';


--
-- Name: COLUMN discuss_channel_member.custom_notifications; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.custom_notifications IS 'Customized Notifications';


--
-- Name: COLUMN discuss_channel_member.mute_until_dt; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.mute_until_dt IS 'Mute notifications until';


--
-- Name: COLUMN discuss_channel_member.unpin_dt; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.unpin_dt IS 'Unpin date';


--
-- Name: COLUMN discuss_channel_member.last_interest_dt; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel_member.last_seen_dt; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.last_seen_dt IS 'Last seen date';


--
-- Name: COLUMN discuss_channel_member.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel_member.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_member.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_channel_member_partner_or_guest_exists ON discuss_channel_member; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT discuss_channel_member_partner_or_guest_exists ON public.discuss_channel_member IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.discuss_channel_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.discuss_channel_member_id_seq OWNED BY public.discuss_channel_member.id;


--
-- Name: discuss_channel_res_groups_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.discuss_channel_res_groups_rel (
    discuss_channel_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


--
-- Name: TABLE discuss_channel_res_groups_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.discuss_channel_res_groups_rel IS 'RELATION BETWEEN discuss_channel AND res_groups';


--
-- Name: discuss_channel_rtc_session; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.discuss_channel_rtc_session (
    id integer NOT NULL,
    channel_member_id integer NOT NULL,
    channel_id integer,
    create_uid integer,
    write_uid integer,
    is_screen_sharing_on boolean,
    is_camera_on boolean,
    is_muted boolean,
    is_deaf boolean,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


--
-- Name: TABLE discuss_channel_rtc_session; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.discuss_channel_rtc_session IS 'Mail RTC session';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_member_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_member_id IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_rtc_session.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_rtc_session.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_rtc_session.is_screen_sharing_on; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_screen_sharing_on IS 'Is sharing the screen';


--
-- Name: COLUMN discuss_channel_rtc_session.is_camera_on; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_camera_on IS 'Is sending user video';


--
-- Name: COLUMN discuss_channel_rtc_session.is_muted; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_muted IS 'Is microphone muted';


--
-- Name: COLUMN discuss_channel_rtc_session.is_deaf; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_deaf IS 'Has disabled incoming sound';


--
-- Name: COLUMN discuss_channel_rtc_session.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_date IS 'Last Updated On';


--
-- Name: COLUMN discuss_channel_rtc_session.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_date IS 'Created on';


--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.discuss_channel_rtc_session_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNED BY public.discuss_channel_rtc_session.id;


--
-- Name: discuss_gif_favorite; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.discuss_gif_favorite (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tenor_gif_id character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE discuss_gif_favorite; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.discuss_gif_favorite IS 'Save favorite GIF from Tenor API';


--
-- Name: COLUMN discuss_gif_favorite.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_gif_favorite.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_gif_favorite.tenor_gif_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_gif_favorite.tenor_gif_id IS 'GIF id from Tenor';


--
-- Name: COLUMN discuss_gif_favorite.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_date IS 'Created on';


--
-- Name: COLUMN discuss_gif_favorite.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_date IS 'Last Updated on';


--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.discuss_gif_favorite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNED BY public.discuss_gif_favorite.id;


--
-- Name: discuss_voice_metadata; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.discuss_voice_metadata (
    id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE discuss_voice_metadata; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.discuss_voice_metadata IS 'Metadata for voice attachments';


--
-- Name: COLUMN discuss_voice_metadata.attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_voice_metadata.attachment_id IS 'Attachment';


--
-- Name: COLUMN discuss_voice_metadata.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_voice_metadata.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_voice_metadata.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_date IS 'Created on';


--
-- Name: COLUMN discuss_voice_metadata.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_date IS 'Last Updated on';


--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.discuss_voice_metadata_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNED BY public.discuss_voice_metadata.id;


--
-- Name: dms_acc_rep_export_wizard_format_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.dms_acc_rep_export_wizard_format_rel (
    account_reports_export_wizard_id integer NOT NULL,
    account_reports_export_wizard_format_id integer NOT NULL
);


--
-- Name: TABLE dms_acc_rep_export_wizard_format_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.dms_acc_rep_export_wizard_format_rel IS 'RELATION BETWEEN account_reports_export_wizard AND account_reports_export_wizard_format';


--
-- Name: document_alias_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.document_alias_tag_rel (
    documents_document_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


--
-- Name: TABLE document_alias_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.document_alias_tag_rel IS 'RELATION BETWEEN documents_document AND documents_tag';


--
-- Name: document_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.document_tag_rel (
    documents_document_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


--
-- Name: TABLE document_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.document_tag_rel IS 'RELATION BETWEEN documents_document AND documents_tag';


--
-- Name: documents_access; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.documents_access (
    id integer NOT NULL,
    document_id integer NOT NULL,
    partner_id integer NOT NULL,
    role character varying,
    last_access_date timestamp without time zone,
    expiration_date timestamp without time zone,
    CONSTRAINT documents_access_role_or_last_access_date CHECK (((role IS NOT NULL) OR (last_access_date IS NOT NULL)))
);


--
-- Name: TABLE documents_access; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.documents_access IS 'Document / Partner';


--
-- Name: COLUMN documents_access.document_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_access.document_id IS 'Document';


--
-- Name: COLUMN documents_access.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_access.partner_id IS 'Partner';


--
-- Name: COLUMN documents_access.role; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_access.role IS 'Role';


--
-- Name: COLUMN documents_access.last_access_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_access.last_access_date IS 'Last Accessed On';


--
-- Name: COLUMN documents_access.expiration_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_access.expiration_date IS 'Expiration';


--
-- Name: CONSTRAINT documents_access_role_or_last_access_date ON documents_access; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT documents_access_role_or_last_access_date ON public.documents_access IS 'check (role IS NOT NULL or last_access_date IS NOT NULL)';


--
-- Name: documents_access_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.documents_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: documents_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.documents_access_id_seq OWNED BY public.documents_access.id;


--
-- Name: documents_account_folder_setting; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.documents_account_folder_setting (
    id integer NOT NULL,
    company_id integer NOT NULL,
    journal_id integer NOT NULL,
    folder_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE documents_account_folder_setting; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.documents_account_folder_setting IS 'Journal and Folder settings';


--
-- Name: COLUMN documents_account_folder_setting.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_account_folder_setting.company_id IS 'Company';


--
-- Name: COLUMN documents_account_folder_setting.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_account_folder_setting.journal_id IS 'Journal';


--
-- Name: COLUMN documents_account_folder_setting.folder_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_account_folder_setting.folder_id IS 'Workspace';


--
-- Name: COLUMN documents_account_folder_setting.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_account_folder_setting.create_uid IS 'Created by';


--
-- Name: COLUMN documents_account_folder_setting.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_account_folder_setting.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_account_folder_setting.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_account_folder_setting.create_date IS 'Created on';


--
-- Name: COLUMN documents_account_folder_setting.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_account_folder_setting.write_date IS 'Last Updated on';


--
-- Name: documents_account_folder_setting_documents_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.documents_account_folder_setting_documents_tag_rel (
    documents_account_folder_setting_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


--
-- Name: TABLE documents_account_folder_setting_documents_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.documents_account_folder_setting_documents_tag_rel IS 'RELATION BETWEEN documents_account_folder_setting AND documents_tag';


--
-- Name: documents_account_folder_setting_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.documents_account_folder_setting_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: documents_account_folder_setting_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.documents_account_folder_setting_id_seq OWNED BY public.documents_account_folder_setting.id;


--
-- Name: documents_document; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.documents_document (
    id integer NOT NULL,
    alias_id integer NOT NULL,
    attachment_id integer,
    file_size integer,
    res_id integer,
    shortcut_document_id integer,
    partner_id integer,
    owner_id integer NOT NULL,
    lock_uid integer,
    request_activity_id integer,
    requestee_partner_id integer,
    folder_id integer,
    company_id integer,
    create_activity_type_id integer,
    create_activity_date_deadline_range integer,
    create_activity_user_id integer,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    file_extension character varying,
    res_model character varying,
    name character varying,
    thumbnail_status character varying,
    url character varying(1024),
    url_preview_image character varying,
    type character varying NOT NULL,
    document_token character varying NOT NULL,
    access_via_link character varying NOT NULL,
    access_internal character varying NOT NULL,
    parent_path character varying,
    create_activity_summary character varying,
    create_activity_date_deadline_range_type character varying,
    create_activity_note text,
    is_editable_attachment boolean,
    is_multipage boolean,
    active boolean,
    is_access_via_link_hidden boolean,
    is_pinned_folder boolean,
    create_activity_option boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    handler character varying,
    website_id integer,
    has_embedded_pdf boolean,
    CONSTRAINT documents_document_folder_id_not_id CHECK ((folder_id <> id)),
    CONSTRAINT documents_document_frozen_spreadsheet_access_via_link__52cdd6ea CHECK ((((handler)::text <> 'frozen_spreadsheet'::text) OR (((access_via_link)::text <> 'edit'::text) AND ((access_internal)::text <> 'edit'::text)))),
    CONSTRAINT documents_document_shortcut_document_id_not_id CHECK ((shortcut_document_id <> id)),
    CONSTRAINT documents_document_spreadsheet_access_via_link CHECK ((((handler)::text <> 'spreadsheet'::text) OR ((access_via_link)::text <> 'edit'::text)))
);


--
-- Name: TABLE documents_document; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.documents_document IS 'Document';


--
-- Name: COLUMN documents_document.alias_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.alias_id IS 'Alias';


--
-- Name: COLUMN documents_document.attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.attachment_id IS 'Attachment';


--
-- Name: COLUMN documents_document.file_size; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.file_size IS 'File Size';


--
-- Name: COLUMN documents_document.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.res_id IS 'Resource ID';


--
-- Name: COLUMN documents_document.shortcut_document_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.shortcut_document_id IS 'Source Document';


--
-- Name: COLUMN documents_document.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.partner_id IS 'Contact';


--
-- Name: COLUMN documents_document.owner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.owner_id IS 'Owner';


--
-- Name: COLUMN documents_document.lock_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.lock_uid IS 'Locked by';


--
-- Name: COLUMN documents_document.request_activity_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.request_activity_id IS 'Request Activity';


--
-- Name: COLUMN documents_document.requestee_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.requestee_partner_id IS 'Requestee Partner';


--
-- Name: COLUMN documents_document.folder_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.folder_id IS 'Parent Folder';


--
-- Name: COLUMN documents_document.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.company_id IS 'Company';


--
-- Name: COLUMN documents_document.create_activity_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.create_activity_type_id IS 'Activity type';


--
-- Name: COLUMN documents_document.create_activity_date_deadline_range; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.create_activity_date_deadline_range IS 'Due Date In';


--
-- Name: COLUMN documents_document.create_activity_user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.create_activity_user_id IS 'Responsible';


--
-- Name: COLUMN documents_document.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.create_uid IS 'Created by';


--
-- Name: COLUMN documents_document.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_document.email_cc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.email_cc IS 'Email cc';


--
-- Name: COLUMN documents_document.file_extension; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.file_extension IS 'File Extension';


--
-- Name: COLUMN documents_document.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.res_model IS 'Resource Model';


--
-- Name: COLUMN documents_document.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.name IS 'Name';


--
-- Name: COLUMN documents_document.thumbnail_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.thumbnail_status IS 'Thumbnail Status';


--
-- Name: COLUMN documents_document.url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.url IS 'Link URL';


--
-- Name: COLUMN documents_document.url_preview_image; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.url_preview_image IS 'URL Preview Image';


--
-- Name: COLUMN documents_document.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.type IS 'Type';


--
-- Name: COLUMN documents_document.document_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.document_token IS 'Document Token';


--
-- Name: COLUMN documents_document.access_via_link; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.access_via_link IS 'Link Access Rights';


--
-- Name: COLUMN documents_document.access_internal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.access_internal IS 'Internal Users Rights';


--
-- Name: COLUMN documents_document.parent_path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.parent_path IS 'Parent Path';


--
-- Name: COLUMN documents_document.create_activity_summary; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.create_activity_summary IS 'Summary';


--
-- Name: COLUMN documents_document.create_activity_date_deadline_range_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.create_activity_date_deadline_range_type IS 'Due type';


--
-- Name: COLUMN documents_document.create_activity_note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.create_activity_note IS 'Note';


--
-- Name: COLUMN documents_document.is_editable_attachment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.is_editable_attachment IS 'Is Editable Attachment';


--
-- Name: COLUMN documents_document.is_multipage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.is_multipage IS 'Is considered multipage';


--
-- Name: COLUMN documents_document.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.active IS 'Active';


--
-- Name: COLUMN documents_document.is_access_via_link_hidden; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.is_access_via_link_hidden IS 'Link Access Hidden';


--
-- Name: COLUMN documents_document.is_pinned_folder; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.is_pinned_folder IS 'Pinned to Company roots';


--
-- Name: COLUMN documents_document.create_activity_option; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.create_activity_option IS 'Create a new activity';


--
-- Name: COLUMN documents_document.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.create_date IS 'Created on';


--
-- Name: COLUMN documents_document.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.write_date IS 'Last Updated on';


--
-- Name: COLUMN documents_document.handler; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.handler IS 'Handler';


--
-- Name: COLUMN documents_document.website_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.website_id IS 'Website';


--
-- Name: COLUMN documents_document.has_embedded_pdf; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_document.has_embedded_pdf IS 'Has Embedded PDF';


--
-- Name: CONSTRAINT documents_document_folder_id_not_id ON documents_document; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT documents_document_folder_id_not_id ON public.documents_document IS 'check(folder_id <> id)';


--
-- Name: CONSTRAINT documents_document_frozen_spreadsheet_access_via_link__52cdd6ea ON documents_document; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT documents_document_frozen_spreadsheet_access_via_link__52cdd6ea ON public.documents_document IS 'CHECK((handler != ''frozen_spreadsheet'') OR (access_via_link != ''edit'' AND access_internal != ''edit''))';


--
-- Name: CONSTRAINT documents_document_shortcut_document_id_not_id ON documents_document; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT documents_document_shortcut_document_id_not_id ON public.documents_document IS 'check(shortcut_document_id <> id)';


--
-- Name: CONSTRAINT documents_document_spreadsheet_access_via_link ON documents_document; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT documents_document_spreadsheet_access_via_link ON public.documents_document IS 'CHECK((handler != ''spreadsheet'') OR access_via_link != ''edit'')';


--
-- Name: documents_document_documents_link_to_record_wizard_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.documents_document_documents_link_to_record_wizard_rel (
    documents_link_to_record_wizard_id integer NOT NULL,
    documents_document_id integer NOT NULL
);


--
-- Name: TABLE documents_document_documents_link_to_record_wizard_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.documents_document_documents_link_to_record_wizard_rel IS 'RELATION BETWEEN documents_link_to_record_wizard AND documents_document';


--
-- Name: documents_document_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.documents_document_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: documents_document_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.documents_document_id_seq OWNED BY public.documents_document.id;


--
-- Name: documents_document_ir_attachment_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.documents_document_ir_attachment_rel (
    documents_document_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


--
-- Name: TABLE documents_document_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.documents_document_ir_attachment_rel IS 'RELATION BETWEEN documents_document AND ir_attachment';


--
-- Name: documents_document_res_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.documents_document_res_users_rel (
    documents_document_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE documents_document_res_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.documents_document_res_users_rel IS 'RELATION BETWEEN documents_document AND res_users';


--
-- Name: documents_link_to_record_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.documents_link_to_record_wizard (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    resource_ref character varying,
    is_readonly_model boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE documents_link_to_record_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.documents_link_to_record_wizard IS 'Documents Link to Record';


--
-- Name: COLUMN documents_link_to_record_wizard.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.model_id IS 'Model';


--
-- Name: COLUMN documents_link_to_record_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN documents_link_to_record_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_link_to_record_wizard.resource_ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.resource_ref IS 'Record';


--
-- Name: COLUMN documents_link_to_record_wizard.is_readonly_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.is_readonly_model IS 'is_readonly_model';


--
-- Name: COLUMN documents_link_to_record_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.create_date IS 'Created on';


--
-- Name: COLUMN documents_link_to_record_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.write_date IS 'Last Updated on';


--
-- Name: documents_link_to_record_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.documents_link_to_record_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: documents_link_to_record_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.documents_link_to_record_wizard_id_seq OWNED BY public.documents_link_to_record_wizard.id;


--
-- Name: documents_redirect; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.documents_redirect (
    id integer NOT NULL,
    document_id integer,
    access_token character varying NOT NULL,
    employee_id integer
);


--
-- Name: TABLE documents_redirect; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.documents_redirect IS 'Document Redirect';


--
-- Name: COLUMN documents_redirect.document_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_redirect.document_id IS 'Document';


--
-- Name: COLUMN documents_redirect.access_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_redirect.access_token IS 'Access Token';


--
-- Name: COLUMN documents_redirect.employee_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_redirect.employee_id IS 'Employee';


--
-- Name: documents_redirect_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.documents_redirect_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: documents_redirect_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.documents_redirect_id_seq OWNED BY public.documents_redirect.id;


--
-- Name: documents_request_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.documents_request_wizard (
    id integer NOT NULL,
    requestee_id integer NOT NULL,
    partner_id integer,
    activity_type_id integer NOT NULL,
    folder_id integer NOT NULL,
    res_id integer,
    activity_date_deadline_range integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    activity_date_deadline_range_type character varying,
    activity_note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE documents_request_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.documents_request_wizard IS 'Document Request';


--
-- Name: COLUMN documents_request_wizard.requestee_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_request_wizard.requestee_id IS 'Owner';


--
-- Name: COLUMN documents_request_wizard.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_request_wizard.partner_id IS 'Contact';


--
-- Name: COLUMN documents_request_wizard.activity_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_request_wizard.activity_type_id IS 'Activity type';


--
-- Name: COLUMN documents_request_wizard.folder_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_request_wizard.folder_id IS 'Folder';


--
-- Name: COLUMN documents_request_wizard.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_request_wizard.res_id IS 'Resource ID';


--
-- Name: COLUMN documents_request_wizard.activity_date_deadline_range; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_request_wizard.activity_date_deadline_range IS 'Due Date In';


--
-- Name: COLUMN documents_request_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_request_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN documents_request_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_request_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_request_wizard.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_request_wizard.name IS 'Name';


--
-- Name: COLUMN documents_request_wizard.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_request_wizard.res_model IS 'Resource Model';


--
-- Name: COLUMN documents_request_wizard.activity_date_deadline_range_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_request_wizard.activity_date_deadline_range_type IS 'Due type';


--
-- Name: COLUMN documents_request_wizard.activity_note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_request_wizard.activity_note IS 'Message';


--
-- Name: COLUMN documents_request_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_request_wizard.create_date IS 'Created on';


--
-- Name: COLUMN documents_request_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_request_wizard.write_date IS 'Last Updated on';


--
-- Name: documents_request_wizard_documents_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.documents_request_wizard_documents_tag_rel (
    documents_request_wizard_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


--
-- Name: TABLE documents_request_wizard_documents_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.documents_request_wizard_documents_tag_rel IS 'RELATION BETWEEN documents_request_wizard AND documents_tag';


--
-- Name: documents_request_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.documents_request_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: documents_request_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.documents_request_wizard_id_seq OWNED BY public.documents_request_wizard.id;


--
-- Name: documents_tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.documents_tag (
    id integer NOT NULL,
    sequence integer,
    color integer,
    create_uid integer,
    write_uid integer,
    tooltip character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE documents_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.documents_tag IS 'Tag';


--
-- Name: COLUMN documents_tag.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_tag.sequence IS 'Sequence';


--
-- Name: COLUMN documents_tag.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_tag.color IS 'Color';


--
-- Name: COLUMN documents_tag.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_tag.create_uid IS 'Created by';


--
-- Name: COLUMN documents_tag.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_tag.tooltip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_tag.tooltip IS 'Tooltip';


--
-- Name: COLUMN documents_tag.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_tag.name IS 'Name';


--
-- Name: COLUMN documents_tag.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_tag.create_date IS 'Created on';


--
-- Name: COLUMN documents_tag.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.documents_tag.write_date IS 'Last Updated on';


--
-- Name: documents_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.documents_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: documents_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.documents_tag_id_seq OWNED BY public.documents_tag.id;


--
-- Name: documents_tag_mail_activity_type_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.documents_tag_mail_activity_type_rel (
    mail_activity_type_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


--
-- Name: TABLE documents_tag_mail_activity_type_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.documents_tag_mail_activity_type_rel IS 'RELATION BETWEEN mail_activity_type AND documents_tag';


--
-- Name: documents_tag_sign_template_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.documents_tag_sign_template_rel (
    sign_template_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


--
-- Name: TABLE documents_tag_sign_template_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.documents_tag_sign_template_rel IS 'RELATION BETWEEN sign_template AND documents_tag';


--
-- Name: email_template_attachment_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.email_template_attachment_rel (
    email_template_id integer NOT NULL,
    attachment_id integer NOT NULL
);


--
-- Name: TABLE email_template_attachment_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.email_template_attachment_rel IS 'RELATION BETWEEN mail_template AND ir_attachment';


--
-- Name: employee_category_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.employee_category_rel (
    employee_id integer NOT NULL,
    category_id integer NOT NULL
);


--
-- Name: TABLE employee_category_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.employee_category_rel IS 'RELATION BETWEEN hr_employee AND hr_employee_category';


--
-- Name: event_allowed_track_tags_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_allowed_track_tags_rel (
    event_event_id integer NOT NULL,
    event_track_tag_id integer NOT NULL
);


--
-- Name: TABLE event_allowed_track_tags_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_allowed_track_tags_rel IS 'RELATION BETWEEN event_event AND event_track_tag';


--
-- Name: event_booth; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_booth (
    id integer NOT NULL,
    event_type_id integer,
    booth_category_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    event_id integer NOT NULL,
    partner_id integer,
    contact_name character varying,
    contact_email character varying,
    contact_phone character varying,
    state character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sale_order_line_id integer,
    sale_order_id integer,
    is_paid boolean,
    price double precision,
    sponsor_id integer
);


--
-- Name: TABLE event_booth; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_booth IS 'Event Booth';


--
-- Name: COLUMN event_booth.event_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.event_type_id IS 'Event Category';


--
-- Name: COLUMN event_booth.booth_category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.booth_category_id IS 'Booth Category';


--
-- Name: COLUMN event_booth.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.create_uid IS 'Created by';


--
-- Name: COLUMN event_booth.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_booth.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.event_id IS 'Event';


--
-- Name: COLUMN event_booth.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.partner_id IS 'Renter';


--
-- Name: COLUMN event_booth.contact_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.contact_name IS 'Renter Name';


--
-- Name: COLUMN event_booth.contact_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.contact_email IS 'Renter Email';


--
-- Name: COLUMN event_booth.contact_phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.contact_phone IS 'Renter Phone';


--
-- Name: COLUMN event_booth.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.state IS 'Status';


--
-- Name: COLUMN event_booth.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.name IS 'Name';


--
-- Name: COLUMN event_booth.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.create_date IS 'Created on';


--
-- Name: COLUMN event_booth.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.write_date IS 'Last Updated on';


--
-- Name: COLUMN event_booth.sale_order_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.sale_order_line_id IS 'Final Sale Order Line';


--
-- Name: COLUMN event_booth.sale_order_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.sale_order_id IS 'Order Reference';


--
-- Name: COLUMN event_booth.is_paid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.is_paid IS 'Is Paid';


--
-- Name: COLUMN event_booth.price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.price IS 'Price';


--
-- Name: COLUMN event_booth.sponsor_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth.sponsor_id IS 'Sponsor';


--
-- Name: event_booth_category; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_booth_category (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_id integer NOT NULL,
    price numeric,
    sponsor_type_id integer,
    exhibitor_type character varying,
    use_sponsor boolean
);


--
-- Name: TABLE event_booth_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_booth_category IS 'Event Booth Category';


--
-- Name: COLUMN event_booth_category.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_category.sequence IS 'Sequence';


--
-- Name: COLUMN event_booth_category.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_category.create_uid IS 'Created by';


--
-- Name: COLUMN event_booth_category.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_booth_category.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_category.name IS 'Name';


--
-- Name: COLUMN event_booth_category.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_category.description IS 'Description';


--
-- Name: COLUMN event_booth_category.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_category.active IS 'Active';


--
-- Name: COLUMN event_booth_category.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_category.create_date IS 'Created on';


--
-- Name: COLUMN event_booth_category.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_category.write_date IS 'Last Updated on';


--
-- Name: COLUMN event_booth_category.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_category.product_id IS 'Product';


--
-- Name: COLUMN event_booth_category.price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_category.price IS 'Price';


--
-- Name: COLUMN event_booth_category.sponsor_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_category.sponsor_type_id IS 'Sponsor Level';


--
-- Name: COLUMN event_booth_category.exhibitor_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_category.exhibitor_type IS 'Sponsor Type';


--
-- Name: COLUMN event_booth_category.use_sponsor; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_category.use_sponsor IS 'Create Sponsor';


--
-- Name: event_booth_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_booth_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_booth_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_booth_category_id_seq OWNED BY public.event_booth_category.id;


--
-- Name: event_booth_configurator; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_booth_configurator (
    id integer NOT NULL,
    product_id integer,
    sale_order_line_id integer,
    event_id integer NOT NULL,
    event_booth_category_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_booth_configurator; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_booth_configurator IS 'Event Booth Configurator';


--
-- Name: COLUMN event_booth_configurator.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_configurator.product_id IS 'Product';


--
-- Name: COLUMN event_booth_configurator.sale_order_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_configurator.sale_order_line_id IS 'Sale Order Line';


--
-- Name: COLUMN event_booth_configurator.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_configurator.event_id IS 'Event';


--
-- Name: COLUMN event_booth_configurator.event_booth_category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_configurator.event_booth_category_id IS 'Booth Category';


--
-- Name: COLUMN event_booth_configurator.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_configurator.create_uid IS 'Created by';


--
-- Name: COLUMN event_booth_configurator.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_configurator.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_booth_configurator.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_configurator.create_date IS 'Created on';


--
-- Name: COLUMN event_booth_configurator.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_configurator.write_date IS 'Last Updated on';


--
-- Name: event_booth_configurator_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_booth_configurator_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_booth_configurator_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_booth_configurator_id_seq OWNED BY public.event_booth_configurator.id;


--
-- Name: event_booth_event_booth_configurator_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_booth_event_booth_configurator_rel (
    event_booth_configurator_id integer NOT NULL,
    event_booth_id integer NOT NULL
);


--
-- Name: TABLE event_booth_event_booth_configurator_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_booth_event_booth_configurator_rel IS 'RELATION BETWEEN event_booth_configurator AND event_booth';


--
-- Name: event_booth_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_booth_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_booth_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_booth_id_seq OWNED BY public.event_booth.id;


--
-- Name: event_booth_registration; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_booth_registration (
    id integer NOT NULL,
    sale_order_line_id integer NOT NULL,
    event_booth_id integer NOT NULL,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    contact_name character varying,
    contact_email character varying,
    contact_phone character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sponsor_name character varying,
    sponsor_email character varying,
    sponsor_mobile character varying,
    sponsor_phone character varying,
    sponsor_subtitle character varying,
    sponsor_website_description text
);


--
-- Name: TABLE event_booth_registration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_booth_registration IS 'Event Booth Registration';


--
-- Name: COLUMN event_booth_registration.sale_order_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_registration.sale_order_line_id IS 'Sale Order Line';


--
-- Name: COLUMN event_booth_registration.event_booth_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_registration.event_booth_id IS 'Booth';


--
-- Name: COLUMN event_booth_registration.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_registration.partner_id IS 'Customer';


--
-- Name: COLUMN event_booth_registration.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_registration.create_uid IS 'Created by';


--
-- Name: COLUMN event_booth_registration.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_registration.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_booth_registration.contact_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_registration.contact_name IS 'Contact Name';


--
-- Name: COLUMN event_booth_registration.contact_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_registration.contact_email IS 'Contact Email';


--
-- Name: COLUMN event_booth_registration.contact_phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_registration.contact_phone IS 'Contact Phone';


--
-- Name: COLUMN event_booth_registration.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_registration.create_date IS 'Created on';


--
-- Name: COLUMN event_booth_registration.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_registration.write_date IS 'Last Updated on';


--
-- Name: COLUMN event_booth_registration.sponsor_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_registration.sponsor_name IS 'Sponsor Name';


--
-- Name: COLUMN event_booth_registration.sponsor_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_registration.sponsor_email IS 'Sponsor Email';


--
-- Name: COLUMN event_booth_registration.sponsor_mobile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_registration.sponsor_mobile IS 'Sponsor Mobile';


--
-- Name: COLUMN event_booth_registration.sponsor_phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_registration.sponsor_phone IS 'Sponsor Phone';


--
-- Name: COLUMN event_booth_registration.sponsor_subtitle; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_registration.sponsor_subtitle IS 'Sponsor Slogan';


--
-- Name: COLUMN event_booth_registration.sponsor_website_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_booth_registration.sponsor_website_description IS 'Sponsor Description';


--
-- Name: event_booth_registration_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_booth_registration_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_booth_registration_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_booth_registration_id_seq OWNED BY public.event_booth_registration.id;


--
-- Name: event_event; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_event (
    id integer NOT NULL,
    user_id integer,
    company_id integer,
    organizer_id integer,
    event_type_id integer,
    stage_id integer,
    seats_max integer,
    address_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    kanban_state character varying,
    kanban_state_label character varying,
    date_tz character varying NOT NULL,
    lang character varying,
    badge_format character varying NOT NULL,
    name jsonb NOT NULL,
    description jsonb,
    registration_properties_definition jsonb,
    ticket_instructions jsonb,
    note text,
    active boolean,
    seats_limited boolean NOT NULL,
    date_begin timestamp without time zone NOT NULL,
    date_end timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    website_id integer,
    menu_id integer,
    website_meta_og_img character varying,
    website_visibility character varying NOT NULL,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    subtitle jsonb,
    cover_properties text,
    is_published boolean,
    website_menu boolean,
    introduction_menu boolean,
    location_menu boolean,
    register_menu boolean,
    community_menu boolean,
    booth_menu boolean,
    website_track boolean,
    website_track_proposal boolean,
    exhibitor_menu boolean,
    meeting_room_allow_creation boolean
);


--
-- Name: TABLE event_event; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_event IS 'Event';


--
-- Name: COLUMN event_event.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.user_id IS 'Responsible';


--
-- Name: COLUMN event_event.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.company_id IS 'Company';


--
-- Name: COLUMN event_event.organizer_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.organizer_id IS 'Organizer';


--
-- Name: COLUMN event_event.event_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.event_type_id IS 'Template';


--
-- Name: COLUMN event_event.stage_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.stage_id IS 'Stage';


--
-- Name: COLUMN event_event.seats_max; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.seats_max IS 'Maximum Attendees';


--
-- Name: COLUMN event_event.address_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.address_id IS 'Venue';


--
-- Name: COLUMN event_event.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.country_id IS 'Country';


--
-- Name: COLUMN event_event.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.create_uid IS 'Created by';


--
-- Name: COLUMN event_event.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_event.kanban_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.kanban_state IS 'Kanban State';


--
-- Name: COLUMN event_event.kanban_state_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.kanban_state_label IS 'Kanban State Label';


--
-- Name: COLUMN event_event.date_tz; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.date_tz IS 'Timezone';


--
-- Name: COLUMN event_event.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.lang IS 'Language';


--
-- Name: COLUMN event_event.badge_format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.badge_format IS 'Badge Dimension';


--
-- Name: COLUMN event_event.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.name IS 'Event';


--
-- Name: COLUMN event_event.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.description IS 'Description';


--
-- Name: COLUMN event_event.registration_properties_definition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.registration_properties_definition IS 'Registration Properties';


--
-- Name: COLUMN event_event.ticket_instructions; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.ticket_instructions IS 'Ticket Instructions';


--
-- Name: COLUMN event_event.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.note IS 'Note';


--
-- Name: COLUMN event_event.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.active IS 'Active';


--
-- Name: COLUMN event_event.seats_limited; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.seats_limited IS 'Limit Attendees';


--
-- Name: COLUMN event_event.date_begin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.date_begin IS 'Start Date';


--
-- Name: COLUMN event_event.date_end; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.date_end IS 'End Date';


--
-- Name: COLUMN event_event.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.create_date IS 'Created on';


--
-- Name: COLUMN event_event.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.write_date IS 'Last Updated on';


--
-- Name: COLUMN event_event.website_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.website_id IS 'Website';


--
-- Name: COLUMN event_event.menu_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.menu_id IS 'Event Menu';


--
-- Name: COLUMN event_event.website_meta_og_img; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN event_event.website_visibility; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.website_visibility IS 'Website Visibility';


--
-- Name: COLUMN event_event.website_meta_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN event_event.website_meta_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN event_event.website_meta_keywords; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN event_event.seo_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.seo_name IS 'Seo name';


--
-- Name: COLUMN event_event.subtitle; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.subtitle IS 'Event Subtitle';


--
-- Name: COLUMN event_event.cover_properties; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.cover_properties IS 'Cover Properties';


--
-- Name: COLUMN event_event.is_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.is_published IS 'Is Published';


--
-- Name: COLUMN event_event.website_menu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.website_menu IS 'Website Menu';


--
-- Name: COLUMN event_event.introduction_menu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.introduction_menu IS 'Introduction Menu';


--
-- Name: COLUMN event_event.location_menu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.location_menu IS 'Location Menu';


--
-- Name: COLUMN event_event.register_menu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.register_menu IS 'Register Menu';


--
-- Name: COLUMN event_event.community_menu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.community_menu IS 'Community Menu';


--
-- Name: COLUMN event_event.booth_menu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.booth_menu IS 'Booth Register';


--
-- Name: COLUMN event_event.website_track; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.website_track IS 'Tracks on Website';


--
-- Name: COLUMN event_event.website_track_proposal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.website_track_proposal IS 'Proposals on Website';


--
-- Name: COLUMN event_event.exhibitor_menu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.exhibitor_menu IS 'Showcase Exhibitors';


--
-- Name: COLUMN event_event.meeting_room_allow_creation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event.meeting_room_allow_creation IS 'Allow Room Creation';


--
-- Name: event_event_configurator; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_event_configurator (
    id integer NOT NULL,
    product_id integer,
    event_id integer,
    event_ticket_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_event_configurator; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_event_configurator IS 'Event Configurator';


--
-- Name: COLUMN event_event_configurator.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_configurator.product_id IS 'Product';


--
-- Name: COLUMN event_event_configurator.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_configurator.event_id IS 'Event';


--
-- Name: COLUMN event_event_configurator.event_ticket_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_configurator.event_ticket_id IS 'Ticket Type';


--
-- Name: COLUMN event_event_configurator.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_configurator.create_uid IS 'Created by';


--
-- Name: COLUMN event_event_configurator.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_configurator.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_event_configurator.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_configurator.create_date IS 'Created on';


--
-- Name: COLUMN event_event_configurator.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_configurator.write_date IS 'Last Updated on';


--
-- Name: event_event_configurator_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_event_configurator_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_event_configurator_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_event_configurator_id_seq OWNED BY public.event_event_configurator.id;


--
-- Name: event_event_event_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_event_event_tag_rel (
    event_event_id integer NOT NULL,
    event_tag_id integer NOT NULL
);


--
-- Name: TABLE event_event_event_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_event_event_tag_rel IS 'RELATION BETWEEN event_event AND event_tag';


--
-- Name: event_event_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_event_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_event_id_seq OWNED BY public.event_event.id;


--
-- Name: event_event_ticket; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_event_ticket (
    id integer NOT NULL,
    sequence integer,
    event_type_id integer,
    seats_max integer,
    create_uid integer,
    write_uid integer,
    event_id integer NOT NULL,
    color character varying,
    name jsonb NOT NULL,
    description jsonb,
    seats_limited boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    start_sale_datetime timestamp without time zone,
    end_sale_datetime timestamp without time zone,
    product_id integer NOT NULL,
    price numeric
);


--
-- Name: TABLE event_event_ticket; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_event_ticket IS 'Event Ticket';


--
-- Name: COLUMN event_event_ticket.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_ticket.sequence IS 'Sequence';


--
-- Name: COLUMN event_event_ticket.event_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_ticket.event_type_id IS 'Event Category';


--
-- Name: COLUMN event_event_ticket.seats_max; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_ticket.seats_max IS 'Maximum Attendees';


--
-- Name: COLUMN event_event_ticket.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_ticket.create_uid IS 'Created by';


--
-- Name: COLUMN event_event_ticket.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_ticket.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_event_ticket.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_ticket.event_id IS 'Event';


--
-- Name: COLUMN event_event_ticket.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_ticket.color IS 'Color';


--
-- Name: COLUMN event_event_ticket.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_ticket.name IS 'Name';


--
-- Name: COLUMN event_event_ticket.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_ticket.description IS 'Description';


--
-- Name: COLUMN event_event_ticket.seats_limited; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_ticket.seats_limited IS 'Limit Attendees';


--
-- Name: COLUMN event_event_ticket.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_ticket.create_date IS 'Created on';


--
-- Name: COLUMN event_event_ticket.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_ticket.write_date IS 'Last Updated on';


--
-- Name: COLUMN event_event_ticket.start_sale_datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_ticket.start_sale_datetime IS 'Registration Start';


--
-- Name: COLUMN event_event_ticket.end_sale_datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_ticket.end_sale_datetime IS 'Registration End';


--
-- Name: COLUMN event_event_ticket.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_ticket.product_id IS 'Product';


--
-- Name: COLUMN event_event_ticket.price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_event_ticket.price IS 'Price';


--
-- Name: event_event_ticket_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_event_ticket_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_event_ticket_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_event_ticket_id_seq OWNED BY public.event_event_ticket.id;


--
-- Name: event_lead_request; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_lead_request (
    id integer NOT NULL,
    event_id integer NOT NULL,
    processed_registration_id integer
);


--
-- Name: TABLE event_lead_request; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_lead_request IS 'Event Lead Request';


--
-- Name: COLUMN event_lead_request.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_lead_request.event_id IS 'Event';


--
-- Name: COLUMN event_lead_request.processed_registration_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_lead_request.processed_registration_id IS 'Processed Registration';


--
-- Name: event_lead_request_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_lead_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_lead_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_lead_request_id_seq OWNED BY public.event_lead_request.id;


--
-- Name: event_lead_rule; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_lead_rule (
    id integer NOT NULL,
    event_id integer,
    company_id integer,
    lead_sales_team_id integer,
    lead_user_id integer,
    create_uid integer,
    write_uid integer,
    lead_creation_basis character varying NOT NULL,
    lead_creation_trigger character varying NOT NULL,
    lead_type character varying NOT NULL,
    name jsonb NOT NULL,
    event_registration_filter text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_lead_rule; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_lead_rule IS 'Event Lead Rules';


--
-- Name: COLUMN event_lead_rule.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_lead_rule.event_id IS 'Event';


--
-- Name: COLUMN event_lead_rule.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_lead_rule.company_id IS 'Company';


--
-- Name: COLUMN event_lead_rule.lead_sales_team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_lead_rule.lead_sales_team_id IS 'Sales Team';


--
-- Name: COLUMN event_lead_rule.lead_user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_lead_rule.lead_user_id IS 'Salesperson';


--
-- Name: COLUMN event_lead_rule.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_lead_rule.create_uid IS 'Created by';


--
-- Name: COLUMN event_lead_rule.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_lead_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_lead_rule.lead_creation_basis; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_lead_rule.lead_creation_basis IS 'Create';


--
-- Name: COLUMN event_lead_rule.lead_creation_trigger; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_lead_rule.lead_creation_trigger IS 'When';


--
-- Name: COLUMN event_lead_rule.lead_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_lead_rule.lead_type IS 'Lead Type';


--
-- Name: COLUMN event_lead_rule.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_lead_rule.name IS 'Rule Name';


--
-- Name: COLUMN event_lead_rule.event_registration_filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_lead_rule.event_registration_filter IS 'Registrations Domain';


--
-- Name: COLUMN event_lead_rule.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_lead_rule.active IS 'Active';


--
-- Name: COLUMN event_lead_rule.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_lead_rule.create_date IS 'Created on';


--
-- Name: COLUMN event_lead_rule.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_lead_rule.write_date IS 'Last Updated on';


--
-- Name: event_lead_rule_event_type_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_lead_rule_event_type_rel (
    event_lead_rule_id integer NOT NULL,
    event_type_id integer NOT NULL
);


--
-- Name: TABLE event_lead_rule_event_type_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_lead_rule_event_type_rel IS 'RELATION BETWEEN event_lead_rule AND event_type';


--
-- Name: event_lead_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_lead_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_lead_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_lead_rule_id_seq OWNED BY public.event_lead_rule.id;


--
-- Name: event_mail; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_mail (
    id integer NOT NULL,
    event_id integer NOT NULL,
    sequence integer,
    interval_nbr integer,
    last_registration_id integer,
    mail_count_done integer,
    create_uid integer,
    write_uid integer,
    interval_unit character varying NOT NULL,
    interval_type character varying NOT NULL,
    template_ref character varying NOT NULL,
    mail_done boolean,
    scheduled_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_mail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_mail IS 'Event Automated Mailing';


--
-- Name: COLUMN event_mail.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail.event_id IS 'Event';


--
-- Name: COLUMN event_mail.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail.sequence IS 'Display order';


--
-- Name: COLUMN event_mail.interval_nbr; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail.interval_nbr IS 'Interval';


--
-- Name: COLUMN event_mail.last_registration_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail.last_registration_id IS 'Last Attendee';


--
-- Name: COLUMN event_mail.mail_count_done; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail.mail_count_done IS '# Sent';


--
-- Name: COLUMN event_mail.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail.create_uid IS 'Created by';


--
-- Name: COLUMN event_mail.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_mail.interval_unit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail.interval_unit IS 'Unit';


--
-- Name: COLUMN event_mail.interval_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail.interval_type IS 'Trigger ';


--
-- Name: COLUMN event_mail.template_ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail.template_ref IS 'Template';


--
-- Name: COLUMN event_mail.mail_done; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail.mail_done IS 'Sent';


--
-- Name: COLUMN event_mail.scheduled_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail.scheduled_date IS 'Schedule Date';


--
-- Name: COLUMN event_mail.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail.create_date IS 'Created on';


--
-- Name: COLUMN event_mail.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail.write_date IS 'Last Updated on';


--
-- Name: event_mail_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_mail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_mail_id_seq OWNED BY public.event_mail.id;


--
-- Name: event_mail_registration; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_mail_registration (
    id integer NOT NULL,
    scheduler_id integer NOT NULL,
    registration_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    mail_sent boolean,
    scheduled_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_mail_registration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_mail_registration IS 'Registration Mail Scheduler';


--
-- Name: COLUMN event_mail_registration.scheduler_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail_registration.scheduler_id IS 'Mail Scheduler';


--
-- Name: COLUMN event_mail_registration.registration_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail_registration.registration_id IS 'Attendee';


--
-- Name: COLUMN event_mail_registration.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail_registration.create_uid IS 'Created by';


--
-- Name: COLUMN event_mail_registration.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail_registration.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_mail_registration.mail_sent; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail_registration.mail_sent IS 'Mail Sent';


--
-- Name: COLUMN event_mail_registration.scheduled_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail_registration.scheduled_date IS 'Scheduled Time';


--
-- Name: COLUMN event_mail_registration.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail_registration.create_date IS 'Created on';


--
-- Name: COLUMN event_mail_registration.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_mail_registration.write_date IS 'Last Updated on';


--
-- Name: event_mail_registration_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_mail_registration_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_mail_registration_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_mail_registration_id_seq OWNED BY public.event_mail_registration.id;


--
-- Name: event_meeting_room; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_meeting_room (
    id integer NOT NULL,
    chat_room_id integer NOT NULL,
    event_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    summary jsonb,
    target_audience jsonb,
    is_published boolean,
    active boolean,
    is_pinned boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_meeting_room; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_meeting_room IS 'Event Meeting Room';


--
-- Name: COLUMN event_meeting_room.chat_room_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_meeting_room.chat_room_id IS 'Chat Room';


--
-- Name: COLUMN event_meeting_room.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_meeting_room.event_id IS 'Event';


--
-- Name: COLUMN event_meeting_room.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_meeting_room.create_uid IS 'Created by';


--
-- Name: COLUMN event_meeting_room.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_meeting_room.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_meeting_room.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_meeting_room.name IS 'Topic';


--
-- Name: COLUMN event_meeting_room.summary; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_meeting_room.summary IS 'Summary';


--
-- Name: COLUMN event_meeting_room.target_audience; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_meeting_room.target_audience IS 'Audience';


--
-- Name: COLUMN event_meeting_room.is_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_meeting_room.is_published IS 'Is Published';


--
-- Name: COLUMN event_meeting_room.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_meeting_room.active IS 'Active';


--
-- Name: COLUMN event_meeting_room.is_pinned; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_meeting_room.is_pinned IS 'Is Pinned';


--
-- Name: COLUMN event_meeting_room.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_meeting_room.create_date IS 'Created on';


--
-- Name: COLUMN event_meeting_room.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_meeting_room.write_date IS 'Last Updated on';


--
-- Name: event_meeting_room_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_meeting_room_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_meeting_room_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_meeting_room_id_seq OWNED BY public.event_meeting_room.id;


--
-- Name: event_question; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_question (
    id integer NOT NULL,
    event_type_id integer,
    event_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    question_type character varying NOT NULL,
    title jsonb NOT NULL,
    once_per_order boolean,
    is_mandatory_answer boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_question; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_question IS 'Event Question';


--
-- Name: COLUMN event_question.event_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question.event_type_id IS 'Event Type';


--
-- Name: COLUMN event_question.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question.event_id IS 'Event';


--
-- Name: COLUMN event_question.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question.sequence IS 'Sequence';


--
-- Name: COLUMN event_question.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question.create_uid IS 'Created by';


--
-- Name: COLUMN event_question.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_question.question_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question.question_type IS 'Question Type';


--
-- Name: COLUMN event_question.title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question.title IS 'Title';


--
-- Name: COLUMN event_question.once_per_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question.once_per_order IS 'Ask once per order';


--
-- Name: COLUMN event_question.is_mandatory_answer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question.is_mandatory_answer IS 'Mandatory Answer';


--
-- Name: COLUMN event_question.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question.create_date IS 'Created on';


--
-- Name: COLUMN event_question.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question.write_date IS 'Last Updated on';


--
-- Name: event_question_answer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_question_answer (
    id integer NOT NULL,
    question_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_question_answer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_question_answer IS 'Event Question Answer';


--
-- Name: COLUMN event_question_answer.question_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question_answer.question_id IS 'Question';


--
-- Name: COLUMN event_question_answer.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question_answer.sequence IS 'Sequence';


--
-- Name: COLUMN event_question_answer.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question_answer.create_uid IS 'Created by';


--
-- Name: COLUMN event_question_answer.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question_answer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_question_answer.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question_answer.name IS 'Answer';


--
-- Name: COLUMN event_question_answer.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question_answer.create_date IS 'Created on';


--
-- Name: COLUMN event_question_answer.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_question_answer.write_date IS 'Last Updated on';


--
-- Name: event_question_answer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_question_answer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_question_answer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_question_answer_id_seq OWNED BY public.event_question_answer.id;


--
-- Name: event_question_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_question_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_question_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_question_id_seq OWNED BY public.event_question.id;


--
-- Name: event_quiz; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_quiz (
    id integer NOT NULL,
    event_track_id integer,
    event_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    repeatable boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_quiz; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_quiz IS 'Quiz';


--
-- Name: COLUMN event_quiz.event_track_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz.event_track_id IS 'Event Track';


--
-- Name: COLUMN event_quiz.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz.event_id IS 'Event';


--
-- Name: COLUMN event_quiz.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz.create_uid IS 'Created by';


--
-- Name: COLUMN event_quiz.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_quiz.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz.name IS 'Name';


--
-- Name: COLUMN event_quiz.repeatable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz.repeatable IS 'Unlimited Tries';


--
-- Name: COLUMN event_quiz.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz.create_date IS 'Created on';


--
-- Name: COLUMN event_quiz.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz.write_date IS 'Last Updated on';


--
-- Name: event_quiz_answer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_quiz_answer (
    id integer NOT NULL,
    sequence integer,
    question_id integer NOT NULL,
    awarded_points integer,
    create_uid integer,
    write_uid integer,
    text_value jsonb NOT NULL,
    comment jsonb,
    is_correct boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_quiz_answer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_quiz_answer IS 'Question''s Answer';


--
-- Name: COLUMN event_quiz_answer.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_answer.sequence IS 'Sequence';


--
-- Name: COLUMN event_quiz_answer.question_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_answer.question_id IS 'Question';


--
-- Name: COLUMN event_quiz_answer.awarded_points; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_answer.awarded_points IS 'Points';


--
-- Name: COLUMN event_quiz_answer.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_answer.create_uid IS 'Created by';


--
-- Name: COLUMN event_quiz_answer.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_answer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_quiz_answer.text_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_answer.text_value IS 'Answer';


--
-- Name: COLUMN event_quiz_answer.comment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_answer.comment IS 'Extra Comment';


--
-- Name: COLUMN event_quiz_answer.is_correct; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_answer.is_correct IS 'Correct';


--
-- Name: COLUMN event_quiz_answer.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_answer.create_date IS 'Created on';


--
-- Name: COLUMN event_quiz_answer.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_answer.write_date IS 'Last Updated on';


--
-- Name: event_quiz_answer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_quiz_answer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_quiz_answer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_quiz_answer_id_seq OWNED BY public.event_quiz_answer.id;


--
-- Name: event_quiz_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_quiz_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_quiz_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_quiz_id_seq OWNED BY public.event_quiz.id;


--
-- Name: event_quiz_question; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_quiz_question (
    id integer NOT NULL,
    sequence integer,
    quiz_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_quiz_question; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_quiz_question IS 'Content Quiz Question';


--
-- Name: COLUMN event_quiz_question.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_question.sequence IS 'Sequence';


--
-- Name: COLUMN event_quiz_question.quiz_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_question.quiz_id IS 'Quiz';


--
-- Name: COLUMN event_quiz_question.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_question.create_uid IS 'Created by';


--
-- Name: COLUMN event_quiz_question.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_question.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_quiz_question.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_question.name IS 'Question';


--
-- Name: COLUMN event_quiz_question.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_question.create_date IS 'Created on';


--
-- Name: COLUMN event_quiz_question.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_quiz_question.write_date IS 'Last Updated on';


--
-- Name: event_quiz_question_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_quiz_question_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_quiz_question_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_quiz_question_id_seq OWNED BY public.event_quiz_question.id;


--
-- Name: event_registration; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_registration (
    id integer NOT NULL,
    event_id integer NOT NULL,
    event_ticket_id integer,
    utm_campaign_id integer,
    utm_source_id integer,
    utm_medium_id integer,
    partner_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    barcode character varying,
    name character varying,
    email character varying,
    phone character varying,
    company_name character varying,
    state character varying,
    registration_properties jsonb,
    active boolean,
    date_closed timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    event_begin_date timestamp without time zone,
    visitor_id integer,
    sale_order_id integer,
    sale_order_line_id integer,
    sale_status character varying
);


--
-- Name: TABLE event_registration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_registration IS 'Event Registration';


--
-- Name: COLUMN event_registration.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.event_id IS 'Event';


--
-- Name: COLUMN event_registration.event_ticket_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.event_ticket_id IS 'Ticket Type';


--
-- Name: COLUMN event_registration.utm_campaign_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.utm_campaign_id IS 'Campaign';


--
-- Name: COLUMN event_registration.utm_source_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.utm_source_id IS 'Source';


--
-- Name: COLUMN event_registration.utm_medium_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.utm_medium_id IS 'Medium';


--
-- Name: COLUMN event_registration.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.partner_id IS 'Booked by';


--
-- Name: COLUMN event_registration.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.company_id IS 'Company';


--
-- Name: COLUMN event_registration.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.create_uid IS 'Created by';


--
-- Name: COLUMN event_registration.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_registration.barcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.barcode IS 'Barcode';


--
-- Name: COLUMN event_registration.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.name IS 'Attendee Name';


--
-- Name: COLUMN event_registration.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.email IS 'Email';


--
-- Name: COLUMN event_registration.phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.phone IS 'Phone';


--
-- Name: COLUMN event_registration.company_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.company_name IS 'Company Name';


--
-- Name: COLUMN event_registration.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.state IS 'Status';


--
-- Name: COLUMN event_registration.registration_properties; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.registration_properties IS 'Properties';


--
-- Name: COLUMN event_registration.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.active IS 'Active';


--
-- Name: COLUMN event_registration.date_closed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.date_closed IS 'Attended Date';


--
-- Name: COLUMN event_registration.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.create_date IS 'Created on';


--
-- Name: COLUMN event_registration.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.write_date IS 'Last Updated on';


--
-- Name: COLUMN event_registration.event_begin_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.event_begin_date IS 'Event Start Date';


--
-- Name: COLUMN event_registration.visitor_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.visitor_id IS 'Visitor';


--
-- Name: COLUMN event_registration.sale_order_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.sale_order_id IS 'Sales Order';


--
-- Name: COLUMN event_registration.sale_order_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.sale_order_line_id IS 'Sales Order Line';


--
-- Name: COLUMN event_registration.sale_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration.sale_status IS 'Sale Status';


--
-- Name: event_registration_answer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_registration_answer (
    id integer NOT NULL,
    question_id integer NOT NULL,
    registration_id integer NOT NULL,
    value_answer_id integer,
    create_uid integer,
    write_uid integer,
    value_text_box text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT event_registration_answer_value_check CHECK (((value_answer_id IS NOT NULL) OR (COALESCE(value_text_box, ''::text) <> ''::text)))
);


--
-- Name: TABLE event_registration_answer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_registration_answer IS 'Event Registration Answer';


--
-- Name: COLUMN event_registration_answer.question_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration_answer.question_id IS 'Question';


--
-- Name: COLUMN event_registration_answer.registration_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration_answer.registration_id IS 'Registration';


--
-- Name: COLUMN event_registration_answer.value_answer_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration_answer.value_answer_id IS 'Suggested answer';


--
-- Name: COLUMN event_registration_answer.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration_answer.create_uid IS 'Created by';


--
-- Name: COLUMN event_registration_answer.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration_answer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_registration_answer.value_text_box; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration_answer.value_text_box IS 'Text answer';


--
-- Name: COLUMN event_registration_answer.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration_answer.create_date IS 'Created on';


--
-- Name: COLUMN event_registration_answer.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_registration_answer.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT event_registration_answer_value_check ON event_registration_answer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT event_registration_answer_value_check ON public.event_registration_answer IS 'CHECK(value_answer_id IS NOT NULL OR COALESCE(value_text_box, '''') <> '''')';


--
-- Name: event_registration_answer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_registration_answer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_registration_answer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_registration_answer_id_seq OWNED BY public.event_registration_answer.id;


--
-- Name: event_registration_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_registration_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_registration_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_registration_id_seq OWNED BY public.event_registration.id;


--
-- Name: sale_order; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sale_order (
    id integer NOT NULL,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    journal_id integer,
    partner_invoice_id integer NOT NULL,
    partner_shipping_id integer NOT NULL,
    fiscal_position_id integer,
    payment_term_id integer,
    pricelist_id integer,
    currency_id integer,
    user_id integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    access_token character varying,
    name character varying NOT NULL,
    state character varying,
    client_order_ref character varying,
    origin character varying,
    reference character varying,
    signed_by character varying,
    invoice_status character varying,
    validity_date date,
    note text,
    currency_rate numeric,
    amount_untaxed numeric,
    amount_tax numeric,
    amount_total numeric,
    locked boolean,
    require_signature boolean,
    require_payment boolean,
    create_date timestamp without time zone,
    commitment_date timestamp without time zone,
    date_order timestamp without time zone NOT NULL,
    signed_on timestamp without time zone,
    write_date timestamp without time zone,
    prepayment_percent double precision,
    pending_email_template_id integer,
    opportunity_id integer,
    sale_order_template_id integer,
    customizable_pdf_form_fields jsonb,
    project_id integer,
    report_grids boolean,
    incoterm integer,
    warehouse_id integer,
    procurement_group_id integer,
    incoterm_location character varying,
    picking_policy character varying NOT NULL,
    delivery_status character varying,
    effective_date timestamp without time zone,
    carrier_id integer,
    delivery_message character varying,
    pickup_location_data jsonb,
    recompute_delivery_price boolean,
    shipping_weight double precision,
    website_id integer,
    shop_warning character varying,
    cart_recovery_email_sent boolean,
    CONSTRAINT sale_order_date_order_conditional_required CHECK (((((state)::text = 'sale'::text) AND (date_order IS NOT NULL)) OR ((state)::text <> 'sale'::text)))
);


--
-- Name: TABLE sale_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sale_order IS 'Sales Order';


--
-- Name: COLUMN sale_order.campaign_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.campaign_id IS 'Campaign';


--
-- Name: COLUMN sale_order.source_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.source_id IS 'Source';


--
-- Name: COLUMN sale_order.medium_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.medium_id IS 'Medium';


--
-- Name: COLUMN sale_order.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.company_id IS 'Company';


--
-- Name: COLUMN sale_order.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.partner_id IS 'Customer';


--
-- Name: COLUMN sale_order.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.journal_id IS 'Invoicing Journal';


--
-- Name: COLUMN sale_order.partner_invoice_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.partner_invoice_id IS 'Invoice Address';


--
-- Name: COLUMN sale_order.partner_shipping_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.partner_shipping_id IS 'Delivery Address';


--
-- Name: COLUMN sale_order.fiscal_position_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN sale_order.payment_term_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.payment_term_id IS 'Payment Terms';


--
-- Name: COLUMN sale_order.pricelist_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.pricelist_id IS 'Pricelist';


--
-- Name: COLUMN sale_order.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.currency_id IS 'Currency';


--
-- Name: COLUMN sale_order.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.user_id IS 'Salesperson';


--
-- Name: COLUMN sale_order.team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.team_id IS 'Sales Team';


--
-- Name: COLUMN sale_order.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.create_uid IS 'Created by';


--
-- Name: COLUMN sale_order.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sale_order.access_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.access_token IS 'Security Token';


--
-- Name: COLUMN sale_order.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.name IS 'Order Reference';


--
-- Name: COLUMN sale_order.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.state IS 'Status';


--
-- Name: COLUMN sale_order.client_order_ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.client_order_ref IS 'Customer Reference';


--
-- Name: COLUMN sale_order.origin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.origin IS 'Source Document';


--
-- Name: COLUMN sale_order.reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.reference IS 'Payment Ref.';


--
-- Name: COLUMN sale_order.signed_by; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.signed_by IS 'Signed By';


--
-- Name: COLUMN sale_order.invoice_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.invoice_status IS 'Invoice Status';


--
-- Name: COLUMN sale_order.validity_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.validity_date IS 'Expiration';


--
-- Name: COLUMN sale_order.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.note IS 'Terms and conditions';


--
-- Name: COLUMN sale_order.currency_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.currency_rate IS 'Currency Rate';


--
-- Name: COLUMN sale_order.amount_untaxed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.amount_untaxed IS 'Untaxed Amount';


--
-- Name: COLUMN sale_order.amount_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.amount_tax IS 'Taxes';


--
-- Name: COLUMN sale_order.amount_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.amount_total IS 'Total';


--
-- Name: COLUMN sale_order.locked; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.locked IS 'Locked';


--
-- Name: COLUMN sale_order.require_signature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.require_signature IS 'Online signature';


--
-- Name: COLUMN sale_order.require_payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.require_payment IS 'Online payment';


--
-- Name: COLUMN sale_order.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.create_date IS 'Creation Date';


--
-- Name: COLUMN sale_order.commitment_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.commitment_date IS 'Delivery Date';


--
-- Name: COLUMN sale_order.date_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.date_order IS 'Order Date';


--
-- Name: COLUMN sale_order.signed_on; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.signed_on IS 'Signed On';


--
-- Name: COLUMN sale_order.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.write_date IS 'Last Updated on';


--
-- Name: COLUMN sale_order.prepayment_percent; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.prepayment_percent IS 'Prepayment percentage';


--
-- Name: COLUMN sale_order.pending_email_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.pending_email_template_id IS 'Pending Email Template';


--
-- Name: COLUMN sale_order.opportunity_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.opportunity_id IS 'Opportunity';


--
-- Name: COLUMN sale_order.customizable_pdf_form_fields; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.customizable_pdf_form_fields IS 'Customizable PDF Form Fields';


--
-- Name: COLUMN sale_order.project_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.project_id IS 'Project';


--
-- Name: COLUMN sale_order.report_grids; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.report_grids IS 'Print Variant Grids';


--
-- Name: COLUMN sale_order.incoterm; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.incoterm IS 'Incoterm';


--
-- Name: COLUMN sale_order.warehouse_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.warehouse_id IS 'Warehouse';


--
-- Name: COLUMN sale_order.procurement_group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.procurement_group_id IS 'Procurement Group';


--
-- Name: COLUMN sale_order.incoterm_location; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.incoterm_location IS 'Incoterm Location';


--
-- Name: COLUMN sale_order.picking_policy; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.picking_policy IS 'Shipping Policy';


--
-- Name: COLUMN sale_order.delivery_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.delivery_status IS 'Delivery Status';


--
-- Name: COLUMN sale_order.effective_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.effective_date IS 'Effective Date';


--
-- Name: COLUMN sale_order.carrier_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.carrier_id IS 'Delivery Method';


--
-- Name: COLUMN sale_order.delivery_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.delivery_message IS 'Delivery Message';


--
-- Name: COLUMN sale_order.pickup_location_data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.pickup_location_data IS 'Pickup Location Data';


--
-- Name: COLUMN sale_order.recompute_delivery_price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.recompute_delivery_price IS 'Delivery cost should be recomputed';


--
-- Name: COLUMN sale_order.shipping_weight; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.shipping_weight IS 'Shipping Weight';


--
-- Name: COLUMN sale_order.website_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.website_id IS 'Website';


--
-- Name: COLUMN sale_order.shop_warning; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.shop_warning IS 'Warning';


--
-- Name: COLUMN sale_order.cart_recovery_email_sent; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order.cart_recovery_email_sent IS 'Cart recovery email already sent';


--
-- Name: CONSTRAINT sale_order_date_order_conditional_required ON sale_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT sale_order_date_order_conditional_required ON public.sale_order IS 'CHECK((state = ''sale'' AND date_order IS NOT NULL) OR state != ''sale'')';


--
-- Name: sale_order_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sale_order_line (
    id integer NOT NULL,
    order_id integer NOT NULL,
    sequence integer,
    company_id integer,
    currency_id integer,
    order_partner_id integer,
    salesman_id integer,
    product_id integer,
    product_uom integer,
    linked_line_id integer,
    combo_item_id integer,
    product_packaging_id integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    display_type character varying,
    virtual_id character varying,
    linked_virtual_id character varying,
    qty_delivered_method character varying,
    invoice_status character varying,
    analytic_distribution jsonb,
    name text NOT NULL,
    product_uom_qty numeric NOT NULL,
    price_unit numeric NOT NULL,
    discount numeric,
    price_subtotal numeric,
    price_total numeric,
    price_reduce_taxexcl numeric,
    price_reduce_taxinc numeric,
    qty_delivered numeric,
    qty_invoiced numeric,
    qty_to_invoice numeric,
    untaxed_amount_invoiced numeric,
    untaxed_amount_to_invoice numeric,
    is_downpayment boolean,
    is_expense boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    technical_price_unit double precision,
    price_tax double precision,
    product_packaging_qty double precision,
    customer_lead double precision NOT NULL,
    is_service boolean,
    planning_hours_planned double precision,
    planning_hours_to_plan double precision,
    project_id integer,
    task_id integer,
    has_displayed_warning_upsell boolean,
    remaining_hours double precision,
    route_id integer,
    warehouse_id integer,
    is_delivery boolean,
    shop_warning character varying,
    calendar_event_id integer,
    event_id integer,
    event_ticket_id integer,
    event_booth_category_id integer,
    CONSTRAINT sale_order_line_accountable_required_fields CHECK (((display_type IS NOT NULL) OR is_downpayment OR ((product_id IS NOT NULL) AND (product_uom IS NOT NULL)))),
    CONSTRAINT sale_order_line_non_accountable_null_fields CHECK (((display_type IS NULL) OR ((product_id IS NULL) AND (price_unit = (0)::numeric) AND (product_uom_qty = (0)::numeric) AND (product_uom IS NULL) AND (customer_lead = (0)::double precision))))
);


--
-- Name: TABLE sale_order_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.sale_order_line IS 'Sales Order Line';


--
-- Name: COLUMN sale_order_line.order_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.order_id IS 'Order Reference';


--
-- Name: COLUMN sale_order_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.sequence IS 'Sequence';


--
-- Name: COLUMN sale_order_line.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.company_id IS 'Company';


--
-- Name: COLUMN sale_order_line.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.currency_id IS 'Currency';


--
-- Name: COLUMN sale_order_line.order_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.order_partner_id IS 'Customer';


--
-- Name: COLUMN sale_order_line.salesman_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.salesman_id IS 'Salesperson';


--
-- Name: COLUMN sale_order_line.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.product_id IS 'Product';


--
-- Name: COLUMN sale_order_line.product_uom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.product_uom IS 'Unit of Measure';


--
-- Name: COLUMN sale_order_line.linked_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.linked_line_id IS 'Linked Order Line';


--
-- Name: COLUMN sale_order_line.combo_item_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.combo_item_id IS 'Combo Item';


--
-- Name: COLUMN sale_order_line.product_packaging_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.product_packaging_id IS 'Packaging';


--
-- Name: COLUMN sale_order_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.create_uid IS 'Created by';


--
-- Name: COLUMN sale_order_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sale_order_line.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.state IS 'Order Status';


--
-- Name: COLUMN sale_order_line.display_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.display_type IS 'Display Type';


--
-- Name: COLUMN sale_order_line.virtual_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.virtual_id IS 'Virtual';


--
-- Name: COLUMN sale_order_line.linked_virtual_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.linked_virtual_id IS 'Linked Virtual';


--
-- Name: COLUMN sale_order_line.qty_delivered_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.qty_delivered_method IS 'Method to update delivered qty';


--
-- Name: COLUMN sale_order_line.invoice_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.invoice_status IS 'Invoice Status';


--
-- Name: COLUMN sale_order_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN sale_order_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.name IS 'Description';


--
-- Name: COLUMN sale_order_line.product_uom_qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.product_uom_qty IS 'Quantity';


--
-- Name: COLUMN sale_order_line.price_unit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.price_unit IS 'Unit Price';


--
-- Name: COLUMN sale_order_line.discount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.discount IS 'Discount (%)';


--
-- Name: COLUMN sale_order_line.price_subtotal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.price_subtotal IS 'Subtotal';


--
-- Name: COLUMN sale_order_line.price_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.price_total IS 'Total';


--
-- Name: COLUMN sale_order_line.price_reduce_taxexcl; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.price_reduce_taxexcl IS 'Price Reduce Tax excl';


--
-- Name: COLUMN sale_order_line.price_reduce_taxinc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.price_reduce_taxinc IS 'Price Reduce Tax incl';


--
-- Name: COLUMN sale_order_line.qty_delivered; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.qty_delivered IS 'Delivery Quantity';


--
-- Name: COLUMN sale_order_line.qty_invoiced; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.qty_invoiced IS 'Invoiced Quantity';


--
-- Name: COLUMN sale_order_line.qty_to_invoice; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.qty_to_invoice IS 'Quantity To Invoice';


--
-- Name: COLUMN sale_order_line.untaxed_amount_invoiced; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.untaxed_amount_invoiced IS 'Untaxed Invoiced Amount';


--
-- Name: COLUMN sale_order_line.untaxed_amount_to_invoice; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.untaxed_amount_to_invoice IS 'Untaxed Amount To Invoice';


--
-- Name: COLUMN sale_order_line.is_downpayment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.is_downpayment IS 'Is a down payment';


--
-- Name: COLUMN sale_order_line.is_expense; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.is_expense IS 'Is expense';


--
-- Name: COLUMN sale_order_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.create_date IS 'Created on';


--
-- Name: COLUMN sale_order_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN sale_order_line.technical_price_unit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.technical_price_unit IS 'Technical Price Unit';


--
-- Name: COLUMN sale_order_line.price_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.price_tax IS 'Total Tax';


--
-- Name: COLUMN sale_order_line.product_packaging_qty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.product_packaging_qty IS 'Packaging Quantity';


--
-- Name: COLUMN sale_order_line.customer_lead; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.customer_lead IS 'Lead Time';


--
-- Name: COLUMN sale_order_line.planning_hours_planned; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.planning_hours_planned IS 'Planning Hours Planned';


--
-- Name: COLUMN sale_order_line.planning_hours_to_plan; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.planning_hours_to_plan IS 'Planning Hours To Plan';


--
-- Name: COLUMN sale_order_line.project_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.project_id IS 'Generated Project';


--
-- Name: COLUMN sale_order_line.task_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.task_id IS 'Generated Task';


--
-- Name: COLUMN sale_order_line.has_displayed_warning_upsell; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.has_displayed_warning_upsell IS 'Has Displayed Warning Upsell';


--
-- Name: COLUMN sale_order_line.remaining_hours; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.remaining_hours IS 'Time Remaining on SO';


--
-- Name: COLUMN sale_order_line.route_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.route_id IS 'Route';


--
-- Name: COLUMN sale_order_line.warehouse_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.warehouse_id IS 'Warehouse';


--
-- Name: COLUMN sale_order_line.is_delivery; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.is_delivery IS 'Is a Delivery';


--
-- Name: COLUMN sale_order_line.shop_warning; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.shop_warning IS 'Warning';


--
-- Name: COLUMN sale_order_line.calendar_event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.calendar_event_id IS 'Meeting';


--
-- Name: COLUMN sale_order_line.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.event_id IS 'Event';


--
-- Name: COLUMN sale_order_line.event_ticket_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.event_ticket_id IS 'Ticket Type';


--
-- Name: COLUMN sale_order_line.event_booth_category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sale_order_line.event_booth_category_id IS 'Booths Category';


--
-- Name: CONSTRAINT sale_order_line_accountable_required_fields ON sale_order_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT sale_order_line_accountable_required_fields ON public.sale_order_line IS 'CHECK(display_type IS NOT NULL OR is_downpayment OR (product_id IS NOT NULL AND product_uom IS NOT NULL))';


--
-- Name: CONSTRAINT sale_order_line_non_accountable_null_fields ON sale_order_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT sale_order_line_non_accountable_null_fields ON public.sale_order_line IS 'CHECK(display_type IS NULL OR (product_id IS NULL AND price_unit = 0 AND product_uom_qty = 0 AND product_uom IS NULL AND customer_lead = 0))';


--
-- Name: event_sale_report; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.event_sale_report AS
 SELECT row_number() OVER (ORDER BY event_registration.id) AS id,
    event_registration.id AS event_registration_id,
    event_registration.company_id,
    event_registration.event_id,
    event_registration.event_ticket_id,
    event_registration.create_date AS event_registration_create_date,
    event_registration.name AS event_registration_name,
    event_registration.state AS event_registration_state,
    event_registration.active,
    event_registration.sale_order_id,
    event_registration.sale_order_line_id,
    event_registration.sale_status,
    event_event.event_type_id,
    event_event.date_begin AS event_date_begin,
    event_event.date_end AS event_date_end,
    event_event_ticket.price AS event_ticket_price,
    sale_order.date_order AS sale_order_date,
    sale_order.partner_invoice_id AS invoice_partner_id,
    sale_order.partner_id AS sale_order_partner_id,
    sale_order.state AS sale_order_state,
    sale_order.user_id AS sale_order_user_id,
    sale_order_line.product_id,
        CASE
            WHEN (sale_order_line.product_uom_qty = (0)::numeric) THEN (0)::numeric
            ELSE ((sale_order_line.price_total /
            CASE COALESCE(sale_order.currency_rate, (0)::numeric)
                WHEN 0 THEN 1.0
                ELSE sale_order.currency_rate
            END) / sale_order_line.product_uom_qty)
        END AS sale_price,
        CASE
            WHEN (sale_order_line.product_uom_qty = (0)::numeric) THEN (0)::numeric
            ELSE ((sale_order_line.price_subtotal /
            CASE COALESCE(sale_order.currency_rate, (0)::numeric)
                WHEN 0 THEN 1.0
                ELSE sale_order.currency_rate
            END) / sale_order_line.product_uom_qty)
        END AS sale_price_untaxed,
    event_event.is_published
   FROM ((((public.event_registration
     LEFT JOIN public.event_event ON ((event_event.id = event_registration.event_id)))
     LEFT JOIN public.event_event_ticket ON ((event_event_ticket.id = event_registration.event_ticket_id)))
     LEFT JOIN public.sale_order ON ((sale_order.id = event_registration.sale_order_id)))
     LEFT JOIN public.sale_order_line ON ((sale_order_line.id = event_registration.sale_order_line_id)));


--
-- Name: event_sponsor; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_sponsor (
    id integer NOT NULL,
    chat_room_id integer,
    event_id integer NOT NULL,
    sponsor_type_id integer NOT NULL,
    sequence integer,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    url character varying,
    subtitle character varying,
    exhibitor_type character varying,
    name character varying,
    email character varying,
    phone character varying,
    mobile character varying,
    website_description jsonb,
    is_published boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    hour_from double precision,
    hour_to double precision
);


--
-- Name: TABLE event_sponsor; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_sponsor IS 'Event Sponsor';


--
-- Name: COLUMN event_sponsor.chat_room_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.chat_room_id IS 'Chat Room';


--
-- Name: COLUMN event_sponsor.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.event_id IS 'Event';


--
-- Name: COLUMN event_sponsor.sponsor_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.sponsor_type_id IS 'Sponsorship Level';


--
-- Name: COLUMN event_sponsor.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.sequence IS 'Sequence';


--
-- Name: COLUMN event_sponsor.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.partner_id IS 'Partner';


--
-- Name: COLUMN event_sponsor.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.create_uid IS 'Created by';


--
-- Name: COLUMN event_sponsor.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_sponsor.url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.url IS 'Sponsor Website';


--
-- Name: COLUMN event_sponsor.subtitle; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.subtitle IS 'Slogan';


--
-- Name: COLUMN event_sponsor.exhibitor_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.exhibitor_type IS 'Sponsor Type';


--
-- Name: COLUMN event_sponsor.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.name IS 'Sponsor Name';


--
-- Name: COLUMN event_sponsor.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.email IS 'Sponsor Email';


--
-- Name: COLUMN event_sponsor.phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.phone IS 'Sponsor Phone';


--
-- Name: COLUMN event_sponsor.mobile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.mobile IS 'Sponsor Mobile';


--
-- Name: COLUMN event_sponsor.website_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.website_description IS 'Description';


--
-- Name: COLUMN event_sponsor.is_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.is_published IS 'Is Published';


--
-- Name: COLUMN event_sponsor.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.active IS 'Active';


--
-- Name: COLUMN event_sponsor.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.create_date IS 'Created on';


--
-- Name: COLUMN event_sponsor.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.write_date IS 'Last Updated on';


--
-- Name: COLUMN event_sponsor.hour_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.hour_from IS 'Opening hour';


--
-- Name: COLUMN event_sponsor.hour_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor.hour_to IS 'End hour';


--
-- Name: event_sponsor_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_sponsor_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_sponsor_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_sponsor_id_seq OWNED BY public.event_sponsor.id;


--
-- Name: event_sponsor_type; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_sponsor_type (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    display_ribbon_style character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_sponsor_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_sponsor_type IS 'Event Sponsor Level';


--
-- Name: COLUMN event_sponsor_type.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor_type.sequence IS 'Sequence';


--
-- Name: COLUMN event_sponsor_type.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor_type.create_uid IS 'Created by';


--
-- Name: COLUMN event_sponsor_type.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_sponsor_type.display_ribbon_style; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor_type.display_ribbon_style IS 'Ribbon Style';


--
-- Name: COLUMN event_sponsor_type.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor_type.name IS 'Sponsor Level';


--
-- Name: COLUMN event_sponsor_type.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor_type.create_date IS 'Created on';


--
-- Name: COLUMN event_sponsor_type.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_sponsor_type.write_date IS 'Last Updated on';


--
-- Name: event_sponsor_type_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_sponsor_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_sponsor_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_sponsor_type_id_seq OWNED BY public.event_sponsor_type.id;


--
-- Name: event_stage; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_stage (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description jsonb,
    legend_blocked jsonb NOT NULL,
    legend_done jsonb NOT NULL,
    legend_normal jsonb NOT NULL,
    fold boolean,
    pipe_end boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_stage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_stage IS 'Event Stage';


--
-- Name: COLUMN event_stage.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_stage.sequence IS 'Sequence';


--
-- Name: COLUMN event_stage.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_stage.create_uid IS 'Created by';


--
-- Name: COLUMN event_stage.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_stage.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_stage.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_stage.name IS 'Stage Name';


--
-- Name: COLUMN event_stage.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_stage.description IS 'Stage description';


--
-- Name: COLUMN event_stage.legend_blocked; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_stage.legend_blocked IS 'Red Kanban Label';


--
-- Name: COLUMN event_stage.legend_done; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_stage.legend_done IS 'Green Kanban Label';


--
-- Name: COLUMN event_stage.legend_normal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_stage.legend_normal IS 'Grey Kanban Label';


--
-- Name: COLUMN event_stage.fold; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_stage.fold IS 'Folded in Kanban';


--
-- Name: COLUMN event_stage.pipe_end; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_stage.pipe_end IS 'End Stage';


--
-- Name: COLUMN event_stage.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_stage.create_date IS 'Created on';


--
-- Name: COLUMN event_stage.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_stage.write_date IS 'Last Updated on';


--
-- Name: event_stage_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_stage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_stage_id_seq OWNED BY public.event_stage.id;


--
-- Name: event_tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_tag (
    id integer NOT NULL,
    sequence integer,
    category_id integer NOT NULL,
    category_sequence integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    website_id integer,
    is_published boolean
);


--
-- Name: TABLE event_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_tag IS 'Event Tag';


--
-- Name: COLUMN event_tag.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag.sequence IS 'Sequence';


--
-- Name: COLUMN event_tag.category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag.category_id IS 'Category';


--
-- Name: COLUMN event_tag.category_sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag.category_sequence IS 'Category Sequence';


--
-- Name: COLUMN event_tag.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag.color IS 'Color Index';


--
-- Name: COLUMN event_tag.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag.create_uid IS 'Created by';


--
-- Name: COLUMN event_tag.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_tag.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag.name IS 'Name';


--
-- Name: COLUMN event_tag.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag.create_date IS 'Created on';


--
-- Name: COLUMN event_tag.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag.write_date IS 'Last Updated on';


--
-- Name: COLUMN event_tag.website_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag.website_id IS 'Website';


--
-- Name: COLUMN event_tag.is_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag.is_published IS 'Is Published';


--
-- Name: event_tag_category; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_tag_category (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    website_id integer,
    is_published boolean
);


--
-- Name: TABLE event_tag_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_tag_category IS 'Event Tag Category';


--
-- Name: COLUMN event_tag_category.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag_category.sequence IS 'Sequence';


--
-- Name: COLUMN event_tag_category.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag_category.create_uid IS 'Created by';


--
-- Name: COLUMN event_tag_category.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_tag_category.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag_category.name IS 'Name';


--
-- Name: COLUMN event_tag_category.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag_category.create_date IS 'Created on';


--
-- Name: COLUMN event_tag_category.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag_category.write_date IS 'Last Updated on';


--
-- Name: COLUMN event_tag_category.website_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag_category.website_id IS 'Website';


--
-- Name: COLUMN event_tag_category.is_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_tag_category.is_published IS 'Is Published';


--
-- Name: event_tag_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_tag_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_tag_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_tag_category_id_seq OWNED BY public.event_tag_category.id;


--
-- Name: event_tag_event_type_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_tag_event_type_rel (
    event_type_id integer NOT NULL,
    event_tag_id integer NOT NULL
);


--
-- Name: TABLE event_tag_event_type_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_tag_event_type_rel IS 'RELATION BETWEEN event_type AND event_tag';


--
-- Name: event_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_tag_id_seq OWNED BY public.event_tag.id;


--
-- Name: event_track; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_track (
    id integer NOT NULL,
    event_id integer NOT NULL,
    user_id integer,
    color integer,
    stage_id integer NOT NULL,
    partner_id integer,
    location_id integer,
    website_cta_delay integer,
    create_uid integer,
    write_uid integer,
    website_meta_og_img character varying,
    priority character varying NOT NULL,
    kanban_state character varying NOT NULL,
    kanban_state_label character varying,
    partner_name character varying,
    partner_email character varying,
    partner_phone character varying,
    partner_function character varying,
    partner_company_name character varying,
    contact_email character varying,
    contact_phone character varying,
    website_cta_title character varying,
    website_cta_url character varying,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    name jsonb NOT NULL,
    description jsonb,
    partner_biography text,
    is_published boolean,
    active boolean,
    wishlisted_by_default boolean,
    website_cta boolean,
    date timestamp without time zone,
    date_end timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision,
    youtube_video_url character varying,
    is_youtube_replay boolean,
    quiz_id integer
);


--
-- Name: TABLE event_track; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_track IS 'Event Track';


--
-- Name: COLUMN event_track.event_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.event_id IS 'Event';


--
-- Name: COLUMN event_track.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.user_id IS 'Responsible';


--
-- Name: COLUMN event_track.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.color IS 'Agenda Color';


--
-- Name: COLUMN event_track.stage_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.stage_id IS 'Stage';


--
-- Name: COLUMN event_track.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.partner_id IS 'Contact';


--
-- Name: COLUMN event_track.location_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.location_id IS 'Location';


--
-- Name: COLUMN event_track.website_cta_delay; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.website_cta_delay IS 'Show Button';


--
-- Name: COLUMN event_track.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.create_uid IS 'Created by';


--
-- Name: COLUMN event_track.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_track.website_meta_og_img; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN event_track.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.priority IS 'Priority';


--
-- Name: COLUMN event_track.kanban_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.kanban_state IS 'Kanban State';


--
-- Name: COLUMN event_track.kanban_state_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.kanban_state_label IS 'Kanban State Label';


--
-- Name: COLUMN event_track.partner_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.partner_name IS 'Name';


--
-- Name: COLUMN event_track.partner_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.partner_email IS 'Email';


--
-- Name: COLUMN event_track.partner_phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.partner_phone IS 'Phone';


--
-- Name: COLUMN event_track.partner_function; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.partner_function IS 'Job Position';


--
-- Name: COLUMN event_track.partner_company_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.partner_company_name IS 'Company Name';


--
-- Name: COLUMN event_track.contact_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.contact_email IS 'Contact Email';


--
-- Name: COLUMN event_track.contact_phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.contact_phone IS 'Contact Phone';


--
-- Name: COLUMN event_track.website_cta_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.website_cta_title IS 'Button Title';


--
-- Name: COLUMN event_track.website_cta_url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.website_cta_url IS 'Button Target URL';


--
-- Name: COLUMN event_track.website_meta_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN event_track.website_meta_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN event_track.website_meta_keywords; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN event_track.seo_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.seo_name IS 'Seo name';


--
-- Name: COLUMN event_track.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.name IS 'Title';


--
-- Name: COLUMN event_track.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.description IS 'Description';


--
-- Name: COLUMN event_track.partner_biography; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.partner_biography IS 'Biography';


--
-- Name: COLUMN event_track.is_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.is_published IS 'Is Published';


--
-- Name: COLUMN event_track.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.active IS 'Active';


--
-- Name: COLUMN event_track.wishlisted_by_default; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.wishlisted_by_default IS 'Always Wishlisted';


--
-- Name: COLUMN event_track.website_cta; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.website_cta IS 'Magic Button';


--
-- Name: COLUMN event_track.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.date IS 'Track Date';


--
-- Name: COLUMN event_track.date_end; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.date_end IS 'Track End Date';


--
-- Name: COLUMN event_track.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.create_date IS 'Created on';


--
-- Name: COLUMN event_track.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.write_date IS 'Last Updated on';


--
-- Name: COLUMN event_track.duration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.duration IS 'Duration';


--
-- Name: COLUMN event_track.youtube_video_url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.youtube_video_url IS 'YouTube Video Link';


--
-- Name: COLUMN event_track.is_youtube_replay; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.is_youtube_replay IS 'Is YouTube Replay';


--
-- Name: COLUMN event_track.quiz_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track.quiz_id IS 'Quiz';


--
-- Name: event_track_event_track_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_track_event_track_tag_rel (
    event_track_id integer NOT NULL,
    event_track_tag_id integer NOT NULL
);


--
-- Name: TABLE event_track_event_track_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_track_event_track_tag_rel IS 'RELATION BETWEEN event_track AND event_track_tag';


--
-- Name: event_track_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_track_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_track_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_track_id_seq OWNED BY public.event_track.id;


--
-- Name: event_track_location; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_track_location (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_track_location; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_track_location IS 'Event Track Location';


--
-- Name: COLUMN event_track_location.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_location.sequence IS 'Sequence';


--
-- Name: COLUMN event_track_location.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_location.create_uid IS 'Created by';


--
-- Name: COLUMN event_track_location.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_location.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_track_location.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_location.name IS 'Location';


--
-- Name: COLUMN event_track_location.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_location.create_date IS 'Created on';


--
-- Name: COLUMN event_track_location.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_location.write_date IS 'Last Updated on';


--
-- Name: event_track_location_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_track_location_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_track_location_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_track_location_id_seq OWNED BY public.event_track_location.id;


--
-- Name: event_track_stage; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_track_stage (
    id integer NOT NULL,
    sequence integer,
    mail_template_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description jsonb,
    legend_blocked jsonb,
    legend_done jsonb,
    legend_normal jsonb,
    fold boolean,
    is_visible_in_agenda boolean,
    is_fully_accessible boolean,
    is_cancel boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_track_stage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_track_stage IS 'Event Track Stage';


--
-- Name: COLUMN event_track_stage.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_stage.sequence IS 'Sequence';


--
-- Name: COLUMN event_track_stage.mail_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_stage.mail_template_id IS 'Email Template';


--
-- Name: COLUMN event_track_stage.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_stage.color IS 'Color';


--
-- Name: COLUMN event_track_stage.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_stage.create_uid IS 'Created by';


--
-- Name: COLUMN event_track_stage.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_stage.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_track_stage.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_stage.name IS 'Stage Name';


--
-- Name: COLUMN event_track_stage.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_stage.description IS 'Description';


--
-- Name: COLUMN event_track_stage.legend_blocked; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_stage.legend_blocked IS 'Red Kanban Label';


--
-- Name: COLUMN event_track_stage.legend_done; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_stage.legend_done IS 'Green Kanban Label';


--
-- Name: COLUMN event_track_stage.legend_normal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_stage.legend_normal IS 'Grey Kanban Label';


--
-- Name: COLUMN event_track_stage.fold; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_stage.fold IS 'Folded in Kanban';


--
-- Name: COLUMN event_track_stage.is_visible_in_agenda; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_stage.is_visible_in_agenda IS 'Visible in agenda';


--
-- Name: COLUMN event_track_stage.is_fully_accessible; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_stage.is_fully_accessible IS 'Fully accessible';


--
-- Name: COLUMN event_track_stage.is_cancel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_stage.is_cancel IS 'Cancelled Stage';


--
-- Name: COLUMN event_track_stage.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_stage.create_date IS 'Created on';


--
-- Name: COLUMN event_track_stage.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_stage.write_date IS 'Last Updated on';


--
-- Name: event_track_stage_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_track_stage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_track_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_track_stage_id_seq OWNED BY public.event_track_stage.id;


--
-- Name: event_track_tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_track_tag (
    id integer NOT NULL,
    color integer,
    sequence integer,
    category_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_track_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_track_tag IS 'Event Track Tag';


--
-- Name: COLUMN event_track_tag.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_tag.color IS 'Color Index';


--
-- Name: COLUMN event_track_tag.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_tag.sequence IS 'Sequence';


--
-- Name: COLUMN event_track_tag.category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_tag.category_id IS 'Category';


--
-- Name: COLUMN event_track_tag.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_tag.create_uid IS 'Created by';


--
-- Name: COLUMN event_track_tag.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_track_tag.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_tag.name IS 'Tag Name';


--
-- Name: COLUMN event_track_tag.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_tag.create_date IS 'Created on';


--
-- Name: COLUMN event_track_tag.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_tag.write_date IS 'Last Updated on';


--
-- Name: event_track_tag_category; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_track_tag_category (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_track_tag_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_track_tag_category IS 'Event Track Tag Category';


--
-- Name: COLUMN event_track_tag_category.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_tag_category.sequence IS 'Sequence';


--
-- Name: COLUMN event_track_tag_category.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_tag_category.create_uid IS 'Created by';


--
-- Name: COLUMN event_track_tag_category.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_tag_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_track_tag_category.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_tag_category.name IS 'Name';


--
-- Name: COLUMN event_track_tag_category.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_tag_category.create_date IS 'Created on';


--
-- Name: COLUMN event_track_tag_category.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_tag_category.write_date IS 'Last Updated on';


--
-- Name: event_track_tag_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_track_tag_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_track_tag_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_track_tag_category_id_seq OWNED BY public.event_track_tag_category.id;


--
-- Name: event_track_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_track_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_track_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_track_tag_id_seq OWNED BY public.event_track_tag.id;


--
-- Name: event_track_tags_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_track_tags_rel (
    event_event_id integer NOT NULL,
    event_track_tag_id integer NOT NULL
);


--
-- Name: TABLE event_track_tags_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_track_tags_rel IS 'RELATION BETWEEN event_event AND event_track_tag';


--
-- Name: event_track_visitor; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_track_visitor (
    id integer NOT NULL,
    partner_id integer,
    visitor_id integer,
    track_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    is_wishlisted boolean,
    is_blacklisted boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    quiz_points integer,
    quiz_completed boolean
);


--
-- Name: TABLE event_track_visitor; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_track_visitor IS 'Track / Visitor Link';


--
-- Name: COLUMN event_track_visitor.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_visitor.partner_id IS 'Partner';


--
-- Name: COLUMN event_track_visitor.visitor_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_visitor.visitor_id IS 'Visitor';


--
-- Name: COLUMN event_track_visitor.track_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_visitor.track_id IS 'Track';


--
-- Name: COLUMN event_track_visitor.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_visitor.create_uid IS 'Created by';


--
-- Name: COLUMN event_track_visitor.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_visitor.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_track_visitor.is_wishlisted; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_visitor.is_wishlisted IS 'Is Wishlisted';


--
-- Name: COLUMN event_track_visitor.is_blacklisted; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_visitor.is_blacklisted IS 'Is reminder off';


--
-- Name: COLUMN event_track_visitor.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_visitor.create_date IS 'Created on';


--
-- Name: COLUMN event_track_visitor.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_visitor.write_date IS 'Last Updated on';


--
-- Name: COLUMN event_track_visitor.quiz_points; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_visitor.quiz_points IS 'Quiz Points';


--
-- Name: COLUMN event_track_visitor.quiz_completed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_track_visitor.quiz_completed IS 'Completed';


--
-- Name: event_track_visitor_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_track_visitor_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_track_visitor_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_track_visitor_id_seq OWNED BY public.event_track_visitor.id;


--
-- Name: event_type; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_type (
    id integer NOT NULL,
    sequence integer,
    seats_max integer,
    create_uid integer,
    write_uid integer,
    default_timezone character varying,
    name jsonb NOT NULL,
    ticket_instructions jsonb,
    note text,
    has_seats_limitation boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    website_menu boolean,
    community_menu boolean,
    booth_menu boolean,
    website_track boolean,
    website_track_proposal boolean,
    exhibitor_menu boolean,
    meeting_room_allow_creation boolean
);


--
-- Name: TABLE event_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_type IS 'Event Template';


--
-- Name: COLUMN event_type.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.sequence IS 'Sequence';


--
-- Name: COLUMN event_type.seats_max; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.seats_max IS 'Maximum Registrations';


--
-- Name: COLUMN event_type.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.create_uid IS 'Created by';


--
-- Name: COLUMN event_type.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_type.default_timezone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.default_timezone IS 'Timezone';


--
-- Name: COLUMN event_type.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.name IS 'Event Template';


--
-- Name: COLUMN event_type.ticket_instructions; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.ticket_instructions IS 'Ticket Instructions';


--
-- Name: COLUMN event_type.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.note IS 'Note';


--
-- Name: COLUMN event_type.has_seats_limitation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.has_seats_limitation IS 'Limited Seats';


--
-- Name: COLUMN event_type.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.create_date IS 'Created on';


--
-- Name: COLUMN event_type.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.write_date IS 'Last Updated on';


--
-- Name: COLUMN event_type.website_menu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.website_menu IS 'Display a dedicated menu on Website';


--
-- Name: COLUMN event_type.community_menu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.community_menu IS 'Community Menu';


--
-- Name: COLUMN event_type.booth_menu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.booth_menu IS 'Booths on Website';


--
-- Name: COLUMN event_type.website_track; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.website_track IS 'Tracks on Website';


--
-- Name: COLUMN event_type.website_track_proposal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.website_track_proposal IS 'Tracks Proposals on Website';


--
-- Name: COLUMN event_type.exhibitor_menu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.exhibitor_menu IS 'Showcase Exhibitors';


--
-- Name: COLUMN event_type.meeting_room_allow_creation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type.meeting_room_allow_creation IS 'Allow Room Creation';


--
-- Name: event_type_booth; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_type_booth (
    id integer NOT NULL,
    event_type_id integer NOT NULL,
    booth_category_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    price double precision
);


--
-- Name: TABLE event_type_booth; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_type_booth IS 'Event Booth Template';


--
-- Name: COLUMN event_type_booth.event_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_booth.event_type_id IS 'Event Category';


--
-- Name: COLUMN event_type_booth.booth_category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_booth.booth_category_id IS 'Booth Category';


--
-- Name: COLUMN event_type_booth.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_booth.create_uid IS 'Created by';


--
-- Name: COLUMN event_type_booth.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_booth.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_type_booth.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_booth.name IS 'Name';


--
-- Name: COLUMN event_type_booth.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_booth.create_date IS 'Created on';


--
-- Name: COLUMN event_type_booth.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_booth.write_date IS 'Last Updated on';


--
-- Name: COLUMN event_type_booth.price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_booth.price IS 'Price';


--
-- Name: event_type_booth_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_type_booth_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_type_booth_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_type_booth_id_seq OWNED BY public.event_type_booth.id;


--
-- Name: event_type_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_type_id_seq OWNED BY public.event_type.id;


--
-- Name: event_type_mail; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_type_mail (
    id integer NOT NULL,
    event_type_id integer NOT NULL,
    interval_nbr integer,
    create_uid integer,
    write_uid integer,
    interval_unit character varying NOT NULL,
    interval_type character varying NOT NULL,
    template_ref character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE event_type_mail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_type_mail IS 'Mail Scheduling on Event Category';


--
-- Name: COLUMN event_type_mail.event_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_mail.event_type_id IS 'Event Type';


--
-- Name: COLUMN event_type_mail.interval_nbr; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_mail.interval_nbr IS 'Interval';


--
-- Name: COLUMN event_type_mail.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_mail.create_uid IS 'Created by';


--
-- Name: COLUMN event_type_mail.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_mail.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_type_mail.interval_unit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_mail.interval_unit IS 'Unit';


--
-- Name: COLUMN event_type_mail.interval_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_mail.interval_type IS 'Trigger';


--
-- Name: COLUMN event_type_mail.template_ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_mail.template_ref IS 'Template';


--
-- Name: COLUMN event_type_mail.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_mail.create_date IS 'Created on';


--
-- Name: COLUMN event_type_mail.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_mail.write_date IS 'Last Updated on';


--
-- Name: event_type_mail_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_type_mail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_type_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_type_mail_id_seq OWNED BY public.event_type_mail.id;


--
-- Name: event_type_ticket; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.event_type_ticket (
    id integer NOT NULL,
    sequence integer,
    event_type_id integer NOT NULL,
    seats_max integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description jsonb,
    seats_limited boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_id integer NOT NULL,
    price numeric
);


--
-- Name: TABLE event_type_ticket; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.event_type_ticket IS 'Event Template Ticket';


--
-- Name: COLUMN event_type_ticket.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_ticket.sequence IS 'Sequence';


--
-- Name: COLUMN event_type_ticket.event_type_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_ticket.event_type_id IS 'Event Category';


--
-- Name: COLUMN event_type_ticket.seats_max; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_ticket.seats_max IS 'Maximum Attendees';


--
-- Name: COLUMN event_type_ticket.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_ticket.create_uid IS 'Created by';


--
-- Name: COLUMN event_type_ticket.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_ticket.write_uid IS 'Last Updated by';


--
-- Name: COLUMN event_type_ticket.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_ticket.name IS 'Name';


--
-- Name: COLUMN event_type_ticket.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_ticket.description IS 'Description';


--
-- Name: COLUMN event_type_ticket.seats_limited; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_ticket.seats_limited IS 'Limit Attendees';


--
-- Name: COLUMN event_type_ticket.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_ticket.create_date IS 'Created on';


--
-- Name: COLUMN event_type_ticket.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_ticket.write_date IS 'Last Updated on';


--
-- Name: COLUMN event_type_ticket.product_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_ticket.product_id IS 'Product';


--
-- Name: COLUMN event_type_ticket.price; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.event_type_ticket.price IS 'Price';


--
-- Name: event_type_ticket_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.event_type_ticket_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event_type_ticket_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.event_type_ticket_id_seq OWNED BY public.event_type_ticket.id;


--
-- Name: expense_sample_receipt; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.expense_sample_receipt (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE expense_sample_receipt; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.expense_sample_receipt IS 'Try Sample Receipts';


--
-- Name: COLUMN expense_sample_receipt.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.expense_sample_receipt.create_uid IS 'Created by';


--
-- Name: COLUMN expense_sample_receipt.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.expense_sample_receipt.write_uid IS 'Last Updated by';


--
-- Name: COLUMN expense_sample_receipt.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.expense_sample_receipt.create_date IS 'Created on';


--
-- Name: COLUMN expense_sample_receipt.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.expense_sample_receipt.write_date IS 'Last Updated on';


--
-- Name: expense_sample_receipt_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.expense_sample_receipt_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: expense_sample_receipt_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.expense_sample_receipt_id_seq OWNED BY public.expense_sample_receipt.id;


--
-- Name: expense_sample_register; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.expense_sample_register (
    id integer NOT NULL,
    sheet_id integer,
    journal_id integer,
    payment_method_line_id integer,
    create_uid integer,
    write_uid integer,
    memo character varying,
    partial_mode character varying,
    date date NOT NULL,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE expense_sample_register; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.expense_sample_register IS 'Register Sample Payments';


--
-- Name: COLUMN expense_sample_register.sheet_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.expense_sample_register.sheet_id IS 'Expense';


--
-- Name: COLUMN expense_sample_register.journal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.expense_sample_register.journal_id IS 'Journal';


--
-- Name: COLUMN expense_sample_register.payment_method_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.expense_sample_register.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN expense_sample_register.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.expense_sample_register.create_uid IS 'Created by';


--
-- Name: COLUMN expense_sample_register.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.expense_sample_register.write_uid IS 'Last Updated by';


--
-- Name: COLUMN expense_sample_register.memo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.expense_sample_register.memo IS 'Memo';


--
-- Name: COLUMN expense_sample_register.partial_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.expense_sample_register.partial_mode IS 'Payment Difference';


--
-- Name: COLUMN expense_sample_register.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.expense_sample_register.date IS 'Payment Date';


--
-- Name: COLUMN expense_sample_register.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.expense_sample_register.amount IS 'Amount';


--
-- Name: COLUMN expense_sample_register.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.expense_sample_register.create_date IS 'Created on';


--
-- Name: COLUMN expense_sample_register.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.expense_sample_register.write_date IS 'Last Updated on';


--
-- Name: expense_sample_register_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.expense_sample_register_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: expense_sample_register_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.expense_sample_register_id_seq OWNED BY public.expense_sample_register.id;


--
-- Name: expense_tax; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.expense_tax (
    expense_id integer NOT NULL,
    tax_id integer NOT NULL
);


--
-- Name: TABLE expense_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.expense_tax IS 'RELATION BETWEEN hr_expense AND account_tax';


--
-- Name: export_wiz_document_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.export_wiz_document_tag_rel (
    account_reports_export_wizard_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


--
-- Name: TABLE export_wiz_document_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.export_wiz_document_tag_rel IS 'RELATION BETWEEN account_reports_export_wizard AND documents_tag';


--
-- Name: fetchmail_server; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.fetchmail_server (
    id integer NOT NULL,
    port integer,
    object_id integer,
    priority integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    server character varying,
    server_type character varying NOT NULL,
    "user" character varying,
    password character varying,
    script character varying,
    configuration text,
    active boolean,
    is_ssl boolean,
    attach boolean,
    original boolean,
    date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    google_gmail_access_token_expiration integer,
    google_gmail_authorization_code character varying,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying
);


--
-- Name: TABLE fetchmail_server; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.fetchmail_server IS 'Incoming Mail Server';


--
-- Name: COLUMN fetchmail_server.port; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.port IS 'Port';


--
-- Name: COLUMN fetchmail_server.object_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.object_id IS 'Create a New Record';


--
-- Name: COLUMN fetchmail_server.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.priority IS 'Server Priority';


--
-- Name: COLUMN fetchmail_server.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.create_uid IS 'Created by';


--
-- Name: COLUMN fetchmail_server.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN fetchmail_server.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.name IS 'Name';


--
-- Name: COLUMN fetchmail_server.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.state IS 'Status';


--
-- Name: COLUMN fetchmail_server.server; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.server IS 'Server Name';


--
-- Name: COLUMN fetchmail_server.server_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.server_type IS 'Server Type';


--
-- Name: COLUMN fetchmail_server."user"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server."user" IS 'Username';


--
-- Name: COLUMN fetchmail_server.password; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.password IS 'Password';


--
-- Name: COLUMN fetchmail_server.script; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.script IS 'Script';


--
-- Name: COLUMN fetchmail_server.configuration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.configuration IS 'Configuration';


--
-- Name: COLUMN fetchmail_server.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.active IS 'Active';


--
-- Name: COLUMN fetchmail_server.is_ssl; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.is_ssl IS 'SSL/TLS';


--
-- Name: COLUMN fetchmail_server.attach; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.attach IS 'Keep Attachments';


--
-- Name: COLUMN fetchmail_server.original; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.original IS 'Keep Original';


--
-- Name: COLUMN fetchmail_server.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.date IS 'Last Fetch Date';


--
-- Name: COLUMN fetchmail_server.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.create_date IS 'Created on';


--
-- Name: COLUMN fetchmail_server.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN fetchmail_server.google_gmail_authorization_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_authorization_code IS 'Authorization Code';


--
-- Name: COLUMN fetchmail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.fetchmail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.fetchmail_server_id_seq OWNED BY public.fetchmail_server.id;


--
-- Name: forum_forum; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.forum_forum (
    id integer NOT NULL,
    website_id integer,
    sequence integer,
    authorized_group_id integer,
    karma_gen_question_new integer,
    karma_gen_question_upvote integer,
    karma_gen_question_downvote integer,
    karma_gen_answer_upvote integer,
    karma_gen_answer_downvote integer,
    karma_gen_answer_accept integer,
    karma_gen_answer_accepted integer,
    karma_gen_answer_flagged integer,
    karma_ask integer,
    karma_answer integer,
    karma_edit_own integer,
    karma_edit_all integer,
    karma_edit_retag integer,
    karma_close_own integer,
    karma_close_all integer,
    karma_unlink_own integer,
    karma_unlink_all integer,
    karma_tag_create integer,
    karma_upvote integer,
    karma_downvote integer,
    karma_answer_accept_own integer,
    karma_answer_accept_all integer,
    karma_comment_own integer,
    karma_comment_all integer,
    karma_comment_convert_own integer,
    karma_comment_convert_all integer,
    karma_comment_unlink_own integer,
    karma_comment_unlink_all integer,
    karma_flag integer,
    karma_dofollow integer,
    karma_editor integer,
    karma_user_bio integer,
    karma_post integer,
    karma_moderate integer,
    create_uid integer,
    write_uid integer,
    website_meta_og_img character varying,
    mode character varying NOT NULL,
    privacy character varying,
    default_order character varying NOT NULL,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    name jsonb NOT NULL,
    faq jsonb,
    description jsonb,
    welcome_message jsonb,
    teaser text,
    active boolean,
    allow_share boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    relevancy_post_vote double precision,
    relevancy_time_decay double precision,
    slide_channel_id integer
);


--
-- Name: TABLE forum_forum; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.forum_forum IS 'Forum';


--
-- Name: COLUMN forum_forum.website_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.website_id IS 'Website';


--
-- Name: COLUMN forum_forum.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.sequence IS 'Sequence';


--
-- Name: COLUMN forum_forum.authorized_group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.authorized_group_id IS 'Authorized Group';


--
-- Name: COLUMN forum_forum.karma_gen_question_new; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_gen_question_new IS 'Asking a question';


--
-- Name: COLUMN forum_forum.karma_gen_question_upvote; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_gen_question_upvote IS 'Question upvoted';


--
-- Name: COLUMN forum_forum.karma_gen_question_downvote; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_gen_question_downvote IS 'Question downvoted';


--
-- Name: COLUMN forum_forum.karma_gen_answer_upvote; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_gen_answer_upvote IS 'Answer upvoted';


--
-- Name: COLUMN forum_forum.karma_gen_answer_downvote; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_gen_answer_downvote IS 'Answer downvoted';


--
-- Name: COLUMN forum_forum.karma_gen_answer_accept; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_gen_answer_accept IS 'Accepting an answer';


--
-- Name: COLUMN forum_forum.karma_gen_answer_accepted; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_gen_answer_accepted IS 'Answer accepted';


--
-- Name: COLUMN forum_forum.karma_gen_answer_flagged; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_gen_answer_flagged IS 'Answer flagged';


--
-- Name: COLUMN forum_forum.karma_ask; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_ask IS 'Ask questions';


--
-- Name: COLUMN forum_forum.karma_answer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_answer IS 'Answer questions';


--
-- Name: COLUMN forum_forum.karma_edit_own; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_edit_own IS 'Edit own posts';


--
-- Name: COLUMN forum_forum.karma_edit_all; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_edit_all IS 'Edit all posts';


--
-- Name: COLUMN forum_forum.karma_edit_retag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_edit_retag IS 'Change question tags';


--
-- Name: COLUMN forum_forum.karma_close_own; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_close_own IS 'Close own posts';


--
-- Name: COLUMN forum_forum.karma_close_all; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_close_all IS 'Close all posts';


--
-- Name: COLUMN forum_forum.karma_unlink_own; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_unlink_own IS 'Delete own posts';


--
-- Name: COLUMN forum_forum.karma_unlink_all; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_unlink_all IS 'Delete all posts';


--
-- Name: COLUMN forum_forum.karma_tag_create; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_tag_create IS 'Create new tags';


--
-- Name: COLUMN forum_forum.karma_upvote; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_upvote IS 'Upvote';


--
-- Name: COLUMN forum_forum.karma_downvote; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_downvote IS 'Downvote';


--
-- Name: COLUMN forum_forum.karma_answer_accept_own; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_answer_accept_own IS 'Accept an answer on own questions';


--
-- Name: COLUMN forum_forum.karma_answer_accept_all; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_answer_accept_all IS 'Accept an answer to all questions';


--
-- Name: COLUMN forum_forum.karma_comment_own; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_comment_own IS 'Comment own posts';


--
-- Name: COLUMN forum_forum.karma_comment_all; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_comment_all IS 'Comment all posts';


--
-- Name: COLUMN forum_forum.karma_comment_convert_own; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_comment_convert_own IS 'Convert own comments to answers';


--
-- Name: COLUMN forum_forum.karma_comment_convert_all; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_comment_convert_all IS 'Convert all comments to answers';


--
-- Name: COLUMN forum_forum.karma_comment_unlink_own; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_comment_unlink_own IS 'Delete own comments';


--
-- Name: COLUMN forum_forum.karma_comment_unlink_all; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_comment_unlink_all IS 'Delete all comments';


--
-- Name: COLUMN forum_forum.karma_flag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_flag IS 'Flag a post as offensive';


--
-- Name: COLUMN forum_forum.karma_dofollow; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_dofollow IS 'Nofollow links';


--
-- Name: COLUMN forum_forum.karma_editor; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_editor IS 'Editor Features: image and links';


--
-- Name: COLUMN forum_forum.karma_user_bio; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_user_bio IS 'Display detailed user biography';


--
-- Name: COLUMN forum_forum.karma_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_post IS 'Ask questions without validation';


--
-- Name: COLUMN forum_forum.karma_moderate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.karma_moderate IS 'Moderate posts';


--
-- Name: COLUMN forum_forum.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.create_uid IS 'Created by';


--
-- Name: COLUMN forum_forum.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.write_uid IS 'Last Updated by';


--
-- Name: COLUMN forum_forum.website_meta_og_img; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN forum_forum.mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.mode IS 'Mode';


--
-- Name: COLUMN forum_forum.privacy; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.privacy IS 'Privacy';


--
-- Name: COLUMN forum_forum.default_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.default_order IS 'Default';


--
-- Name: COLUMN forum_forum.website_meta_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN forum_forum.website_meta_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN forum_forum.website_meta_keywords; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN forum_forum.seo_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.seo_name IS 'Seo name';


--
-- Name: COLUMN forum_forum.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.name IS 'Forum Name';


--
-- Name: COLUMN forum_forum.faq; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.faq IS 'Guidelines';


--
-- Name: COLUMN forum_forum.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.description IS 'Description';


--
-- Name: COLUMN forum_forum.welcome_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.welcome_message IS 'Welcome Message';


--
-- Name: COLUMN forum_forum.teaser; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.teaser IS 'Teaser';


--
-- Name: COLUMN forum_forum.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.active IS 'Active';


--
-- Name: COLUMN forum_forum.allow_share; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.allow_share IS 'Sharing Options';


--
-- Name: COLUMN forum_forum.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.create_date IS 'Created on';


--
-- Name: COLUMN forum_forum.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.write_date IS 'Last Updated on';


--
-- Name: COLUMN forum_forum.relevancy_post_vote; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.relevancy_post_vote IS 'First Relevance Parameter';


--
-- Name: COLUMN forum_forum.relevancy_time_decay; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.relevancy_time_decay IS 'Second Relevance Parameter';


--
-- Name: COLUMN forum_forum.slide_channel_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_forum.slide_channel_id IS 'Course';


--
-- Name: forum_forum_helpdesk_team_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.forum_forum_helpdesk_team_rel (
    helpdesk_team_id integer NOT NULL,
    forum_forum_id integer NOT NULL
);


--
-- Name: TABLE forum_forum_helpdesk_team_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.forum_forum_helpdesk_team_rel IS 'RELATION BETWEEN helpdesk_team AND forum_forum';


--
-- Name: forum_forum_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.forum_forum_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: forum_forum_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.forum_forum_id_seq OWNED BY public.forum_forum.id;


--
-- Name: forum_post; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.forum_post (
    id integer NOT NULL,
    forum_id integer NOT NULL,
    views integer,
    create_uid integer,
    write_uid integer,
    vote_count integer,
    favourite_count integer,
    parent_id integer,
    child_count integer,
    flag_user_id integer,
    moderator_id integer,
    closed_reason_id integer,
    closed_uid integer,
    website_meta_og_img character varying,
    name character varying,
    state character varying,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    content text,
    plain_content text,
    active boolean,
    is_correct boolean,
    self_reply boolean,
    has_validated_answer boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    last_activity_date timestamp without time zone NOT NULL,
    closed_date timestamp without time zone,
    relevancy double precision,
    ticket_id integer
);


--
-- Name: TABLE forum_post; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.forum_post IS 'Forum Post';


--
-- Name: COLUMN forum_post.forum_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.forum_id IS 'Forum';


--
-- Name: COLUMN forum_post.views; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.views IS 'Views';


--
-- Name: COLUMN forum_post.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.create_uid IS 'Created by';


--
-- Name: COLUMN forum_post.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.write_uid IS 'Updated by';


--
-- Name: COLUMN forum_post.vote_count; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.vote_count IS 'Total Votes';


--
-- Name: COLUMN forum_post.favourite_count; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.favourite_count IS 'Favorite';


--
-- Name: COLUMN forum_post.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.parent_id IS 'Question';


--
-- Name: COLUMN forum_post.child_count; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.child_count IS 'Answers';


--
-- Name: COLUMN forum_post.flag_user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.flag_user_id IS 'Flagged by';


--
-- Name: COLUMN forum_post.moderator_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.moderator_id IS 'Reviewed by';


--
-- Name: COLUMN forum_post.closed_reason_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.closed_reason_id IS 'Reason';


--
-- Name: COLUMN forum_post.closed_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.closed_uid IS 'Closed by';


--
-- Name: COLUMN forum_post.website_meta_og_img; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN forum_post.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.name IS 'Title';


--
-- Name: COLUMN forum_post.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.state IS 'Status';


--
-- Name: COLUMN forum_post.website_meta_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN forum_post.website_meta_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN forum_post.website_meta_keywords; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN forum_post.seo_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.seo_name IS 'Seo name';


--
-- Name: COLUMN forum_post.content; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.content IS 'Content';


--
-- Name: COLUMN forum_post.plain_content; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.plain_content IS 'Plain Content';


--
-- Name: COLUMN forum_post.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.active IS 'Active';


--
-- Name: COLUMN forum_post.is_correct; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.is_correct IS 'Correct';


--
-- Name: COLUMN forum_post.self_reply; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.self_reply IS 'Reply to own question';


--
-- Name: COLUMN forum_post.has_validated_answer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.has_validated_answer IS 'Is answered';


--
-- Name: COLUMN forum_post.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.create_date IS 'Asked on';


--
-- Name: COLUMN forum_post.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.write_date IS 'Updated on';


--
-- Name: COLUMN forum_post.last_activity_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.last_activity_date IS 'Last activity on';


--
-- Name: COLUMN forum_post.closed_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.closed_date IS 'Closed on';


--
-- Name: COLUMN forum_post.relevancy; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.relevancy IS 'Relevance';


--
-- Name: COLUMN forum_post.ticket_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post.ticket_id IS 'Ticket';


--
-- Name: forum_post_helpdesk_ticket_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.forum_post_helpdesk_ticket_rel (
    helpdesk_ticket_id integer NOT NULL,
    forum_post_id integer NOT NULL
);


--
-- Name: TABLE forum_post_helpdesk_ticket_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.forum_post_helpdesk_ticket_rel IS 'RELATION BETWEEN helpdesk_ticket AND forum_post';


--
-- Name: forum_post_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.forum_post_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: forum_post_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.forum_post_id_seq OWNED BY public.forum_post.id;


--
-- Name: forum_post_reason; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.forum_post_reason (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reason_type character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE forum_post_reason; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.forum_post_reason IS 'Post Closing Reason';


--
-- Name: COLUMN forum_post_reason.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post_reason.create_uid IS 'Created by';


--
-- Name: COLUMN forum_post_reason.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post_reason.write_uid IS 'Last Updated by';


--
-- Name: COLUMN forum_post_reason.reason_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post_reason.reason_type IS 'Reason Type';


--
-- Name: COLUMN forum_post_reason.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post_reason.name IS 'Closing Reason';


--
-- Name: COLUMN forum_post_reason.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post_reason.create_date IS 'Created on';


--
-- Name: COLUMN forum_post_reason.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post_reason.write_date IS 'Last Updated on';


--
-- Name: forum_post_reason_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.forum_post_reason_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: forum_post_reason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.forum_post_reason_id_seq OWNED BY public.forum_post_reason.id;


--
-- Name: forum_post_res_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.forum_post_res_users_rel (
    forum_post_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE forum_post_res_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.forum_post_res_users_rel IS 'RELATION BETWEEN forum_post AND res_users';


--
-- Name: forum_post_vote; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.forum_post_vote (
    id integer NOT NULL,
    post_id integer NOT NULL,
    user_id integer NOT NULL,
    forum_id integer,
    recipient_id integer,
    create_uid integer,
    write_uid integer,
    vote character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE forum_post_vote; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.forum_post_vote IS 'Post Vote';


--
-- Name: COLUMN forum_post_vote.post_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post_vote.post_id IS 'Post';


--
-- Name: COLUMN forum_post_vote.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post_vote.user_id IS 'User';


--
-- Name: COLUMN forum_post_vote.forum_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post_vote.forum_id IS 'Forum';


--
-- Name: COLUMN forum_post_vote.recipient_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post_vote.recipient_id IS 'To';


--
-- Name: COLUMN forum_post_vote.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post_vote.create_uid IS 'Created by';


--
-- Name: COLUMN forum_post_vote.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post_vote.write_uid IS 'Last Updated by';


--
-- Name: COLUMN forum_post_vote.vote; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post_vote.vote IS 'Vote';


--
-- Name: COLUMN forum_post_vote.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post_vote.create_date IS 'Create Date';


--
-- Name: COLUMN forum_post_vote.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_post_vote.write_date IS 'Last Updated on';


--
-- Name: forum_post_vote_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.forum_post_vote_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: forum_post_vote_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.forum_post_vote_id_seq OWNED BY public.forum_post_vote.id;


--
-- Name: forum_tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.forum_tag (
    id integer NOT NULL,
    color integer,
    forum_id integer NOT NULL,
    posts_count integer,
    create_uid integer,
    write_uid integer,
    website_meta_og_img character varying,
    name character varying NOT NULL,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE forum_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.forum_tag IS 'Forum Tag';


--
-- Name: COLUMN forum_tag.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_tag.color IS 'Color';


--
-- Name: COLUMN forum_tag.forum_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_tag.forum_id IS 'Forum';


--
-- Name: COLUMN forum_tag.posts_count; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_tag.posts_count IS 'Number of Posts';


--
-- Name: COLUMN forum_tag.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_tag.create_uid IS 'Created by';


--
-- Name: COLUMN forum_tag.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN forum_tag.website_meta_og_img; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_tag.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN forum_tag.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_tag.name IS 'Name';


--
-- Name: COLUMN forum_tag.website_meta_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_tag.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN forum_tag.website_meta_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_tag.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN forum_tag.website_meta_keywords; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_tag.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN forum_tag.seo_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_tag.seo_name IS 'Seo name';


--
-- Name: COLUMN forum_tag.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_tag.create_date IS 'Created on';


--
-- Name: COLUMN forum_tag.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.forum_tag.write_date IS 'Last Updated on';


--
-- Name: forum_tag_helpdesk_ticket_select_forum_wizard_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.forum_tag_helpdesk_ticket_select_forum_wizard_rel (
    helpdesk_ticket_select_forum_wizard_id integer NOT NULL,
    forum_tag_id integer NOT NULL
);


--
-- Name: TABLE forum_tag_helpdesk_ticket_select_forum_wizard_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.forum_tag_helpdesk_ticket_select_forum_wizard_rel IS 'RELATION BETWEEN helpdesk_ticket_select_forum_wizard AND forum_tag';


--
-- Name: forum_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.forum_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: forum_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.forum_tag_id_seq OWNED BY public.forum_tag.id;


--
-- Name: forum_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.forum_tag_rel (
    forum_post_id integer NOT NULL,
    forum_tag_id integer NOT NULL
);


--
-- Name: TABLE forum_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.forum_tag_rel IS 'RELATION BETWEEN forum_post AND forum_tag';


--
-- Name: gamification_badge; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.gamification_badge (
    id integer NOT NULL,
    rule_max_number integer,
    create_uid integer,
    write_uid integer,
    level character varying,
    rule_auth character varying NOT NULL,
    name jsonb NOT NULL,
    description jsonb,
    active boolean,
    rule_max boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    survey_id integer,
    is_published boolean
);


--
-- Name: TABLE gamification_badge; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.gamification_badge IS 'Gamification Badge';


--
-- Name: COLUMN gamification_badge.rule_max_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge.rule_max_number IS 'Limitation Number';


--
-- Name: COLUMN gamification_badge.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_badge.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_badge.level; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge.level IS 'Forum Badge Level';


--
-- Name: COLUMN gamification_badge.rule_auth; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge.rule_auth IS 'Allowance to Grant';


--
-- Name: COLUMN gamification_badge.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge.name IS 'Badge';


--
-- Name: COLUMN gamification_badge.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge.description IS 'Description';


--
-- Name: COLUMN gamification_badge.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge.active IS 'Active';


--
-- Name: COLUMN gamification_badge.rule_max; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge.rule_max IS 'Monthly Limited Sending';


--
-- Name: COLUMN gamification_badge.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge.create_date IS 'Created on';


--
-- Name: COLUMN gamification_badge.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge.write_date IS 'Last Updated on';


--
-- Name: COLUMN gamification_badge.survey_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge.survey_id IS 'Survey';


--
-- Name: COLUMN gamification_badge.is_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge.is_published IS 'Is Published';


--
-- Name: gamification_badge_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.gamification_badge_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: gamification_badge_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.gamification_badge_id_seq OWNED BY public.gamification_badge.id;


--
-- Name: gamification_badge_rule_badge_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.gamification_badge_rule_badge_rel (
    badge1_id integer NOT NULL,
    badge2_id integer NOT NULL
);


--
-- Name: TABLE gamification_badge_rule_badge_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.gamification_badge_rule_badge_rel IS 'RELATION BETWEEN gamification_badge AND gamification_badge';


--
-- Name: gamification_badge_user; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.gamification_badge_user (
    id integer NOT NULL,
    user_id integer NOT NULL,
    sender_id integer,
    badge_id integer NOT NULL,
    challenge_id integer,
    create_uid integer,
    write_uid integer,
    level character varying,
    comment text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    employee_id integer
);


--
-- Name: TABLE gamification_badge_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.gamification_badge_user IS 'Gamification User Badge';


--
-- Name: COLUMN gamification_badge_user.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user.user_id IS 'User';


--
-- Name: COLUMN gamification_badge_user.sender_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user.sender_id IS 'Sender';


--
-- Name: COLUMN gamification_badge_user.badge_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user.badge_id IS 'Badge';


--
-- Name: COLUMN gamification_badge_user.challenge_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user.challenge_id IS 'Challenge';


--
-- Name: COLUMN gamification_badge_user.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_badge_user.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_badge_user.level; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user.level IS 'Badge Level';


--
-- Name: COLUMN gamification_badge_user.comment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user.comment IS 'Comment';


--
-- Name: COLUMN gamification_badge_user.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user.create_date IS 'Created on';


--
-- Name: COLUMN gamification_badge_user.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user.write_date IS 'Last Updated on';


--
-- Name: COLUMN gamification_badge_user.employee_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user.employee_id IS 'Employee';


--
-- Name: gamification_badge_user_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.gamification_badge_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: gamification_badge_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.gamification_badge_user_id_seq OWNED BY public.gamification_badge_user.id;


--
-- Name: gamification_badge_user_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.gamification_badge_user_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    badge_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    comment text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    employee_id integer
);


--
-- Name: TABLE gamification_badge_user_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.gamification_badge_user_wizard IS 'Gamification User Badge Wizard';


--
-- Name: COLUMN gamification_badge_user_wizard.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user_wizard.user_id IS 'User';


--
-- Name: COLUMN gamification_badge_user_wizard.badge_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user_wizard.badge_id IS 'Badge';


--
-- Name: COLUMN gamification_badge_user_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_badge_user_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_badge_user_wizard.comment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user_wizard.comment IS 'Comment';


--
-- Name: COLUMN gamification_badge_user_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user_wizard.create_date IS 'Created on';


--
-- Name: COLUMN gamification_badge_user_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN gamification_badge_user_wizard.employee_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_badge_user_wizard.employee_id IS 'Employee';


--
-- Name: gamification_badge_user_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.gamification_badge_user_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: gamification_badge_user_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.gamification_badge_user_wizard_id_seq OWNED BY public.gamification_badge_user_wizard.id;


--
-- Name: gamification_challenge; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.gamification_challenge (
    id integer NOT NULL,
    manager_id integer,
    reward_id integer,
    reward_first_id integer,
    reward_second_id integer,
    reward_third_id integer,
    report_message_group_id integer,
    report_template_id integer NOT NULL,
    remind_update_delay integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    user_domain character varying,
    period character varying NOT NULL,
    visibility_mode character varying NOT NULL,
    report_message_frequency character varying NOT NULL,
    challenge_category character varying NOT NULL,
    start_date date,
    end_date date,
    last_report_date date,
    next_report_date date,
    name jsonb NOT NULL,
    description jsonb,
    reward_failure boolean,
    reward_realtime boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE gamification_challenge; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.gamification_challenge IS 'Gamification Challenge';


--
-- Name: COLUMN gamification_challenge.manager_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.manager_id IS 'Responsible';


--
-- Name: COLUMN gamification_challenge.reward_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.reward_id IS 'For Every Succeeding User';


--
-- Name: COLUMN gamification_challenge.reward_first_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.reward_first_id IS 'For 1st user';


--
-- Name: COLUMN gamification_challenge.reward_second_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.reward_second_id IS 'For 2nd user';


--
-- Name: COLUMN gamification_challenge.reward_third_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.reward_third_id IS 'For 3rd user';


--
-- Name: COLUMN gamification_challenge.report_message_group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.report_message_group_id IS 'Send a copy to';


--
-- Name: COLUMN gamification_challenge.report_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.report_template_id IS 'Report Template';


--
-- Name: COLUMN gamification_challenge.remind_update_delay; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.remind_update_delay IS 'Non-updated manual goals will be reminded after';


--
-- Name: COLUMN gamification_challenge.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_challenge.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_challenge.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.state IS 'State';


--
-- Name: COLUMN gamification_challenge.user_domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.user_domain IS 'User domain';


--
-- Name: COLUMN gamification_challenge.period; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.period IS 'Periodicity';


--
-- Name: COLUMN gamification_challenge.visibility_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.visibility_mode IS 'Display Mode';


--
-- Name: COLUMN gamification_challenge.report_message_frequency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.report_message_frequency IS 'Report Frequency';


--
-- Name: COLUMN gamification_challenge.challenge_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.challenge_category IS 'Appears in';


--
-- Name: COLUMN gamification_challenge.start_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.start_date IS 'Start Date';


--
-- Name: COLUMN gamification_challenge.end_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.end_date IS 'End Date';


--
-- Name: COLUMN gamification_challenge.last_report_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.last_report_date IS 'Last Report Date';


--
-- Name: COLUMN gamification_challenge.next_report_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.next_report_date IS 'Next Report Date';


--
-- Name: COLUMN gamification_challenge.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.name IS 'Challenge Name';


--
-- Name: COLUMN gamification_challenge.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.description IS 'Description';


--
-- Name: COLUMN gamification_challenge.reward_failure; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.reward_failure IS 'Reward Bests if not Succeeded?';


--
-- Name: COLUMN gamification_challenge.reward_realtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.reward_realtime IS 'Reward as soon as every goal is reached';


--
-- Name: COLUMN gamification_challenge.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.create_date IS 'Created on';


--
-- Name: COLUMN gamification_challenge.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge.write_date IS 'Last Updated on';


--
-- Name: gamification_challenge_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.gamification_challenge_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: gamification_challenge_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.gamification_challenge_id_seq OWNED BY public.gamification_challenge.id;


--
-- Name: gamification_challenge_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.gamification_challenge_line (
    id integer NOT NULL,
    challenge_id integer NOT NULL,
    definition_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    target_goal double precision NOT NULL
);


--
-- Name: TABLE gamification_challenge_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.gamification_challenge_line IS 'Gamification generic goal for challenge';


--
-- Name: COLUMN gamification_challenge_line.challenge_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge_line.challenge_id IS 'Challenge';


--
-- Name: COLUMN gamification_challenge_line.definition_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge_line.definition_id IS 'Goal Definition';


--
-- Name: COLUMN gamification_challenge_line.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge_line.sequence IS 'Sequence';


--
-- Name: COLUMN gamification_challenge_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge_line.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_challenge_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_challenge_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge_line.create_date IS 'Created on';


--
-- Name: COLUMN gamification_challenge_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN gamification_challenge_line.target_goal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_challenge_line.target_goal IS 'Target Value to Reach';


--
-- Name: gamification_challenge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.gamification_challenge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: gamification_challenge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.gamification_challenge_line_id_seq OWNED BY public.gamification_challenge_line.id;


--
-- Name: gamification_challenge_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.gamification_challenge_users_rel (
    gamification_challenge_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE gamification_challenge_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.gamification_challenge_users_rel IS 'RELATION BETWEEN gamification_challenge AND res_users';


--
-- Name: gamification_goal; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.gamification_goal (
    id integer NOT NULL,
    definition_id integer NOT NULL,
    user_id integer NOT NULL,
    line_id integer,
    challenge_id integer,
    remind_update_delay integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    start_date date,
    end_date date,
    last_update date,
    to_update boolean,
    closed boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    target_goal double precision NOT NULL,
    current double precision NOT NULL
);


--
-- Name: TABLE gamification_goal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.gamification_goal IS 'Gamification Goal';


--
-- Name: COLUMN gamification_goal.definition_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.definition_id IS 'Goal Definition';


--
-- Name: COLUMN gamification_goal.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.user_id IS 'User';


--
-- Name: COLUMN gamification_goal.line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.line_id IS 'Challenge Line';


--
-- Name: COLUMN gamification_goal.challenge_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.challenge_id IS 'Challenge';


--
-- Name: COLUMN gamification_goal.remind_update_delay; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.remind_update_delay IS 'Remind delay';


--
-- Name: COLUMN gamification_goal.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_goal.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_goal.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.state IS 'State';


--
-- Name: COLUMN gamification_goal.start_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.start_date IS 'Start Date';


--
-- Name: COLUMN gamification_goal.end_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.end_date IS 'End Date';


--
-- Name: COLUMN gamification_goal.last_update; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.last_update IS 'Last Update';


--
-- Name: COLUMN gamification_goal.to_update; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.to_update IS 'To update';


--
-- Name: COLUMN gamification_goal.closed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.closed IS 'Closed goal';


--
-- Name: COLUMN gamification_goal.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.create_date IS 'Created on';


--
-- Name: COLUMN gamification_goal.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.write_date IS 'Last Updated on';


--
-- Name: COLUMN gamification_goal.target_goal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.target_goal IS 'To Reach';


--
-- Name: COLUMN gamification_goal.current; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal.current IS 'Current Value';


--
-- Name: gamification_goal_definition; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.gamification_goal_definition (
    id integer NOT NULL,
    model_id integer,
    field_id integer,
    field_date_id integer,
    batch_distinctive_field integer,
    action_id integer,
    create_uid integer,
    write_uid integer,
    computation_mode character varying NOT NULL,
    display_mode character varying NOT NULL,
    domain character varying NOT NULL,
    batch_user_expression character varying,
    condition character varying NOT NULL,
    res_id_field character varying,
    name jsonb NOT NULL,
    suffix jsonb,
    description text,
    compute_code text,
    monetary boolean,
    batch_mode boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE gamification_goal_definition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.gamification_goal_definition IS 'Gamification Goal Definition';


--
-- Name: COLUMN gamification_goal_definition.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.model_id IS 'Model';


--
-- Name: COLUMN gamification_goal_definition.field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.field_id IS 'Field to Sum';


--
-- Name: COLUMN gamification_goal_definition.field_date_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.field_date_id IS 'Date Field';


--
-- Name: COLUMN gamification_goal_definition.batch_distinctive_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.batch_distinctive_field IS 'Distinctive field for batch user';


--
-- Name: COLUMN gamification_goal_definition.action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.action_id IS 'Action';


--
-- Name: COLUMN gamification_goal_definition.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_goal_definition.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_goal_definition.computation_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.computation_mode IS 'Computation Mode';


--
-- Name: COLUMN gamification_goal_definition.display_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.display_mode IS 'Displayed as';


--
-- Name: COLUMN gamification_goal_definition.domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.domain IS 'Filter Domain';


--
-- Name: COLUMN gamification_goal_definition.batch_user_expression; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.batch_user_expression IS 'Evaluated expression for batch mode';


--
-- Name: COLUMN gamification_goal_definition.condition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.condition IS 'Goal Performance';


--
-- Name: COLUMN gamification_goal_definition.res_id_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.res_id_field IS 'ID Field of user';


--
-- Name: COLUMN gamification_goal_definition.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.name IS 'Goal Definition';


--
-- Name: COLUMN gamification_goal_definition.suffix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.suffix IS 'Suffix';


--
-- Name: COLUMN gamification_goal_definition.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.description IS 'Goal Description';


--
-- Name: COLUMN gamification_goal_definition.compute_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.compute_code IS 'Python Code';


--
-- Name: COLUMN gamification_goal_definition.monetary; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.monetary IS 'Monetary Value';


--
-- Name: COLUMN gamification_goal_definition.batch_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.batch_mode IS 'Batch Mode';


--
-- Name: COLUMN gamification_goal_definition.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.create_date IS 'Created on';


--
-- Name: COLUMN gamification_goal_definition.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_definition.write_date IS 'Last Updated on';


--
-- Name: gamification_goal_definition_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.gamification_goal_definition_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: gamification_goal_definition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.gamification_goal_definition_id_seq OWNED BY public.gamification_goal_definition.id;


--
-- Name: gamification_goal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.gamification_goal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: gamification_goal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.gamification_goal_id_seq OWNED BY public.gamification_goal.id;


--
-- Name: gamification_goal_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.gamification_goal_wizard (
    id integer NOT NULL,
    goal_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    current double precision
);


--
-- Name: TABLE gamification_goal_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.gamification_goal_wizard IS 'Gamification Goal Wizard';


--
-- Name: COLUMN gamification_goal_wizard.goal_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_wizard.goal_id IS 'Goal';


--
-- Name: COLUMN gamification_goal_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_goal_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_goal_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_wizard.create_date IS 'Created on';


--
-- Name: COLUMN gamification_goal_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN gamification_goal_wizard.current; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_goal_wizard.current IS 'Current';


--
-- Name: gamification_goal_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.gamification_goal_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: gamification_goal_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.gamification_goal_wizard_id_seq OWNED BY public.gamification_goal_wizard.id;


--
-- Name: gamification_invited_user_ids_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.gamification_invited_user_ids_rel (
    gamification_challenge_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE gamification_invited_user_ids_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.gamification_invited_user_ids_rel IS 'RELATION BETWEEN gamification_challenge AND res_users';


--
-- Name: gamification_karma_rank; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.gamification_karma_rank (
    id integer NOT NULL,
    karma_min integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description jsonb,
    description_motivational jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT gamification_karma_rank_karma_min_check CHECK ((karma_min > 0))
);


--
-- Name: TABLE gamification_karma_rank; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.gamification_karma_rank IS 'Rank based on karma';


--
-- Name: COLUMN gamification_karma_rank.karma_min; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_rank.karma_min IS 'Required Karma';


--
-- Name: COLUMN gamification_karma_rank.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_rank.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_karma_rank.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_rank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_karma_rank.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_rank.name IS 'Rank Name';


--
-- Name: COLUMN gamification_karma_rank.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_rank.description IS 'Description';


--
-- Name: COLUMN gamification_karma_rank.description_motivational; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_rank.description_motivational IS 'Motivational';


--
-- Name: COLUMN gamification_karma_rank.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_rank.create_date IS 'Created on';


--
-- Name: COLUMN gamification_karma_rank.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_rank.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT gamification_karma_rank_karma_min_check ON gamification_karma_rank; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT gamification_karma_rank_karma_min_check ON public.gamification_karma_rank IS 'CHECK( karma_min > 0 )';


--
-- Name: gamification_karma_rank_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.gamification_karma_rank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: gamification_karma_rank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.gamification_karma_rank_id_seq OWNED BY public.gamification_karma_rank.id;


--
-- Name: gamification_karma_tracking; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.gamification_karma_tracking (
    id integer NOT NULL,
    user_id integer NOT NULL,
    old_value integer,
    new_value integer NOT NULL,
    create_uid integer,
    write_uid integer,
    origin_ref character varying,
    origin_ref_model_name character varying,
    reason text,
    consolidated boolean,
    tracking_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE gamification_karma_tracking; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.gamification_karma_tracking IS 'Track Karma Changes';


--
-- Name: COLUMN gamification_karma_tracking.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_tracking.user_id IS 'User';


--
-- Name: COLUMN gamification_karma_tracking.old_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_tracking.old_value IS 'Old Karma Value';


--
-- Name: COLUMN gamification_karma_tracking.new_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_tracking.new_value IS 'New Karma Value';


--
-- Name: COLUMN gamification_karma_tracking.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_tracking.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_karma_tracking.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_tracking.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_karma_tracking.origin_ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_tracking.origin_ref IS 'Source';


--
-- Name: COLUMN gamification_karma_tracking.origin_ref_model_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_tracking.origin_ref_model_name IS 'Source Type';


--
-- Name: COLUMN gamification_karma_tracking.reason; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_tracking.reason IS 'Description';


--
-- Name: COLUMN gamification_karma_tracking.consolidated; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_tracking.consolidated IS 'Consolidated';


--
-- Name: COLUMN gamification_karma_tracking.tracking_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_tracking.tracking_date IS 'Tracking Date';


--
-- Name: COLUMN gamification_karma_tracking.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_tracking.create_date IS 'Created on';


--
-- Name: COLUMN gamification_karma_tracking.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.gamification_karma_tracking.write_date IS 'Last Updated on';


--
-- Name: gamification_karma_tracking_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.gamification_karma_tracking_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: gamification_karma_tracking_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.gamification_karma_tracking_id_seq OWNED BY public.gamification_karma_tracking.id;


--
-- Name: google_calendar_account_reset; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.google_calendar_account_reset (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    delete_policy character varying NOT NULL,
    sync_policy character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE google_calendar_account_reset; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.google_calendar_account_reset IS 'Google Calendar Account Reset';


--
-- Name: COLUMN google_calendar_account_reset.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.google_calendar_account_reset.user_id IS 'User';


--
-- Name: COLUMN google_calendar_account_reset.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.google_calendar_account_reset.create_uid IS 'Created by';


--
-- Name: COLUMN google_calendar_account_reset.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.google_calendar_account_reset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN google_calendar_account_reset.delete_policy; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.google_calendar_account_reset.delete_policy IS 'User''s Existing Events';


--
-- Name: COLUMN google_calendar_account_reset.sync_policy; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.google_calendar_account_reset.sync_policy IS 'Next Synchronization';


--
-- Name: COLUMN google_calendar_account_reset.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.google_calendar_account_reset.create_date IS 'Created on';


--
-- Name: COLUMN google_calendar_account_reset.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.google_calendar_account_reset.write_date IS 'Last Updated on';


--
-- Name: google_calendar_account_reset_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.google_calendar_account_reset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: google_calendar_account_reset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.google_calendar_account_reset_id_seq OWNED BY public.google_calendar_account_reset.id;


--
-- Name: header_footer_quotation_template_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.header_footer_quotation_template_rel (
    quotation_document_id integer NOT NULL,
    sale_order_template_id integer NOT NULL
);


--
-- Name: TABLE header_footer_quotation_template_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.header_footer_quotation_template_rel IS 'RELATION BETWEEN quotation_document AND sale_order_template';


--
-- Name: helpdesk_sla; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_sla (
    id integer NOT NULL,
    team_id integer NOT NULL,
    stage_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    priority character varying NOT NULL,
    name jsonb NOT NULL,
    description jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "time" double precision NOT NULL
);


--
-- Name: TABLE helpdesk_sla; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_sla IS 'Helpdesk SLA Policies';


--
-- Name: COLUMN helpdesk_sla.team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla.team_id IS 'Helpdesk Team';


--
-- Name: COLUMN helpdesk_sla.stage_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla.stage_id IS 'Target Stage';


--
-- Name: COLUMN helpdesk_sla.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla.company_id IS 'Company';


--
-- Name: COLUMN helpdesk_sla.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_sla.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_sla.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla.priority IS 'Priority';


--
-- Name: COLUMN helpdesk_sla.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla.name IS 'Name';


--
-- Name: COLUMN helpdesk_sla.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla.description IS 'SLA Policy Description';


--
-- Name: COLUMN helpdesk_sla.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla.active IS 'Active';


--
-- Name: COLUMN helpdesk_sla.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_sla.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_sla."time"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla."time" IS 'Within';


--
-- Name: helpdesk_sla_helpdesk_stage_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_sla_helpdesk_stage_rel (
    helpdesk_sla_id integer NOT NULL,
    helpdesk_stage_id integer NOT NULL
);


--
-- Name: TABLE helpdesk_sla_helpdesk_stage_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_sla_helpdesk_stage_rel IS 'RELATION BETWEEN helpdesk_sla AND helpdesk_stage';


--
-- Name: helpdesk_sla_helpdesk_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_sla_helpdesk_tag_rel (
    helpdesk_sla_id integer NOT NULL,
    helpdesk_tag_id integer NOT NULL
);


--
-- Name: TABLE helpdesk_sla_helpdesk_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_sla_helpdesk_tag_rel IS 'RELATION BETWEEN helpdesk_sla AND helpdesk_tag';


--
-- Name: helpdesk_sla_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.helpdesk_sla_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: helpdesk_sla_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.helpdesk_sla_id_seq OWNED BY public.helpdesk_sla.id;


--
-- Name: helpdesk_sla_report_analysis; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.helpdesk_sla_report_analysis AS
SELECT
    NULL::integer AS id,
    NULL::integer AS ticket_id,
    NULL::text AS description,
    NULL::character varying AS ticket_ref,
    NULL::character varying AS name,
    NULL::timestamp without time zone AS create_date,
    NULL::integer AS team_id,
    NULL::boolean AS active,
    NULL::integer AS stage_id,
    NULL::integer AS user_id,
    NULL::integer AS partner_id,
    NULL::character varying AS partner_name,
    NULL::character varying AS partner_email,
    NULL::character varying AS partner_phone,
    NULL::integer AS company_id,
    NULL::character varying AS kanban_state,
    NULL::double precision AS rating_last_value,
    NULL::double precision AS rating_avg,
    NULL::character varying AS priority,
    NULL::double precision AS ticket_close_hours,
    NULL::numeric AS ticket_open_hours,
    NULL::double precision AS ticket_assignation_hours,
    NULL::double precision AS avg_response_hours,
    NULL::double precision AS first_response_hours,
    NULL::timestamp without time zone AS close_date,
    NULL::boolean AS ticket_closed,
    NULL::integer AS sla_stage_id,
    NULL::timestamp without time zone AS sla_deadline,
    NULL::integer AS sla_id,
    NULL::double precision AS sla_exceeded_hours,
    NULL::boolean AS sla_fail,
    NULL::integer AS sla_status_failed,
    NULL::text AS sla_status,
    NULL::boolean AS sla_success,
    NULL::integer AS sale_order_id;


--
-- Name: helpdesk_sla_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_sla_res_partner_rel (
    helpdesk_sla_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE helpdesk_sla_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_sla_res_partner_rel IS 'RELATION BETWEEN helpdesk_sla AND res_partner';


--
-- Name: helpdesk_sla_status; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_sla_status (
    id integer NOT NULL,
    ticket_id integer NOT NULL,
    sla_id integer NOT NULL,
    sla_stage_id integer,
    create_uid integer,
    write_uid integer,
    deadline timestamp without time zone,
    reached_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    exceeded_hours double precision
);


--
-- Name: TABLE helpdesk_sla_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_sla_status IS 'Ticket SLA Status';


--
-- Name: COLUMN helpdesk_sla_status.ticket_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla_status.ticket_id IS 'Ticket';


--
-- Name: COLUMN helpdesk_sla_status.sla_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla_status.sla_id IS 'Sla';


--
-- Name: COLUMN helpdesk_sla_status.sla_stage_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla_status.sla_stage_id IS 'Target Stage';


--
-- Name: COLUMN helpdesk_sla_status.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla_status.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_sla_status.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla_status.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_sla_status.deadline; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla_status.deadline IS 'Deadline';


--
-- Name: COLUMN helpdesk_sla_status.reached_datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla_status.reached_datetime IS 'Reached Date';


--
-- Name: COLUMN helpdesk_sla_status.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla_status.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_sla_status.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla_status.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_sla_status.exceeded_hours; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_sla_status.exceeded_hours IS 'Exceeded Working Hours';


--
-- Name: helpdesk_sla_status_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.helpdesk_sla_status_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: helpdesk_sla_status_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.helpdesk_sla_status_id_seq OWNED BY public.helpdesk_sla_status.id;


--
-- Name: helpdesk_stage; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_stage (
    id integer NOT NULL,
    sequence integer,
    template_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description jsonb,
    legend_blocked jsonb NOT NULL,
    legend_done jsonb NOT NULL,
    legend_normal jsonb NOT NULL,
    active boolean,
    fold boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sms_template_id integer
);


--
-- Name: TABLE helpdesk_stage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_stage IS 'Helpdesk Stage';


--
-- Name: COLUMN helpdesk_stage.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage.sequence IS 'Sequence';


--
-- Name: COLUMN helpdesk_stage.template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage.template_id IS 'Email Template';


--
-- Name: COLUMN helpdesk_stage.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_stage.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_stage.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage.name IS 'Name';


--
-- Name: COLUMN helpdesk_stage.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage.description IS 'Description';


--
-- Name: COLUMN helpdesk_stage.legend_blocked; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage.legend_blocked IS 'Red Kanban Label';


--
-- Name: COLUMN helpdesk_stage.legend_done; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage.legend_done IS 'Green Kanban Label';


--
-- Name: COLUMN helpdesk_stage.legend_normal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage.legend_normal IS 'Grey Kanban Label';


--
-- Name: COLUMN helpdesk_stage.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage.active IS 'Active';


--
-- Name: COLUMN helpdesk_stage.fold; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage.fold IS 'Folded in Kanban';


--
-- Name: COLUMN helpdesk_stage.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_stage.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_stage.sms_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage.sms_template_id IS 'SMS Template';


--
-- Name: helpdesk_stage_delete_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_stage_delete_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE helpdesk_stage_delete_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_stage_delete_wizard IS 'Helpdesk Stage Delete Wizard';


--
-- Name: COLUMN helpdesk_stage_delete_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage_delete_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_stage_delete_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage_delete_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_stage_delete_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage_delete_wizard.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_stage_delete_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_stage_delete_wizard.write_date IS 'Last Updated on';


--
-- Name: helpdesk_stage_delete_wizard_helpdesk_team_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_stage_delete_wizard_helpdesk_team_rel (
    helpdesk_stage_delete_wizard_id integer NOT NULL,
    helpdesk_team_id integer NOT NULL
);


--
-- Name: TABLE helpdesk_stage_delete_wizard_helpdesk_team_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_stage_delete_wizard_helpdesk_team_rel IS 'RELATION BETWEEN helpdesk_stage_delete_wizard AND helpdesk_team';


--
-- Name: helpdesk_stage_delete_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.helpdesk_stage_delete_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: helpdesk_stage_delete_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.helpdesk_stage_delete_wizard_id_seq OWNED BY public.helpdesk_stage_delete_wizard.id;


--
-- Name: helpdesk_stage_helpdesk_stage_delete_wizard_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_stage_helpdesk_stage_delete_wizard_rel (
    helpdesk_stage_delete_wizard_id integer NOT NULL,
    helpdesk_stage_id integer NOT NULL
);


--
-- Name: TABLE helpdesk_stage_helpdesk_stage_delete_wizard_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_stage_helpdesk_stage_delete_wizard_rel IS 'RELATION BETWEEN helpdesk_stage_delete_wizard AND helpdesk_stage';


--
-- Name: helpdesk_stage_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.helpdesk_stage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: helpdesk_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.helpdesk_stage_id_seq OWNED BY public.helpdesk_stage.id;


--
-- Name: helpdesk_tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE helpdesk_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_tag IS 'Helpdesk Tags';


--
-- Name: COLUMN helpdesk_tag.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_tag.color IS 'Color';


--
-- Name: COLUMN helpdesk_tag.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_tag.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_tag.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_tag.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_tag.name IS 'Name';


--
-- Name: COLUMN helpdesk_tag.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_tag.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_tag.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_tag.write_date IS 'Last Updated on';


--
-- Name: helpdesk_tag_helpdesk_ticket_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_tag_helpdesk_ticket_rel (
    helpdesk_ticket_id integer NOT NULL,
    helpdesk_tag_id integer NOT NULL
);


--
-- Name: TABLE helpdesk_tag_helpdesk_ticket_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_tag_helpdesk_ticket_rel IS 'RELATION BETWEEN helpdesk_ticket AND helpdesk_tag';


--
-- Name: helpdesk_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.helpdesk_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: helpdesk_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.helpdesk_tag_id_seq OWNED BY public.helpdesk_tag.id;


--
-- Name: helpdesk_team; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_team (
    id integer NOT NULL,
    alias_id integer NOT NULL,
    company_id integer NOT NULL,
    sequence integer,
    color integer,
    resource_calendar_id integer,
    auto_close_day integer,
    to_stage_id integer,
    create_uid integer,
    write_uid integer,
    assign_method character varying NOT NULL,
    privacy_visibility character varying NOT NULL,
    name jsonb NOT NULL,
    description jsonb,
    ticket_properties jsonb,
    active boolean,
    auto_assignment boolean,
    use_alias boolean,
    allow_portal_ticket_closing boolean,
    use_website_helpdesk_form boolean,
    use_website_helpdesk_livechat boolean,
    use_website_helpdesk_forum boolean,
    use_website_helpdesk_slides boolean,
    use_website_helpdesk_knowledge boolean,
    use_helpdesk_timesheet boolean,
    use_helpdesk_sale_timesheet boolean,
    use_credit_notes boolean,
    use_coupons boolean,
    use_fsm boolean,
    use_product_returns boolean,
    use_product_repairs boolean,
    use_twitter boolean,
    use_rating boolean,
    use_sla boolean,
    auto_close_ticket boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    website_id integer,
    website_menu_id integer,
    website_form_view_id integer,
    website_meta_og_img character varying,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    is_published boolean,
    website_article_id integer
);


--
-- Name: TABLE helpdesk_team; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_team IS 'Helpdesk Team';


--
-- Name: COLUMN helpdesk_team.alias_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.alias_id IS 'Alias';


--
-- Name: COLUMN helpdesk_team.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.company_id IS 'Company';


--
-- Name: COLUMN helpdesk_team.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.sequence IS 'Sequence';


--
-- Name: COLUMN helpdesk_team.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.color IS 'Color Index';


--
-- Name: COLUMN helpdesk_team.resource_calendar_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN helpdesk_team.auto_close_day; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.auto_close_day IS 'Inactive Period(days)';


--
-- Name: COLUMN helpdesk_team.to_stage_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.to_stage_id IS 'Move to Stage';


--
-- Name: COLUMN helpdesk_team.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_team.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_team.assign_method; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.assign_method IS 'Assignment Method';


--
-- Name: COLUMN helpdesk_team.privacy_visibility; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.privacy_visibility IS 'Visibility';


--
-- Name: COLUMN helpdesk_team.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.name IS 'Helpdesk Team';


--
-- Name: COLUMN helpdesk_team.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.description IS 'About Team';


--
-- Name: COLUMN helpdesk_team.ticket_properties; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.ticket_properties IS 'Ticket Properties';


--
-- Name: COLUMN helpdesk_team.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.active IS 'Active';


--
-- Name: COLUMN helpdesk_team.auto_assignment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.auto_assignment IS 'Automatic Assignment';


--
-- Name: COLUMN helpdesk_team.use_alias; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.use_alias IS 'Use Alias';


--
-- Name: COLUMN helpdesk_team.allow_portal_ticket_closing; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.allow_portal_ticket_closing IS 'Closure by Customers';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_form; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_form IS 'Website Form';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_livechat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_livechat IS 'Live Chat';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_forum; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_forum IS 'Community Forum';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_slides; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_slides IS 'eLearning';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_knowledge; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_knowledge IS 'Knowledge';


--
-- Name: COLUMN helpdesk_team.use_helpdesk_timesheet; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.use_helpdesk_timesheet IS 'Timesheets';


--
-- Name: COLUMN helpdesk_team.use_helpdesk_sale_timesheet; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.use_helpdesk_sale_timesheet IS 'Time Billing';


--
-- Name: COLUMN helpdesk_team.use_credit_notes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.use_credit_notes IS 'Refunds';


--
-- Name: COLUMN helpdesk_team.use_coupons; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.use_coupons IS 'Coupons';


--
-- Name: COLUMN helpdesk_team.use_fsm; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.use_fsm IS 'Field Service';


--
-- Name: COLUMN helpdesk_team.use_product_returns; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.use_product_returns IS 'Returns';


--
-- Name: COLUMN helpdesk_team.use_product_repairs; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.use_product_repairs IS 'Repairs';


--
-- Name: COLUMN helpdesk_team.use_twitter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.use_twitter IS 'X';


--
-- Name: COLUMN helpdesk_team.use_rating; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.use_rating IS 'Customer Ratings';


--
-- Name: COLUMN helpdesk_team.use_sla; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.use_sla IS 'SLA Policies';


--
-- Name: COLUMN helpdesk_team.auto_close_ticket; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.auto_close_ticket IS 'Automatic Closing';


--
-- Name: COLUMN helpdesk_team.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_team.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_team.website_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.website_id IS 'Website';


--
-- Name: COLUMN helpdesk_team.website_menu_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.website_menu_id IS 'Website Menu';


--
-- Name: COLUMN helpdesk_team.website_form_view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.website_form_view_id IS 'Website Form View';


--
-- Name: COLUMN helpdesk_team.website_meta_og_img; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN helpdesk_team.website_meta_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN helpdesk_team.website_meta_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN helpdesk_team.website_meta_keywords; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN helpdesk_team.seo_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.seo_name IS 'Seo name';


--
-- Name: COLUMN helpdesk_team.is_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.is_published IS 'Is Published';


--
-- Name: COLUMN helpdesk_team.website_article_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_team.website_article_id IS 'Article';


--
-- Name: helpdesk_team_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.helpdesk_team_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: helpdesk_team_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.helpdesk_team_id_seq OWNED BY public.helpdesk_team.id;


--
-- Name: helpdesk_team_res_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_team_res_users_rel (
    helpdesk_team_id integer NOT NULL,
    res_users_id integer NOT NULL
);


--
-- Name: TABLE helpdesk_team_res_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_team_res_users_rel IS 'RELATION BETWEEN helpdesk_team AND res_users';


--
-- Name: helpdesk_team_slide_channel_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_team_slide_channel_rel (
    helpdesk_team_id integer NOT NULL,
    slide_channel_id integer NOT NULL
);


--
-- Name: TABLE helpdesk_team_slide_channel_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_team_slide_channel_rel IS 'RELATION BETWEEN helpdesk_team AND slide_channel';


--
-- Name: helpdesk_ticket; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_ticket (
    id integer NOT NULL,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    team_id integer,
    company_id integer,
    color integer,
    user_id integer,
    partner_id integer,
    stage_id integer,
    answered_customer_message_count integer,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    access_token character varying,
    name character varying NOT NULL,
    kanban_state character varying NOT NULL,
    partner_name character varying,
    partner_email character varying,
    partner_phone character varying,
    priority character varying,
    ticket_ref character varying,
    properties jsonb,
    description text,
    active boolean,
    closed_by_partner boolean,
    sla_reached_late boolean,
    sla_reached boolean,
    date_last_stage_update timestamp without time zone,
    assign_date timestamp without time zone,
    close_date timestamp without time zone,
    sla_deadline timestamp without time zone,
    oldest_unanswered_customer_message_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rating_last_value double precision,
    assign_hours double precision,
    close_hours double precision,
    sla_deadline_hours double precision,
    first_response_hours double precision,
    avg_response_hours double precision,
    total_response_hours double precision,
    partner_company_name character varying,
    sale_order_id integer
);


--
-- Name: TABLE helpdesk_ticket; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_ticket IS 'Helpdesk Ticket';


--
-- Name: COLUMN helpdesk_ticket.campaign_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.campaign_id IS 'Campaign';


--
-- Name: COLUMN helpdesk_ticket.source_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.source_id IS 'Source';


--
-- Name: COLUMN helpdesk_ticket.medium_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.medium_id IS 'Medium';


--
-- Name: COLUMN helpdesk_ticket.team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.team_id IS 'Helpdesk Team';


--
-- Name: COLUMN helpdesk_ticket.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.company_id IS 'Company';


--
-- Name: COLUMN helpdesk_ticket.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.color IS 'Color Index';


--
-- Name: COLUMN helpdesk_ticket.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.user_id IS 'Assigned to';


--
-- Name: COLUMN helpdesk_ticket.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_id IS 'Customer';


--
-- Name: COLUMN helpdesk_ticket.stage_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.stage_id IS 'Stage';


--
-- Name: COLUMN helpdesk_ticket.answered_customer_message_count; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.answered_customer_message_count IS '# Exchanges';


--
-- Name: COLUMN helpdesk_ticket.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_ticket.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_ticket.email_cc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.email_cc IS 'Email cc';


--
-- Name: COLUMN helpdesk_ticket.access_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.access_token IS 'Security Token';


--
-- Name: COLUMN helpdesk_ticket.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.name IS 'Subject';


--
-- Name: COLUMN helpdesk_ticket.kanban_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.kanban_state IS 'Kanban State';


--
-- Name: COLUMN helpdesk_ticket.partner_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_name IS 'Customer Name';


--
-- Name: COLUMN helpdesk_ticket.partner_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_email IS 'Customer Email';


--
-- Name: COLUMN helpdesk_ticket.partner_phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_phone IS 'Customer Phone';


--
-- Name: COLUMN helpdesk_ticket.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.priority IS 'Priority';


--
-- Name: COLUMN helpdesk_ticket.ticket_ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.ticket_ref IS 'Ticket IDs Sequence';


--
-- Name: COLUMN helpdesk_ticket.properties; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.properties IS 'Properties';


--
-- Name: COLUMN helpdesk_ticket.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.description IS 'Description';


--
-- Name: COLUMN helpdesk_ticket.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.active IS 'Active';


--
-- Name: COLUMN helpdesk_ticket.closed_by_partner; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.closed_by_partner IS 'Closed by Partner';


--
-- Name: COLUMN helpdesk_ticket.sla_reached_late; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.sla_reached_late IS 'Has SLA reached late';


--
-- Name: COLUMN helpdesk_ticket.sla_reached; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.sla_reached IS 'Has SLA reached';


--
-- Name: COLUMN helpdesk_ticket.date_last_stage_update; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.date_last_stage_update IS 'Last Stage Update';


--
-- Name: COLUMN helpdesk_ticket.assign_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.assign_date IS 'First assignment date';


--
-- Name: COLUMN helpdesk_ticket.close_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.close_date IS 'Close date';


--
-- Name: COLUMN helpdesk_ticket.sla_deadline; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.sla_deadline IS 'SLA Deadline';


--
-- Name: COLUMN helpdesk_ticket.oldest_unanswered_customer_message_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.oldest_unanswered_customer_message_date IS 'Oldest Unanswered Customer Message Date';


--
-- Name: COLUMN helpdesk_ticket.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_ticket.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_ticket.rating_last_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.rating_last_value IS 'Rating Last Value';


--
-- Name: COLUMN helpdesk_ticket.assign_hours; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.assign_hours IS 'Time to first assignment (hours)';


--
-- Name: COLUMN helpdesk_ticket.close_hours; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.close_hours IS 'Time to close (hours)';


--
-- Name: COLUMN helpdesk_ticket.sla_deadline_hours; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.sla_deadline_hours IS 'Working Hours until SLA Deadline';


--
-- Name: COLUMN helpdesk_ticket.first_response_hours; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.first_response_hours IS 'Hours to First Response';


--
-- Name: COLUMN helpdesk_ticket.avg_response_hours; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.avg_response_hours IS 'Average Hours to Respond';


--
-- Name: COLUMN helpdesk_ticket.total_response_hours; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.total_response_hours IS 'Total Exchange Time in Hours';


--
-- Name: COLUMN helpdesk_ticket.partner_company_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_company_name IS 'Company Name';


--
-- Name: COLUMN helpdesk_ticket.sale_order_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket.sale_order_id IS 'Ref. Sales Order';


--
-- Name: helpdesk_ticket_convert_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_ticket_convert_wizard (
    id integer NOT NULL,
    project_id integer,
    stage_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE helpdesk_ticket_convert_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_ticket_convert_wizard IS 'Convert Helpdesk Tickets to Tasks';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.project_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.project_id IS 'Project';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.stage_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.stage_id IS 'Stage';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.write_date IS 'Last Updated on';


--
-- Name: helpdesk_ticket_convert_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.helpdesk_ticket_convert_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: helpdesk_ticket_convert_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.helpdesk_ticket_convert_wizard_id_seq OWNED BY public.helpdesk_ticket_convert_wizard.id;


--
-- Name: helpdesk_ticket_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.helpdesk_ticket_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: helpdesk_ticket_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.helpdesk_ticket_id_seq OWNED BY public.helpdesk_ticket.id;


--
-- Name: helpdesk_ticket_report_analysis; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.helpdesk_ticket_report_analysis AS
SELECT
    NULL::integer AS id,
    NULL::integer AS ticket_id,
    NULL::text AS description,
    NULL::character varying AS ticket_ref,
    NULL::character varying AS name,
    NULL::timestamp without time zone AS create_date,
    NULL::character varying AS priority,
    NULL::integer AS user_id,
    NULL::integer AS partner_id,
    NULL::character varying AS partner_name,
    NULL::character varying AS partner_email,
    NULL::character varying AS partner_phone,
    NULL::integer AS stage_id,
    NULL::timestamp without time zone AS sla_deadline,
    NULL::double precision AS ticket_deadline_hours,
    NULL::double precision AS ticket_close_hours,
    NULL::numeric AS ticket_open_hours,
    NULL::double precision AS ticket_assignation_hours,
    NULL::timestamp without time zone AS close_date,
    NULL::timestamp without time zone AS assign_date,
    NULL::double precision AS rating_last_value,
    NULL::double precision AS rating_avg,
    NULL::boolean AS active,
    NULL::integer AS team_id,
    NULL::integer AS company_id,
    NULL::character varying AS kanban_state,
    NULL::double precision AS first_response_hours,
    NULL::double precision AS avg_response_hours,
    NULL::boolean AS sla_success,
    NULL::integer AS sale_order_id;


--
-- Name: helpdesk_ticket_select_forum_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_ticket_select_forum_wizard (
    id integer NOT NULL,
    ticket_id integer,
    forum_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    title character varying NOT NULL,
    description text NOT NULL,
    answer_content text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE helpdesk_ticket_select_forum_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_ticket_select_forum_wizard IS 'Share on Forum';


--
-- Name: COLUMN helpdesk_ticket_select_forum_wizard.ticket_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_select_forum_wizard.ticket_id IS 'Ticket';


--
-- Name: COLUMN helpdesk_ticket_select_forum_wizard.forum_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_select_forum_wizard.forum_id IS 'Forum';


--
-- Name: COLUMN helpdesk_ticket_select_forum_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_select_forum_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_ticket_select_forum_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_select_forum_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_ticket_select_forum_wizard.title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_select_forum_wizard.title IS 'Title';


--
-- Name: COLUMN helpdesk_ticket_select_forum_wizard.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_select_forum_wizard.description IS 'Description';


--
-- Name: COLUMN helpdesk_ticket_select_forum_wizard.answer_content; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_select_forum_wizard.answer_content IS 'Answer';


--
-- Name: COLUMN helpdesk_ticket_select_forum_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_select_forum_wizard.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_ticket_select_forum_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_select_forum_wizard.write_date IS 'Last Updated on';


--
-- Name: helpdesk_ticket_select_forum_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.helpdesk_ticket_select_forum_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: helpdesk_ticket_select_forum_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.helpdesk_ticket_select_forum_wizard_id_seq OWNED BY public.helpdesk_ticket_select_forum_wizard.id;


--
-- Name: helpdesk_ticket_to_lead; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.helpdesk_ticket_to_lead (
    id integer NOT NULL,
    ticket_id integer NOT NULL,
    partner_id integer,
    team_id integer,
    user_id integer,
    create_uid integer,
    write_uid integer,
    convert_to character varying,
    action character varying,
    force_assignment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE helpdesk_ticket_to_lead; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.helpdesk_ticket_to_lead IS 'Convert Ticket to Lead';


--
-- Name: COLUMN helpdesk_ticket_to_lead.ticket_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_to_lead.ticket_id IS 'Ticket';


--
-- Name: COLUMN helpdesk_ticket_to_lead.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_to_lead.partner_id IS 'Customer';


--
-- Name: COLUMN helpdesk_ticket_to_lead.team_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_to_lead.team_id IS 'Sales Team';


--
-- Name: COLUMN helpdesk_ticket_to_lead.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_to_lead.user_id IS 'Salesperson';


--
-- Name: COLUMN helpdesk_ticket_to_lead.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_to_lead.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_ticket_to_lead.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_to_lead.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_ticket_to_lead.convert_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_to_lead.convert_to IS 'Conversion Action';


--
-- Name: COLUMN helpdesk_ticket_to_lead.action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_to_lead.action IS 'Related Customer';


--
-- Name: COLUMN helpdesk_ticket_to_lead.force_assignment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_to_lead.force_assignment IS 'Force assignment';


--
-- Name: COLUMN helpdesk_ticket_to_lead.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_to_lead.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_ticket_to_lead.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.helpdesk_ticket_to_lead.write_date IS 'Last Updated on';


--
-- Name: helpdesk_ticket_to_lead_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.helpdesk_ticket_to_lead_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: helpdesk_ticket_to_lead_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.helpdesk_ticket_to_lead_id_seq OWNED BY public.helpdesk_ticket_to_lead.id;


--
-- Name: hr_appraisal; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.hr_appraisal (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    company_id integer,
    department_id integer,
    appraisal_template_id integer,
    assessment_note integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    date_close date NOT NULL,
    appraisal_properties jsonb,
    employee_feedback text,
    manager_feedback text,
    note text,
    active boolean,
    employee_feedback_published boolean,
    manager_feedback_published boolean,
    appraisal_plan_posted boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE hr_appraisal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.hr_appraisal IS 'Employee Appraisal';


--
-- Name: COLUMN hr_appraisal.employee_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.employee_id IS 'Employee';


--
-- Name: COLUMN hr_appraisal.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.company_id IS 'Company';


--
-- Name: COLUMN hr_appraisal.department_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.department_id IS 'Department';


--
-- Name: COLUMN hr_appraisal.appraisal_template_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.appraisal_template_id IS 'Appraisal Template';


--
-- Name: COLUMN hr_appraisal.assessment_note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.assessment_note IS 'Final Rating';


--
-- Name: COLUMN hr_appraisal.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.create_uid IS 'Created by';


--
-- Name: COLUMN hr_appraisal.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_appraisal.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.state IS 'Status';


--
-- Name: COLUMN hr_appraisal.date_close; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.date_close IS 'Appraisal Date';


--
-- Name: COLUMN hr_appraisal.appraisal_properties; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.appraisal_properties IS 'Properties';


--
-- Name: COLUMN hr_appraisal.employee_feedback; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.employee_feedback IS 'Employee Feedback';


--
-- Name: COLUMN hr_appraisal.manager_feedback; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.manager_feedback IS 'Manager Feedback';


--
-- Name: COLUMN hr_appraisal.note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.note IS 'Private Note';


--
-- Name: COLUMN hr_appraisal.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.active IS 'Active';


--
-- Name: COLUMN hr_appraisal.employee_feedback_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.employee_feedback_published IS 'Employee Feedback Published';


--
-- Name: COLUMN hr_appraisal.manager_feedback_published; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.manager_feedback_published IS 'Manager Feedback Published';


--
-- Name: COLUMN hr_appraisal.appraisal_plan_posted; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.appraisal_plan_posted IS 'Appraisal Plan Posted';


--
-- Name: COLUMN hr_appraisal.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.create_date IS 'Created on';


--
-- Name: COLUMN hr_appraisal.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal.write_date IS 'Last Updated on';


--
-- Name: hr_appraisal_goal; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.hr_appraisal_goal (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    manager_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    progression character varying NOT NULL,
    deadline date,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE hr_appraisal_goal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.hr_appraisal_goal IS 'Appraisal Goal';


--
-- Name: COLUMN hr_appraisal_goal.employee_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_goal.employee_id IS 'Employee';


--
-- Name: COLUMN hr_appraisal_goal.manager_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_goal.manager_id IS 'Manager';


--
-- Name: COLUMN hr_appraisal_goal.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_goal.create_uid IS 'Created by';


--
-- Name: COLUMN hr_appraisal_goal.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_goal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_appraisal_goal.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_goal.name IS 'Name';


--
-- Name: COLUMN hr_appraisal_goal.progression; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_goal.progression IS 'Progress';


--
-- Name: COLUMN hr_appraisal_goal.deadline; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_goal.deadline IS 'Deadline';


--
-- Name: COLUMN hr_appraisal_goal.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_goal.description IS 'Description';


--
-- Name: COLUMN hr_appraisal_goal.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_goal.create_date IS 'Created on';


--
-- Name: COLUMN hr_appraisal_goal.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_goal.write_date IS 'Last Updated on';


--
-- Name: hr_appraisal_goal_hr_appraisal_goal_tag_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.hr_appraisal_goal_hr_appraisal_goal_tag_rel (
    hr_appraisal_goal_id integer NOT NULL,
    hr_appraisal_goal_tag_id integer NOT NULL
);


--
-- Name: TABLE hr_appraisal_goal_hr_appraisal_goal_tag_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.hr_appraisal_goal_hr_appraisal_goal_tag_rel IS 'RELATION BETWEEN hr_appraisal_goal AND hr_appraisal_goal_tag';


--
-- Name: hr_appraisal_goal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.hr_appraisal_goal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_appraisal_goal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.hr_appraisal_goal_id_seq OWNED BY public.hr_appraisal_goal.id;


--
-- Name: hr_appraisal_goal_tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.hr_appraisal_goal_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE hr_appraisal_goal_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.hr_appraisal_goal_tag IS 'Appraisal Goal Tags';


--
-- Name: COLUMN hr_appraisal_goal_tag.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_goal_tag.color IS 'Color';


--
-- Name: COLUMN hr_appraisal_goal_tag.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_goal_tag.create_uid IS 'Created by';


--
-- Name: COLUMN hr_appraisal_goal_tag.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_goal_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_appraisal_goal_tag.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_goal_tag.name IS 'Name';


--
-- Name: COLUMN hr_appraisal_goal_tag.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_goal_tag.create_date IS 'Created on';


--
-- Name: COLUMN hr_appraisal_goal_tag.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_goal_tag.write_date IS 'Last Updated on';


--
-- Name: hr_appraisal_goal_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.hr_appraisal_goal_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_appraisal_goal_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.hr_appraisal_goal_tag_id_seq OWNED BY public.hr_appraisal_goal_tag.id;


--
-- Name: hr_appraisal_hr_employee_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.hr_appraisal_hr_employee_rel (
    hr_appraisal_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


--
-- Name: TABLE hr_appraisal_hr_employee_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.hr_appraisal_hr_employee_rel IS 'RELATION BETWEEN hr_appraisal AND hr_employee';


--
-- Name: hr_appraisal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.hr_appraisal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_appraisal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.hr_appraisal_id_seq OWNED BY public.hr_appraisal.id;


--
-- Name: hr_appraisal_note; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.hr_appraisal_note (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE hr_appraisal_note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.hr_appraisal_note IS 'Appraisal Assessment Note';


--
-- Name: COLUMN hr_appraisal_note.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_note.sequence IS 'Sequence';


--
-- Name: COLUMN hr_appraisal_note.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_note.company_id IS 'Company';


--
-- Name: COLUMN hr_appraisal_note.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_note.create_uid IS 'Created by';


--
-- Name: COLUMN hr_appraisal_note.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_note.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_appraisal_note.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_note.name IS 'Name';


--
-- Name: COLUMN hr_appraisal_note.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_note.create_date IS 'Created on';


--
-- Name: COLUMN hr_appraisal_note.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_appraisal_note.write_date IS 'Last Updated on';


--
-- Name: hr_appraisal_note_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.hr_appraisal_note_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: hr_appraisal_note_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.hr_appraisal_note_id_seq OWNED BY public.hr_appraisal_note.id;


--
-- Name: hr_employee; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.hr_employee (
    id integer NOT NULL,
    resource_id integer NOT NULL,
    company_id integer NOT NULL,
    resource_calendar_id integer,
    message_main_attachment_id integer,
    color integer,
    department_id integer,
    job_id integer,
    address_id integer,
    work_contact_id integer,
    work_location_id integer,
    user_id integer,
    parent_id integer,
    coach_id integer,
    private_state_id integer,
    private_country_id integer,
    country_id integer,
    children integer,
    country_of_birth integer,
    bank_account_id integer,
    distance_home_work integer,
    km_home_work integer,
    departure_reason_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    job_title character varying,
    work_phone character varying,
    mobile_phone character varying,
    work_email character varying,
    private_street character varying,
    private_street2 character varying,
    private_city character varying,
    private_zip character varying,
    private_phone character varying,
    private_email character varying,
    lang character varying,
    gender character varying,
    marital character varying NOT NULL,
    spouse_complete_name character varying,
    place_of_birth character varying,
    ssnid character varying,
    sinid character varying,
    identification_id character varying,
    passport_id character varying,
    permit_no character varying,
    visa_no character varying,
    certificate character varying,
    study_field character varying,
    study_school character varying,
    emergency_contact character varying,
    emergency_phone character varying,
    distance_home_work_unit character varying NOT NULL,
    employee_type character varying NOT NULL,
    barcode character varying,
    pin character varying,
    private_car_plate character varying,
    spouse_birthdate date,
    birthday date,
    visa_expire date,
    work_permit_expiration_date date,
    departure_date date,
    employee_properties jsonb,
    additional_note text,
    notes text,
    departure_description text,
    active boolean,
    is_flexible boolean,
    is_fully_flexible boolean,
    work_permit_scheduled_activity boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    hourly_cost numeric,
    employee_token character varying,
    last_appraisal_id integer,
    ongoing_appraisal_count integer,
    appraisal_count integer,
    next_appraisal_date date,
    last_appraisal_date date,
    timesheet_manager_id integer,
    last_validated_timesheet_date date,
    billable_time_target double precision,
    expense_manager_id integer,
    CONSTRAINT hr_employee_check_billable_time_target CHECK ((billable_time_target >= (0)::double precision))
);


--
-- Name: TABLE hr_employee; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.hr_employee IS 'Employee';


--
-- Name: COLUMN hr_employee.resource_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.resource_id IS 'Resource';


--
-- Name: COLUMN hr_employee.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.company_id IS 'Company';


--
-- Name: COLUMN hr_employee.resource_calendar_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN hr_employee.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN hr_employee.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.color IS 'Color Index';


--
-- Name: COLUMN hr_employee.department_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.department_id IS 'Department';


--
-- Name: COLUMN hr_employee.job_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.job_id IS 'Job Position';


--
-- Name: COLUMN hr_employee.address_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.address_id IS 'Work Address';


--
-- Name: COLUMN hr_employee.work_contact_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.work_contact_id IS 'Work Contact';


--
-- Name: COLUMN hr_employee.work_location_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.work_location_id IS 'Work Location';


--
-- Name: COLUMN hr_employee.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.user_id IS 'User';


--
-- Name: COLUMN hr_employee.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.parent_id IS 'Manager';


--
-- Name: COLUMN hr_employee.coach_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.coach_id IS 'Coach';


--
-- Name: COLUMN hr_employee.private_state_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.private_state_id IS 'Private State';


--
-- Name: COLUMN hr_employee.private_country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.private_country_id IS 'Private Country';


--
-- Name: COLUMN hr_employee.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.country_id IS 'Nationality (Country)';


--
-- Name: COLUMN hr_employee.children; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.children IS 'Number of Dependent Children';


--
-- Name: COLUMN hr_employee.country_of_birth; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.country_of_birth IS 'Country of Birth';


--
-- Name: COLUMN hr_employee.bank_account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN hr_employee.distance_home_work; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.distance_home_work IS 'Home-Work Distance';


--
-- Name: COLUMN hr_employee.km_home_work; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.km_home_work IS 'Home-Work Distance in Km';


--
-- Name: COLUMN hr_employee.departure_reason_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.departure_reason_id IS 'Departure Reason';


--
-- Name: COLUMN hr_employee.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.name IS 'Employee Name';


--
-- Name: COLUMN hr_employee.job_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.job_title IS 'Job Title';


--
-- Name: COLUMN hr_employee.work_phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.work_phone IS 'Work Phone';


--
-- Name: COLUMN hr_employee.mobile_phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.mobile_phone IS 'Work Mobile';


--
-- Name: COLUMN hr_employee.work_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr_employee.work_email IS 'Work Email';


--
-- Name: COLUMN hr_employee.private_street; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.hr